/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.autoplot.datasource.AutoplotSettings;
import org.das2.util.LoggerManager;

public class WindowManager {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.windowmanager");
    private static final WindowManager instance = new WindowManager();
    Dimension lastFileChooserDimension = null;
    int lastFileChooserX = 0;
    int lastFileChooserY = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int YES_OPTION = 0;

    public static WindowManager getInstance() {
        return instance;
    }

    public static int showConfirmDialog(Component parent, Object omessage, String title, int optionType, int messageType) {
        return WindowManager.showConfirmDialog(parent, omessage, title, optionType);
    }

    public static int showConfirmDialog(Component parent, Object omessage, String title, int optionType, int messageType, Icon icon) {
        return WindowManager.showConfirmDialog(parent, omessage, title, optionType);
    }

    private boolean isOnScreen(Rectangle pos, int grab) {
        GraphicsDevice[] gs;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
            Rectangle bounds = gd.getDefaultConfiguration().getBounds();
            Rectangle intersect = pos.intersection(bounds);
            if (intersect.height <= grab || intersect.width <= grab) continue;
            return true;
        }
        return false;
    }

    public void recallWindowSizePosition(final JFileChooser window) {
        String name = window.getName();
        if (name == null) {
            name = "fileChooser";
        }
        logger.log(Level.FINE, "looking up position for {0}", name);
        Preferences prefs = AutoplotSettings.settings().getPreferences(WindowManager.class);
        int grab = 48;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Pattern p = Pattern.compile("(?<width>\\d+)x(?<height>\\d+)");
        String s = prefs.get("window." + name + ".screensize", "");
        logger.log(Level.FINE, "found for window.{0}.screensize: {1} currentSize: {2}x{3}", new Object[]{name, s, screenSize.width, screenSize.height});
        Matcher m0 = p.matcher(s);
        if (m0.matches() && Integer.parseInt(m0.group("width")) == screenSize.width && Integer.parseInt(m0.group("height")) == screenSize.height) {
            int y;
            int h;
            String wh = prefs.get("window." + name + ".size", "");
            logger.log(Level.FINER, "window.{0}.size={1}", new Object[]{name, wh});
            Matcher m = p.matcher(wh);
            int w = m.matches() ? Integer.parseInt(m.group("width")) : -9999;
            int n = h = m.matches() ? Integer.parseInt(m.group("height")) : -9999;
            if (w > 10 && h > 10 && w < screenSize.width && h < screenSize.height) {
                window.setSize(w, h);
                window.setPreferredSize(new Dimension(w, h));
                this.lastFileChooserDimension = window.getSize();
            }
            String xy = prefs.get("window." + name + ".location", "");
            logger.log(Level.FINER, "window.{0}.location={1}", new Object[]{name, xy});
            Pattern p2 = Pattern.compile("(?<x>\\d+),(?<y>\\d+)");
            Matcher m2 = p2.matcher(xy);
            int x = m2.matches() ? Integer.parseInt(m2.group("x")) : -9999;
            int n2 = y = m2.matches() ? Integer.parseInt(m2.group("y")) : -9999;
            if (x != 0 && y != 0 && x > -9999 && y > -9999) {
                int newx = x;
                int newy = y;
                if (newx < 0) {
                    newx = 0;
                }
                if (newy < 0) {
                    newy = 0;
                }
                if (newx > screenSize.width - grab) {
                    newx = screenSize.width - grab;
                }
                if (newy > screenSize.height - grab) {
                    newy = screenSize.height - h;
                }
                if (this.isOnScreen(new Rectangle(newx, newy, window.getWidth(), window.getWidth()), grab)) {
                    window.setLocation(newx, newy);
                }
            }
        }
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WindowManager.this.lastFileChooserDimension = window.getSize();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                WindowManager.this.lastFileChooserDimension = window.getSize();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                WindowManager.this.lastFileChooserX = window.getX();
                WindowManager.this.lastFileChooserY = window.getY();
                System.err.println("x,y=" + WindowManager.this.lastFileChooserX + "," + WindowManager.this.lastFileChooserY);
            }
        });
        SwingUtilities.invokeLater(() -> {
            Action a = window.getActionMap().get("viewTypeDetails");
            if (a != null) {
                a.actionPerformed(null);
            }
        });
    }

    public void recordWindowSizePosition(JFileChooser window) {
        int x = this.lastFileChooserX;
        int y = this.lastFileChooserY;
        if (this.lastFileChooserDimension == null) {
            return;
        }
        int w = this.lastFileChooserDimension.width;
        int h = this.lastFileChooserDimension.height;
        Container c = window.getParent();
        String name = window.getName();
        if (name == null) {
            name = "fileChooser";
        }
        logger.log(Level.FINE, "storing position for {0}", name);
        Preferences prefs = AutoplotSettings.settings().getPreferences(WindowManager.class);
        logger.log(Level.FINE, "saving last location {0} {1} {2} {3}", new Object[]{x, y, h, w});
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        prefs.put("window." + name + ".screensize", String.format("%dx%d", d.width, d.height));
        if (c != null) {
            prefs.put("window." + name + ".rlocation", String.format("%d,%d", x - c.getX(), y - c.getY()));
            prefs.put("window." + name + ".location", String.format("%d,%d", x, y));
        } else {
            prefs.put("window." + name + ".rlocation", "0,0");
            prefs.put("window." + name + ".location", String.format("%d,%d", x, y));
        }
        prefs.put("window." + name + ".size", String.format("%dx%d", w, h));
    }

    public void recallWindowSizePosition(Window window) {
        Container parent = window.getParent();
        String name = window.getName();
        logger.log(Level.FINE, "looking up position for {0}", name);
        if (name == null) {
            return;
        }
        Preferences prefs = AutoplotSettings.settings().getPreferences(WindowManager.class);
        int grab = 4 * window.getFont().getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Pattern p = Pattern.compile("(?<width>\\d+)x(?<height>\\d+)");
        String s = prefs.get("window." + name + ".screensize", "");
        logger.log(Level.FINE, "found for window.{0}.screensize: {1} currentSize: {2}x{3}", new Object[]{name, s, screenSize.width, screenSize.height});
        Matcher m0 = p.matcher(s);
        if (m0.matches() && Integer.parseInt(m0.group("width")) == screenSize.width && Integer.parseInt(m0.group("height")) == screenSize.height) {
            int h;
            String wh = prefs.get("window." + name + ".size", "");
            logger.log(Level.FINER, "window.{0}.size={1}", new Object[]{name, wh});
            Matcher m = p.matcher(wh);
            int w = m.matches() ? Integer.parseInt(m.group("width")) : -9999;
            int n = h = m.matches() ? Integer.parseInt(m.group("height")) : -9999;
            if (w > 10 && h > 10 && w < screenSize.width && h < screenSize.height) {
                window.setSize(w, h);
            }
            if (parent != null) {
                int y;
                String rxy = prefs.get("window." + name + ".rlocation", "");
                logger.log(Level.FINER, "window.{0}.rlocation={1}", new Object[]{name, rxy});
                Pattern p2 = Pattern.compile("(?<x>\\d+),(?<y>\\d+)");
                Matcher m2 = p2.matcher(rxy);
                int x = m2.matches() ? Integer.parseInt(m2.group("x")) : -9999;
                int n2 = y = m2.matches() ? Integer.parseInt(m2.group("y")) : -9999;
                if (x > -9999 && y > -9999) {
                    int newx = parent.getX() + x;
                    int newy = parent.getY() + y;
                    if (newx < 0) {
                        newx = 0;
                    }
                    if (newy < 0) {
                        newy = 0;
                    }
                    if (newx > screenSize.width - grab) {
                        newx = screenSize.width - grab;
                    }
                    if (newy > screenSize.height - grab) {
                        newy = screenSize.height - grab;
                    }
                    if (this.isOnScreen(new Rectangle(newx, newy, window.getWidth(), window.getWidth()), grab)) {
                        window.setLocation(newx, newy);
                    }
                }
            } else {
                int y;
                String xy = prefs.get("window." + name + ".location", "");
                logger.log(Level.FINER, "window.{0}.location={1}", new Object[]{name, xy});
                Pattern p2 = Pattern.compile("(?<x>\\d+),(?<y>\\d+)");
                Matcher m2 = p2.matcher(xy);
                int x = m2.matches() ? Integer.parseInt(m2.group("x")) : -9999;
                int n3 = y = m2.matches() ? Integer.parseInt(m2.group("y")) : -9999;
                if (x > -9999 && y > -9999) {
                    int newx = x;
                    int newy = y;
                    if (newx < 0) {
                        newx = 0;
                    }
                    if (newy < 0) {
                        newy = 0;
                    }
                    if (newx > screenSize.width - grab) {
                        newx = screenSize.width - grab;
                    }
                    if (newy > screenSize.height - grab) {
                        newy = screenSize.height - h;
                    }
                    if (this.isOnScreen(new Rectangle(newx, newy, window.getWidth(), window.getWidth()), grab)) {
                        window.setLocation(newx, newy);
                    }
                }
            }
        }
    }

    public void recordWindowSizePosition(Window window) {
        int x = window.getLocation().x;
        int y = window.getLocation().y;
        int w = window.getWidth();
        int h = window.getHeight();
        Container c = window.getParent();
        String name = window.getName();
        logger.log(Level.FINE, "storing position for {0}", name);
        if (name == null) {
            return;
        }
        Preferences prefs = AutoplotSettings.settings().getPreferences(WindowManager.class);
        logger.log(Level.FINE, "saving last location {0} {1} {2} {3}", new Object[]{x, y, h, w});
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        prefs.put("window." + name + ".screensize", String.format("%dx%d", d.width, d.height));
        if (c != null) {
            prefs.put("window." + name + ".rlocation", String.format("%d,%d", x - c.getX(), y - c.getY()));
            prefs.put("window." + name + ".location", String.format("%d,%d", x, y));
        } else {
            prefs.put("window." + name + ".rlocation", "0,0");
            prefs.put("window." + name + ".location", String.format("%d,%d", x, y));
        }
        prefs.put("window." + name + ".size", String.format("%dx%d", w, h));
    }

    public void showModalDialog(Dialog dia) {
        if (!dia.isModal()) {
            throw new IllegalArgumentException("dialog should be modal");
        }
        WindowManager.getInstance().recallWindowSizePosition(dia);
        try {
            dia.setVisible(true);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, null, ex);
        }
        WindowManager.getInstance().recordWindowSizePosition(dia);
    }

    public static int showConfirmDialog(Component parent, Object omessage, final String title, int optionType) {
        String name;
        if (optionType != 2 && optionType != 1) {
            throw new IllegalArgumentException("must be OK_CANCEL_OPTION or YES_NO_CANCEL_OPTION");
        }
        final Component message = !(omessage instanceof Component) ? new JLabel(omessage.toString()) : (Component)omessage;
        final Window p = parent != null ? (parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent)) : null;
        final JDialog dia = new JDialog(p, Dialog.ModalityType.APPLICATION_MODAL);
        if (title.startsWith("Run Script ")) {
            String hash = String.format("%09d", title.substring(11).hashCode());
            if (hash.startsWith("-")) {
                hash = "0" + hash.substring(1);
            }
            name = "RunScript-" + hash;
        } else {
            name = title.replaceAll("\\s", "");
        }
        dia.setName(name);
        dia.setLayout(new BorderLayout());
        final JPanel pc = new JPanel();
        final ArrayList<Integer> result = new ArrayList<Integer>(1);
        result.add(2);
        BoxLayout b = new BoxLayout(pc, 0);
        pc.setLayout(b);
        pc.add(Box.createGlue());
        if (optionType == 2) {
            AbstractAction aa = new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    result.set(0, 2);
                    dia.setVisible(false);
                    dia.dispose();
                }
            };
            pc.add(new JButton(aa));
            pc.add(Box.createHorizontalStrut(7));
            aa = new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    result.set(0, 0);
                    dia.setVisible(false);
                    dia.dispose();
                }
            };
            pc.add(new JButton(aa));
        } else if (optionType == 1) {
            pc.add(new JButton(new AbstractAction("Yes"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    result.set(0, 0);
                    dia.setVisible(false);
                    dia.dispose();
                }
            }));
            pc.add(Box.createHorizontalStrut(7));
            pc.add(new JButton(new AbstractAction("No"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    result.set(0, 1);
                    dia.setVisible(false);
                    dia.dispose();
                }
            }));
            pc.add(Box.createHorizontalStrut(7));
            pc.add(new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    result.set(0, 2);
                    dia.setVisible(false);
                    dia.dispose();
                }
            }));
        }
        dia.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                result.set(0, 2);
                dia.setVisible(false);
                dia.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        pc.add(Box.createHorizontalStrut(7));
        Runnable run = new Runnable(){

            @Override
            public void run() {
                dia.setResizable(true);
                dia.add(message);
                dia.add((Component)pc, "South");
                dia.setTitle(title);
                dia.pack();
                dia.setLocationRelativeTo(p);
                WindowManager.getInstance().recallWindowSizePosition(dia);
                dia.setVisible(true);
                WindowManager.getInstance().recordWindowSizePosition(dia);
            }
        };
        if (EventQueue.isDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return (Integer)result.get(0);
    }
}

