/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PromptTextArea
extends JTextArea {
    JLabel promptLabel = new JLabel("enter text here");

    public PromptTextArea() {
        this("enter text here");
    }

    public PromptTextArea(String label) {
        this.promptLabel.setText(label);
        this.promptLabel.setForeground(Color.GRAY);
        this.addFocusListener(this.createFocusListener());
        this.promptLabel.addNotify();
    }

    public void setPromptText(String text) {
        this.promptLabel.setText(text);
        this.repaint();
    }

    public String getPromptText() {
        return this.promptLabel.getText();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        String txt = this.getText();
        if (!(txt != null && txt.length() != 0 || this.hasFocus())) {
            Graphics scratch = g.create();
            this.promptLabel.setBounds(0, 0, this.getWidth(), this.promptLabel.getFont().getSize());
            scratch.translate(this.getInsets().left, 0);
            this.promptLabel.paint(scratch);
            scratch.dispose();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        PromptTextArea ta = new PromptTextArea("Enter something here");
        p.add(ta);
        p.add((Component)new JTextField("set focus here"), "South");
        f.setContentPane(p);
        f.pack();
        f.setVisible(true);
    }

    private FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                PromptTextArea.this.repaint(PromptTextArea.this.getBounds());
            }

            @Override
            public void focusLost(FocusEvent e) {
                PromptTextArea.this.repaint(PromptTextArea.this.getBounds());
            }
        };
    }
}

