/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.ui;

import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;

public class RowHeaderRenderer
extends JLabel
implements ListCellRenderer {
    private JTable table;
    private Border selectedBorder;
    private Border normalBorder;
    private Font selectedFont;
    private Font normalFont;

    RowHeaderRenderer(JTable table) {
        this.table = table;
        this.normalBorder = UIManager.getBorder("TableHeader.cellBorder");
        this.selectedBorder = BorderFactory.createRaisedBevelBorder();
        JTableHeader header = table.getTableHeader();
        this.normalFont = header.getFont();
        this.selectedFont = this.normalFont.deriveFont(this.normalFont.getStyle() | 1);
        this.setForeground(header.getForeground());
        this.setBackground(header.getBackground());
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.table.getSelectionModel().isSelectedIndex(index)) {
            this.setFont(this.selectedFont);
            this.setBorder(this.selectedBorder);
        } else {
            this.setFont(this.normalFont);
            this.setBorder(this.normalBorder);
        }
        String label = String.valueOf(index + 1);
        this.setText(label);
        return this;
    }
}

