/*
 * Decompiled with CFR 0.152.
 */
package zipfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import zipfs.ZipFileObject;

public class ZipFileSystem
extends FileSystem {
    private ZipFile zipFile;
    private TreeMap<String, ZipFileObject> filemap = new TreeMap();

    protected ZipFileSystem(URI root) throws IOException {
        super(root);
        if (!"file".equals(root.getScheme())) {
            throw new IllegalArgumentException("Cannot access non-local zip file: " + root);
        }
        File f = new File(root);
        try {
            this.zipFile = new ZipFile(f);
        }
        catch (ZipException ex) {
            throw new IllegalArgumentException("File is not a properly formatted zip file: " + f, ex);
        }
        this.filemap.put("/", new ZipFileObject(this, null, null));
        Enumeration<? extends ZipEntry> contents = this.zipFile.entries();
        while (contents.hasMoreElements()) {
            ZipEntry entry = contents.nextElement();
            String entryName = "/" + entry.getName();
            this.addZipEntry(entryName, entry);
        }
    }

    private void addZipEntry(String name, ZipEntry entry) {
        logger.log(Level.FINE, "addZipEntry: {0}", name);
        String parentName = name.substring(0, name.lastIndexOf(47, name.length() - 2) + 1);
        if (!this.filemap.containsKey(parentName)) {
            this.addZipEntry(parentName, null);
        }
        String n = null;
        if (entry == null) {
            n = name;
            if (n.endsWith("/")) {
                n = n.substring(0, n.length() - 1);
            }
            n = n.substring(n.lastIndexOf(47));
        }
        ZipFileObject zfo = new ZipFileObject(this, entry, this.filemap.get(parentName), n);
        this.filemap.put(name, zfo);
        this.filemap.get(parentName).addChildObject(zfo);
        if (name.endsWith(".gz")) {
            n = name.substring(0, name.length() - 3);
            zfo = new ZipFileObject(this, entry, this.filemap.get(parentName), n);
            this.filemap.put(n, zfo);
            this.filemap.get(parentName).addChildObject(zfo);
        }
    }

    protected ZipFile getZipFile() {
        return this.zipFile;
    }

    public FileObject getFileObject(String filename) {
        String f = FileSystem.toCanonicalFilename((String)filename);
        if (!f.startsWith("/")) {
            f = "/" + f;
        }
        if (this.filemap.containsKey(f)) {
            return this.filemap.get(f);
        }
        if (this.filemap.containsKey(f + "/")) {
            return this.filemap.get(f + "/");
        }
        if (this.filemap.containsKey(f + ".gz")) {
            return this.filemap.get(f + ".gz");
        }
        return new ZipFileObject(this, null, null, filename);
    }

    public boolean isDirectory(String filename) throws IOException {
        String f = FileSystem.toCanonicalFilename((String)filename);
        if (this.filemap.containsKey(f)) {
            return this.filemap.get(f).isFolder();
        }
        f = FileSystem.toCanonicalFolderName((String)filename);
        if (this.filemap.containsKey(f)) {
            return this.filemap.get(f).isFolder();
        }
        throw new FileNotFoundException("No such file in zip: " + filename);
    }

    public String[] listDirectory(String directory) throws IOException {
        String dname = FileSystem.toCanonicalFolderName((String)directory);
        if (!this.isDirectory(dname)) {
            throw new IllegalArgumentException("Not a folder in zip file: " + dname);
        }
        FileObject[] contents = this.filemap.get(dname).getChildren();
        String[] results = new String[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            String s = contents[i].getNameExt();
            results[i] = s.substring(s.lastIndexOf(47, s.length() - 2) + 1);
        }
        return results;
    }

    public String[] listDirectory(String directory, String regex) throws IOException {
        directory = ZipFileSystem.toCanonicalFilename((String)directory);
        String[] listing = this.listDirectory(directory);
        Pattern pattern = Pattern.compile(regex + "/?");
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < listing.length; ++i) {
            if (!pattern.matcher(listing[i]).matches()) continue;
            result.add(listing[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public File getLocalRoot() {
        File localCacheDir = ZipFileSystem.settings().getLocalCacheDir();
        char sep = File.separatorChar;
        String zname = this.zipFile.getName().substring(0, this.zipFile.getName().length() - 4) + sep;
        if (!zname.startsWith("/") && zname.charAt(1) == ':') {
            zname = String.valueOf(sep) + String.valueOf(zname.charAt(0)).toLowerCase() + zname.substring(2);
        }
        String zipCacheName = localCacheDir.getAbsolutePath() + sep + "zip" + zname;
        File zipCache = new File(zipCacheName);
        return zipCache;
    }

    public String toString() {
        return "zipfs " + this.zipFile.getName();
    }
}

