/*
 * Decompiled with CFR 0.152.
 */
package org.das2.client;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Das2ServerGUI {
    private String[] ll;
    private String[] tt;
    private String[] ff;
    private String[] ss;
    private JComponent[] cc;
    private JPanel panel;

    private String[] readXML(String xmlsrc) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        InputSource inputsrc = new InputSource(new StringReader(xmlsrc));
        Document doc = builder.parse(inputsrc);
        XPath xp = XPathFactory.newInstance().newXPath();
        Node nn = (Node)xp.evaluate("//properties", doc, XPathConstants.NODE);
        LinkedHashMap mm = new LinkedHashMap();
        ArrayList<String> ll = new ArrayList<String>(100);
        for (int i = 0; i < 100; ++i) {
            ll.add(i, "");
        }
        NamedNodeMap aa = nn.getAttributes();
        for (int i = 0; i < aa.getLength(); ++i) {
            Node itm = aa.item(i);
            if (!itm.getNodeName().startsWith("param_")) continue;
            int idx = Integer.parseInt(itm.getNodeName().substring(6));
            ll.set(idx, itm.getNodeValue());
        }
        return ll.toArray(new String[ll.size()]);
    }

    private static int parseInt(String s) {
        if ((s = s.trim()).startsWith("0")) {
            return Integer.parseInt(s.substring(1));
        }
        return Integer.parseInt(s);
    }

    private String[] readDsdf(String dsdfsrc) {
        ArrayList<String> ll = new ArrayList<String>(100);
        for (int i = 0; i < 100; ++i) {
            ll.add(i, "");
        }
        for (String line : dsdfsrc.split("\n")) {
            if (!line.startsWith("param_")) continue;
            int ieq = line.indexOf("=");
            int idx = Das2ServerGUI.parseInt(line.substring(0, ieq).substring(6));
            String vv = line.substring(ieq + 1).trim();
            if (vv.charAt(0) == '\'' && vv.charAt(vv.length() - 1) == '\'') {
                vv = vv.substring(1, vv.length() - 1);
            }
            ll.set(idx, vv);
        }
        return ll.toArray(new String[ll.size()]);
    }

    private String checkMatch(String template, String sval) {
        template = template.trim();
        sval = sval.trim();
        if (template.indexOf("@") > -1) {
            int idx = template.indexOf("@");
            int i = sval.length() - template.length() - idx - 1;
            if (template.substring(0, idx).equals(sval.substring(0, idx)) && template.substring(idx + 1).equals(sval.substring(i))) {
                return sval.substring(idx, idx + sval.length() - template.length() + 1);
            }
            return "";
        }
        if (template.equals(sval)) {
            return sval;
        }
        return "";
    }

    private int index(String[] arr, String search) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(search)) continue;
            return i;
        }
        return -1;
    }

    private String findParamValue(String[] paramsArr, String ss0, String template) {
        try {
            if (template == null) {
                int idx = this.index(paramsArr, ss0);
                if (idx == -1) {
                    return "";
                }
                paramsArr[idx] = "";
                return ss0;
            }
            if (template.charAt(0) == '^') {
                String regex = template;
                Pattern pattern = Pattern.compile(regex);
                int idx = 0;
                for (String item : paramsArr) {
                    Matcher match = pattern.matcher(item);
                    if (match != null) {
                        paramsArr[idx] = "";
                        return item;
                    }
                    ++idx;
                }
                return "";
            }
            String[] templates = template.split("\\s+");
            int i = 0;
            int ipa = 0;
            while (i < templates.length) {
                while (ipa < paramsArr.length && i < templates.length) {
                    String item = paramsArr[ipa].trim();
                    String match = this.checkMatch(templates[i], item);
                    if (match.length() == 0) {
                        return "";
                    }
                    if (templates[i].contains("@")) {
                        paramsArr[ipa] = "";
                        return match;
                    }
                    paramsArr[ipa] = "";
                    ++ipa;
                    ++i;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("param not found: " + ss0);
            return "";
        }
    }

    private void setSelectedListItems(Component jcomponent, String[] allItems, String[] items) {
        JPanel jPanel = (JPanel)jcomponent;
        for (Component b : jPanel.getComponents()) {
            JCheckBox tp = (JCheckBox)b;
            String item = tp.getName();
            try {
                int idx = this.index(items, item);
                if (idx <= -1) continue;
                tp.setSelected(true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private List<String> getSelectedListItems(Component jcomponent) {
        if (jcomponent instanceof JList) {
            return ((JList)jcomponent).getSelectedValuesList();
        }
        ArrayList<String> resultList = new ArrayList<String>();
        JPanel jList = (JPanel)jcomponent;
        for (Component c : jList.getComponents()) {
            JCheckBox b = (JCheckBox)c;
            if (!b.isSelected()) continue;
            resultList.add(b.getText());
        }
        return resultList;
    }

    private String getRegex(String t) {
        return t.replaceAll("@", "(\\S+)");
    }

    public void setSpecification(String sss) {
        if (sss.length() < 4) {
            throw new IllegalArgumentException("control string is too short");
        }
        if (sss.substring(0, 4).equals("[00]")) {
            sss = sss.substring(10);
        }
        if (sss.trim().startsWith("<")) {
            try {
                this.ll = this.readXML(sss);
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
                Logger.getLogger("das2").log(Level.SEVERE, null, ex);
            }
        } else {
            this.ll = this.readDsdf(sss);
        }
        this.tt = new String[101];
        this.ff = new String[101];
        this.ss = new String[101];
        this.cc = new JComponent[101];
    }

    public void setParameters(String paramz) {
        String delim = "\\s+";
        String delimRaw = " ";
        String[] paramsArr = paramz.split(delim);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        boolean extra = false;
        for (int i = 0; i < 100; ++i) {
            String vv;
            JComponent c;
            String itm = this.ll[i];
            if (itm.length() <= 0) continue;
            itm = itm.trim();
            this.ss = itm.split("\\s*\\|\\s*", -2);
            int narg = this.ss.length;
            JComponent c2 = null;
            if (narg == 1) {
                c = new JCheckBox(this.ss[0]);
                vv = this.findParamValue(paramsArr, this.ss[0], null);
                if (vv.length() > 0) {
                    ((AbstractButton)c).setSelected(true);
                }
                this.tt[i] = "JCheckBox";
                this.panel.add(c);
                c2 = c;
            } else if (narg == 2) {
                c = new JCheckBox(this.ss[0] + ": " + this.ss[1]);
                vv = this.findParamValue(paramsArr, this.ss[0], null);
                if (vv.length() > 0) {
                    ((AbstractButton)c).setSelected(true);
                }
                this.tt[i] = "JCheckBox";
                this.panel.add(c);
                c2 = c;
            } else if (narg == 3) {
                this.panel.add(new JLabel(this.ss[0] + ": " + this.ss[1]));
                c = new JTextField("");
                c.setMaximumSize(new Dimension(8000, ((JTextField)c).getPreferredSize().height));
                vv = this.findParamValue(paramsArr, this.ss[0], null);
                this.ff[i] = this.ss[2];
                vv = this.findParamValue(paramsArr, this.ss[0], this.ss[2]);
                if (vv.length() > 0) {
                    ((JTextComponent)c).setText(vv);
                }
                this.tt[i] = "JTextField";
                this.panel.add(c);
                c2 = c;
            } else if (narg == 4) {
                if (this.ss[3].startsWith("set:")) {
                    String sep;
                    this.panel.add(new JLabel(this.ss[0] + ": " + this.ss[1]));
                    String[] sepAllItems = this.ss[3].substring(4).trim().split("\\s+");
                    CharSequence[] allItems = Arrays.copyOfRange(sepAllItems, 1, sepAllItems.length);
                    this.ss[i] = sep = sepAllItems[0];
                    JPanel panel1 = new JPanel();
                    panel1.setLayout(new BoxLayout(panel1, 0));
                    for (String string : allItems) {
                        JCheckBox b1 = new JCheckBox(string);
                        b1.setSelected(false);
                        panel1.add(b1);
                    }
                    c2 = panel1;
                    String itemMatch = String.join((CharSequence)"|", allItems);
                    String regex = String.format("^(%s)(?:%s(%s))*$", itemMatch, sep, itemMatch);
                    String vv2 = this.findParamValue(paramsArr, this.ss[0], regex);
                    if (vv2.length() > 0) {
                        String[] stringArray = vv2.split(sep);
                        this.setSelectedListItems(c2, (String[])allItems, stringArray);
                    }
                    this.tt[i] = "JList";
                } else {
                    this.panel.add(new JLabel(this.ss[0] + ": " + this.ss[1] + " (" + this.ss[3] + ")"));
                    c2 = c = new JTextField("");
                    c.setMaximumSize(new Dimension(8000, ((JTextField)c).getPreferredSize().height));
                    vv = this.findParamValue(paramsArr, this.ss[0], null);
                    this.ff[i] = this.ss[2];
                    vv = this.findParamValue(paramsArr, this.ss[0], this.ss[2]);
                    if (vv.length() > 0) {
                        ((JTextComponent)c).setText(vv);
                    }
                    this.tt[i] = "JTextField";
                }
                this.panel.add(c2);
            } else {
                extra = true;
            }
            if (c2 == null) continue;
            this.panel.add(c2);
            this.cc[i] = c2;
            c2.setAlignmentX(0.0f);
        }
        StringBuilder extraArgs = new StringBuilder();
        for (int i = 0; i < paramsArr.length; ++i) {
            if (paramsArr[i].trim().length() > 0) {
                extraArgs.append(paramsArr[i]);
            }
            if (i <= 0) continue;
            extraArgs.append(delimRaw);
        }
        if (extra || extraArgs.length() > 0) {
            this.panel.add(new JLabel("Text not described in DSDF"));
            JTextArea c = new JTextArea();
            c.setAlignmentX(0.0f);
            c.setText(extraArgs.toString());
            c.setRows(4);
            this.panel.add(c);
            this.cc[100] = c;
        }
    }

    public String getParameters() {
        String delim = " ";
        StringBuilder parametersBuilder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            if (this.cc[i] == null) continue;
            if (this.tt[i].equals("JCheckBox")) {
                if (!((JCheckBox)this.cc[i]).isSelected()) continue;
                String txt = ((JCheckBox)this.cc[i]).getText();
                int i2 = txt.indexOf(": ");
                if (i2 > -1) {
                    txt = txt.substring(0, i2);
                }
                parametersBuilder.append(txt);
                parametersBuilder.append(delim);
                continue;
            }
            if (this.tt[i].equals("JTextField")) {
                String s = ((JTextField)this.cc[i]).getText();
                if (s.length() <= 0) continue;
                s = this.ff[i].replace("@", s);
                parametersBuilder.append(s);
                parametersBuilder.append(delim);
                continue;
            }
            if (!this.tt[i].equals("JList")) continue;
            List<String> selectedItems = this.getSelectedListItems(this.cc[i]);
            String sep = this.ss[i];
            parametersBuilder.append(String.join((CharSequence)sep, selectedItems));
            parametersBuilder.append(delim);
        }
        if (this.cc[100] != null) {
            parametersBuilder.append(delim);
            String txt = ((JTextArea)this.cc[100]).getText().replace("\n", delim);
            txt = txt.trim();
            parametersBuilder.append(txt);
        }
        return parametersBuilder.toString();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public static void main(String[] args) {
        String params0;
        String dsdf;
        Das2ServerGUI x = new Das2ServerGUI();
        int test = 2;
        switch (test) {
            case 1: {
                dsdf = "param_01 = '1.5V_REF | Simulate +1.8 monitor'\nparam_02 = '1.5V_WvFE'\nparam_03 = '1.5V_Y180'\nparam_04 = '1.8U | Power Supply'\nparam_05 = '1.8V_MEM'";
                params0 = "1.5V_REF 1.8V_MEM Extra-Unrecognized";
                break;
            }
            case 2: {
                dsdf = "param_01 = 'packet_ids|Output data from the following packet IDs (defaults to all)|@|set: , x242 x252'\n";
                params0 = "";
                break;
            }
            default: {
                throw new IllegalArgumentException("bad test number");
            }
        }
        x.setSpecification(dsdf);
        x.setParameters(params0);
        if (0 == JOptionPane.showConfirmDialog(null, x.panel, "Edit params", 2)) {
            System.err.println(x.getParameters());
        }
    }
}

