/*
 * Decompiled with CFR 0.152.
 */
package org.das2.client;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSetBuilder;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.SkeletonDescriptor;
import org.das2.stream.StreamComment;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamHandler;
import org.das2.stream.StreamScalarDescriptor;
import org.das2.stream.StreamYScanDescriptor;
import org.das2.stream.StreamZDescriptor;
import org.das2.system.DasLogger;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class DataSetStreamHandler
implements StreamHandler {
    StreamHandlerDelegate delegate;
    StreamDescriptor sd;
    Map extraProperties;
    ProgressMonitor monitor;
    int totalPacketCount = -1;
    int taskSize = -1;
    int packetCount = 0;
    Datum xTagMax = null;
    boolean bReadPkts = true;
    String schema = "";
    private static final Logger logger = DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG);
    private boolean monotonic = true;

    public DataSetStreamHandler(Map extraProperties, ProgressMonitor monitor) {
        this.extraProperties = new HashMap(extraProperties);
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
    }

    @Override
    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        logger.finest("got stream descriptor");
        this.sd = sd;
        Object o = sd.getProperty("taskSize");
        if (o != null) {
            this.taskSize = (Integer)o;
            this.monitor.setTaskSize((long)this.taskSize);
            this.monitor.started();
        } else {
            o = sd.getProperty("packetCount");
            if (o != null) {
                this.totalPacketCount = (Integer)o;
                this.monitor.setTaskSize((long)this.totalPacketCount);
                this.monitor.started();
            }
        }
        o = sd.getProperty("cacheTagString");
        if (o != null) {
            try {
                String[] ss = ((String)o).split(",");
                Datum min = TimeUtil.create((String)ss[0]);
                Datum max = TimeUtil.create((String)ss[2]);
                Datum res = DatumUtil.parse((String)ss[1]);
                if (res.doubleValue(res.getUnits()) == 0.0) {
                    res = null;
                }
                this.extraProperties.put("cacheTag", new CacheTag(min, max, res));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            Object oRng = sd.getProperty("xCacheRange");
            if (oRng != null) {
                try {
                    DatumRange rng = null;
                    rng = !(oRng instanceof DatumRange) ? DatumRangeUtil.parseDatumRange((String)((String)oRng)) : (DatumRange)oRng;
                    Datum res = null;
                    Object oRes = sd.getProperty("xCacheResolution");
                    if (oRes != null) {
                        res = !(oRes instanceof Datum) ? DatumUtil.parse((String)((String)oRes)) : (Datum)oRes;
                    }
                    this.extraProperties.put("cacheTag", new CacheTag(rng.min(), rng.max(), res));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((o = sd.getProperty("xMonotonic")) != null) {
            this.extraProperties.put("xMonotonic", Boolean.valueOf((String)o));
        }
        if ((o = sd.getProperty("pid")) != null) {
            logger.log(Level.FINE, "stream pid={0}", o);
        }
    }

    @Override
    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        logger.finest("got packet descriptor");
        if (this.delegate == null) {
            SkeletonDescriptor descriptor = pd.getYDescriptor(0);
            if (descriptor instanceof StreamScalarDescriptor) {
                logger.fine("using VectorDS delegate");
                this.delegate = new VectorDataSetStreamHandler(pd);
                if (pd.getYCount() == 2 && pd.getYDescriptor(1) instanceof StreamZDescriptor) {
                    this.schema = "xyz";
                }
            } else if (descriptor instanceof StreamYScanDescriptor) {
                logger.fine("using TableDS delegate");
                this.delegate = new TableDataSetStreamHandler(pd);
            }
        } else {
            this.delegate.packetDescriptor(pd);
        }
    }

    public void setReadPackets(boolean b) {
        this.bReadPkts = b;
    }

    public boolean getReadPackets() {
        return this.bReadPkts;
    }

    @Override
    public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
        if (!this.bReadPkts) {
            return;
        }
        logger.finest("got packet");
        this.ensureNotNullDelegate();
        if (this.xTagMax == null || xTag.ge(this.xTagMax)) {
            this.xTagMax = xTag;
        } else {
            this.monotonic = false;
        }
        this.delegate.packet(pd, xTag, vectors);
        ++this.packetCount;
        if (this.totalPacketCount != -1) {
            this.monitor.setTaskProgress((long)this.packetCount);
        }
    }

    @Override
    public void streamClosed(StreamDescriptor sd) throws StreamException {
        logger.finest("got streamClosed");
        if (this.delegate != null) {
            this.delegate.streamClosed(sd);
        }
    }

    @Override
    public void streamException(StreamException se) throws StreamException {
        logger.finest("got stream exception");
    }

    @Override
    public void streamComment(StreamComment sc) throws StreamException {
        logger.log(Level.FINEST, "got stream comment: {0}", sc);
        if (sc.getType().equals("taskSize")) {
            if (!this.monitor.isCancelled()) {
                this.taskSize = Integer.parseInt(sc.getValue());
                this.monitor.setTaskSize((long)this.taskSize);
                this.monitor.started();
            }
            return;
        }
        if (sc.getType().equals("taskProgress")) {
            if (this.taskSize != -1 && !this.monitor.isCancelled()) {
                this.monitor.setTaskProgress(Long.parseLong(sc.getValue()));
            }
            return;
        }
        if (sc.getType().matches("log:(.*)")) {
            String level = sc.getType().substring(4);
            Level l = Level.parse(level.toUpperCase());
            if (l.intValue() > Level.FINE.intValue()) {
                logger.log(Level.FINE, sc.getValue());
            } else {
                logger.log(l, sc.getValue());
            }
            this.monitor.setProgressMessage(sc.getValue());
        }
    }

    public DataSet getDataSet() {
        if (this.delegate == null) {
            System.err.println("never established delegate, which might mean the stream contains no packets.");
            return null;
        }
        DataSet d = this.delegate.getDataSet();
        d.getProperty("schema");
        return this.delegate.getDataSet();
    }

    private void ensureNotNullDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Null delegate");
        }
    }

    private static double getXWithBase(Datum base, Datum x) {
        if (base == null) {
            return x.doubleValue(x.getUnits());
        }
        return base.doubleValue(base.getUnits()) + x.doubleValue(base.getUnits().getOffsetUnits());
    }

    private class TableDataSetStreamHandler
    implements StreamHandlerDelegate {
        private TableDataSetBuilder builder;
        String[] streamPlaneIDs = null;

        private TableDataSetStreamHandler(PacketDescriptor pd) throws StreamException {
            StreamYScanDescriptor y = (StreamYScanDescriptor)pd.getYDescriptor(0);
            Datum base = pd.getXDescriptor().getBase();
            Units xUnits = base != null ? base.getUnits() : pd.getXDescriptor().getUnits();
            Units yUnits = y.getYUnits();
            Units zUnits = y.getZUnits();
            this.builder = new TableDataSetBuilder(xUnits, yUnits, zUnits, y.getName());
            this.packetDescriptor(pd);
        }

        @Override
        public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
            StreamYScanDescriptor yscan = (StreamYScanDescriptor)pd.getYDescriptor(0);
            Datum base = pd.getXDescriptor().getBase();
            Datum x = base == null ? xTag : base.add(xTag);
            DatumVector y = DatumVector.newDatumVector((double[])yscan.getYTags(), (Units)yscan.getYUnits());
            String[] planeIDs = new String[pd.getYCount()];
            for (int i = 0; i < pd.getYCount(); ++i) {
                planeIDs[i] = ((StreamYScanDescriptor)pd.getYDescriptor(i)).getName();
            }
            this.builder.insertYScan(x, y, vectors, planeIDs);
        }

        @Override
        public void packetDescriptor(PacketDescriptor pd) throws StreamException {
            int i;
            StreamYScanDescriptor y = (StreamYScanDescriptor)pd.getYDescriptor(0);
            this.builder.setPlaneProperties(0, y.getProperties());
            for (int i2 = 1; i2 < pd.getYCount(); ++i2) {
                y = (StreamYScanDescriptor)pd.getYDescriptor(i2);
                this.builder.addPlane(y.getName(), y.getZUnits(), y.getProperties());
            }
            String[] planeIDs = new String[pd.getYCount()];
            for (i = 0; i < pd.getYCount(); ++i) {
                planeIDs[i] = ((StreamYScanDescriptor)pd.getYDescriptor(i)).getName();
            }
            if (this.streamPlaneIDs == null) {
                this.streamPlaneIDs = planeIDs;
            } else {
                for (i = 0; i < this.streamPlaneIDs.length; ++i) {
                    if (this.streamPlaneIDs[i].equals(planeIDs[i])) continue;
                    throw new StreamException("only one name set allowed in stream: " + planeIDs[i] + " != " + this.streamPlaneIDs[i]);
                }
            }
            Map p = pd.getProperties();
            for (Map.Entry e : p.entrySet()) {
                String key = (String)e.getKey();
                Object p0 = this.builder.getProperty(key);
                if (p0 == null) {
                    this.builder.setProperty(key, e.getValue());
                    continue;
                }
                if (p0.equals(e.getValue())) continue;
                int i2 = 1;
                while (this.builder.getProperty("" + key + "." + i2) != null) {
                    ++i2;
                }
                this.builder.setProperty("" + key + "." + i2, e.getValue());
            }
        }

        @Override
        public void streamClosed(StreamDescriptor sd) throws StreamException {
        }

        @Override
        public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        }

        @Override
        public void streamException(StreamException se) throws StreamException {
        }

        @Override
        public void streamComment(StreamComment sc) throws StreamException {
        }

        @Override
        public DataSet getDataSet() {
            this.builder.addProperties(DataSetStreamHandler.this.sd.getProperties());
            this.builder.addProperties(DataSetStreamHandler.this.extraProperties);
            if (DataSetStreamHandler.this.monotonic && this.builder.getProperty("xMonotonic") == null) {
                this.builder.setProperty("xMonotonic", Boolean.TRUE);
            }
            return this.builder.toTableDataSet();
        }
    }

    private class VectorDataSetStreamHandler
    implements StreamHandlerDelegate {
        private VectorDataSetBuilder builder;
        private DatumRange validRange = null;

        private VectorDataSetStreamHandler(PacketDescriptor pd) throws StreamException {
            StreamScalarDescriptor y = (StreamScalarDescriptor)pd.getYDescriptor(0);
            Datum base = pd.getXDescriptor().getBase();
            Units xUnits = base == null ? pd.getXDescriptor().getUnits() : base.getUnits();
            Units yUnits = y.getUnits();
            this.builder = new VectorDataSetBuilder(xUnits, yUnits);
            this.builder.addProperties(Collections.singletonMap("yLabel", y.getProperty("name")));
            for (int i = 1; i < pd.getYCount(); ++i) {
                StreamScalarDescriptor smyd = (StreamScalarDescriptor)pd.getYDescriptor(i);
                this.builder.addProperties(Collections.singletonMap(smyd.getName() + "." + "yLabel", smyd.getName()));
            }
            String srange = (String)y.getProperty("valid_range");
            if (srange != null) {
                try {
                    this.validRange = DatumRangeUtil.parseDatumRange((String)srange, (Units)yUnits);
                }
                catch (ParseException ex) {
                    throw new StreamException("Unable to parse valid_range:" + srange);
                }
            }
            this.packetDescriptor(pd);
        }

        @Override
        public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
            Datum base = pd.getXDescriptor().getBase();
            double x = DataSetStreamHandler.getXWithBase(base, xTag);
            for (int i = 0; i < pd.getYCount(); ++i) {
                if (pd.getYDescriptor(i) instanceof StreamScalarDescriptor) {
                    StreamScalarDescriptor my = (StreamScalarDescriptor)pd.getYDescriptor(i);
                    double y = vectors[i].doubleValue(0, my.getUnits());
                    if (this.validRange != null && !this.validRange.contains(Datum.create((double)y, (Units)my.getUnits()))) {
                        y = my.getUnits().getFillDouble();
                    }
                    if (i != 0) {
                        this.builder.insertY(x, y, my.getName());
                    } else {
                        this.builder.insertY(x, y);
                    }
                    Map props = my.getProperties();
                    for (Map.Entry p : props.entrySet()) {
                        if (i == 0) {
                            this.builder.setProperty((String)p.getKey(), p.getValue());
                            continue;
                        }
                        this.builder.setProperty(my.getName() + "." + (String)p.getKey(), p.getValue());
                    }
                    continue;
                }
                throw new StreamException("Mixed data sets are not currently supported");
            }
        }

        @Override
        public void packetDescriptor(PacketDescriptor pd) throws StreamException {
            logger.log(Level.FINE, "got packet descriptor: {0}", pd);
            for (int i = 1; i < pd.getYCount(); ++i) {
                StreamScalarDescriptor y = (StreamScalarDescriptor)pd.getYDescriptor(i);
                this.builder.addPlane(y.getName(), y.getUnits());
                if (!(y instanceof StreamZDescriptor)) continue;
                this.builder.setProperty("schema", "xyzScatter");
            }
        }

        @Override
        public void streamClosed(StreamDescriptor sd) throws StreamException {
        }

        @Override
        public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        }

        @Override
        public void streamException(StreamException se) throws StreamException {
        }

        @Override
        public void streamComment(StreamComment sc) throws StreamException {
        }

        @Override
        public DataSet getDataSet() {
            this.builder.addProperties(DataSetStreamHandler.this.sd.getProperties());
            this.builder.addProperties(DataSetStreamHandler.this.extraProperties);
            if (DataSetStreamHandler.this.monotonic && this.builder.getProperty("xMonotonic") == null) {
                this.builder.setProperty("xMonotonic", Boolean.TRUE);
            }
            return this.builder.toVectorDataSet();
        }
    }

    private static interface StreamHandlerDelegate
    extends StreamHandler {
        public DataSet getDataSet();
    }
}

