/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.das2.DasException;
import org.das2.components.ComponentsUtil;
import org.das2.dataset.AverageTableRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SymbolLineRenderer;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;

public class VerticalSpectrogramAverager
implements DataRangeSelectionListener {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.gui.dmia");
    private JDialog popupWindow;
    private final DasPlot parentPlot;
    private DasPlot myPlot;
    private final DasAxis sourceZAxis;
    private final DasAxis sourceXAxis;
    protected Datum value;
    private SeriesRenderer renderer;
    private final Color markColor = new Color(230, 230, 230);
    JPanel buttonPanel;
    List<Action> additionalActions = new ArrayList<Action>();
    private String mode = "average";
    public static final String PROP_MODE = "mode";
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected VerticalSpectrogramAverager(DasPlot parent, DasAxis sourceXAxis, DasAxis sourceZAxis) {
        this.sourceZAxis = sourceZAxis;
        this.sourceXAxis = sourceXAxis;
        this.parentPlot = parent;
    }

    private void initPlot() {
        DasAxis xAxis = this.sourceXAxis.createAttachedAxis(2);
        DasAxis yAxis = this.sourceZAxis.createAttachedAxis(3);
        this.myPlot = new DasPlot(xAxis, yAxis);
        this.renderer = new SymbolLineRenderer();
        this.renderer.setAntiAliased(true);
        this.myPlot.addRenderer(this.renderer);
        this.myPlot.addRenderer(new Renderer(){

            @Override
            public void render(Graphics2D g, DasAxis xAxis, DasAxis yAxis) {
                if (VerticalSpectrogramAverager.this.value != null) {
                    int ix = (int)VerticalSpectrogramAverager.this.myPlot.getXAxis().transform(VerticalSpectrogramAverager.this.value);
                    DasRow row = VerticalSpectrogramAverager.this.myPlot.getRow();
                    int iy0 = row.getDMinimum();
                    int iy1 = row.getDMaximum();
                    g.drawLine(ix + 3, iy0, ix, iy0 + 3);
                    g.drawLine(ix - 3, iy0, ix, iy0 + 3);
                    g.drawLine(ix + 3, iy1, ix, iy1 - 3);
                    g.drawLine(ix - 3, iy1, ix, iy1 - 3);
                    g.setColor(VerticalSpectrogramAverager.this.markColor);
                    g.drawLine(ix, iy0 + 4, ix, iy1 - 4);
                }
            }
        });
    }

    public void addAction(Action a) {
        this.additionalActions.add(a);
        if (this.buttonPanel != null) {
            JButton b = new JButton(a);
            this.buttonPanel.add((Component)b, 0);
        }
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        String oldMode = this.mode;
        this.mode = mode;
        this.propertyChangeSupport.firePropertyChange(PROP_MODE, oldMode, mode);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void setDataSet(QDataSet ds) {
        this.renderer.setDataSet(ds);
    }

    public QDataSet getDataSet() {
        return this.renderer.getDataSet();
    }

    public static VerticalSpectrogramAverager createAverager(DasPlot plot, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceYAxis = plot.getYAxis();
        DasAxis sourceZAxis = dataSetConsumer.getZAxis();
        return new VerticalSpectrogramAverager(plot, sourceYAxis, sourceZAxis);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    VerticalSpectrogramAverager.this.showPopupImpl();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    public void dispose() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            this.popupWindow.dispose();
        }
    }

    public void clear() {
        if (this.renderer != null) {
            this.renderer.setDataSet(null);
        }
    }

    private void createPopup() {
        if (this.myPlot == null) {
            this.initPlot();
        }
        int width = this.parentPlot.getCanvas().getWidth() / 2;
        int height = this.parentPlot.getCanvas().getHeight() / 2;
        final DasCanvas canvas = new DasCanvas(width, height);
        DasRow row = new DasRow(canvas, null, 0.0, 1.0, 3.0, -5.0, 0, 0);
        DasColumn column = new DasColumn(canvas, null, 0.0, 1.0, 7.0, -3.0, 0, 0);
        canvas.add(this.myPlot, row, column);
        JPanel content = new JPanel(new BorderLayout());
        this.buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(this.buttonPanel, 0);
        this.buttonPanel.setLayout(buttonLayout);
        if (this.additionalActions != null && this.additionalActions.size() > 0) {
            for (Action a : this.additionalActions) {
                this.buttonPanel.add(new JButton(a));
            }
        }
        this.buttonPanel.add(Box.createHorizontalGlue());
        JButton pdfButton = new JButton(ComponentsUtil.getPdfButtonAction(canvas));
        this.buttonPanel.add(pdfButton);
        JButton printButton = new JButton(new AbstractAction("Print..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                canvas.makeCurrent();
                DasCanvas.PRINT_ACTION.actionPerformed(e);
            }
        });
        this.buttonPanel.add(printButton);
        JButton close = new JButton("Hide Window");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerticalSpectrogramAverager.this.popupWindow.setVisible(false);
            }
        });
        this.buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)this.buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = new JDialog(parentWindow);
        this.popupWindow.setTitle("Vertical Interval Averager");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(content);
        this.popupWindow.pack();
        Point parentLocation = new Point(0, this.parentPlot.getY());
        parentLocation.translate(this.parentPlot.getX() / 20, -1 * this.myPlot.getRow().getDMinimum());
        SwingUtilities.convertPointToScreen(parentLocation, this.parentPlot.getCanvas());
        int xx = parentLocation.x + this.parentPlot.getCanvas().getWidth();
        int yy = parentLocation.y;
        Rectangle r = ComponentsUtil.verifyVisible(new Rectangle(xx, yy, width, height));
        if (r != null) {
            xx = r.x;
            yy = r.y;
        }
        JComboBox<String> modeCB = new JComboBox<String>(new String[]{"average", "sum"});
        modeCB.addActionListener(e -> {
            this.setMode((String)modeCB.getSelectedItem());
            JOptionPane.showMessageDialog(this.buttonPanel, "Re-slice to update.", "mode updated", 1);
        });
        this.buttonPanel.add(modeCB);
        this.popupWindow.setLocation(xx, yy);
    }

    protected boolean isPopupVisible() {
        return this.popupWindow != null && this.popupWindow.isVisible() && this.myPlot.getCanvas() != null;
    }

    @Override
    public void dataRangeSelected(DataRangeSelectionEvent e) {
        QDataSet ds = e.getDataSet();
        if (ds == null) {
            return;
        }
        if (Schemes.isXYZScatter((QDataSet)ds)) {
            logger.fine("gridding data to support mouse module");
            ds = Ops.grid((QDataSet)ds);
        } else if (!SemanticOps.isTableDataSet((QDataSet)ds)) {
            logger.log(Level.WARNING, "dataset scheme is not supported: {0}", ds);
        }
        QDataSet xtys = ds;
        Datum xValue1 = e.getMinimum();
        Datum xValue2 = e.getMaximum();
        if (xValue2.equals(xValue1)) {
            return;
        }
        if (!this.isPopupVisible()) {
            this.showPopup();
        } else {
            Rectangle r = ComponentsUtil.verifyVisible(this.popupWindow.getBounds());
            if (r != null) {
                this.popupWindow.setLocation(r.x, r.y);
            }
        }
        RebinDescriptor ddX = new RebinDescriptor(xValue1, xValue2, 1, false);
        ddX.setOutOfBoundsAction(-3);
        AverageTableRebinner rebinner = new AverageTableRebinner();
        String title = this.parentPlot.getTitle().trim();
        try {
            if (xtys.rank() == 3) {
                QDataSet jds = null;
                for (int i = 0; i < xtys.length(); ++i) {
                    QDataSet rebinned = rebinner.rebin(xtys.slice(i), ddX, null, null);
                    QDataSet ds1 = rebinned.slice(0);
                    jds = Ops.append(jds, (QDataSet)ds1);
                }
                this.renderer.setDataSet(jds);
            } else {
                QDataSet rebinned;
                switch (this.mode) {
                    case "average": {
                        rebinned = Ops.reduceMean((QDataSet)Ops.trim((QDataSet)ds, (QDataSet)Ops.dataset((Object)xValue1), (QDataSet)Ops.dataset((Object)xValue2)), (int)0);
                        title = "Averaged " + title;
                        break;
                    }
                    case "sum": {
                        rebinned = Ops.reduceSum((QDataSet)Ops.trim((QDataSet)ds, (QDataSet)Ops.dataset((Object)xValue1), (QDataSet)Ops.dataset((Object)xValue2)), (int)0);
                        title = "Summed " + title;
                        break;
                    }
                    case "integrate": {
                        this.renderer.setException(new Exception("integrate is not implemented."));
                        return;
                    }
                    default: {
                        this.renderer.setException(new Exception("unknown mode in averager: " + this.mode));
                        return;
                    }
                }
                this.myPlot.getCanvas().setFont(this.parentPlot.getCanvas().getFont());
                QDataSet ds1 = rebinned;
                this.renderer.setDataSet(ds1);
            }
        }
        catch (DasException dasException) {
            // empty catch block
        }
        this.value = e.getReference();
        this.myPlot.setTitle(title + "!c" + new DatumRange(xValue1, xValue2).toString());
        if (!this.myPlot.getXAxis().getLabel().equals(this.sourceXAxis.getLabel())) {
            this.myPlot.getXAxis().setLabel(this.sourceXAxis.getLabel());
        }
        if (!this.myPlot.getYAxis().getLabel().equals(this.sourceZAxis.getLabel())) {
            this.myPlot.getYAxis().setLabel(this.sourceZAxis.getLabel());
        }
    }
}

