/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.beans.IndexedPropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.das2.components.propertyeditor.IndexedPropertyItemTreeNode;
import org.das2.components.propertyeditor.PropertyTreeNode;

class IndexedPropertyTreeNode
extends PropertyTreeNode {
    private IndexedPropertyDescriptor indexedPropertyDescriptor;

    IndexedPropertyTreeNode(PropertyTreeNode parent, IndexedPropertyDescriptor indexedPropertyDescriptor) throws InvocationTargetException {
        super(parent, indexedPropertyDescriptor);
        this.indexedPropertyDescriptor = indexedPropertyDescriptor;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    protected void maybeLoadChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
            int childCount = Array.getLength(this.value);
            for (int i = 0; i < childCount; ++i) {
                this.children.add(new IndexedPropertyItemTreeNode(this, this.indexedPropertyDescriptor, i));
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.propertyDescriptor.getName() + "[]";
    }

    @Override
    public Object getDisplayValue() {
        return "" + this.getChildCount() + " element" + (this.getChildCount() != 1 ? "s" : "");
    }

    @Override
    public void flush() {
        if (this.childDirty) {
            for (PropertyTreeNode child : this.children) {
                child.flush();
            }
            this.childDirty = false;
        }
    }

    @Override
    protected Object read() {
        if (this.propertyDescriptor == null) {
            return this.value;
        }
        Method readMethod = this.propertyDescriptor.getReadMethod();
        if (readMethod == null) {
            String pName = this.propertyDescriptor.getName();
            String pId = this.value.getClass().getName() + "#" + pName;
            throw new IllegalStateException("Null read method for: " + pId);
        }
        try {
            return readMethod.invoke(this.parent.value, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            IllegalAccessError err = new IllegalAccessError(iae.getMessage());
            err.initCause(iae);
            throw err;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    @Override
    public boolean isCellEditable(int column) {
        return false;
    }

    @Override
    public void refresh() {
        Object newValue;
        this.value = newValue = this.read();
        if (this.children != null) {
            if (this.children.size() < ((Object[])newValue).length) {
                this.children = null;
                this.treeModel.nodeStructureChanged(this);
            } else if (this.children.size() > ((Object[])newValue).length) {
                this.children = null;
                this.treeModel.nodeStructureChanged(this);
            }
        }
        if (this.children != null) {
            for (PropertyTreeNode child : this.children) {
                child.refresh();
            }
        }
    }
}

