/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.treetable;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    private JTable table;
    private int visibleRow;

    public TreeTableCellRenderer(TreeModel model) {
        super(model);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, 0, w, this.table.getRowHeight() * this.table.getRowCount());
    }

    @Override
    public void paint(Graphics g) {
        g.translate(0, -this.visibleRow * this.getHeight() / this.getRowCount());
        super.paint(g);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.table = table;
        this.visibleRow = row;
        if (table != null) {
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        }
        return this;
    }
}

