/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.beans.BeansUtil;
import org.das2.dasml.CommandBlock;
import org.das2.dasml.DataFormatException;
import org.das2.dasml.FormComponent;
import org.das2.dasml.FormTab;
import org.das2.dasml.FormWindow;
import org.das2.dasml.ParsedExpressionException;
import org.das2.dasml.Processor;
import org.das2.dasml.TransferableFormComponent;
import org.das2.datum.Datum;
import org.das2.datum.LoggerManager;
import org.das2.util.DasExceptionHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FormBase
extends JTabbedPane
implements FormComponent {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.dasml");
    private static DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    private DasApplication application = DasApplication.getDefaultApplication();
    private CommandBlock initBlock;
    List windowList = new ArrayList();
    private JDesktopPane desktop;
    boolean editable;
    private boolean onHover = false;

    public FormBase(URL url, ErrorHandler eh, boolean editable) throws IOException, SAXException {
        this(url.openStream(), eh, editable);
    }

    public FormBase(InputStream in, ErrorHandler eh, boolean editable) throws IOException, SAXException {
        this(new InputStreamReader(in), eh, editable);
    }

    public FormBase(Reader reader, ErrorHandler eh, boolean editable) throws IOException, SAXException {
        DnDSupport dndSupport = new DnDSupport();
        DropTarget dropTarget = new DropTarget(this, dndSupport);
        this.setDropTarget(dropTarget);
        this.editable = editable;
        try {
            Document document = FormBase.parseDasML(reader, eh);
            this.createFormFromTree(document);
            this.registerComponent();
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalStateException("DOM parser not configured properly: " + pce.getMessage());
        }
        catch (DasException de) {
            throw new SAXException(de);
        }
    }

    public FormBase(boolean editable) {
        DnDSupport dndSupport = new DnDSupport();
        DropTarget dropTarget = new DropTarget(this, dndSupport);
        this.setDropTarget(dropTarget);
        this.editable = editable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Document parseDasML(Reader reader, ErrorHandler eh) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder;
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        DocumentBuilderFactory documentBuilderFactory = domFactory;
        synchronized (documentBuilderFactory) {
            builder = domFactory.newDocumentBuilder();
        }
        builder.setErrorHandler(eh);
        return builder.parse(source);
    }

    private void createFormFromTree(Document doc) throws SAXException {
        try {
            Element das2 = doc.getDocumentElement();
            if (!das2.getTagName().equals("das2")) {
                // empty if block
            }
            NodeList children = das2.getChildNodes();
            int childCount = children.getLength();
            for (int index = 0; index < childCount; ++index) {
                Node node = children.item(index);
                if (!(node instanceof Element)) continue;
                if (node.getNodeName().equals("form")) {
                    FormTab form = new FormTab((Element)node, this);
                    this.addForm(form);
                    continue;
                }
                if (node.getNodeName().equals("window")) {
                    FormWindow window = new FormWindow((Element)node, this);
                    this.addWindow(window);
                    continue;
                }
                if (!node.getNodeName().equals("init")) continue;
                this.initBlock = this.processInitElement((Element)node);
            }
        }
        catch (DasException dne) {
            throw new SAXException(dne);
        }
        catch (ParsedExpressionException pee) {
            throw new SAXException(pee);
        }
    }

    private int getTabInsertionIndex() {
        int index;
        int count = this.getComponentCount();
        for (index = 0; index < count && this.getComponent(index) instanceof FormTab; ++index) {
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addForm(FormTab form) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getEditingMode()) {
                int index = this.getTabInsertionIndex();
                this.insertTab(form.getLabel(), null, form, null, index);
            } else {
                this.addTab(form.getLabel(), form);
            }
        }
        form.setEditingMode(this.getEditingMode());
    }

    public void addWindow(FormWindow window) {
        if (window.form != null) {
            window.form.removeWindow(window);
        }
        window.form = this;
        this.windowList.add(window);
        boolean editingMode = this.getEditingMode();
        window.setEditingMode(editingMode);
        if (editingMode) {
            if (this.desktop == null) {
                this.desktop = new JDesktopPane();
                this.add((Component)this.desktop, "Windows");
            }
            window.pack();
            this.desktop.add(window.getInternalFrame());
        }
        this.firePropertyChange("window", null, window);
    }

    public void removeWindow(FormWindow window) {
        if (this.windowList.contains(window)) {
            this.windowList.remove(window);
            if (this.getEditingMode()) {
                this.desktop.remove(SwingUtilities.getAncestorOfClass(JInternalFrame.class, window));
            }
            this.firePropertyChange("window", window, null);
        }
    }

    private CommandBlock processActionElement(Element element) {
        return new CommandBlock(element, this);
    }

    Component processGlueElement(Element element) {
        String direction = element.getAttribute("direction");
        if (direction.equals("horizontal")) {
            return Box.createHorizontalGlue();
        }
        return Box.createVerticalGlue();
    }

    private CommandBlock processInitElement(Element element) throws SAXException {
        return new CommandBlock(element, this);
    }

    public void serialize(OutputStream out) throws IOException {
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.appendChild(this.getDOMElement(document));
            DOMImplementationLS ls = (DOMImplementationLS)document.getImplementation().getFeature("LS", "3.0");
            LSOutput output = ls.createLSOutput();
            output.setEncoding("UTF-8");
            output.setByteStream(out);
            ls.createLSSerializer().write(document, output);
            out.close();
        }
        catch (ParserConfigurationException pce) {
            IOException ioe = new IOException(pce.getMessage());
            ioe.initCause(pce);
            throw ioe;
        }
    }

    private boolean isValidType(Class type) {
        return type.isPrimitive() || type == String.class || type == Datum.class || Datum.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type);
    }

    public Object checkValue(String name, Class type, String tag) throws DasPropertyException, DasNameException {
        try {
            Object obj = this.application.getNameContext().get(name);
            if (obj == null) {
                throw new DasNameException(name + " must be defined before it is used");
            }
            if (!type.isInstance(obj)) {
                throw new DasPropertyException(DasPropertyException.TYPE_MISMATCH, name, null);
            }
            return obj;
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite);
        }
    }

    public Object invoke(String name, String[] args) throws DasPropertyException, DataFormatException, ParsedExpressionException, InvocationTargetException {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            throw new DataFormatException("No object associated with method name" + name);
        }
        String objectName = name.substring(0, lastDot);
        String methodName = name.substring(lastDot + 1);
        logger.fine("object name: " + objectName);
        logger.fine("method name: " + methodName);
        Object o = this.application.getNameContext().get(objectName);
        Method method = null;
        try {
            BeanInfo info = BeansUtil.getBeanInfo(o.getClass());
            MethodDescriptor[] methodDescriptors = info.getMethodDescriptors();
            for (int i = 0; i <= methodDescriptors.length; ++i) {
                if (i == methodDescriptors.length) {
                    throw new DasPropertyException(DasPropertyException.NOT_DEFINED, methodName, objectName);
                }
                if (!methodDescriptors[i].getName().equals(methodName)) continue;
                method = methodDescriptors[i].getMethod();
                break;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] argValues = new Object[args.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                argValues[i] = Processor.parseValue(this.application.getNameContext(), args[i], parameterTypes[i]);
            }
            return method.invoke(o, argValues);
        }
        catch (IntrospectionException ie) {
            throw new DataFormatException(ie.getMessage());
        }
        catch (InvocationTargetException ite) {
            throw new DataFormatException(ite.getTargetException().getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new DataFormatException(iae.getMessage());
        }
    }

    @Override
    public boolean getEditingMode() {
        return this.editable;
    }

    @Override
    public void setEditingMode(boolean b) {
        if (this.editable != b) {
            this.editable = b;
            int componentCount = this.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof FormTab)) continue;
                ((FormTab)c).setEditingMode(b);
            }
            if (this.windowList.size() > 0) {
                if (b) {
                    if (this.desktop == null) {
                        this.desktop = new JDesktopPane();
                    }
                    this.add((Component)this.desktop, "Windows");
                } else {
                    this.remove(this.desktop);
                }
                for (FormWindow window : this.windowList) {
                    window.setEditingMode(b);
                    if (!b) continue;
                    window.pack();
                    JInternalFrame it = window.getInternalFrame();
                    if (it.getParent() == this.desktop) continue;
                    this.desktop.add(it);
                }
            }
            this.revalidate();
            this.repaint();
            if (b) {
                this.firePropertyChange("editable", Boolean.FALSE, Boolean.TRUE);
            } else {
                this.firePropertyChange("editable", Boolean.TRUE, Boolean.FALSE);
            }
        }
    }

    @Override
    public FormBase getForm() {
        return this;
    }

    @Override
    public Element getDOMElement(Document document) {
        Element element = document.createElement("das2");
        for (int index = 0; index < this.getComponentCount(); ++index) {
            FormComponent child = (FormComponent)((Object)this.getComponent(index));
            element.appendChild(child.getDOMElement(document));
        }
        if (!this.editable) {
            for (FormComponent child : this.windowList) {
                element.appendChild(child.getDOMElement(document));
            }
        }
        return element;
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        if (this.onHover) {
            Graphics2D g2 = (Graphics2D)g.create();
            BasicStroke thick = new BasicStroke(3.0f);
            g2.setStroke(thick);
            g2.setColor(Color.GRAY);
            g2.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            g2.dispose();
        }
    }

    @Override
    public org.das2.util.DnDSupport getDnDSupport() {
        return null;
    }

    @Override
    public boolean startDrag(int x, int y, int action, MouseEvent evt) {
        return false;
    }

    @Override
    public String getDasName() {
        return null;
    }

    public List getWindowList() {
        return Collections.unmodifiableList(this.windowList);
    }

    @Override
    public void setDasName(String name) throws DasNameException {
        throw new DasNameException();
    }

    @Override
    public void deregisterComponent() {
        for (int index = 0; index < this.getComponentCount(); ++index) {
            Component c = this.getComponent(index);
            if (!(c instanceof FormComponent)) continue;
            ((FormComponent)((Object)c)).deregisterComponent();
        }
        for (FormWindow w : this.windowList) {
            w.deregisterComponent();
        }
    }

    @Override
    public DasApplication getDasApplication() {
        return this.application;
    }

    @Override
    public void registerComponent() throws DasException {
        for (int index = 0; index < this.getComponentCount(); ++index) {
            Component c = this.getComponent(index);
            if (!(c instanceof FormComponent)) continue;
            ((FormComponent)((Object)c)).registerComponent();
        }
        for (FormWindow w : this.windowList) {
            w.registerComponent();
        }
    }

    static {
        URL schemaLocation = FormBase.class.getResource("schema/dasML.xsd");
        if (schemaLocation != null) {
            domFactory.setAttribute("http://apache.org/xml/features/validation/schema-full-checking", Boolean.TRUE);
            domFactory.setAttribute("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", schemaLocation.toExternalForm());
            domFactory.setValidating(true);
            domFactory.setNamespaceAware(true);
        }
        domFactory.setCoalescing(true);
        domFactory.setIgnoringElementContentWhitespace(true);
    }

    private class DnDSupport
    implements DropTargetListener {
        private final Set acceptableFlavors = new HashSet<DataFlavor>(Arrays.asList(TransferableFormComponent.TAB_FLAVOR, TransferableFormComponent.WINDOW_FLAVOR));

        private DnDSupport() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (this.canAccept(dtde.getCurrentDataFlavors())) {
                dtde.acceptDrag(dtde.getSourceActions());
                FormBase.this.onHover = true;
                FormBase.this.repaint();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            FormBase.this.onHover = false;
            FormBase.this.repaint();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            boolean success = false;
            if (this.canAccept(dtde.getCurrentDataFlavors())) {
                Transferable t = dtde.getTransferable();
                if (t.isDataFlavorSupported(TransferableFormComponent.COMPONENT_FLAVOR)) {
                    dtde.acceptDrop(dtde.getDropAction());
                    success = this.acceptComponent(t);
                } else if (t.isDataFlavorSupported(TransferableFormComponent.DASML_FRAGMENT_FLAVOR)) {
                    dtde.acceptDrop(1);
                    success = this.acceptFragment(t);
                }
                dtde.dropComplete(success);
            } else {
                dtde.rejectDrop();
            }
            FormBase.this.onHover = false;
            FormBase.this.repaint();
        }

        private boolean acceptFragment(Transferable t) {
            boolean success = false;
            try {
                String data = (String)t.getTransferData(TransferableFormComponent.DASML_FRAGMENT_FLAVOR);
                Document document = FormBase.parseDasML(new StringReader(data), null);
                Element root = document.getDocumentElement();
                if (root.getTagName().equals("form")) {
                    FormTab tab = new FormTab(root, FormBase.this);
                    FormBase.this.addForm(tab);
                    success = true;
                    FormBase.this.revalidate();
                } else if (root.getTagName().equals("window")) {
                    FormWindow window = new FormWindow(root, FormBase.this);
                    FormBase.this.addWindow(window);
                    success = true;
                    FormBase.this.revalidate();
                }
            }
            catch (ParsedExpressionException pee) {
                pee.printStackTrace();
            }
            catch (DasException de) {
                de.printStackTrace();
            }
            catch (UnsupportedFlavorException de) {
            }
            catch (IOException ioe) {
                DasExceptionHandler.handle((Throwable)ioe);
            }
            catch (ParserConfigurationException pce) {
                DasExceptionHandler.handle((Throwable)pce);
            }
            catch (SAXException se) {
                DasExceptionHandler.handle((Throwable)se);
            }
            return success;
        }

        private boolean acceptComponent(Transferable t) {
            boolean success = false;
            try {
                Component c = (Component)t.getTransferData(TransferableFormComponent.COMPONENT_FLAVOR);
                if (c instanceof FormTab) {
                    FormBase.this.addForm((FormTab)c);
                    success = true;
                    FormBase.this.revalidate();
                } else if (c instanceof FormWindow) {
                    FormBase.this.addWindow((FormWindow)c);
                    success = true;
                    FormBase.this.revalidate();
                } else {
                    System.out.println(c);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return success;
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            if (FormBase.this.onHover) {
                dtde.acceptDrag(dtde.getDropAction());
            }
        }

        private boolean canAccept(DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!this.acceptableFlavors.contains(flavors[i])) continue;
                return true;
            }
            return false;
        }
    }
}

