/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.NameContext;
import org.das2.dasml.FormBase;
import org.das2.dasml.FormComponent;
import org.das2.dasml.ParsedExpression;
import org.das2.dasml.ParsedExpressionException;
import org.das2.datum.Datum;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasLabelAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.StackedHistogramRenderer;
import org.das2.graph.SymColor;
import org.das2.graph.SymbolLineRenderer;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Processor {
    public static final Pattern refPattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
    public static final Pattern intPattern = Pattern.compile("-?(0|[1-9][0-9]*)");
    public static final Pattern floatPattern = Pattern.compile("-?[0-9]*(\\.[0-9]*)?([eE]-?[0-9]+)?");

    static DasAxis processAxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String columnString;
        Datum dataMaximum;
        Datum dataMinimum;
        String max;
        String min;
        String name = element.getAttribute("name");
        boolean log = element.getAttribute("log").equals("true");
        if ("TIME".equals(element.getAttribute("units"))) {
            min = element.getAttribute("dataMinimum");
            max = element.getAttribute("dataMaximum");
            dataMinimum = min == null || min.equals("") ? TimeUtil.create((String)"1979-02-26") : TimeUtil.create((String)min);
            dataMaximum = max == null || max.equals("") ? TimeUtil.create((String)"1979-02-27") : TimeUtil.create((String)max);
        } else {
            min = element.getAttribute("dataMinimum");
            max = element.getAttribute("dataMaximum");
            dataMinimum = min == null || min.equals("") ? Datum.create((double)1.0) : Datum.create((double)Double.parseDouble(min));
            dataMaximum = max == null || max.equals("") ? Datum.create((double)10.0) : Datum.create((double)Double.parseDouble(max));
        }
        int orientation = Processor.parseOrientationString(element.getAttribute("orientation"));
        DasAxis axis = new DasAxis(dataMinimum, dataMaximum, orientation, log);
        String rowString = element.getAttribute("row");
        if (!rowString.equals("")) {
            DasRow row = (DasRow)form.checkValue(rowString, DasRow.class, "<row>");
            axis.setRow(row);
        }
        if (!(columnString = element.getAttribute("column")).equals("")) {
            DasColumn column = (DasColumn)form.checkValue(columnString, DasColumn.class, "<column>");
            axis.setColumn(column);
        }
        axis.setLabel(element.getAttribute("label"));
        axis.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        axis.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        axis.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, axis);
        return axis;
    }

    protected static String orientationToString(int i) {
        switch (i) {
            case 1: {
                return "top";
            }
            case 2: {
                return "bottom";
            }
            case 3: {
                return "left";
            }
            case 4: {
                return "right";
            }
        }
        throw new IllegalStateException("invalid orienation: " + i);
    }

    protected static int parseOrientationString(String orientationString) {
        if (orientationString.equals("horizontal")) {
            return 2;
        }
        if (orientationString.equals("vertical")) {
            return 3;
        }
        if (orientationString.equals("left")) {
            return 3;
        }
        if (orientationString.equals("right")) {
            return 4;
        }
        if (orientationString.equals("top")) {
            return 1;
        }
        if (orientationString.equals("bottom")) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientationString);
    }

    public static Element getDOMElement(DasAxis axis, Document document) {
        Element element = axis.isAttached() ? document.createElement("attachedaxis") : document.createElement("axis");
        if (axis.isAttached()) {
            element.setAttribute("ref", axis.getMasterAxis().getDasName());
        } else {
            String minimumStr = axis.getDataMinimum().toString();
            element.setAttribute("dataMinimum", minimumStr);
            String maximumStr = axis.getDataMaximum().toString();
            element.setAttribute("dataMaximum", maximumStr);
        }
        element.setAttribute("name", axis.getDasName());
        element.setAttribute("row", axis.getRow().getDasName());
        element.setAttribute("column", axis.getColumn().getDasName());
        element.setAttribute("label", axis.getLabel());
        element.setAttribute("log", Boolean.toString(axis.isLog()));
        element.setAttribute("tickLabelsVisible", Boolean.toString(axis.isTickLabelsVisible()));
        element.setAttribute("oppositeAxisVisible", Boolean.toString(axis.isOppositeAxisVisible()));
        element.setAttribute("animated", Boolean.toString(axis.isAnimated()));
        element.setAttribute("orientation", Processor.orientationToString(axis.getOrientation()));
        return element;
    }

    static DasAxis processTimeaxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException, DasException, ParseException {
        String columnString;
        String name = element.getAttribute("name");
        Datum timeMinimum = TimeUtil.create((String)element.getAttribute("timeMinimum"));
        Datum timeMaximum = TimeUtil.create((String)element.getAttribute("timeMaximum"));
        int orientation = Processor.parseOrientationString(element.getAttribute("orientation"));
        DasAxis timeaxis = new DasAxis(timeMinimum, timeMaximum, orientation);
        String rowString = element.getAttribute("row");
        if (!rowString.equals("")) {
            DasRow row = (DasRow)form.checkValue(rowString, DasRow.class, "<row>");
            timeaxis.setRow(row);
        }
        if (!(columnString = element.getAttribute("column")).equals("")) {
            DasColumn column = (DasColumn)form.checkValue(columnString, DasColumn.class, "<column>");
            timeaxis.setColumn(column);
        }
        timeaxis.setDataPath(element.getAttribute("dataPath"));
        timeaxis.setDrawTca(element.getAttribute("showTca").equals("true"));
        timeaxis.setLabel(element.getAttribute("label"));
        timeaxis.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        timeaxis.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        timeaxis.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, timeaxis);
        return timeaxis;
    }

    static DasAxis processAttachedaxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException {
        String columnString;
        String name = element.getAttribute("name");
        DasAxis ref = (DasAxis)form.checkValue(element.getAttribute("ref"), DasAxis.class, "<attachedaxis>");
        int orientation = element.getAttribute("orientation").equals("horizontal") ? 2 : 3;
        DasAxis axis = ref.createAttachedAxis(orientation);
        String rowString = element.getAttribute("row");
        if (!rowString.equals("")) {
            DasRow row = (DasRow)form.checkValue(rowString, DasRow.class, "<row>");
            axis.setRow(row);
        }
        if (!(columnString = element.getAttribute("column")).equals("")) {
            DasColumn column = (DasColumn)form.checkValue(columnString, DasColumn.class, "<column>");
            axis.setColumn(column);
        }
        axis.setDataPath(element.getAttribute("dataPath"));
        axis.setDrawTca(element.getAttribute("showTca").equals("true"));
        axis.setLabel(element.getAttribute("label"));
        axis.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        axis.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        axis.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, axis);
        return axis;
    }

    public static DasAxis createNamedAxis(String name) {
        DasAxis axis = new DasAxis(Datum.create((double)1.0, (Units)Units.dimensionless), Datum.create((double)10.0, (Units)Units.dimensionless), 2);
        if (name == null) {
            name = "axis_" + Integer.toHexString(System.identityHashCode(axis));
        }
        try {
            axis.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
        return axis;
    }

    public static Element getDOMElement(DasCanvas canvas, Document document) {
        int index;
        Element element = document.createElement("canvas");
        Dimension size = canvas.getPreferredSize();
        element.setAttribute("name", canvas.getDasName());
        element.setAttribute("width", Integer.toString(size.width));
        element.setAttribute("height", Integer.toString(size.height));
        for (int index2 = 0; index2 < canvas.devicePositionList().size(); ++index2) {
            Object obj = canvas.devicePositionList().get(index2);
            if (obj instanceof DasRow) {
                DasRow row = (DasRow)obj;
                element.appendChild(Processor.getDOMElement(row, document));
                continue;
            }
            if (!(obj instanceof DasColumn)) continue;
            DasColumn column = (DasColumn)obj;
            element.appendChild(Processor.getDOMElement(column, document));
        }
        DasCanvasComponent[] components = canvas.getCanvasComponents();
        LinkedHashMap<String, Element> elementMap = new LinkedHashMap<String, Element>();
        for (index = 0; index < components.length; ++index) {
            if (!(components[index] instanceof DasAxis)) continue;
            DasAxis axis = (DasAxis)components[index];
            elementMap.put(axis.getDasName(), Processor.getDOMElement(axis, document));
        }
        for (index = 0; index < components.length; ++index) {
            if (!(components[index] instanceof DasColorBar)) continue;
            DasColorBar colorbar = (DasColorBar)components[index];
            elementMap.put(colorbar.getDasName(), Processor.getDOMElement(colorbar, document));
        }
        for (index = 0; index < components.length; ++index) {
            if (!(components[index] instanceof DasPlot)) continue;
            DasPlot plot = (DasPlot)components[index];
            elementMap.remove(plot.getXAxis().getDasName());
            elementMap.remove(plot.getYAxis().getDasName());
            Renderer[] renderers = plot.getRenderers();
            for (int i = 0; i < renderers.length; ++i) {
                if (!(renderers[i] instanceof SpectrogramRenderer)) continue;
                SpectrogramRenderer spectrogram = (SpectrogramRenderer)renderers[i];
                elementMap.remove(spectrogram.getColorBar().getDasName());
            }
            elementMap.put(plot.getDasName(), Processor.getDOMElement(plot, document));
        }
        for (Element e : elementMap.values()) {
            if (e == null) continue;
            element.appendChild(e);
        }
        return element;
    }

    public static DasCanvas processCanvasElement(Element element, FormBase form) throws DasPropertyException, DasNameException, DasException, ParsedExpressionException, ParseException {
        try {
            Logger log = DasLogger.getLogger(DasLogger.DASML_LOG);
            String name = element.getAttribute("name");
            int width = Integer.parseInt(element.getAttribute("width"));
            int height = Integer.parseInt(element.getAttribute("height"));
            DasApplication app = form.getDasApplication();
            NameContext nc = app.getNameContext();
            DasCanvas canvas = new DasCanvas(width, height);
            NodeList children = element.getChildNodes();
            int childCount = children.getLength();
            for (int index = 0; index < childCount; ++index) {
                DasPlot plot;
                DasDevicePosition dasDevicePosition;
                Node node = children.item(index);
                log.fine("node=" + node.getNodeName());
                if (!(node instanceof Element)) continue;
                String tagName = node.getNodeName();
                if (tagName.equals("row")) {
                    dasDevicePosition = Processor.processRowElement((Element)node, canvas, form);
                    continue;
                }
                if (tagName.equals("column")) {
                    dasDevicePosition = Processor.processColumnElement((Element)node, canvas, form);
                    continue;
                }
                if (tagName.equals("axis")) {
                    DasAxis axis = Processor.processAxisElement((Element)node, form);
                    canvas.add(axis);
                    continue;
                }
                if (tagName.equals("timeaxis")) {
                    DasAxis timeaxis = Processor.processTimeaxisElement((Element)node, form);
                    canvas.add(timeaxis);
                    continue;
                }
                if (tagName.equals("attachedaxis")) {
                    DasAxis attachedaxis = Processor.processAttachedaxisElement((Element)node, form);
                    canvas.add(attachedaxis);
                    continue;
                }
                if (tagName.equals("colorbar")) {
                    DasColorBar colorbar = Processor.processColorbarElement((Element)node, form);
                    canvas.add(colorbar);
                    continue;
                }
                if (tagName.equals("plot")) {
                    plot = Processor.processPlotElement((Element)node, form);
                    canvas.add(plot);
                    continue;
                }
                if (!tagName.equals("spectrogram")) continue;
                plot = Processor.processPlotElement((Element)node, form);
                canvas.add(plot);
            }
            canvas.setDasName(name);
            nc.put(name, canvas);
            return canvas;
        }
        catch (DasPropertyException dpe) {
            if (!element.getAttribute("name").equals("")) {
                dpe.setObjectName(element.getAttribute("name"));
            }
            throw dpe;
        }
    }

    static DasRow processRowElement(Element element, DasCanvas canvas, FormBase form) throws DasException {
        String name = element.getAttribute("name");
        double minimum = Double.parseDouble(element.getAttribute("minimum"));
        double maximum = Double.parseDouble(element.getAttribute("maximum"));
        DasRow row = new DasRow(canvas, minimum, maximum);
        row.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, row);
        return row;
    }

    public static Element getDOMElement(DasRow row, Document document) {
        Element element = document.createElement("row");
        element.setAttribute("name", row.getDasName());
        element.setAttribute("minimum", Double.toString(row.getMinimum()));
        element.setAttribute("maximum", Double.toString(row.getMaximum()));
        return element;
    }

    static DasColumn processColumnElement(Element element, DasCanvas canvas, FormBase form) throws DasException {
        String name = element.getAttribute("name");
        double minimum = Double.parseDouble(element.getAttribute("minimum"));
        double maximum = Double.parseDouble(element.getAttribute("maximum"));
        DasColumn column = new DasColumn(canvas, minimum, maximum);
        column.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, column);
        return column;
    }

    public static Element getDOMElement(DasColumn column, Document document) {
        Element element = document.createElement("column");
        element.setAttribute("name", column.getDasName());
        element.setAttribute("minimum", Double.toString(column.getMinimum()));
        element.setAttribute("maximum", Double.toString(column.getMaximum()));
        return element;
    }

    public static SpectrogramRenderer processSpectrogramElement(Element element, DasPlot parent, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String dataSetID = element.getAttribute("dataSetID");
        DasColorBar colorbar = null;
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node node = children.item(index);
            if (!(node instanceof Element) || !node.getNodeName().equals("zAxis")) continue;
            colorbar = Processor.processZAxisElement((Element)node, form);
        }
        if (colorbar == null) {
            try {
                colorbar = (DasColorBar)form.checkValue(element.getAttribute("colorbar"), DasColorBar.class, "<colorbar>");
            }
            catch (DasPropertyException dpe) {
                dpe.setPropertyName("colorbar");
                throw dpe;
            }
        }
        SpectrogramRenderer renderer = new SpectrogramRenderer(null, colorbar);
        parent.addRenderer(renderer);
        try {
            renderer.setDataSetID(dataSetID);
        }
        catch (DasException de) {
            DasExceptionHandler.handle((Throwable)de);
        }
        return renderer;
    }

    private static DasColorBar processZAxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("colorbar")) continue;
            return Processor.processColorbarElement((Element)node, form);
        }
        return null;
    }

    static DasColorBar processColorbarElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String columnString;
        Datum dataMaximum;
        Datum dataMinimum;
        String name = element.getAttribute("name");
        boolean log = element.getAttribute("log").equals("true");
        String unitStr = element.getAttribute("units");
        if (unitStr == null) {
            unitStr = "";
        }
        if (unitStr.equals("TIME")) {
            String min = element.getAttribute("dataMinimum");
            String max = element.getAttribute("dataMaximum");
            dataMinimum = min == null || min.equals("") ? TimeUtil.create((String)"1979-02-26") : TimeUtil.create((String)min);
            dataMaximum = max == null || max.equals("") ? TimeUtil.create((String)"1979-02-27") : TimeUtil.create((String)max);
        } else {
            Units units = Units.getByName((String)unitStr);
            String min = element.getAttribute("dataMinimum");
            String max = element.getAttribute("dataMaximum");
            dataMinimum = min == null || min.equals("") ? Datum.create((double)1.0, (Units)units) : Datum.create((double)Double.parseDouble(min), (Units)units);
            dataMaximum = max == null || max.equals("") ? Datum.create((double)10.0, (Units)units) : Datum.create((double)Double.parseDouble(max), (Units)units);
        }
        int orientation = Processor.parseOrientationString(element.getAttribute("orientation"));
        DasColorBar cb = new DasColorBar(dataMinimum, dataMaximum, orientation, log);
        String rowString = element.getAttribute("row");
        if (!rowString.equals("")) {
            DasRow row = (DasRow)form.checkValue(rowString, DasRow.class, "<row>");
            cb.setRow(row);
        }
        if (!(columnString = element.getAttribute("column")).equals("")) {
            DasColumn column = (DasColumn)form.checkValue(columnString, DasColumn.class, "<column>");
            cb.setColumn(column);
        }
        cb.setLabel(element.getAttribute("label"));
        cb.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        cb.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        cb.setType(DasColorBar.Type.parse(element.getAttribute("type")));
        cb.setDasName(name);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, cb);
        return cb;
    }

    public static Element getDOMElement(DasColorBar colorbar, Document document) {
        Element element = document.createElement("colorbar");
        String minimumStr = colorbar.getDataMinimum().toString();
        element.setAttribute("dataMinimum", minimumStr);
        String maximumStr = colorbar.getDataMaximum().toString();
        element.setAttribute("dataMaximum", maximumStr);
        element.setAttribute("name", colorbar.getDasName());
        element.setAttribute("row", colorbar.getRow().getDasName());
        element.setAttribute("column", colorbar.getColumn().getDasName());
        element.setAttribute("label", colorbar.getLabel());
        element.setAttribute("log", Boolean.toString(colorbar.isLog()));
        element.setAttribute("tickLabelsVisible", Boolean.toString(colorbar.isTickLabelsVisible()));
        element.setAttribute("oppositeAxisVisible", Boolean.toString(colorbar.isOppositeAxisVisible()));
        element.setAttribute("animated", Boolean.toString(colorbar.isAnimated()));
        element.setAttribute("orientation", Processor.orientationToString(colorbar.getOrientation()));
        element.setAttribute("type", colorbar.getType().toString());
        return element;
    }

    public static DasColorBar createNamedColorBar(String name) {
        DasColorBar cb = new DasColorBar(Datum.create((double)1.0, (Units)Units.dimensionless), Datum.create((double)10.0, (Units)Units.dimensionless), false);
        if (name == null) {
            name = "colorbar_" + Integer.toHexString(System.identityHashCode(cb));
        }
        try {
            cb.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
        return cb;
    }

    public static DasPlot processPlotElement(Element element, FormBase form) throws DasPropertyException, DasNameException, DasException, ParseException {
        String name = element.getAttribute("name");
        DasRow row = (DasRow)form.checkValue(element.getAttribute("row"), DasRow.class, "<row>");
        DasColumn column = (DasColumn)form.checkValue(element.getAttribute("column"), DasColumn.class, "<column>");
        DasAxis xAxis = null;
        DasAxis yAxis = null;
        DasColorBar colorbar = null;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            if (node.getNodeName().equals("xAxis")) {
                xAxis = Processor.processXAxisElement((Element)node, row, column, form);
                continue;
            }
            if (node.getNodeName().equals("yAxis")) {
                yAxis = Processor.processYAxisElement((Element)node, row, column, form);
                continue;
            }
            if (!node.getNodeName().equals("zAxis")) continue;
            colorbar = Processor.processZAxisElement((Element)node, row, column, form);
        }
        if (xAxis == null) {
            xAxis = (DasAxis)form.checkValue(element.getAttribute("xAxis"), DasAxis.class, "<axis> or <timeaxis>");
        }
        if (yAxis == null) {
            yAxis = (DasAxis)form.checkValue(element.getAttribute("yAxis"), DasAxis.class, "<axis> or <timeaxis>");
        }
        DasPlot plot = new DasPlot(xAxis, yAxis);
        if (element.getNodeName().equals("spectrogram")) {
            SpectrogramRenderer rend = new SpectrogramRenderer(null, colorbar);
            plot.addRenderer(rend);
        }
        plot.setTitle(element.getAttribute("title"));
        plot.setDasName(name);
        plot.setRow(row);
        plot.setColumn(column);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, plot);
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("renderers")) continue;
            Processor.processRenderersElement((Element)node, plot, form);
        }
        return plot;
    }

    private static DasAxis processXAxisElement(Element element, DasRow row, DasColumn column, FormBase form) throws DasPropertyException, DasNameException, DasException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (node.getNodeName().equals("axis")) {
                DasAxis axis = Processor.processAxisElement(e, form);
                if (!axis.isHorizontal()) {
                    axis.setOrientation(2);
                }
                return axis;
            }
            if (node.getNodeName().equals("timeaxis")) {
                DasAxis axis = Processor.processTimeaxisElement(e, form);
                if (!axis.isHorizontal()) {
                    axis.setOrientation(2);
                }
                return axis;
            }
            if (!node.getNodeName().equals("attachedaxis")) continue;
            DasAxis axis = Processor.processAttachedaxisElement(e, form);
            if (!axis.isHorizontal()) {
                axis.setOrientation(2);
            }
            return axis;
        }
        return null;
    }

    private static DasAxis processYAxisElement(Element element, DasRow row, DasColumn column, FormBase form) throws DasPropertyException, DasNameException, DasException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (node.getNodeName().equals("axis")) {
                DasAxis axis = Processor.processAxisElement(e, form);
                if (axis.isHorizontal()) {
                    axis.setOrientation(3);
                }
                return axis;
            }
            if (node.getNodeName().equals("timeaxis")) {
                DasAxis axis = Processor.processTimeaxisElement(e, form);
                if (axis.isHorizontal()) {
                    axis.setOrientation(3);
                }
                return axis;
            }
            if (!node.getNodeName().equals("attachedaxis")) continue;
            DasAxis axis = Processor.processAttachedaxisElement(e, form);
            if (axis.isHorizontal()) {
                axis.setOrientation(3);
            }
            return axis;
        }
        return null;
    }

    private static DasColorBar processZAxisElement(Element element, DasRow row, DasColumn column, FormBase form) throws DasPropertyException, DasNameException, DasException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("colorbar")) continue;
            return Processor.processColorbarElement((Element)node, form);
        }
        return null;
    }

    private static void processRenderersElement(Element element, DasPlot parent, FormBase form) throws DasPropertyException, DasNameException, DasException, ParseException {
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node node = children.item(index);
            if (!(node instanceof Element)) continue;
            if (node.getNodeName().equals("spectrogram")) {
                parent.addRenderer(Processor.processSpectrogramElement((Element)node, parent, form));
                continue;
            }
            if (!node.getNodeName().equals("lineplot")) continue;
            parent.addRenderer(Processor.processLinePlotElement((Element)node, parent, form));
        }
    }

    public static SeriesRenderer processLinePlotElement(Element element, DasPlot parent, FormBase form) {
        String dataSetID = element.getAttribute("dataSetID");
        DefaultPlotSymbol psym = DefaultPlotSymbol.BOX;
        SymColor color = SymColor.parseSymColor(element.getAttribute("color"));
        SeriesRenderer renderer = new SeriesRenderer();
        parent.addRenderer(renderer);
        float lineWidth = Float.parseFloat(element.getAttribute("lineWidth"));
        try {
            renderer.setDataSetID(dataSetID);
        }
        catch (DasException de) {
            DasExceptionHandler.handle((Throwable)de);
        }
        renderer.setPsym(psym);
        renderer.setColor(color);
        renderer.setLineWidth(lineWidth);
        return renderer;
    }

    public static Element getDOMElement(DasPlot plot, Document document) {
        Element element = document.createElement("plot");
        element.setAttribute("name", plot.getDasName());
        element.setAttribute("row", plot.getRow().getDasName());
        element.setAttribute("column", plot.getColumn().getDasName());
        element.setAttribute("title", plot.getTitle());
        Element xAxisChild = document.createElement("xAxis");
        Element xAxisElement = Processor.getDOMElement(plot.getXAxis(), document);
        xAxisElement.removeAttribute("orientation");
        if (xAxisElement.getAttribute("row").equals(plot.getRow().getDasName())) {
            xAxisElement.removeAttribute("row");
        }
        if (xAxisElement.getAttribute("column").equals(plot.getColumn().getDasName())) {
            xAxisElement.removeAttribute("column");
        }
        xAxisChild.appendChild(xAxisElement);
        element.appendChild(xAxisChild);
        Element yAxisChild = document.createElement("yAxis");
        Element yAxisElement = Processor.getDOMElement(plot.getYAxis(), document);
        yAxisElement.removeAttribute("orientation");
        if (yAxisElement.getAttribute("row").equals(plot.getRow().getDasName())) {
            yAxisElement.removeAttribute("row");
        }
        if (yAxisElement.getAttribute("column").equals(plot.getColumn().getDasName())) {
            yAxisElement.removeAttribute("column");
        }
        yAxisChild.appendChild(yAxisElement);
        element.appendChild(yAxisChild);
        Renderer[] renderers = plot.getRenderers();
        if (renderers.length > 0) {
            Element renderersChild = document.createElement("renderers");
            for (int index = 0; index < renderers.length; ++index) {
                renderersChild.appendChild(Processor.getDOMElement(renderers[index], document));
            }
            element.appendChild(renderersChild);
        }
        return element;
    }

    public static DasPlot createNamedPlot(String name) {
        DasAxis xAxis = Processor.createNamedAxis(null);
        xAxis.setOrientation(2);
        DasAxis yAxis = Processor.createNamedAxis(null);
        yAxis.setOrientation(3);
        DasPlot plot = new DasPlot(xAxis, yAxis);
        if (name == null) {
            name = "plot_" + Integer.toHexString(System.identityHashCode(plot));
        }
        try {
            plot.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
        return plot;
    }

    public static Element getDOMElement(Renderer r, Document doc) {
        Element element = null;
        if (r instanceof SymbolLineRenderer) {
            SymbolLineRenderer slr = (SymbolLineRenderer)r;
            element = doc.createElement("lineplot");
            element.setAttribute("dataSetID", slr.getDataSetID());
            element.setAttribute("psym", slr.getPsym().toString());
            element.setAttribute("color", slr.getColor().toString());
        } else if (r instanceof SpectrogramRenderer) {
            SpectrogramRenderer spec = (SpectrogramRenderer)r;
            element = doc.createElement("spectrogram");
            element.setAttribute("dataSetID", spec.getDataSetID());
            Element zAxisChild = doc.createElement("zAxis");
            Element zAxisElement = Processor.getDOMElement(spec.getColorBar(), doc);
            if (zAxisElement.getAttribute("row").equals(spec.getParent().getRow().getDasName())) {
                zAxisElement.removeAttribute("row");
            }
            if (zAxisElement.getAttribute("column").equals(spec.getParent().getColumn().getDasName())) {
                zAxisElement.removeAttribute("column");
            }
            zAxisChild.appendChild(zAxisElement);
            element.appendChild(zAxisChild);
        } else if (r instanceof StackedHistogramRenderer) {
            StackedHistogramRenderer shr = (StackedHistogramRenderer)r;
            element = doc.createElement("stackedHistogram");
            element.setAttribute("zAxis", shr.getZAxis().getDasName());
            element.setAttribute("dataSetID", shr.getDataSetID());
        }
        return element;
    }

    public static Renderer processStackedHistogramElement(Element element, DasPlot parent, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String dataSetID = element.getAttribute("dataSetID");
        StackedHistogramRenderer renderer = new StackedHistogramRenderer(parent, null, null, (DasLabelAxis)parent.getYAxis());
        try {
            renderer.setDataSetID(dataSetID);
        }
        catch (DasException de) {
            DasExceptionHandler.handle((Throwable)de);
        }
        return renderer;
    }

    public static DasCanvas createFormCanvas(String name, int width, int height) {
        DasCanvas canvas = new DasCanvas(width, height);
        if (name == null) {
            name = "canvas_" + Integer.toHexString(System.identityHashCode(canvas));
        }
        try {
            canvas.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
        return canvas;
    }

    public FormBase getForm(DasCanvas canvas) {
        Container parent = canvas.getParent();
        if (parent instanceof FormComponent) {
            return ((FormComponent)((Object)parent)).getForm();
        }
        return null;
    }

    public void deregisterComponent(DasCanvas canvas) {
        DasApplication app = canvas.getDasApplication();
        if (app != null) {
            IllegalStateException se;
            NameContext nc = app.getNameContext();
            for (DasDevicePosition dp : canvas.devicePositionList()) {
                try {
                    if (nc.get(dp.getDasName()) != dp) continue;
                    nc.remove(dp.getDasName());
                }
                catch (DasPropertyException dpe) {
                    IllegalStateException se2 = new IllegalStateException(dpe.toString());
                    se2.initCause(dpe);
                    throw se2;
                }
                catch (InvocationTargetException ite) {
                    IllegalStateException se3 = new IllegalStateException(ite.toString());
                    se3.initCause(ite);
                    throw se3;
                }
            }
            for (int index = 0; index < canvas.getComponentCount(); ++index) {
                Component c = canvas.getComponent(index);
                if (!(c instanceof DasCanvasComponent)) continue;
                DasCanvasComponent cc = (DasCanvasComponent)c;
                try {
                    if (nc.get(cc.getDasName()) != cc) continue;
                    nc.remove(cc.getDasName());
                    continue;
                }
                catch (DasPropertyException dpe) {
                    IllegalStateException se4 = new IllegalStateException(dpe.toString());
                    se4.initCause(dpe);
                    throw se4;
                }
                catch (InvocationTargetException ite) {
                    IllegalStateException se5 = new IllegalStateException(ite.toString());
                    se5.initCause(ite);
                    throw se5;
                }
            }
            try {
                if (nc.get(canvas.getDasName()) == this) {
                    nc.remove(canvas.getDasName());
                }
            }
            catch (DasPropertyException dpe) {
                se = new IllegalStateException(dpe.toString());
                se.initCause(dpe);
                throw se;
            }
            catch (InvocationTargetException ite) {
                se = new IllegalStateException(ite.toString());
                se.initCause(ite);
                throw se;
            }
        }
    }

    public void registerComponent(DasCanvas canvas) throws DasException {
        try {
            DasApplication app = canvas.getDasApplication();
            if (app != null) {
                NameContext nc = app.getNameContext();
                for (DasDevicePosition dp : canvas.devicePositionList()) {
                    nc.put(dp.getDasName(), dp);
                }
                for (int index = 0; index < canvas.getComponentCount(); ++index) {
                    Component c = canvas.getComponent(index);
                    if (!(c instanceof DasCanvasComponent)) continue;
                    DasCanvasComponent cc = (DasCanvasComponent)c;
                    nc.put(cc.getDasName(), cc);
                }
                nc.put(canvas.getDasName(), this);
            }
        }
        catch (DasNameException dne) {
            this.deregisterComponent(canvas);
            throw dne;
        }
    }

    protected static String replaceReferences(NameContext n, String str) throws DasPropertyException, InvocationTargetException {
        Matcher matcher = refPattern.matcher(str);
        while (matcher.find()) {
            String name = matcher.group(1).trim();
            Object value = n.get(name);
            str = matcher.replaceFirst(value.toString());
            matcher.reset(str);
        }
        return str;
    }

    public static Object parseValue(NameContext nameContext, String valueString, Class type) throws ParsedExpressionException, InvocationTargetException, DasPropertyException {
        valueString = Processor.replaceReferences(nameContext, valueString);
        if (type == String.class) {
            return valueString;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            if (valueString.equals("true")) {
                return Boolean.TRUE;
            }
            if (valueString.equals("false")) {
                return Boolean.FALSE;
            }
            ParsedExpression exp = new ParsedExpression(valueString);
            Object o = exp.evaluate(nameContext);
            if (!(o instanceof Boolean)) {
                throw new ParsedExpressionException("'" + valueString + "' does not evaluate to a boolean value");
            }
            return o;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            if (intPattern.matcher(valueString).matches()) {
                return new Integer(valueString);
            }
            ParsedExpression exp = new ParsedExpression(valueString);
            Object o = exp.evaluate(nameContext);
            if (!(o instanceof Number)) {
                throw new ParsedExpressionException("'" + valueString + "' does not evaluate to a numeric value");
            }
            return o instanceof Integer ? (Integer)o : new Integer(((Number)o).intValue());
        }
        if (type == Long.TYPE || type == Long.class) {
            ParsedExpression exp;
            Object o;
            if (intPattern.matcher(valueString).matches()) {
                Long l = new Long(valueString);
            }
            if (!((o = (exp = new ParsedExpression(valueString)).evaluate(nameContext)) instanceof Number)) {
                throw new ParsedExpressionException("'" + valueString + "' does not evaluate to a numeric value");
            }
            return new Long(((Number)o).longValue());
        }
        if (type == Float.TYPE || type == Float.class) {
            ParsedExpression exp;
            Object o;
            if (floatPattern.matcher(valueString).matches()) {
                Float f = new Float(valueString);
            }
            if (!((o = (exp = new ParsedExpression(valueString)).evaluate(nameContext)) instanceof Number)) {
                throw new ParsedExpressionException("'" + valueString + "' does not evaluate to a numeric value");
            }
            return new Float(((Number)o).floatValue());
        }
        if (type == Double.TYPE || type == Double.class) {
            ParsedExpression exp;
            Object o;
            if (floatPattern.matcher(valueString).matches()) {
                Double d = new Double(valueString);
            }
            if (!((o = (exp = new ParsedExpression(valueString)).evaluate(nameContext)) instanceof Number)) {
                throw new ParsedExpressionException("'" + valueString + "' does not evaluate to a numeric value");
            }
            return o instanceof Double ? (Double)o : new Double(((Number)o).doubleValue());
        }
        if (type == Datum.class) {
            try {
                return TimeUtil.create((String)valueString);
            }
            catch (ParseException ex) {
                try {
                    return Datum.create((double)Double.parseDouble(valueString));
                }
                catch (NumberFormatException iae) {
                    throw new ParsedExpressionException(valueString + " cannot be parsed as a Datum");
                }
            }
        }
        throw new IllegalStateException(type.getName() + " is not a recognized type");
    }
}

