/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;

public final class RebinDescriptor {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.data.rebinner");
    Units units;
    protected double start;
    protected double end;
    protected int nBin;
    protected boolean isLog = false;
    public static final int FIRSTORLAST = -2;
    public static final int MINUSONE = -3;
    public static final int EXTRAPOLATE = -4;
    private int outOfBoundsAction = -4;
    private UnitsConverter uc;
    private Units inUnits = null;

    private RebinDescriptor() {
    }

    public RebinDescriptor(double start, double end, Units units, int nBin, boolean isLog) {
        this.units = units;
        if (isLog) {
            this.start = Math.log(start);
            this.end = Math.log(end);
        } else {
            this.start = start;
            this.end = end;
        }
        this.nBin = nBin;
        this.isLog = isLog;
    }

    public RebinDescriptor(Datum start, Datum end, int nBin, boolean isLog) {
        this(start.doubleValue(start.getUnits()), end.doubleValue(end.getUnits()), start.getUnits(), nBin, isLog);
        if (start.getUnits() != end.getUnits()) {
            throw new IllegalArgumentException("start and end units differ: \"" + start.getUnits() + "\" \"" + end.getUnits() + "\"");
        }
    }

    public int numberOfBins() {
        return this.nBin;
    }

    public int whichBin(double x, Units units) {
        boolean outOfBounds;
        if (units != this.units) {
            if (this.uc == null || units != this.inUnits) {
                this.uc = Units.getConverter((Units)units, (Units)this.units);
                this.inUnits = units;
            }
            x = this.uc.convert(x);
        }
        int result = 0;
        if (this.isLog) {
            x = Math.log(x);
        }
        boolean bl = this.start < this.end ? x < this.start || x >= this.end : (outOfBounds = x < this.end || x >= this.start);
        if (outOfBounds && this.outOfBoundsAction != -4) {
            switch (this.outOfBoundsAction) {
                case -2: {
                    result = this.start < this.end ? (x < this.start ? 0 : this.nBin - 1) : (x < this.end ? this.nBin - 1 : 0);
                    break;
                }
                case -3: {
                    result = -1;
                    break;
                }
                default: {
                    logger.log(Level.INFO, "outOfBoundsAction not supported: {0}", this.outOfBoundsAction);
                    break;
                }
            }
        } else {
            result = (int)((x - this.start) * (double)this.nBin / (this.end - this.start));
        }
        return result;
    }

    public DatumVector binCentersDV() {
        double[] result = this.binCenters();
        return DatumVector.newDatumVector((double[])result, (Units)this.units);
    }

    public double[] binCenters() {
        int i;
        double[] result = new double[this.nBin];
        for (i = 0; i < this.nBin; ++i) {
            result[i] = this.start + ((double)i + 0.5) / (double)this.nBin * (this.end - this.start);
        }
        if (this.isLog) {
            for (i = 0; i < this.nBin; ++i) {
                result[i] = Math.exp(result[i]);
            }
        }
        return result;
    }

    public double binCenter(int ibin, Units units) {
        UnitsConverter cu = this.units.getConverter(units);
        double result = this.start + ((double)ibin + 0.5) / (double)this.nBin * (this.end - this.start);
        if (this.isLog) {
            return cu.convert(Math.exp(result));
        }
        return cu.convert(result);
    }

    public Datum binCenter(int ibin) {
        return Datum.create((double)this.binCenter(ibin, this.units), (Units)this.units);
    }

    public Datum binStart(int ibin) {
        return Datum.create((double)this.binStart(ibin, this.units), (Units)this.units);
    }

    public double binStart(int ibin, Units units) {
        if (this.outOfBoundsAction != -4 && (ibin < 0 || ibin >= this.numberOfBins())) {
            throw new IllegalArgumentException("bin " + ibin + " is out of bounds");
        }
        double result = this.start + (double)ibin / (double)this.nBin * (this.end - this.start);
        UnitsConverter cu = this.units.getConverter(units);
        if (this.isLog) {
            return cu.convert(Math.exp(result));
        }
        return cu.convert(result);
    }

    public Datum binStop(int ibin) {
        return Datum.create((double)this.binStop(ibin, this.units), (Units)this.units);
    }

    public double binStop(int ibin, Units units) {
        if (this.outOfBoundsAction != -4 && (ibin < 0 || ibin >= this.numberOfBins())) {
            throw new IllegalArgumentException("bin " + ibin + " is out of bounds");
        }
        double result = this.start + (double)(ibin + 1) / (double)this.nBin * (this.end - this.start);
        UnitsConverter cu = this.units.getConverter(units);
        if (this.isLog) {
            return cu.convert(Math.exp(result));
        }
        return cu.convert(result);
    }

    public double[] binStarts() {
        int i;
        double[] result = new double[this.nBin];
        for (i = 0; i < this.nBin; ++i) {
            result[i] = this.start + (double)((float)i / (float)this.nBin) * (this.end - this.start);
        }
        if (this.isLog) {
            for (i = 0; i < this.nBin; ++i) {
                result[i] = Math.exp(result[i]);
            }
        }
        return result;
    }

    public double[] binStops() {
        int i;
        double[] result = new double[this.nBin];
        for (i = 0; i < this.nBin; ++i) {
            result[i] = this.start + (double)((float)(i + 1) / (float)this.nBin) * (this.end - this.start);
        }
        if (this.isLog) {
            for (i = 0; i < this.nBin; ++i) {
                result[i] = Math.exp(result[i]);
            }
        }
        return result;
    }

    public void setOutOfBoundsAction(int action) {
        this.outOfBoundsAction = action;
    }

    private Object clone(int outOfBoundsAction) {
        RebinDescriptor result = new RebinDescriptor();
        result.units = this.units;
        result.start = this.start;
        result.end = this.end;
        result.nBin = this.nBin;
        result.isLog = this.isLog;
        result.outOfBoundsAction = outOfBoundsAction;
        return result;
    }

    public static RebinDescriptor createSubsumingRebinDescriptor(RebinDescriptor ddY, Datum ymin, Datum ymax) {
        Units units;
        if (ddY == null) {
            return null;
        }
        RebinDescriptor dd = (RebinDescriptor)ddY.clone(-4);
        int i0 = dd.whichBin(ymin.doubleValue(units = ddY.getUnits()), units);
        if (i0 > 0) {
            i0 = 0;
            ymin = units.createDatum(ddY.binStart(0, units));
        }
        if (i0 < -10000000) {
            throw new IllegalArgumentException("ymin would result in impossibly large rebin descriptor (ymin=" + ymin + " falls in bin number " + i0 + ")");
        }
        int i1 = dd.whichBin(ymax.doubleValue(units), units);
        if (i1 < dd.numberOfBins()) {
            i1 = dd.numberOfBins();
            ymax = units.createDatum(dd.binStop(dd.numberOfBins() - 1, units));
        }
        if (i0 > 10000000) {
            throw new IllegalArgumentException("ymax would result in impossibly large rebin descriptor (ymax=" + ymax + " falls in bin number " + i0 + ")");
        }
        int nbins = i1 - i0 + 1;
        return new RebinDescriptor(units.createDatum(dd.binStart(i0, units)), units.createDatum(dd.binStop(i1, units)), nbins, dd.isLog());
    }

    public double binWidth() {
        return (this.end - this.start) / (double)this.nBin;
    }

    public Datum binWidthDatum() {
        return Datum.create((double)this.binWidth(), (Units)this.getUnits().getOffsetUnits());
    }

    public boolean isLog() {
        return this.isLog;
    }

    public Units getUnits() {
        return this.units;
    }

    public static void putDepDataSet(QDataSet ds, MutablePropertyDataSet result, RebinDescriptor ddX, RebinDescriptor ddY) {
        String[] props;
        MutablePropertyDataSet yy;
        MutablePropertyDataSet xx;
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        if (ddX != null) {
            DDataSet xxx = DDataSet.createRank1((int)ddX.numberOfBins());
            for (int i = 0; i < xxx.length(); ++i) {
                xxx.putValue(i, ddX.binCenter(i, ddX.units));
            }
            xxx.putProperty("UNITS", (Object)ddX.units);
            xx = xxx;
        } else {
            xx = DataSetOps.makePropertiesMutable((QDataSet)xds);
        }
        QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)ds);
        if (ddY != null) {
            DDataSet yyy = DDataSet.createRank1((int)ddY.numberOfBins());
            for (int i = 0; i < yyy.length(); ++i) {
                yyy.putValue(i, ddY.binCenter(i, ddY.units));
            }
            yyy.putProperty("UNITS", (Object)ddY.units);
            yy = yyy;
        } else {
            yy = DataSetOps.makePropertiesMutable((QDataSet)yds);
        }
        for (String s : props = new String[]{"NAME", "LABEL", "TITLE"}) {
            if (xds != null && xds.property(s) != null) {
                xx.putProperty(s, xds.property(s));
            }
            if (yds == null || yds.property(s) == null) continue;
            yy.putProperty(s, yds.property(s));
        }
        for (String s : DataSetUtil.dimensionProperties()) {
            if (ds.property(s) == null) continue;
            result.putProperty(s, ds.property(s));
        }
        if (ddX != null) {
            xx.putProperty("CADENCE", (Object)DataSetUtil.asDataSet((Datum)ddX.binWidthDatum()));
        }
        if (ddY != null) {
            yy.putProperty("CADENCE", (Object)DataSetUtil.asDataSet((Datum)ddY.binWidthDatum()));
        }
        result.putProperty("DEPEND_0", (Object)xx);
        result.putProperty("DEPEND_1", (Object)yy);
    }

    public String toString() {
        if (this.isLog()) {
            return "[" + this.units.createDatum(Math.exp(this.start)) + " - " + this.units.createDatum(Math.exp(this.end)) + " in " + this.nBin + " bins " + (this.isLog ? "Log" : "") + "]";
        }
        return "[" + this.units.createDatum(this.start) + " - " + this.units.createDatum(this.end) + " in " + this.nBin + " bins " + (this.isLog ? "Log" : "") + "]";
    }
}

