/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.ViewDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public class YSliceDataSet
extends ViewDataSet
implements VectorDataSet {
    private final int table;
    private final int jIndex;
    private final int offset;
    private final TableDataSet tdsSource;

    public YSliceDataSet(TableDataSet source, int jIndex, int table) {
        super(source);
        this.tdsSource = source;
        this.jIndex = jIndex;
        this.table = table;
        this.offset = source.tableStart(table);
    }

    @Override
    public DataSet getPlanarView(String planeID) {
        return null;
    }

    @Override
    public String[] getPlaneIds() {
        return new String[0];
    }

    @Override
    public Datum getDatum(int i) {
        return this.tdsSource.getDatum(i + this.offset, this.jIndex);
    }

    @Override
    public double getDouble(int i, Units units) {
        return this.tdsSource.getDouble(i + this.offset, this.jIndex, units);
    }

    @Override
    public int getInt(int i, Units units) {
        return this.tdsSource.getInt(i + this.offset, this.jIndex, units);
    }

    @Override
    public Datum getXTagDatum(int i) {
        return this.tdsSource.getXTagDatum(i + this.offset);
    }

    @Override
    public int getXLength() {
        return this.tdsSource.tableEnd(this.table) - this.tdsSource.tableStart(this.table);
    }

    @Override
    public double getXTagDouble(int i, Units units) {
        return this.tdsSource.getXTagDouble(i + this.offset, units);
    }

    @Override
    public Units getYUnits() {
        return this.tdsSource.getZUnits();
    }

    @Override
    public int getXTagInt(int i, Units units) {
        return this.tdsSource.getXTagInt(i + this.offset, units);
    }
}

