/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.das2.datum.Datum;
import org.das2.datum.DatumUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.LabelDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.util.GrannyTextRenderer;

public class PointSlopeDragRenderer
extends LabelDragRenderer {
    DasAxis xaxis;
    DasAxis yaxis;
    NumberFormat nf;

    public PointSlopeDragRenderer(DasCanvasComponent parent, DasAxis xaxis, DasAxis yaxis) {
        super(parent);
        if (parent instanceof DasPlot) {
            DasPlot plot = (DasPlot)parent;
            this.xaxis = xaxis == null ? plot.getXAxis() : xaxis;
            this.yaxis = yaxis == null ? plot.getYAxis() : yaxis;
        } else {
            this.xaxis = xaxis;
            this.yaxis = yaxis;
        }
        this.gtr = new GrannyTextRenderer();
        this.nf = new DecimalFormat("0.00E0");
    }

    @Override
    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        String su;
        Units u;
        String fit;
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double atan = Math.atan2(p2.y - p1.y, p2.x - p1.x);
        Line2D.Double line2 = new Line2D.Double(p1.x + (int)(6.0 * Math.cos(atan)), (int)((double)p1.y + 6.0 * Math.sin(atan)), p2.x, p2.y);
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 100));
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        g.draw(line2);
        g.draw(new Ellipse2D.Double(p1.x - 4, p1.y - 4, 8.0, 8.0));
        g.setStroke(new BasicStroke());
        g.setColor(color0);
        g1.drawLine(p1.x, p1.y, p2.x, p2.y);
        g1.setColor(g.getBackground());
        g1.fillOval(p1.x - 2, p1.y - 2, 4, 4);
        g1.setColor(color0);
        g1.drawOval(p1.x - 2, p1.y - 2, 4, 4);
        Rectangle myDirtyBounds = new Rectangle(p1.x - 2, p1.y - 2, 5, 5);
        myDirtyBounds.add(p2.x - 2, p2.y - 2);
        myDirtyBounds.add(p2.x + 2, p2.y + 2);
        Datum x1 = this.xaxis.invTransform(p2.x);
        Datum x0 = this.xaxis.invTransform(p1.x);
        Datum run = x1.subtract(x0);
        Datum y1 = this.yaxis.invTransform(p2.y);
        Datum y0 = this.yaxis.invTransform(p1.y);
        Datum rise = y1.subtract(y0);
        Datum xdr = this.xaxis.getDatumRange().width();
        Datum ydr = this.yaxis.getDatumRange().width();
        Units xunits = DatumUtil.asOrderOneUnits((Datum)xdr).getUnits();
        Units yunits = DatumUtil.asOrderOneUnits((Datum)ydr).getUnits();
        run = run.convertTo(xunits);
        rise = rise.convertTo(yunits);
        run = DatumUtil.asOrderOneUnits((Datum)run);
        Units runUnits = run.getUnits();
        if (this.yaxis.isLog() && this.xaxis.isLog()) {
            double ycycles = Math.log10(y1.divide(y0).doubleValue(Units.dimensionless));
            double xcycles = Math.log10(x1.divide(x0).doubleValue(Units.dimensionless));
            DecimalFormat nf = new DecimalFormat("0.00");
            String sslope = nf.format(ycycles / xcycles);
            fit = "y= ( x/" + x1 + " )!A" + sslope + "!n * " + y1;
        } else if (this.yaxis.isLog() && !this.xaxis.isLog()) {
            DecimalFormat nf = new DecimalFormat("0.00");
            u = run.getUnits();
            double drise = Math.log10(y1.divide(y0).doubleValue(Units.dimensionless));
            double drun = x1.subtract(x0).doubleValue(u);
            String sslope = nf.format(drise / drun);
            su = u.isConvertibleTo(Units.seconds) ? UnitsUtil.divideToString((Datum)Units.dimensionless.createDatum(drise), (Datum)run) : (u == Units.dimensionless ? sslope : sslope + "/(" + u + ")");
            String sx0 = x1.toString();
            if (UnitsUtil.isTimeLocation((Units)x1.getUnits())) {
                fit = "!Cx0=" + sx0 + "!C";
                fit = fit + "!Cy=10!A( x-x0 )*" + su + "!n * " + y1;
            } else {
                fit = "!Cy=10!A( x-(" + x1 + ") )*" + su + "!n * " + y1;
            }
        } else if (!this.yaxis.isLog() && this.xaxis.isLog()) {
            DecimalFormat nf1 = new DecimalFormat("0.00");
            u = rise.getUnits();
            double drise = y1.subtract(y0).doubleValue(u);
            double drun = Math.log10(x1.divide(x0).doubleValue(Units.dimensionless));
            String sslope = nf1.format(drise / drun);
            su = u.isConvertibleTo(Units.seconds) ? UnitsUtil.divideToString((Datum)rise, (Datum)Units.dimensionless.createDatum(drun)) : (u == Units.dimensionless ? sslope : sslope + "(" + u + ")");
            fit = "y=Log( x / " + x1 + " )*" + su + " + " + y1;
        } else {
            Datum slope = rise.getUnits().isConvertibleTo(runUnits) ? rise.divide(run) : rise.divide(run.doubleValue(runUnits));
            DecimalFormat nf1 = new DecimalFormat("0.00");
            String dx = "( x - (" + x1 + ") )";
            if (runUnits != Units.dimensionless) {
                if (UnitsUtil.isTimeLocation((Units)x1.getUnits())) {
                    fit = "!Cx0=" + x1 + "!C";
                    dx = "( x-x0 )";
                    fit = fit + "!Cy=" + nf1.format(slope.value()) + "/" + runUnits + " * " + dx + " + " + y1;
                } else {
                    fit = "y=" + nf1.format(slope.value()) + "/" + runUnits + " * " + dx + " + " + y1;
                }
            } else {
                slope = rise.getUnits().isConvertibleTo(runUnits) ? rise.divide(run) : rise.divide(run.doubleValue(runUnits));
                fit = "y=" + slope + " * ( x - (" + x1 + ") ) + " + y1;
            }
        }
        if (this.xaxis.isLog()) {
            this.setLabel(fit);
        } else if (this.yaxis.isLog()) {
            this.setLabel(fit);
        } else if (!p1.equals(p2)) {
            String units;
            try {
                Datum slope = rise.divide(run);
                this.setLabel("m=" + slope);
            }
            catch (InconvertibleUnitsException ex) {
                double drise = rise.doubleValue(rise.getUnits());
                double drun = run.doubleValue(run.getUnits());
                double mag = drise / drun;
                units = "" + rise.getUnits() + " / " + run.getUnits();
                this.setLabel("m=" + this.nf.format(mag) + " " + units);
            }
            catch (IllegalArgumentException ex) {
                double drise = rise.doubleValue(rise.getUnits());
                double drun = run.doubleValue(run.getUnits());
                double mag = drise / drun;
                units = "" + rise.getUnits() + " / " + run.getUnits();
                this.setLabel("m=" + this.nf.format(mag) + " " + units);
            }
        } else {
            this.setLabel("");
        }
        super.renderDrag(g, p1, p2);
        return new Rectangle[]{this.dirtyBounds, myDirtyBounds};
    }
}

