/*
 * Decompiled with CFR 0.152.
 */
package org.das2.fsm;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.LocalFileSystem;
import org.das2.util.filesystem.SubFileSystem;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.filesystem.ZipFileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;

public class FileStorageModel {
    private Pattern pattern;
    private String regex;
    private Pattern gzpattern;
    FileStorageModel parent;
    FileSystem root;
    TimeParser timeParser;
    String template;
    static final Logger logger = LoggerManager.getLogger((String)"das2.system.fsm");
    HashMap fileNameMap = null;
    private boolean allowGz = true;
    List<String> oldVersions = new ArrayList<String>();
    VersioningType versioningType;
    String versionGe = null;
    String versionLt = null;

    public FileSystem getFileSystem() {
        return this.root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileSystem getChildFileSystem(FileSystem root, String child, ProgressMonitor monitor) throws FileSystem.FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        if (!root.getRootURI().getScheme().equals("file")) return FileSystem.create((URI)root.getRootURI().resolve(child), (ProgressMonitor)monitor.getSubtaskMonitor("create"));
        if (root instanceof LocalFileSystem) {
            File localRoot = ((LocalFileSystem)root).getLocalRoot();
            return FileSystem.create((URI)new File(localRoot, child).toURI(), (ProgressMonitor)monitor.getSubtaskMonitor("create"));
        }
        if (root instanceof SubFileSystem) {
            try {
                return root.createFileSystem(child);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        if (!(root instanceof ZipFileSystem)) throw new IllegalArgumentException("not supported, should not happen");
        try {
            return root.createFileSystem(child);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String getRepresentativeFile(ProgressMonitor monitor) throws IOException {
        return FileStorageModel.getRepresentativeFile(this, monitor, null, null, 0);
    }

    public String getRepresentativeFile(ProgressMonitor monitor, String childRegex) throws IOException {
        return FileStorageModel.getRepresentativeFile(this, monitor, childRegex, null, 0);
    }

    public String getRepresentativeFile(ProgressMonitor monitor, String childRegex, DatumRange range) throws IOException {
        return FileStorageModel.getRepresentativeFile(this, monitor, childRegex, range, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRepresentativeFile(FileStorageModel ths, ProgressMonitor monitor, String childRegex, DatumRange range, int depth) throws IOException {
        logger.log(Level.FINE, "get representative from {0} {1} range: {2}", new Object[]{ths.getFileSystem(), childRegex, range});
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String parentRegex = null;
        if (EventQueue.isDispatchThread()) {
            logger.info("FileSystem use on the GUI event thread will often cause problems.");
        }
        String result = null;
        try {
            String listRegex;
            FileSystem[] fileSystems;
            String[] names;
            if (ths.parent != null) {
                parentRegex = FileStorageModel.getParentRegex(ths.regex);
                String one = FileStorageModel.getRepresentativeFile(ths.parent, monitor.getSubtaskMonitor("get representative file"), ths.regex.substring(parentRegex.length() + 1), range, depth + 1);
                if (one == null) {
                    String string = null;
                    return string;
                }
                names = new String[]{one};
                fileSystems = new FileSystem[names.length];
                for (int i = 0; i < names.length; ++i) {
                    try {
                        fileSystems[i] = FileStorageModel.getChildFileSystem(ths.root, names[i], monitor.getSubtaskMonitor("create"));
                        continue;
                    }
                    catch (FileNotFoundException | UnknownHostException | FileSystem.FileSystemOfflineException e) {
                        throw new RuntimeException(e);
                    }
                }
                listRegex = ths.regex.substring(parentRegex.length() + 1);
            } else {
                fileSystems = new FileSystem[]{ths.root};
                names = new String[]{""};
                listRegex = ths.regex;
            }
            while (result == null) {
                String ff;
                int i;
                for (i = fileSystems.length - 1; result == null && i >= 0; --i) {
                    String[] files1 = fileSystems[i].listDirectory("/", listRegex, monitor.getSubtaskMonitor("create"));
                    int j = files1.length - 1;
                    while (j >= 0 && result == null) {
                        String string = ff = names[i].equals("") ? files1[j] : names[i] + "/" + files1[j];
                        if (ff.endsWith("/")) {
                            ff = ff.substring(0, ff.length() - 1);
                        }
                        try {
                            HashMap<String, String> extra = new HashMap<String, String>();
                            DatumRange tr = FileStorageModel.getDatumRangeFor(ths, ff, extra);
                            boolean versionOk = true;
                            if (ths.versionGe != null && ths.versioningType.comp.compare(extra.get("v"), ths.versionGe) < 0) {
                                versionOk = false;
                            }
                            if (ths.versionLt != null && ths.versioningType.comp.compare(extra.get("v"), ths.versionLt) >= 0) {
                                versionOk = false;
                            }
                            if (versionOk && ths.timeParser.getValidRange().contains(tr) && (range == null || range.intersects(tr))) {
                                if (childRegex != null) {
                                    String[] kids = fileSystems[i].listDirectory(files1[j], childRegex, monitor.getSubtaskMonitor("list directory"));
                                    if (kids.length > 0) {
                                        result = ff;
                                    }
                                } else {
                                    result = ff;
                                }
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            logger.log(Level.FINER, null, ex);
                        }
                        if (result != null) continue;
                        --j;
                    }
                }
                if (ths.allowGz && result == null) {
                    for (i = fileSystems.length - 1; result == null && i >= 0; --i) {
                        String[] files1 = fileSystems[i].listDirectory("/", listRegex + ".gz");
                        if (files1.length <= 0) continue;
                        int last = files1.length - 1;
                        String string = ff = names[i].equals("") ? files1[last] : names[i] + "/" + files1[last];
                        if (ff.endsWith("/")) {
                            ff = ff.substring(0, ff.length() - 1);
                        }
                        result = ff.substring(0, ff.length() - 3);
                    }
                }
                if (result != null) continue;
                if (ths.parent == null) {
                    String i2 = null;
                    return i2;
                }
                logger.fine("fall back to old code that would list everything");
                DatumRange range1 = ths.parent.getRangeFor(names[0]);
                range1 = range1.previous();
                if (range != null && !range.intersects(range1)) {
                    String i2 = null;
                    return i2;
                }
                String one = FileStorageModel.getRepresentativeFile(ths.parent, monitor.getSubtaskMonitor("getRepresentativeFile"), ths.regex.substring(parentRegex.length() + 1), range1, depth + 1);
                if (one == null) {
                    String files1 = null;
                    return files1;
                }
                names = new String[]{one};
                fileSystems = new FileSystem[names.length];
                for (int i3 = 0; i3 < names.length; ++i3) {
                    try {
                        fileSystems[i3] = FileStorageModel.getChildFileSystem(ths.root, names[i3], monitor.getSubtaskMonitor("create"));
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        finally {
            monitor.finished();
        }
        return result;
    }

    public void setContext(DatumRange trdr) {
        this.timeParser.setContext(trdr);
    }

    private synchronized DatumRange getDatumRangeFor(String filename, Map<String, String> extra) {
        try {
            extra.clear();
            if (this.pattern.matcher(filename).matches()) {
                this.timeParser.parse(filename, extra);
                return this.timeParser.getTimeRange();
            }
            if (this.gzpattern != null && this.gzpattern.matcher(filename).matches()) {
                this.timeParser.parse(filename.substring(0, filename.length() - 3), extra);
                return this.timeParser.getTimeRange();
            }
            throw new IllegalArgumentException("file name \"" + filename + "\" doesn't match model specification (" + this.template + ")");
        }
        catch (NumberFormatException | ParseException e) {
            IllegalArgumentException e2 = new IllegalArgumentException("file name \"" + filename + "\" doesn't match model specification (" + this.template + "), parse error in field", e);
            throw e2;
        }
    }

    private static DatumRange getDatumRangeFor(FileStorageModel ths, String filename, Map<String, String> extra) {
        try {
            extra.clear();
            if (ths.pattern.matcher(filename).matches()) {
                ths.timeParser.parse(filename, extra);
                return ths.timeParser.getTimeRange();
            }
            if (ths.gzpattern != null && ths.gzpattern.matcher(filename).matches()) {
                ths.timeParser.parse(filename.substring(0, filename.length() - 3), extra);
                return ths.timeParser.getTimeRange();
            }
            throw new IllegalArgumentException("file name \"" + filename + "\" doesn't match model specification (" + ths.template + ")");
        }
        catch (NumberFormatException | ParseException e) {
            IllegalArgumentException e2 = new IllegalArgumentException("file name \"" + filename + "\" doesn't match model specification (" + ths.template + "), parse error in field", e);
            throw e2;
        }
    }

    public String getFilenameFor(Datum start, Datum end) {
        return this.timeParser.format(start, end);
    }

    public String[] generateNamesFor(DatumRange range) {
        String sstart;
        TimeParser tp = this.timeParser;
        try {
            sstart = tp.format(range.min(), null);
        }
        catch (Exception ex) {
            DatumRange dr = tp.getValidRange();
            DatumRange dd = DatumRangeUtil.sloppyIntersection((DatumRange)range, (DatumRange)dr);
            if (dd.width().value() == 0.0) {
                return new String[0];
            }
            sstart = tp.format(dd.min(), null);
        }
        try {
            tp.parse(sstart);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        DatumRange curr = tp.getTimeRange();
        int countLimit = 1000000;
        int approxCount = (int)(1.01 * range.width().divide(curr.width()).value());
        if ((double)approxCount > (double)countLimit * 1.03) {
            throw new IllegalArgumentException("too many intervals would be created, this is limited to about 1000000 intervals.");
        }
        ArrayList<String> result = new ArrayList<String>(approxCount);
        if (!range.intersects(curr)) {
            curr = curr.next();
        }
        while (range.intersects(curr)) {
            String scurr = tp.format(curr.min(), curr.max());
            result.add(scurr);
            DatumRange oldCurr = curr;
            if (!oldCurr.equals((Object)(curr = curr.next()))) continue;
            break;
        }
        return result.toArray(new String[result.size()]);
    }

    public synchronized DatumRange quantize(DatumRange timeRange) {
        try {
            DatumRange dr2;
            DatumRange dr1;
            String tf1 = this.timeParser.format(timeRange.min(), timeRange.min());
            String tf2 = this.timeParser.format(timeRange.max(), timeRange.max());
            try {
                dr1 = this.timeParser.parse(tf1).getTimeRange();
                dr2 = this.timeParser.parse(tf2).getTimeRange();
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.WARNING, "Strange bug shown in test033: {2}\n>>{0}<<\n>>{1}<<", new Object[]{tf1, tf2, this.timeParser});
                TimeParser tp1 = this.timeParser.parse(tf1);
                logger.log(Level.WARNING, "tp1 start {0}", tp1.getTime((Units)Units.us2000));
                logger.log(Level.WARNING, "tp1 end {0}", tp1.getEndTime((Units)Units.us2000));
                logger.log(Level.WARNING, "tp1 tr {0}", tp1.getTimeRange());
                TimeParser tp2 = this.timeParser.parse(tf2);
                logger.log(Level.WARNING, "tp2 start {0}", tp2.getTime((Units)Units.us2000));
                logger.log(Level.WARNING, "tp2 end {0}", tp2.getEndTime((Units)Units.us2000));
                logger.log(Level.WARNING, "tp2 tr {0}", tp2.getTimeRange());
                throw ex;
            }
            if (dr2.min().equals(timeRange.max())) {
                return DatumRangeUtil.union((DatumRange)dr1, (Datum)dr2.min());
            }
            return DatumRangeUtil.union((DatumRange)dr1, (DatumRange)dr2);
        }
        catch (ParseException ex) {
            throw new RuntimeException("this shouldn't happen");
        }
    }

    public String[] getNamesFor(DatumRange targetRange) throws IOException {
        return this.getNamesFor(targetRange, false, (ProgressMonitor)new NullProgressMonitor());
    }

    public String[] getNamesFor(DatumRange targetRange, ProgressMonitor monitor) throws IOException {
        return this.getNamesFor(targetRange, false, monitor);
    }

    public String[] getBestNamesFor(DatumRange targetRange, ProgressMonitor monitor) throws IOException {
        return this.getNamesFor(targetRange, true, monitor);
    }

    public String[] getBestNamesFor(DatumRange targetRange) throws IOException {
        return this.getNamesFor(targetRange, true, (ProgressMonitor)new NullProgressMonitor());
    }

    private String[] getNamesFor(DatumRange targetRange, boolean versioning, ProgressMonitor monitor) throws IOException {
        Object ff;
        int j;
        String listRegex;
        FileSystem[] fileSystems;
        String[] names;
        logger.log(Level.FINE, "getNamesFor {0}", this.root);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.oldVersions.clear();
        if (this.parent != null) {
            names = this.parent.getNamesFor(targetRange, versioning, (ProgressMonitor)new NullProgressMonitor());
            logger.log(Level.FINE, "parent {0} yields: {1}", new Object[]{this.parent.toString(), names.length});
            fileSystems = new FileSystem[names.length];
            for (int i = 0; i < names.length; ++i) {
                try {
                    fileSystems[i] = FileStorageModel.getChildFileSystem(this.root, names[i], monitor);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String parentRegex = FileStorageModel.getParentRegex(this.regex);
            listRegex = this.regex.substring(parentRegex.length() + 1);
        } else {
            fileSystems = new FileSystem[]{this.root};
            names = new String[]{""};
            listRegex = this.regex;
        }
        List<Object> list = new ArrayList();
        ArrayList versionList = new ArrayList();
        ArrayList<DatumRange> rangeList = new ArrayList<DatumRange>();
        monitor.setTaskSize((long)(fileSystems.length * 10));
        monitor.started();
        HashMap<String, String> extra = new HashMap<String, String>();
        for (int i = 0; i < fileSystems.length; ++i) {
            WebFileSystem wfs;
            File f;
            if (monitor.isCancelled()) {
                throw new InterruptedIOException("cancel pressed");
            }
            monitor.setTaskProgress((long)(i * 10));
            String theListRegex = listRegex;
            if (this.allowGz) {
                theListRegex = theListRegex + "(.gz)?";
            }
            Object[] files1 = fileSystems[i].listDirectory("/", theListRegex);
            logger.log(Level.FINER, "listDirectory({0})->{1}", new Object[]{theListRegex, files1.length});
            Arrays.sort(files1);
            for (j = 0; j < files1.length; ++j) {
                Object object = ff = names[i].equals("") ? files1[j] : names[i] + "/" + (String)files1[j];
                if (((String)ff).endsWith("/")) {
                    ff = ((String)ff).substring(0, ((String)ff).length() - 1);
                }
                try {
                    DatumRange dr = this.getDatumRangeFor((String)ff, extra);
                    if (targetRange == null || dr.intersects(targetRange)) {
                        if (((String)ff).endsWith(".gz") && this.allowGz) {
                            ff = ((String)ff).substring(0, ((String)ff).length() - 3);
                        }
                        list.add(ff);
                        rangeList.add(dr);
                        if (this.versioningType != VersioningType.none) {
                            if (extra.get("v") == null) {
                                throw new RuntimeException("expected version");
                            }
                            versionList.add(extra.get("v"));
                        }
                        logger.log(Level.FINER, "  add {0}", ff);
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.FINER, "  skip {0} because it does not parse properly", ff);
                }
                monitor.setTaskProgress((long)(i * 10 + j * 10 / files1.length));
            }
            if (!(fileSystems[i] instanceof WebFileSystem) || (f = (wfs = (WebFileSystem)fileSystems[i]).getLocalRoot()) == null) continue;
            FileSystem lfs = FileSystem.create((URI)f.toURI());
            String[] files2 = lfs.listDirectory("/", theListRegex);
            ArrayList<String> deleteRemote = new ArrayList<String>();
            List<Object> remoteFiles = Arrays.asList(files1);
            for (String s : files2) {
                if (remoteFiles.indexOf(s) != -1) continue;
                deleteRemote.add(s);
            }
            logger.log(Level.FINE, "local files that do not exist on remote: {0}", deleteRemote);
            this.oldVersions.addAll(deleteRemote);
        }
        if (versioning && this.versioningType != VersioningType.none) {
            Comparator<String> comp = this.versioningType.comp;
            HashMap<String, String> bestVersions = new HashMap<String, String>();
            HashMap<String, Object> bestFiles = new HashMap<String, Object>();
            for (j = 0; j < list.size(); ++j) {
                ff = (String)list.get(j);
                String key = ((DatumRange)rangeList.get(j)).toString();
                String thss = (String)versionList.get(j);
                String best = (String)bestVersions.get(key);
                if (best == null) {
                    try {
                        logger.log(Level.FINER, "check format exception: {0}", comp.compare(thss, thss));
                        if (this.versionGe != null && comp.compare(thss, this.versionGe) < 0 || this.versionLt != null && comp.compare(thss, this.versionLt) >= 0) continue;
                        bestVersions.put(key, thss);
                        bestFiles.put(key, ff);
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                    continue;
                }
                try {
                    if (this.versionGe != null && comp.compare(thss, this.versionGe) < 0 || this.versionLt != null && comp.compare(thss, this.versionLt) >= 0 || comp.compare(thss, best) <= 0) continue;
                    bestVersions.put(key, thss);
                    String rm = (String)bestFiles.put(key, ff);
                    if (this.oldVersions.contains(rm)) continue;
                    this.oldVersions.add(rm);
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
            list = Arrays.asList(bestFiles.values().toArray(new String[bestFiles.size()]));
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                DatumRange dr1 = FileStorageModel.this.getRangeFor((String)o1);
                DatumRange dr2 = FileStorageModel.this.getRangeFor((String)o2);
                return dr1.compareTo((Object)dr2);
            }
        });
        logger.log(Level.FINE, "getNamesFor {0} -> {1}", new Object[]{this.root, list.size()});
        monitor.finished();
        return list.toArray(new String[list.size()]);
    }

    public static CacheTag getCacheTagFor(FileStorageModel fsm, DatumRange range, String[] names) {
        Datum min = range.min();
        Datum max = range.max();
        for (String name : names) {
            DatumRange r = fsm.getRangeFor(name);
            min = min.gt(range.min()) ? r.min() : min;
            max = max.lt(range.max()) ? r.max() : max;
        }
        return new CacheTag(min, max, null);
    }

    public static CacheTag getCacheTagFor(FileStorageModel fsm, DatumRange range, File[] files) {
        String[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            names[i] = fsm.getNameFor(files[i]);
        }
        return FileStorageModel.getCacheTagFor(fsm, range, names);
    }

    public File[] getFilesFor(DatumRange targetRange) throws IOException {
        return this.getFilesFor(targetRange, (ProgressMonitor)new NullProgressMonitor());
    }

    public File[] getBestFilesFor(DatumRange targetRange) throws IOException {
        return this.getBestFilesFor(targetRange, (ProgressMonitor)new NullProgressMonitor());
    }

    public void cacheCleanup() {
        if (this.getFileSystem() instanceof LocalFileSystem) {
            logger.fine("local filesystems do not cache");
        } else {
            for (String s : this.oldVersions) {
                if (this.getFileSystem().getFileObject(s).removeLocalFile()) continue;
                logger.log(Level.FINER, "removeLocalFile returned false: {0}", s);
            }
        }
    }

    public DatumRange getRangeFor(String name) {
        return this.getDatumRangeFor(name, new HashMap<String, String>());
    }

    public boolean hasField(String field) {
        return this.timeParser.hasField(field);
    }

    public String getField(String field, String name) {
        HashMap<String, String> hh = new HashMap<String, String>();
        this.getDatumRangeFor(name, hh);
        if (hh.containsKey(field)) {
            return hh.get(field);
        }
        throw new IllegalArgumentException("field is not in template: " + field);
    }

    public boolean containsFile(File file) {
        if (!this.fileNameMap.containsKey(file)) {
            return false;
        }
        String name = this.getNameFor(file);
        return this.containsName(name);
    }

    public boolean containsName(String name) {
        Matcher m = this.pattern.matcher(name);
        return m.matches();
    }

    public String getNameFor(File file) {
        String result = (String)this.fileNameMap.get(file);
        if (result == null) {
            throw new IllegalArgumentException("File didn't come from this FileStorageModel");
        }
        return result;
    }

    public String getRoot() {
        return this.root.getRootURI().toString();
    }

    private File maybeGetGzFile(String name, ProgressMonitor mon) throws IOException {
        FileObject oz;
        File f0 = null;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        if ((oz = this.root.getFileObject(name + ".gz")).exists()) {
            File fz = oz.getFile(mon);
            String sfz = fz.getPath().substring(0, fz.getPath().length() - 3);
            f0 = new File(sfz);
            FileSystemUtil.gunzip((File)fz, (File)f0);
            if (!f0.setLastModified(fz.lastModified())) {
                throw new IllegalArgumentException("failed to set last modified");
            }
        }
        return f0;
    }

    public File getFileFor(String name) throws IOException {
        File[] ff = this.getFilesFor(new String[]{name}, (ProgressMonitor)new NullProgressMonitor());
        if (ff.length > 0) {
            return ff[0];
        }
        return null;
    }

    public File getFileFor(String name, ProgressMonitor monitor) throws IOException {
        File[] ff = this.getFilesFor(new String[]{name}, monitor);
        if (ff.length > 0) {
            return ff[0];
        }
        return null;
    }

    public File[] getFilesFor(String[] names, ProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        File[] files = new File[names.length];
        if (this.fileNameMap == null) {
            this.fileNameMap = new HashMap();
        }
        int numwarn = 0;
        if (names.length > 0) {
            monitor.setTaskSize((long)(names.length * 10));
        }
        monitor.started();
        for (int i = 0; i < names.length; ++i) {
            if (monitor.isCancelled()) {
                throw new InterruptedIOException("cancel pressed");
            }
            try {
                FileObject o = this.root.getFileObject(names[i]);
                if (o.exists()) {
                    files[i] = o.getFile((ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)monitor, (long)(i * 10), (long)((i + 1) * 10)));
                } else if (this.allowGz) {
                    File f0;
                    files[i] = f0 = this.maybeGetGzFile(names[i], (ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)monitor, (long)(i * 10), (long)((i + 1) * 10)));
                }
                if (files[i] == null && numwarn < 3) {
                    logger.log(Level.WARNING, "listing returns result that cannot be resolved file file (e.g. bad link): {0}", names[i]);
                    ++numwarn;
                }
                this.fileNameMap.put(files[i], names[i]);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        monitor.finished();
        ArrayList<File> result = new ArrayList<File>(files.length);
        int i = 0;
        for (File file : files) {
            if (file == null) continue;
            result.add(file);
            ++i;
        }
        return result.toArray(new File[i]);
    }

    public File[] getFilesFor(DatumRange targetRange, ProgressMonitor monitor) throws IOException {
        String[] names = this.getNamesFor(targetRange);
        File[] ff = this.getFilesFor(names, monitor);
        return ff;
    }

    public File[] getBestFilesFor(DatumRange targetRange, ProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] names = this.getNamesFor(targetRange, true, monitor.getSubtaskMonitor("get names"));
        File[] files = new File[names.length];
        if (this.fileNameMap == null) {
            this.fileNameMap = new HashMap();
        }
        if (names.length > 0) {
            monitor.setTaskSize((long)(names.length * 10));
        }
        monitor.started();
        for (int i = 0; i < names.length; ++i) {
            if (monitor.isCancelled()) {
                throw new InterruptedIOException("cancel pressed");
            }
            try {
                FileObject o = this.root.getFileObject(names[i]);
                if (o.exists()) {
                    files[i] = o.getFile((ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)monitor, (long)(i * 10), (long)((i + 1) * 10)));
                } else if (this.allowGz) {
                    File f0;
                    files[i] = f0 = this.maybeGetGzFile(names[i], (ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)monitor, (long)(i * 10), (long)((i + 1) * 10)));
                }
                this.fileNameMap.put(files[i], names[i]);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        monitor.finished();
        return files;
    }

    private static int countGroups(String regex) {
        boolean result = false;
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher("");
        return m.groupCount();
    }

    private static String getParentRegex(String regex) {
        StringBuilder dirRegex;
        String[] s = regex.split("/");
        if (s.length > 1) {
            dirRegex = new StringBuilder(s[0]);
            for (int i = 1; i < s.length - 1; ++i) {
                dirRegex.append("/").append(s[i]);
            }
        } else {
            dirRegex = null;
        }
        return dirRegex == null ? null : dirRegex.toString();
    }

    public FileStorageModel getParent() {
        return this.parent;
    }

    protected static String makeCanonical(String template) {
        String result = template.contains("$Y") || template.contains("$y") ? template.replaceAll("\\$", "%") : template;
        int i = (result = result.replaceAll("//+", "/")).indexOf("/");
        if (i > -1 && result.indexOf("%") > i) {
            System.err.println("each folder of template must have fields marked by $ or %: " + result.substring(0, i));
        }
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    private static String hideParams(String template) {
        StringBuilder result = new StringBuilder();
        boolean withinArg = false;
        for (int i = 0; i < template.length(); ++i) {
            if (withinArg) {
                if (template.charAt(i) == ')') {
                    withinArg = false;
                }
                if (withinArg) {
                    result.append("_");
                    continue;
                }
                result.append(template.charAt(i));
                continue;
            }
            if (template.charAt(i) == '(') {
                withinArg = true;
            }
            result.append(template.charAt(i));
        }
        return result.toString();
    }

    public static int splitIndex(String surl) {
        String regex = "([\\$][yYmdjxv\\(\\{])";
        Matcher m = Pattern.compile(regex).matcher(surl);
        if (m.find()) {
            int i = m.start();
            i = surl.lastIndexOf(47, i);
            return i + 1;
        }
        return -1;
    }

    public static FileStorageModel create(FileSystem root, String template) {
        int i2;
        template = FileStorageModel.makeCanonical(template);
        String templatebr = FileStorageModel.hideParams(template);
        int i = templatebr.lastIndexOf("/");
        if (template.contains("%") && !template.contains("$")) {
            template = template.replaceAll("\\%", "\\$");
            templatebr = templatebr.replaceAll("\\%", "\\$");
        }
        if ((i2 = templatebr.lastIndexOf("$", i)) != -1) {
            String parentTemplate = template.substring(0, i);
            FileStorageModel parentFSM = FileStorageModel.create(root, parentTemplate);
            return new FileStorageModel(parentFSM, root, template);
        }
        return new FileStorageModel(null, root, template);
    }

    public static FileStorageModel create(FileSystem root, String template, String fieldName, TimeParser.FieldHandler fieldHandler) {
        int i2;
        template = FileStorageModel.makeCanonical(template);
        String templatebr = FileStorageModel.hideParams(template);
        int i = templatebr.lastIndexOf("/");
        if (template.contains("%") && !template.contains("$")) {
            template = template.replaceAll("\\%", "\\$");
            templatebr = templatebr.replaceAll("\\%", "\\$");
        }
        if ((i2 = templatebr.lastIndexOf("$", i)) != -1) {
            String parentTemplate = template.substring(0, i);
            FileStorageModel parentFSM = FileStorageModel.create(root, parentTemplate, fieldName, fieldHandler);
            return new FileStorageModel(parentFSM, root, template, fieldName, fieldHandler, new Object[0]);
        }
        return new FileStorageModel(null, root, template, fieldName, fieldHandler, new Object[0]);
    }

    private FileStorageModel(FileStorageModel parent, FileSystem root, String template, String fieldName, TimeParser.FieldHandler fieldHandler, Object ... moreHandler) {
        this.root = root;
        this.parent = parent;
        if (template.startsWith(" ")) {
            throw new IllegalArgumentException("template cannot start with space: \"" + template + "\"");
        }
        if (template.startsWith("/")) {
            template = template.substring(1);
        }
        while (template.contains("//")) {
            template = template.replaceAll("\\/\\/", "/");
        }
        this.template = template.replaceAll("\\+", "\\\\+");
        String f = "v";
        this.versioningType = VersioningType.none;
        TimeParser.FieldHandler vh = new TimeParser.FieldHandler(){

            public String configure(Map<String, String> args) {
                String lt;
                String type;
                String alpha;
                String sep = args.get("sep");
                if (sep == null && args.containsKey("dotnotation")) {
                    sep = "T";
                }
                if ((alpha = args.get("alpha")) == null && args.containsKey("alphanumeric")) {
                    alpha = "T";
                }
                if ((type = args.get("type")) != null) {
                    if (type.equals("sep") || type.equals("dotnotation")) {
                        sep = "T";
                    } else if (type.equals("alpha") || type.equals("alphanumeric")) {
                        alpha = "T";
                    }
                }
                if (args.get("gt") != null) {
                    throw new IllegalArgumentException("gt specified but not supported: must be ge or lt");
                }
                if (args.get("le") != null) {
                    throw new IllegalArgumentException("le specified but not supported: must be ge or lt");
                }
                String ge = args.get("ge");
                if (ge != null) {
                    FileStorageModel.this.versionGe = ge;
                }
                if ((lt = args.get("lt")) != null) {
                    FileStorageModel.this.versionLt = lt;
                }
                if (alpha != null) {
                    if (sep != null) {
                        return "alpha with split not supported";
                    }
                    FileStorageModel.this.versioningType = VersioningType.alphanumeric;
                } else {
                    FileStorageModel.this.versioningType = sep != null ? VersioningType.numericSplit : VersioningType.numeric;
                }
                return null;
            }

            public void parse(String fieldContent, TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, Map<String, String> extra) {
                String v = extra.get("v");
                if (v != null) {
                    FileStorageModel.this.versioningType = VersioningType.numericSplit;
                    fieldContent = v + "." + fieldContent;
                }
                extra.put("v", fieldContent);
            }

            public String getRegex() {
                return ".*";
            }

            public String format(TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, int length, Map<String, String> extra) {
                return extra.get("v");
            }
        };
        this.timeParser = fieldName == null ? TimeParser.create((String)template, (String)f, (TimeParser.FieldHandler)vh, (Object[])new Object[0]) : (moreHandler == null || moreHandler.length == 0 ? TimeParser.create((String)template, (String)fieldName, (TimeParser.FieldHandler)fieldHandler, (Object[])new Object[]{f, vh}) : TimeParser.create((String)template, (String)fieldName, (TimeParser.FieldHandler)fieldHandler, (Object[])new Object[]{f, vh, moreHandler}));
        this.regex = this.timeParser.getRegex();
        this.pattern = Pattern.compile(this.regex);
        if (template.endsWith(".gz")) {
            this.allowGz = false;
        }
        if (this.allowGz) {
            this.gzpattern = Pattern.compile(this.regex + "\\.gz");
        }
    }

    private FileStorageModel(FileStorageModel parent, FileSystem root, String template) {
        this(parent, root, template, null, null, new Object[0]);
    }

    public String toString() {
        return String.valueOf(this.root) + this.template;
    }

    static enum VersioningType {
        none(null),
        numeric(new Comparator(){

            public int compare(Object o1, Object o2) {
                Double d1 = Double.parseDouble((String)o1);
                Double d2 = Double.parseDouble((String)o2);
                return d1.compareTo(d2);
            }
        }),
        alphanumeric(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        }),
        numericSplit(new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] ss1 = o1.toString().split("[\\.-]", -2);
                String[] ss2 = o2.toString().split("[\\.-]", -2);
                int n = Math.min(ss1.length, ss2.length);
                for (int i = 0; i < n; ++i) {
                    int d2;
                    int d1 = Integer.parseInt(ss1[i]);
                    if (d1 == (d2 = Integer.parseInt(ss2[i]))) continue;
                    return d1 < d2 ? -1 : 1;
                }
                return ss1.length - ss2.length;
            }
        });

        Comparator<String> comp;

        private VersioningType(Comparator<String> comp) {
            this.comp = comp;
        }
    }
}

