/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasProperties;
import org.das2.components.DasProgressWheel;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.DomainDivider;
import org.das2.datum.DomainDividerUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.OrbitDatumRange;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatterFactory;
import org.das2.datum.format.TimeDatumFormatterFactory;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.event.HorizontalRangeSelectorMouseModule;
import org.das2.event.MouseModule;
import org.das2.event.TimeRangeSelectionEvent;
import org.das2.event.TimeRangeSelectionListener;
import org.das2.event.VerticalRangeSelectorMouseModule;
import org.das2.event.ZoomPanMouseModule;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.DataRange;
import org.das2.graph.GraphUtil;
import org.das2.graph.TickMaster;
import org.das2.graph.TickVDescriptor;
import org.das2.math.fft.jnt.Factorize;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QFunction;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.system.DasLogger;
import org.das2.system.RequestProcessor;
import org.das2.util.ColorUtil;
import org.das2.util.DasMath;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.LoggerManager;
import org.das2.util.TickleTimer;

public class DasAxis
extends DasCanvasComponent
implements DataRangeSelectionListener,
TimeRangeSelectionListener,
Cloneable {
    public static final String PROP_LABEL = "label";
    public static final String PROP_LOG = "log";
    public static final String PROP_OPPOSITE_AXIS_VISIBLE = "oppositeAxisVisible";
    public static final String PROP_BOUNDS = "bounds";
    public static final String PROP_SCAN_RANGE = "scanRange";
    public static final String PROP_UNITS = "units";
    public static final String PROPERTY_TICKS = "ticks";
    public static final int MAX_TCA_LINES = 32;
    private static final int DEVICE_POSITIVE_LIMIT = 10000;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    private static final int UP = 995;
    private static final int DOWN = 996;
    private static final String STEP_PREVIOUS_LABEL = "<< step";
    private static final String STEP_NEXT_LABEL = "step >>";
    protected DataRange dataRange;
    private int parentHeight;
    private int parentWidth;
    private DatumFormatter userDatumFormatter = null;
    private final Object tickLock = new Object();
    double at_m;
    double at_b;
    private int orientation;
    private int tickDirection = 1;
    protected String axisLabel = "";
    protected TickVDescriptor tickV;
    private boolean autoTickV = true;
    private boolean ticksVisible = true;
    private boolean tickLabelsVisible = true;
    private boolean oppositeAxisVisible = false;
    protected DatumFormatter datumFormatter = DefaultDatumFormatterFactory.getInstance().defaultFormatter();
    private MouseModule zoom = null;
    private PropertyChangeListener dataRangePropertyListener;
    protected JPanel primaryInputPanel;
    protected JPanel secondaryInputPanel;
    private ScanButton stepPrevious;
    private ScanButton stepNext;
    private DatumRange scanRange;
    private boolean animated = "on".equals(DasProperties.getInstance().get("visualCues"));
    private Rectangle blLineRect;
    private Rectangle trLineRect;
    private Rectangle blTickRect;
    private Rectangle trTickRect;
    private Rectangle blLabelRect;
    private Rectangle trLabelRect;
    private Rectangle blTitleRect;
    private Rectangle trTitleRect;
    private Integer leftXOverride = null;
    private String labelOffset = "";
    private boolean flipped;
    private EventListenerList timeRangeListenerList = null;
    private TimeRangeSelectionEvent lastProcessedEvent = null;
    private QFunction tcaFunction;
    private QDataSet tcaData = null;
    private final Object tcaDataLock = new Object();
    private String dataset = "";
    private boolean drawTca;
    private TickleTimer tcaTimer;
    public static final String PROPERTY_DATUMRANGE = "datumRange";
    private static final boolean DEBUG_GRAPHICS = System.getProperty("das2.graph.dasaxis.debuggraphics", "false").equals("true");
    private static final Color[] DEBUG_COLORS = new Color[]{ColorUtil.decodeColor((String)"Purple"), ColorUtil.decodeColor((String)"Purple").brighter().brighter()};
    int tickLen = 0;
    String tickLenStr = "0.66em";
    final int TICK_LABEL_GAP_MIN = 4;
    private int debugColorIndex = 0;
    private DasPlot dasPlot;
    private JMenu bookmarksMenu;
    private JMenu backMenu;
    private static final Logger logger = LoggerManager.getLogger((String)"das2.graphics.axis");
    protected boolean enableHistory = true;
    public static final String PROP_ENABLEHISTORY = "enableHistory";
    private String reference = "";
    public static final String PROP_REFERENCE = "reference";
    private boolean tcaIsLoading;
    private boolean tcaNeedsPainting;
    private int tcaRows = -1;
    public static final String PROP_TCAROWS = "tcaRows";
    private String tcaLabels = "";
    public static final String PROP_TCALABELS = "tcaLabels";
    private String tickValues = "";
    public static final String PROP_TICKVALUES = "tickValues";
    final Object tcaLock = "tcaload_" + this.getDasName();
    private String axisOffset = "";
    public static final String PROP_AXISOFFSET = "axisOffset";
    private String fontSize = "1em";
    public static final String PROP_FONTSIZE = "fontSize";
    private static final Pattern pattern = Pattern.compile("\\([eEfF]\\d+.\\d+\\)");
    private int repaintCount = 0;
    private String lineThickness = "1px";
    public static final String PROP_LINETHICKNESS = "lineThickness";
    public static final String PROP_FLIPPED = "flipped";
    protected String formatString = "";
    public static final String PROP_FORMAT = "format";
    protected boolean flipLabel = false;
    public static final String PROP_FLIPLABEL = "flipLabel";
    protected DatumFormatter dividerDatumFormatter = null;
    public static final String PROP_DIVIDERDATUMFORMATTER = "dividerDatumFormatter";
    protected DomainDivider minorTicksDomainDivider = null;
    public static final String PROP_MINORTICKSDOMAINDIVIDER = "minorTicksDomainDivider";
    protected DomainDivider majorTicksDomainDivider = null;
    public static final String PROP_MAJORTICKSDOMAINDIVIDER = "majorTicksDomainDivider";
    protected boolean useDomainDivider = false;
    public static final String PROP_USEDOMAINDIVIDER = "useDomainDivider";
    private boolean lockDomainDivider = false;
    public static final String PROP_LOCKDOMAINDIVIDER = "lockDomainDivider";

    public DatumFormatter getUserDatumFormatter() {
        return this.userDatumFormatter;
    }

    public void setUserDatumFormatter(DatumFormatter userDatumFormatter) {
        logger.log(Level.FINE, "setUserDatumFormatter({0})", userDatumFormatter);
        DatumFormatter old = this.userDatumFormatter;
        this.userDatumFormatter = userDatumFormatter;
        if (old != userDatumFormatter) {
            this.updateTickV();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DasAxis.this.resize();
                DasAxis.this.repaint();
            }
        });
    }

    public void setNextAction(String label, AbstractAction abstractAction) {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            ActionListener[] als;
            for (ActionListener al : als = this.stepNext.getActionListeners()) {
                this.stepNext.removeActionListener(al);
            }
            this.stepNext.setAction(abstractAction);
            this.stepNext.setText("" + label + " >>");
        }
    }

    public void setPreviousAction(String label, AbstractAction abstractAction) {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            ActionListener[] als;
            for (ActionListener al : als = this.stepPrevious.getActionListeners()) {
                this.stepPrevious.removeActionListener(al);
            }
            this.stepPrevious.setAction(abstractAction);
            this.stepPrevious.setText("<< " + label);
        }
    }

    public DasAxis(Datum min, Datum max, int orientation) {
        this(min, max, orientation, false);
    }

    public DasAxis(DatumRange range, int orientation) {
        this(range.min(), range.max(), orientation);
    }

    public DasAxis(Datum min, Datum max, int orientation, boolean log) {
        this(orientation);
        this.dataRange = new DataRange(this, min, max, log);
        this.addListenersToDataRange(this.dataRange, this.dataRangePropertyListener);
        this.copyFavorites();
        this.copyHistory();
    }

    protected DasAxis(DataRange range, int orientation) {
        this(orientation);
        this.dataRange = range;
        this.addListenersToDataRange(range, this.dataRangePropertyListener);
        this.copyFavorites();
        this.copyHistory();
    }

    private DasAxis(int orientation) {
        this.setOpaque(false);
        this.setOrientationInternal(orientation);
        this.installMouseModules();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.backMenu = new JMenu("Back");
            this.mouseAdapter.addMenuItem(this.backMenu);
            this.bookmarksMenu = new JMenu("Bookmarks");
            this.mouseAdapter.addMenuItem(this.bookmarksMenu);
        }
        this.dataRangePropertyListener = this.createDataRangePropertyListener();
        this.setLayout(new AxisLayoutManager());
        this.maybeInitializeInputPanels();
        this.maybeInitializeScanButtons();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.stepNext.setEnabled(true);
            this.stepPrevious.setEnabled(true);
        }
        this.add(this.primaryInputPanel);
        this.add(this.secondaryInputPanel);
        try {
            this.updateTickLength();
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    DasAxis.this.updateTickLength();
                }
                catch (ParseException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        });
        TickMaster.getInstance().register(this);
    }

    private void addListenersToDataRange(DataRange range, PropertyChangeListener listener) {
        range.addPropertyChangeListener(PROP_LOG, listener);
        range.addPropertyChangeListener("minimum", listener);
        range.addPropertyChangeListener("maximum", listener);
        range.addPropertyChangeListener(PROPERTY_DATUMRANGE, listener);
        range.addPropertyChangeListener("history", listener);
        range.addPropertyChangeListener("favorites", listener);
    }

    public void addToFavorites(DatumRange range) {
        this.dataRange.addToFavorites(range);
        this.copyFavorites();
    }

    public void removeFromFavorites(DatumRange range) {
        this.dataRange.removeFromFavorites(range);
        this.copyFavorites();
    }

    private void copyFavorites() {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            return;
        }
        this.bookmarksMenu.removeAll();
        List favorites = this.dataRange.getFavorites();
        for (final DatumRange r : favorites) {
            AbstractAction action = new AbstractAction(r.toString()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    DasAxis.this.setDatumRange(r);
                }
            };
            JMenuItem menuItem = new JMenuItem(action);
            this.bookmarksMenu.add(menuItem);
        }
        this.bookmarksMenu.add(new JSeparator());
        AbstractAction action = new AbstractAction("bookmark this range"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                DasAxis.this.addToFavorites(DasAxis.this.getDatumRange());
            }
        };
        JMenuItem addItem = new JMenuItem(action);
        this.bookmarksMenu.add(addItem);
        this.bookmarksMenu.add(new JSeparator());
        AbstractAction action2 = new AbstractAction("remove bookmark for range"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                DasAxis.this.removeFromFavorites(DasAxis.this.getDatumRange());
            }
        };
        JMenuItem rmItem = new JMenuItem(action2);
        this.bookmarksMenu.add(rmItem);
    }

    private void copyHistory() {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            return;
        }
        if (!this.enableHistory) {
            return;
        }
        this.backMenu.removeAll();
        List history = this.dataRange.getHistory();
        int ii = 0;
        Iterator i = history.iterator();
        while (i.hasNext()) {
            final int ipop = ii++;
            DatumRange r = (DatumRange)i.next();
            AbstractAction action = new AbstractAction(r.toString()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    DasAxis.this.dataRange.popHistory(ipop);
                    DasAxis.this.setDataRangePrev();
                }
            };
            JMenuItem menuItem = new JMenuItem(action);
            this.backMenu.add(menuItem);
        }
    }

    public boolean isEnableHistory() {
        return this.enableHistory;
    }

    public void setEnableHistory(boolean enableHistory) {
        boolean oldEnableHistory = this.enableHistory;
        this.enableHistory = enableHistory;
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            if (!enableHistory) {
                this.getDasMouseInputAdapter().removeMenuItem(this.backMenu.getText());
            } else {
                this.getDasMouseInputAdapter().addMenuItem(this.backMenu);
            }
        }
        this.firePropertyChange(PROP_ENABLEHISTORY, oldEnableHistory, enableHistory);
    }

    private void maybeInitializeInputPanels() {
        if (this.primaryInputPanel == null) {
            this.primaryInputPanel = new JPanel();
            this.primaryInputPanel.setOpaque(false);
        }
        if (this.secondaryInputPanel == null) {
            this.secondaryInputPanel = new JPanel();
            this.secondaryInputPanel.setOpaque(false);
        }
    }

    private void maybeInitializeScanButtons() {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.stepPrevious = new ScanButton(STEP_PREVIOUS_LABEL);
            this.stepNext = new ScanButton(STEP_NEXT_LABEL);
            ActionListener al = this.createScanActionListener();
            this.stepPrevious.addActionListener(al);
            this.stepNext.addActionListener(al);
            this.add(this.stepPrevious);
            this.add(this.stepNext);
        }
    }

    private ActionListener createScanActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                String command = e.getActionCommand();
                DasLogger.getLogger(DasLogger.GUI_LOG).log(Level.FINE, "event {0}", command);
                if (command.equals(DasAxis.STEP_PREVIOUS_LABEL)) {
                    if (DasAxis.this.scanRange == null || DasAxis.this.scanRange.intersects(DasAxis.this.getDatumRange().previous())) {
                        DasAxis.this.scanPrevious();
                    }
                } else if (command.equals(DasAxis.STEP_NEXT_LABEL) && (DasAxis.this.scanRange == null || DasAxis.this.scanRange.intersects(DasAxis.this.getDatumRange().next()))) {
                    DasAxis.this.scanNext();
                }
            }
        };
    }

    private PropertyChangeListener createDataRangePropertyListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                Object oldValue = e.getOldValue();
                Object newValue = e.getNewValue();
                if (propertyName.equals(DasAxis.PROP_LOG)) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange(DasAxis.PROP_LOG, oldValue, newValue);
                    DasAxis.this.markDirty("transform:" + propertyName + "=" + newValue);
                } else if (propertyName.equals("minimum")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("dataMinimum", oldValue, newValue);
                    DasAxis.this.markDirty("transform:" + propertyName + "=" + DasAxis.this.getUnits().createDatum((Number)newValue));
                } else if (propertyName.equals("maximum")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("dataMaximum", oldValue, newValue);
                    DasAxis.this.markDirty("transform:" + propertyName + "=" + DasAxis.this.getUnits().createDatum((Number)newValue));
                } else if (propertyName.equals("favorites")) {
                    DasAxis.this.copyFavorites();
                } else if (propertyName.equals(DasAxis.PROPERTY_DATUMRANGE)) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange(DasAxis.PROPERTY_DATUMRANGE, oldValue, newValue);
                    DasAxis.this.markDirty("transform:" + propertyName + "=" + newValue);
                } else if (propertyName.equals("history") && !DasAxis.this.dataRange.valueIsAdjusting()) {
                    DasAxis.this.copyHistory();
                }
            }
        };
    }

    private void installMouseModules() {
        if (this.zoom instanceof HorizontalRangeSelectorMouseModule) {
            ((HorizontalRangeSelectorMouseModule)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        } else if (this.zoom instanceof VerticalRangeSelectorMouseModule) {
            ((VerticalRangeSelectorMouseModule)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        }
        if (this.isHorizontal()) {
            this.zoom = new HorizontalRangeSelectorMouseModule(this, this);
            ((HorizontalRangeSelectorMouseModule)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
            ZoomPanMouseModule zoomPan = new ZoomPanMouseModule((DasCanvasComponent)this, this, null);
            this.mouseAdapter.addMouseModule(zoomPan);
            this.mouseAdapter.setSecondaryModule(zoomPan);
        } else {
            this.zoom = new VerticalRangeSelectorMouseModule(this, this);
            ((VerticalRangeSelectorMouseModule)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
            ZoomPanMouseModule zoomPan = new ZoomPanMouseModule((DasCanvasComponent)this, null, this);
            this.mouseAdapter.addMouseModule(zoomPan);
            this.mouseAdapter.setSecondaryModule(zoomPan);
        }
    }

    public void setOrientation(int orientation) {
        boolean oldIsHorizontal = this.isHorizontal();
        this.setOrientationInternal(orientation);
        if (oldIsHorizontal != this.isHorizontal()) {
            this.installMouseModules();
        }
    }

    private void setOrientationInternal(int orientation) {
        this.orientation = orientation;
        switch (orientation) {
            case 1: {
                this.setTickDirection(995);
                break;
            }
            case 2: {
                this.setTickDirection(996);
                break;
            }
            case 3: {
                this.setTickDirection(4);
                break;
            }
            case 4: {
                this.setTickDirection(3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for orientation");
            }
        }
    }

    public void setDatumRange(DatumRange dr) {
        if (dr == null) {
            throw new NullPointerException("range cannot be null");
        }
        if (!UnitsUtil.isIntervalOrRatioMeasurement((Units)dr.getUnits())) {
            throw new IllegalArgumentException("units cannot be ordinal or nominal");
        }
        if (dr.width().value() == 0.0) {
            throw new IllegalArgumentException("width is zero: " + dr);
        }
        DatumRange oldRange = this.dataRange.getDatumRange();
        Units oldUnits = this.getUnits();
        if (!this.rangeIsAcceptable(dr)) {
            logger.log(Level.WARNING, "invalid range ignored: {0}", dr);
            return;
        }
        if (this.getUnits().isConvertibleTo(dr.getUnits())) {
            this.dataRange.setRange(dr);
        } else {
            this.resetRange(dr);
        }
        if (oldUnits != dr.getUnits()) {
            this.firePropertyChange(PROP_UNITS, oldUnits, dr.getUnits());
        }
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, dr);
    }

    public DatumRange getDatumRange() {
        return this.dataRange.getDatumRange();
    }

    protected boolean rangeIsAcceptable(DatumRange dr) {
        return dr.min().lt(dr.max());
    }

    public void setDataRange(Datum minimum, Datum maximum) {
        double max;
        double min;
        Units units = this.dataRange.getUnits();
        if (minimum.getUnits() != units) {
            minimum = minimum.convertTo(units);
            maximum = maximum.convertTo(units);
        }
        DatumRange newRange = new DatumRange(minimum, maximum);
        logger.log(Level.FINE, "enter dasAxis.setDataRange( {0} )", newRange);
        if (!this.rangeIsAcceptable(newRange)) {
            logger.log(Level.WARNING, "invalid range ignored: {0}", newRange);
            return;
        }
        double min0 = this.dataRange.getMinimum();
        double max0 = this.dataRange.getMaximum();
        if (this.dataRange.isLog()) {
            min = Math.log10(minimum.doubleValue(this.getUnits()));
            max = Math.log10(maximum.doubleValue(this.getUnits()));
            if (minimum.doubleValue(this.getUnits()) == 0.0) {
                min = max / 1000.0;
            }
        } else {
            min = minimum.doubleValue(this.getUnits());
            max = maximum.doubleValue(this.getUnits());
        }
        if (!this.valueIsAdjusting()) {
            this.animateChange(min0, max0, min, max);
        }
        DatumRange oldRange = this.dataRange.getDatumRange();
        this.dataRange.setRange(newRange);
        this.refreshScanButtons(false);
        this.update();
        this.createAndFireRangeSelectionEvent();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, newRange);
    }

    public void clearHistory() {
        this.dataRange.clearHistory();
    }

    private void createAndFireRangeSelectionEvent() {
        if (this.getUnits() instanceof TimeLocationUnits) {
            logger.fine("firing rangeSelectionEvent");
            TimeRangeSelectionEvent e = new TimeRangeSelectionEvent(this, new DatumRange(this.getDataMinimum(), this.getDataMaximum()));
            this.fireTimeRangeSelectionListenerTimeRangeSelected(e);
        }
    }

    public void setDataRangePrev() {
        logger.fine("enter dasAxis.setDataRangePrev()");
        DatumRange oldRange = this.dataRange.getDatumRange();
        double min0 = this.dataRange.getMinimum();
        double max0 = this.dataRange.getMaximum();
        this.dataRange.setRangePrev();
        DatumRange newRange = this.dataRange.getDatumRange();
        double min1 = this.dataRange.getMinimum();
        double max1 = this.dataRange.getMaximum();
        this.animateChange(min0, max0, min1, max1);
        this.update();
        this.createAndFireRangeSelectionEvent();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, newRange);
    }

    public void setDataRangeForward() {
        logger.fine("enter dasAxis.setDataRangeForward()");
        double min0 = this.dataRange.getMinimum();
        double max0 = this.dataRange.getMaximum();
        DatumRange oldRange = this.dataRange.getDatumRange();
        this.dataRange.setRangeForward();
        DatumRange newRange = this.dataRange.getDatumRange();
        double min1 = this.dataRange.getMinimum();
        double max1 = this.dataRange.getMaximum();
        this.animateChange(min0, max0, min1, max1);
        this.update();
        this.createAndFireRangeSelectionEvent();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, newRange);
    }

    public void setDataRangeZoomOut() {
        logger.fine("enter dasAxis.setDataRangeZoomOut()");
        double t1 = this.dataRange.getMinimum();
        double t2 = this.dataRange.getMaximum();
        double width = t2 - t1;
        double min = t1 - width;
        double max = t2 + width;
        this.animateChange(t1, t2, min, max);
        DatumRange oldRange = this.dataRange.getDatumRange();
        if (!DatumRangeUtil.isAcceptable((DatumRange)DatumRange.newDatumRange((double)min, (double)max, (Units)this.getUnits()), (boolean)this.isLog())) {
            logger.info("zoom out limit");
            return;
        }
        this.dataRange.setRange(min, max);
        DatumRange newRange = this.dataRange.getDatumRange();
        this.update();
        this.createAndFireRangeSelectionEvent();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, newRange);
    }

    public DataRange getDataRange() {
        return this.dataRange;
    }

    protected void deviceRangeChanged() {
    }

    public Datum getDataMinimum() {
        return this.dataRange.getDatumRange().min();
    }

    public Datum getDataMaximum() {
        return this.dataRange.getDatumRange().max();
    }

    public DatumRange getRange() {
        return this.dataRange.getDatumRange();
    }

    public double getDataMaximum(Units units) {
        return this.getDataMaximum().doubleValue(units);
    }

    public double getDataMinimum(Units units) {
        return this.getDataMinimum().doubleValue(units);
    }

    public void setDataMaximum(Datum max) {
        this.dataRange.setMaximum(max);
        this.update();
    }

    public void setDataMinimum(Datum min) {
        this.dataRange.setMinimum(min);
        this.update();
    }

    public boolean isLog() {
        return this.dataRange.isLog();
    }

    public void setLog(boolean log) {
        boolean oldLog = this.isLog();
        DatumRange range = this.getDatumRange();
        this.dataRange.setLog(log);
        this.update();
        if (log != oldLog) {
            this.firePropertyChange(PROP_LOG, oldLog, log);
        }
        if (!range.equals((Object)this.getDatumRange())) {
            this.firePropertyChange(PROPERTY_DATUMRANGE, range, this.getDatumRange());
        }
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        String oldReference = this.reference;
        this.reference = reference.trim();
        this.update();
        this.firePropertyChange(PROP_REFERENCE, oldReference, reference);
    }

    public Units getUnits() {
        return this.dataRange.getUnits();
    }

    public void setUnits(Units newUnits) {
        this.dataRange.setUnits(newUnits);
    }

    public void setScanRange(DatumRange range) {
        DatumRange old = this.scanRange;
        this.scanRange = range;
        if (this.stepNext != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DatumRange range = DasAxis.this.getScanRange();
                    if (range == null) {
                        DasAxis.this.stepNext.setToolTipText(null);
                        DasAxis.this.stepPrevious.setToolTipText(null);
                    } else {
                        DasAxis.this.stepNext.setToolTipText("<html><em><sub>scan limited to<br>" + range.toString());
                        DasAxis.this.stepPrevious.setToolTipText("<html><em><sub>scan limited to<br>" + range.toString());
                    }
                }
            });
        }
        this.firePropertyChange(PROP_SCAN_RANGE, old, range);
    }

    public DatumRange getScanRange() {
        return this.scanRange;
    }

    public synchronized void resetRange(DatumRange range) {
        DatumRange oldRange = this.getDatumRange();
        if (range.getUnits() != this.getUnits()) {
            if (this.dasPlot != null) {
                this.dasPlot.invalidateCacheImage();
            }
            logger.log(Level.FINEST, "replaceRange({0})", range);
            this.dataRange.resetRange(range);
            this.setScanRange(null);
        } else {
            this.dataRange.setRange(range);
        }
        this.updateTickV();
        this.markDirty("range");
        this.firePropertyChange(PROPERTY_DATUMRANGE, null, range);
        this.update();
    }

    public void setOppositeAxisVisible(boolean visible) {
        if (visible == this.oppositeAxisVisible) {
            return;
        }
        boolean oldValue = this.oppositeAxisVisible;
        this.oppositeAxisVisible = visible;
        this.revalidate();
        this.repaint();
        this.firePropertyChange(PROP_OPPOSITE_AXIS_VISIBLE, oldValue, visible);
    }

    public boolean isOppositeAxisVisible() {
        return this.oppositeAxisVisible;
    }

    public void setLabel(String t) {
        logger.log(Level.FINE, "setLabel(\"{0}\")", t);
        if (t == null) {
            throw new NullPointerException("axis label cannot be null");
        }
        String oldValue = this.axisLabel;
        this.axisLabel = t;
        this.update();
        this.firePropertyChange(PROP_LABEL, oldValue, t);
    }

    public String getLabel() {
        return this.axisLabel;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean getDrawTca() {
        return this.isDrawTca();
    }

    public boolean isDrawTca() {
        return this.drawTca;
    }

    public boolean isTcaLoaded() {
        return this.tcaData != null;
    }

    public void setDrawTca(boolean b) {
        boolean oldValue = this.drawTca;
        if (b && this.getOrientation() != 2) {
            throw new IllegalArgumentException("Vertical time axes cannot have annotations");
        }
        if (this.drawTca == b) {
            return;
        }
        this.drawTca = b;
        if (!b) {
            this.tcaNeedsPainting = false;
            this.tcaIsLoading = false;
        }
        this.markDirty("drawTca");
        this.update();
        this.firePropertyChange("showTca", oldValue, b);
    }

    private static QFunction tcaFunction(String dataset) throws DasException {
        QFunction result;
        block9: {
            result = null;
            if (dataset.startsWith("/")) {
                throw new IllegalArgumentException("das2 legacy TCA stuff needs to be implemented");
            }
            if (dataset.startsWith("class:")) {
                try {
                    try {
                        int argPos = dataset.indexOf(58, 6);
                        if (argPos == -1) {
                            String className = dataset.substring(6);
                            result = (QFunction)Class.forName(className).newInstance();
                            break block9;
                        }
                        String className = dataset.substring(6, argPos);
                        String arg = dataset.substring(argPos + 1);
                        try {
                            result = (QFunction)Class.forName(className).getConstructor(String.class).newInstance(arg);
                        }
                        catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                            throw new DasException(ex);
                        }
                    }
                    catch (IllegalAccessException | InstantiationException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
                catch (ClassNotFoundException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        return result;
    }

    public String getDataPath() {
        return this.dataset;
    }

    public void setDataPath(String dataset) {
        if (dataset == null) {
            throw new NullPointerException("null dataPath string not allowed");
        }
        String oldValue = this.dataset;
        if (dataset.equals(this.dataset)) {
            return;
        }
        this.dataset = dataset;
        if (dataset.equals("")) {
            this.tcaFunction = null;
            this.tcaData = null;
        } else {
            try {
                this.tcaFunction = DasAxis.tcaFunction(dataset);
                this.maybeStartTCATimer();
                this.tcaData = null;
                if (this.tcaFunction == null) {
                    throw new IllegalArgumentException("unable to implement tca QFunction: " + dataset);
                }
            }
            catch (DasException de) {
                DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)de);
            }
        }
        this.markDirty("tcaDataPath");
        this.update();
        this.firePropertyChange("dataPath", oldValue, dataset);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        super.processEvent(e);
        this.repaint();
    }

    @Override
    boolean isDirty() {
        return super.isDirty() || this.drawTca && this.tcaIsLoading;
    }

    private void maybeStartTCATimer() {
        logger.fine("enter maybeStartTcaTimer");
        final DasCanvas lcanvas = this.getCanvas();
        if (lcanvas == null) {
            logger.log(Level.FINER, "canvas is not yet set, returning");
            return;
        }
        this.tcaIsLoading = true;
        if (lcanvas.isPendingChanges(this.tcaLock)) {
            logger.fine("tcatimer is already pending");
        } else {
            lcanvas.registerPendingChange(this, this.tcaLock);
            if (this.tcaTimer == null) {
                this.tcaTimer = new TickleTimer(200L, new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        logger.log(Level.FINER, "mstca, lcanvas={0}", lcanvas);
                        if (lcanvas == null) {
                            DasAxis.this.maybeStartTCATimer();
                            return;
                        }
                        lcanvas.performingChange(DasAxis.this, DasAxis.this.tcaLock);
                        try {
                            DasAxis.this.loadTCASoon();
                        }
                        finally {
                            lcanvas.changePerformed(DasAxis.this, DasAxis.this.tcaLock);
                            DasAxis.this.tcaNeedsPainting = true;
                            DasAxis.this.tcaIsLoading = false;
                        }
                    }
                });
            }
        }
        this.tcaTimer.tickle("startTcaTimer");
    }

    public synchronized void setTcaFunction(QFunction f) {
        QFunction oldF = this.tcaFunction;
        this.tcaFunction = f;
        this.maybeStartTCATimer();
        this.markDirty("tcaFunction");
        this.update();
        this.tcaNeedsPainting = false;
        this.tcaIsLoading = false;
        this.firePropertyChange("dataSetDescriptor", null, null);
        this.firePropertyChange("dataPath", null, null);
        this.firePropertyChange("tcaFunction", oldF, f);
    }

    public int getTcaRows() {
        return this.tcaRows;
    }

    public void setTcaRows(int tcaRows) {
        int oldTcaRows = this.tcaRows;
        this.tcaRows = tcaRows;
        this.update();
        this.firePropertyChange(PROP_TCAROWS, oldTcaRows, tcaRows);
    }

    public String getTcaLabels() {
        return this.tcaLabels;
    }

    public void setTcaLabels(String tcaLabels) {
        String oldTcaLabels = this.tcaLabels;
        this.tcaLabels = tcaLabels;
        this.markDirty("tcaFunction");
        this.update();
        this.firePropertyChange(PROP_TCALABELS, oldTcaLabels, tcaLabels);
    }

    private void loadTCADataSet() {
        DatumVector tickVDV;
        QFunction ltcaFunction = this.tcaFunction;
        if (ltcaFunction == null) {
            this.tcaData = null;
            return;
        }
        logger.fine("updateTCADataSet");
        if (this.valueIsAdjusting()) {
            logger.finest("someone is adjusting this, wait until later to call.");
            return;
        }
        Units u = this.getUnits();
        if (!u.isConvertibleTo((tickVDV = this.getTickV().tickV).getUnits())) {
            return;
        }
        double[] ltickV = tickVDV.toDoubleArray(u);
        DDataSet dep0 = DDataSet.createRank1((int)ltickV.length);
        dep0.putProperty("UNITS", (Object)u);
        logger.log(Level.FINEST, "update for {0} to {1}", new Object[]{tickVDV.get(0), tickVDV.get(tickVDV.getLength() - 1)});
        try {
            QDataSet dx1;
            Units tcaUnits;
            JoinDataSet ltcaData = new JoinDataSet(2);
            QDataSet exampleInput = ltcaFunction.exampleInput();
            ArrayDataSet ex = ArrayDataSet.copy((QDataSet)exampleInput);
            QDataSet bds = (QDataSet)ex.property("BUNDLE_0");
            if (bds == null) {
                logger.info("no bundle descriptor, dealing with it.");
                tcaUnits = (Units)ex.property("UNITS", 0);
            } else {
                tcaUnits = (Units)bds.property("UNITS", 0);
            }
            if (tcaUnits == null) {
                tcaUnits = Units.dimensionless;
            }
            if (!u.isConvertibleTo(tcaUnits)) {
                logger.info("tca units are not convertable");
                return;
            }
            UnitsConverter uc = UnitsConverter.getConverter((Units)u, (Units)tcaUnits);
            DatumRange context = this.getDatumRange();
            context = DatumRangeUtil.union((DatumRange)context, (Datum)u.createDatum(uc.convert(ltickV[0])));
            context = DatumRangeUtil.union((DatumRange)context, (Datum)u.createDatum(uc.convert(ltickV[ltickV.length - 1])));
            ex.putProperty("CONTEXT_0", 0, (Object)DataSetUtil.asDataSet((DatumRange)context));
            DRank0DataSet dx = DataSetUtil.asDataSet((Datum)this.getDatumRange().width().divide((double)this.getColumn().getWidth()));
            ex.putProperty("DELTA_PLUS", 0, (Object)dx);
            ex.putProperty("DELTA_MINUS", 0, (Object)dx);
            QDataSet outDescriptor = null;
            QDataSet ticks1 = null;
            JoinDataSet timeDs = new JoinDataSet(ex.rank() + 1);
            for (int i = 0; i < ltickV.length; ++i) {
                ex.putValue(0, uc.convert(ltickV[i]));
                timeDs.join((QDataSet)ArrayDataSet.copy(Double.TYPE, (QDataSet)ex));
            }
            timeDs.putProperty("BUNDLE_1", timeDs.slice(0).property("BUNDLE_0"));
            QDataSet tickss = ltcaFunction.values((QDataSet)timeDs);
            if (tickss instanceof JoinDataSet && tickss.length() > 0) {
                JoinDataSet jds = (JoinDataSet)tickss;
                QDataSet bundle1 = (QDataSet)jds.property("BUNDLE_1");
                jds.putProperty("BUNDLE_1", null);
                if (jds.slice(0).property("BUNDLE_0") == null) {
                    jds.putProperty("BUNDLE_1", (Object)bundle1);
                }
            }
            if (tickss.rank() != 2) {
                throw new IllegalArgumentException("result of tcaFunction value() should be rank 1");
            }
            for (int i = 0; i < ltickV.length; ++i) {
                QDataSet ticks = tickss.slice(i);
                if (outDescriptor == null && (outDescriptor = (QDataSet)ticks.property("BUNDLE_0")) != null) {
                    int n = outDescriptor.length();
                    if (outDescriptor.property("NAME", 0) == null && outDescriptor.property("LABEL", 0) == null && (n < 1 || outDescriptor.property("NAME", n - 1) == null && outDescriptor.property("LABEL", n - 1) == null)) {
                        outDescriptor = null;
                    }
                }
                if (ticks1 == null) {
                    ticks1 = ticks;
                }
                if (ticks1.length() == ticks.length()) {
                    ltcaData.join(ticks);
                    dep0.putValue(i, ltickV[i]);
                    continue;
                }
                logger.log(Level.FINER, "skipping irregular record: {0}", ticks);
            }
            if (this.tcaLabels.trim().length() > 0) {
                outDescriptor = Ops.labelsDataset((String[])this.tcaLabels.split(";"));
                ltcaData.putProperty("DEPEND_1", (Object)outDescriptor);
            }
            if (outDescriptor == null) {
                outDescriptor = (QDataSet)tickss.property("BUNDLE_1");
            }
            if ((dx1 = (QDataSet)tickss.property("DEPEND_0")) != null) {
                String label = Ops.guessLabel((QDataSet)dx1);
                dep0.putProperty("LABEL", (Object)label);
            }
            ltcaData.putProperty("BUNDLE_1", (Object)outDescriptor);
            ltcaData.putProperty("DEPEND_0", (Object)dep0);
            this.tcaData = ltcaData;
            this.update();
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.WARNING, "exception occured while reading tca", ex);
            ex.printStackTrace();
            this.tcaData = null;
        }
    }

    public final int getDevicePosition() {
        switch (this.orientation) {
            case 2: {
                return this.getRow().getDMaximum();
            }
            case 1: {
                return this.getRow().getDMinimum();
            }
            case 3: {
                return this.getColumn().getDMinimum();
            }
        }
        return this.getColumn().getDMaximum();
    }

    public int getDLength() {
        if (this.isHorizontal()) {
            return this.getColumn().getWidth();
        }
        return this.getRow().getHeight();
    }

    public DasAxis getMasterAxis() {
        return this.dataRange.getCreator();
    }

    public void attachTo(DasAxis axis) {
        DataRange oldRange = this.dataRange;
        this.dataRange = axis.dataRange;
        oldRange.removePropertyChangeListener(PROP_LOG, this.dataRangePropertyListener);
        oldRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        oldRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        oldRange.removePropertyChangeListener(PROPERTY_DATUMRANGE, this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener(PROP_LOG, this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener(PROPERTY_DATUMRANGE, this.dataRangePropertyListener);
        if (oldRange.isLog() != this.dataRange.isLog()) {
            this.firePropertyChange(PROP_LOG, oldRange.isLog(), this.dataRange.isLog());
        }
        this.firePropertyChange("minimum", oldRange.getMinimum(), this.dataRange.getMinimum());
        this.firePropertyChange("maximum", oldRange.getMaximum(), this.dataRange.getMaximum());
        this.copyFavorites();
        this.copyHistory();
    }

    public void detach() {
        DataRange newRange;
        this.dataRange.removePropertyChangeListener(PROP_LOG, this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener(PROPERTY_DATUMRANGE, this.dataRangePropertyListener);
        this.dataRange = newRange = new DataRange(this, Datum.create((double)this.dataRange.getMinimum(), (Units)this.dataRange.getUnits()), Datum.create((double)this.dataRange.getMaximum(), (Units)this.dataRange.getUnits()), this.dataRange.isLog());
        this.dataRange.addPropertyChangeListener(PROP_LOG, this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener(PROPERTY_DATUMRANGE, this.dataRangePropertyListener);
        this.copyFavorites();
        this.copyHistory();
    }

    public boolean isAttached() {
        return this != this.getMasterAxis();
    }

    public TickVDescriptor getTickV() {
        if (this.tickV == null) {
            this.updateTickV();
        }
        return this.tickV;
    }

    public void setTickV(double[] minorTicks, double[] majorTicks) {
        if (majorTicks == null) {
            this.setTickV(null);
            return;
        }
        if (minorTicks == null) {
            minorTicks = this.getTickV().getMinorTicks().toDoubleArray(this.getUnits());
        }
        TickVDescriptor tv = new TickVDescriptor(minorTicks, majorTicks, this.getUnits());
        this.setTickV(tv);
    }

    public void addTickV(Datum majorTick) {
        TickVDescriptor tv = this.getTickV();
        double[] minorTicks = tv.minorTickV.toDoubleArray(tv.units);
        double[] majorTicks = tv.tickV.toDoubleArray(tv.units);
        double[] newMajorTicks = new double[majorTicks.length + 1];
        System.arraycopy(majorTicks, 0, newMajorTicks, 0, majorTicks.length);
        newMajorTicks[majorTicks.length] = majorTick.doubleValue(tv.units);
        TickVDescriptor newtv = new TickVDescriptor(minorTicks, newMajorTicks, tv.units);
        DatumFormatter f = this.getUserDatumFormatter();
        if (f == null) {
            f = this.getDatumFormatter();
        }
        newtv.setFormatter(f);
        this.setTickV(newtv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTickV(TickVDescriptor tickV) {
        logger.fine("about to lock for setTickV");
        DasAxis dasAxis = this;
        synchronized (dasAxis) {
            this.tickV = tickV;
            if (tickV == null) {
                this.autoTickV = true;
                this.updateTickV();
            } else {
                this.autoTickV = false;
                this.datumFormatter = this.resolveFormatter(tickV);
            }
        }
        if (this.dasPlot != null) {
            this.dasPlot.invalidateCacheImage();
        }
        this.update();
    }

    public String getTickValues() {
        return this.tickValues;
    }

    public void setTickValues(String ticks) {
        String oldTicks = this.tickValues;
        this.tickValues = ticks;
        if (oldTicks != null && !oldTicks.equals(ticks)) {
            this.firePropertyChange(PROP_TICKVALUES, oldTicks, ticks);
            this.updateTickV();
            this.maybeStartTCATimer();
            if (this.dasPlot != null) {
                this.dasPlot.invalidateCacheImage();
            }
        }
    }

    private TickVDescriptor updateTickVLog(DatumRange dr) {
        GrannyTextRenderer idlt = GraphUtil.newGrannyTextRenderer();
        idlt.setString(this.getTickLabelFont(), "10!U-10");
        int nTicksMax = this.isHorizontal() ? (int)Math.floor((double)this.getColumn().getWidth() / idlt.getWidth()) : (int)Math.floor((double)this.getRow().getHeight() / idlt.getHeight());
        int n = nTicksMax = nTicksMax < 20 ? nTicksMax : 20;
        if (nTicksMax < 2) {
            nTicksMax = 2;
        }
        TickVDescriptor tickV1 = TickVDescriptor.bestTickVLogNew(dr.min(), dr.max(), 2, nTicksMax, true);
        return tickV1;
    }

    private TickVDescriptor updateTickVLinear(DatumRange dr) {
        int nTicksMax;
        int axisSize;
        int tickSizePixels;
        if (this.isHorizontal()) {
            tickSizePixels = (int)((double)this.getFontMetrics(this.getTickLabelFont()).stringWidth("0.0000") * 1.5);
            axisSize = this.getColumn().getWidth();
            nTicksMax = axisSize / tickSizePixels;
        } else {
            tickSizePixels = this.getFontMetrics(this.getTickLabelFont()).getHeight() + 6;
            axisSize = this.getRow().getHeight();
            nTicksMax = axisSize / tickSizePixels;
        }
        nTicksMax = nTicksMax < 7 ? nTicksMax : 7;
        TickVDescriptor tickV1 = TickVDescriptor.bestTickVLinear(dr.min(), dr.max(), 3, nTicksMax, false);
        DatumFormatter tdf = this.resolveFormatter(tickV1);
        Rectangle maxBounds = this.getMaxBounds(tdf, tickV1);
        if (this.isHorizontal()) {
            int tickSizePixels2 = (int)((double)maxBounds.width + this.getEmSize() * 2.0);
            nTicksMax = axisSize / tickSizePixels2;
        } else {
            int tickSizePixels3 = maxBounds.height;
            nTicksMax = axisSize / tickSizePixels3;
        }
        tickV1 = TickVDescriptor.bestTickVLinear(dr.min(), dr.max(), 3, nTicksMax, true);
        return tickV1;
    }

    private DatumFormatter resolveFormatter(TickVDescriptor tickV) {
        DatumFormatter udf = this.getUserDatumFormatter();
        if (udf == null) {
            if (tickV == null) {
                return DefaultDatumFormatterFactory.getInstance().defaultFormatter();
            }
            if (this.formatString.length() > 0) {
                try {
                    if (TimeParser.isSpec((String)this.formatString)) {
                        return TimeDatumFormatterFactory.getInstance().newFormatter(this.formatString);
                    }
                    return DefaultDatumFormatterFactory.getInstance().newFormatter(this.formatString);
                }
                catch (ParseException ex) {
                    logger.log(Level.WARNING, "unable to parse formatString: {0}", this.formatString);
                    return tickV.getFormatter();
                }
            }
            return tickV.getFormatter();
        }
        return udf;
    }

    private Rectangle getMaxBounds(DatumFormatter tdf, TickVDescriptor tickV) {
        String[] granny = tdf.axisFormat(tickV.tickV, this.getDatumRange());
        GrannyTextRenderer idlt = GraphUtil.newGrannyTextRenderer();
        Rectangle bounds = new Rectangle();
        for (String granny1 : granny) {
            idlt.setString(this.getTickLabelFont(), granny1);
            bounds.add(idlt.getBounds());
        }
        return bounds;
    }

    private boolean hasLabelCollisions(DatumVector major, DatumFormatter df) {
        if (major.getLength() < 2) {
            return false;
        }
        String[] granny = df.axisFormat(major, this.getDatumRange());
        GrannyTextRenderer idlt = GraphUtil.newGrannyTextRenderer();
        Rectangle[] bounds = new Rectangle[granny.length];
        for (int i = 0; i < granny.length; ++i) {
            idlt.setString(this.getTickLabelFont(), granny[i]);
            Rectangle bound = idlt.getBounds();
            if (this.isHorizontal()) {
                bound.translate((int)this.transform(major.get(i)), 0);
                bound.width = (int)((double)bound.width + this.getEmSize());
            } else {
                bound.translate(0, (int)this.transform(major.get(i)));
                bound.height = (int)((double)bound.height + this.getEmSize() / 2.0);
            }
            bounds[i] = bound;
        }
        Rectangle bound = bounds[0];
        boolean intersects = false;
        for (int i = 1; i < bounds.length; ++i) {
            if (bounds[i].intersects(bound)) {
                intersects = true;
            }
            bound = bounds[i];
        }
        return intersects;
    }

    private boolean hasTickCollisions(DatumVector minor) {
        if (minor.getLength() < 2) {
            return false;
        }
        int x0 = (int)this.transform(minor.get(0));
        int intersects = 0;
        for (int i = 1; intersects < 8 && i < minor.getLength(); ++i) {
            int x1 = (int)this.transform(minor.get(i));
            if (x1 >= 10000) continue;
            intersects = Math.abs(x0 - x1) < 6 ? ++intersects : 0;
            x0 = x1;
        }
        return intersects >= 8;
    }

    private void updateDomainDivider() {
        DatumRange dr = this.getDatumRange();
        this.majorTicksDomainDivider = DomainDividerUtil.getDomainDivider((Datum)dr.min(), (Datum)dr.max(), (boolean)this.isLog());
        while (this.majorTicksDomainDivider.boundaryCount(dr.min(), dr.max()) > 100L) {
            this.majorTicksDomainDivider = this.majorTicksDomainDivider.coarserDivider(false);
        }
        DatumVector major = this.majorTicksDomainDivider.boundaries(dr.min(), dr.max());
        DatumVector major1 = this.majorTicksDomainDivider.finerDivider(false).boundaries(dr.min(), dr.max());
        DatumFormatter df = DomainDividerUtil.getDatumFormatter((DomainDivider)this.majorTicksDomainDivider, (DatumRange)dr);
        while (!this.hasLabelCollisions(major1, df)) {
            this.majorTicksDomainDivider = this.majorTicksDomainDivider.finerDivider(false);
            if (this.majorTicksDomainDivider.boundaryCount(dr.min(), dr.max()) <= 1L) continue;
            df = DomainDividerUtil.getDatumFormatter((DomainDivider)this.majorTicksDomainDivider, (DatumRange)dr);
            major = major1;
            major1 = this.majorTicksDomainDivider.finerDivider(false).boundaries(dr.min(), dr.max());
        }
        while (this.hasLabelCollisions(major, df)) {
            this.majorTicksDomainDivider = this.majorTicksDomainDivider.coarserDivider(false);
            df = DomainDividerUtil.getDatumFormatter((DomainDivider)this.majorTicksDomainDivider, (DatumRange)dr);
            major = this.majorTicksDomainDivider.boundaries(dr.min(), dr.max());
        }
        while (major.getLength() < 2) {
            this.majorTicksDomainDivider = this.majorTicksDomainDivider.finerDivider(false);
            major = this.majorTicksDomainDivider.boundaries(dr.min(), dr.max());
            df = DomainDividerUtil.getDatumFormatter((DomainDivider)this.majorTicksDomainDivider, (DatumRange)dr);
        }
        DomainDivider minorTickDivider = this.majorTicksDomainDivider;
        DatumVector minor = major;
        DatumVector minor1 = minorTickDivider.finerDivider(true).boundaries(dr.min(), dr.max());
        while (!this.hasTickCollisions(minor1)) {
            minorTickDivider = minorTickDivider.finerDivider(true);
            minor = minor1;
            minor1 = minorTickDivider.finerDivider(true).boundaries(dr.min(), dr.max());
        }
        minorTickDivider.boundaries(dr.min(), dr.max());
        this.minorTicksDomainDivider = minorTickDivider;
        this.tickV = TickVDescriptor.newTickVDescriptor(major, minor);
        this.dividerDatumFormatter = DomainDividerUtil.getDatumFormatter((DomainDivider)this.majorTicksDomainDivider, (DatumRange)dr);
        this.datumFormatter = this.resolveFormatter(this.tickV);
    }

    private TickVDescriptor updateTickVDomainDivider(DatumRange dr) {
        try {
            long nminor = this.minorTicksDomainDivider.boundaryCount(dr.min(), dr.max());
            if (nminor >= 1000000L) {
                return this.tickV;
            }
            DatumVector major = this.majorTicksDomainDivider.boundaries(dr.min(), dr.max());
            DatumVector minor = this.minorTicksDomainDivider.boundaries(dr.min(), dr.max());
            TickVDescriptor tickV1 = TickVDescriptor.newTickVDescriptor(major, minor);
            tickV1.datumFormatter = this.dividerDatumFormatter;
            return tickV1;
        }
        catch (InconvertibleUnitsException ex) {
            return this.tickV;
        }
    }

    private TickVDescriptor updateTickVTime(DatumRange dr) {
        TickVDescriptor ltickV;
        Datum pixel = dr.width().divide((double)this.getDLength());
        FontMetrics fm = this.getFontMetrics(this.getTickLabelFont());
        if (this.isHorizontal()) {
            String item;
            int width;
            String item2;
            int width2;
            ltickV = TickVDescriptor.bestTickVTime(dr.min().subtract(pixel), dr.max().add(pixel), 3, 8, false);
            DatumFormatter tdf = this.resolveFormatter(ltickV);
            Rectangle bounds = this.getMaxBounds(tdf, ltickV);
            int tickSizePixels = (int)((double)bounds.width + this.getEmSize() * 2.0);
            if (this.drawTca && (width2 = fm.stringWidth(item2 = DasAxis.format(99999.99, "(f8.2)")) + (int)(this.getEmSize() * 2.0)) > tickSizePixels) {
                tickSizePixels = width2;
            }
            int axisSize = this.getColumn().getWidth();
            int nTicksMax = Math.max(2, axisSize / tickSizePixels);
            ltickV = TickVDescriptor.bestTickVTime(dr.min(), dr.max(), 2, nTicksMax, false);
            tdf = this.resolveFormatter(ltickV);
            bounds = this.getMaxBounds(tdf, ltickV);
            tickSizePixels = (int)(bounds.getWidth() + this.getEmSize() * 2.0);
            if (this.drawTca && (width = fm.stringWidth(item = DasAxis.format(99999.99, "(f8.2)"))) > tickSizePixels) {
                tickSizePixels = width;
            }
            nTicksMax = nTicksMax > 1 ? nTicksMax : 2;
            nTicksMax = nTicksMax < 10 ? nTicksMax : 10;
            boolean overlap = true;
            while (overlap && nTicksMax > 2) {
                ltickV = TickVDescriptor.bestTickVTime(dr.min(), dr.max(), 2, nTicksMax, false);
                if (ltickV.getMajorTicks().getLength() <= 1) {
                    logger.log(Level.INFO, "about to assert error: {0}", ltickV.getMajorTicks());
                }
                assert (ltickV.getMajorTicks().getLength() > 1);
                tdf = this.resolveFormatter(ltickV);
                bounds = this.getMaxBounds(tdf, ltickV);
                tickSizePixels = (int)(bounds.getWidth() + this.getEmSize() * 2.0);
                double x0 = this.transform(ltickV.getMajorTicks().get(0));
                double x1 = this.transform(ltickV.getMajorTicks().get(1));
                if (x1 - x0 > (double)tickSizePixels) {
                    overlap = false;
                    continue;
                }
                --nTicksMax;
            }
            ltickV = TickVDescriptor.bestTickVTime(dr.min(), dr.max(), 2, nTicksMax, true);
        } else {
            int tickSizePixels = fm.getHeight();
            int axisSize = this.getRow().getHeight();
            int nTicksMax = axisSize / tickSizePixels;
            nTicksMax = nTicksMax > 1 ? nTicksMax : 2;
            nTicksMax = nTicksMax < 10 ? nTicksMax : 10;
            ltickV = TickVDescriptor.bestTickVTime(dr.min(), dr.max(), 3, nTicksMax, true);
        }
        this.datumFormatter = this.resolveFormatter(ltickV);
        return ltickV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTCAImmediately() {
        logger.fine("enter updateTCAImmediately...");
        DasAxis dasAxis = this;
        synchronized (dasAxis) {
            logger.fine("...got lock.");
            DasProgressWheel tcaProgress = new DasProgressWheel();
            tcaProgress.started();
            Runnable run = () -> tcaProgress.getPanel(this);
            SwingUtilities.invokeLater(run);
            try {
                this.loadTCADataSet();
            }
            finally {
                tcaProgress.finished();
                this.repaint();
            }
        }
    }

    private void loadTCASoon() {
        final DasCanvas lcanvas = this.getCanvas();
        logger.log(Level.FINE, "updateTCASoon {0}", lcanvas);
        if (lcanvas != null) {
            this.tcaIsLoading = true;
            lcanvas.registerPendingChange(this, this.tcaLock);
            RequestProcessor.invokeLater(new Runnable(){

                @Override
                public void run() {
                    lcanvas.performingChange(DasAxis.this, DasAxis.this.tcaLock);
                    try {
                        DasAxis.this.loadTCAImmediately();
                    }
                    finally {
                        lcanvas.changePerformed(DasAxis.this, DasAxis.this.tcaLock);
                        DasAxis.this.tcaIsLoading = false;
                    }
                }
            }, this);
        }
    }

    protected void resetTickV(TickVDescriptor ticks) {
        TickVDescriptor oldTicks = this.tickV;
        boolean doUpdateTicks = true;
        if (oldTicks != null && ticks != null && oldTicks.minorTickV.getLength() == ticks.minorTickV.getLength()) {
            for (int i = 0; i < ticks.minorTickV.getLength(); ++i) {
                if (oldTicks.minorTickV.get(i).equals(ticks.minorTickV.get(i))) continue;
                doUpdateTicks = true;
            }
        } else {
            doUpdateTicks = true;
        }
        if (doUpdateTicks) {
            DasCanvas lcanvas;
            this.tickV = ticks;
            this.datumFormatter = this.resolveFormatter(this.tickV);
            if (this.drawTca && this.tcaFunction != null && (lcanvas = this.getCanvas()) != null) {
                this.tcaIsLoading = true;
                lcanvas.registerPendingChange(this, this.tcaLock);
                lcanvas.performingChange(this, this.tcaLock);
                this.tcaTimer.tickle("resetTickV", evt -> {
                    lcanvas.changePerformed(this, this.tcaLock);
                    this.tcaIsLoading = false;
                });
            }
            this.firePropertyChange(PROPERTY_TICKS, oldTicks, this.tickV);
            this.repaint();
        }
    }

    private boolean getAutoTickV() {
        return this.autoTickV;
    }

    private int updateTickVManualTicksMinor(double dt) {
        int scale;
        if ((double)((int)(dt /= Math.pow(10.0, scale = (int)Math.log10(dt)))) != dt) {
            dt *= 10.0;
        }
        int idt = (int)dt;
        switch (idt) {
            case 1: {
                return 4;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 3;
            }
        }
        int[] factors = Factorize.factor(idt, new int[0]);
        int result = 1;
        for (int i = 0; i < factors.length; ++i) {
            if (result > 3) {
                return result;
            }
            result *= factors[i];
        }
        return 1;
    }

    protected void updateTickVManualTicks(String lticks) {
        TickVDescriptor ticks = GraphUtil.calculateManualTicks(lticks, this.getDatumRange(), this.isLog());
        TickMaster.getInstance().offerTickV(this, ticks);
        this.tickV = ticks;
    }

    protected void updateTickV() {
        boolean lautoTickV = this.autoTickV;
        String lticks = this.tickValues;
        DatumRange dr = this.getDatumRange();
        if (!dr.min().isFinite() || !dr.max().isFinite()) {
            logger.info("range is not finite...");
            return;
        }
        if (!this.valueIsAdjusting()) {
            if (this.getFont() == null) {
                return;
            }
            if (lticks.trim().length() > 0) {
                this.updateTickVManualTicks(lticks);
                if (this.tickV != null) {
                    return;
                }
            }
            if (this.useDomainDivider) {
                if (this.lockDomainDivider) {
                    logger.finer("domain divider is locked.");
                } else {
                    this.updateDomainDivider();
                }
            } else {
                this.majorTicksDomainDivider = null;
            }
            if (lautoTickV) {
                if (this.getDatumRange().width().value() == 0.0) {
                    throw new IllegalArgumentException("datum range width is zero");
                }
                if (this.majorTicksDomainDivider != null) {
                    TickVDescriptor newTicks = this.updateTickVDomainDivider(dr);
                    TickMaster.getInstance().offerTickV(this, newTicks);
                } else {
                    String fs = this.formatString.trim();
                    TickVDescriptor newTicks = fs.length() > 0 ? (TimeParser.isSpec((String)fs) ? this.updateTickVTime(dr) : (fs.toLowerCase().equals("%e") ? this.updateTickVLog(dr) : this.updateTickVLinear(dr))) : (this.getUnits() instanceof TimeLocationUnits ? this.updateTickVTime(dr) : (this.dataRange.isLog() ? this.updateTickVLog(dr) : this.updateTickVLinear(dr)));
                    if (this.tickV == null) {
                        this.resetTickV(newTicks);
                    }
                    TickMaster.getInstance().offerTickV(this, newTicks);
                }
            }
        } else {
            if (lticks.trim().length() > 0) {
                this.updateTickVManualTicks(lticks);
                if (this.tickV != null) {
                    return;
                }
            }
            if (lautoTickV) {
                try {
                    if (this.majorTicksDomainDivider != null) {
                        TickVDescriptor newTicks = this.updateTickVDomainDivider(dr);
                        TickMaster.getInstance().offerTickV(this, newTicks);
                    } else {
                        TickVDescriptor newTicks = this.getUnits() instanceof TimeLocationUnits ? this.updateTickVTime(dr) : (this.dataRange.isLog() ? this.updateTickVLog(dr) : this.updateTickVLinear(dr));
                        if (this.tickV == null) {
                            this.tickV = newTicks;
                        }
                        TickMaster.getInstance().offerTickV(this, newTicks);
                    }
                }
                catch (NullPointerException ex) {
                    logger.log(Level.WARNING, ex.toString(), ex);
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        boolean drawBounds;
        TickVDescriptor tickV1;
        logger.finest("enter DasAxis.paintComponent");
        DasCanvas canvas = this.getCanvas();
        if (canvas.isValueAdjusting()) {
            return;
        }
        if (canvas.getHeight() != this.parentHeight && this.parentHeight < 100) {
            return;
        }
        if (canvas.getWidth() != this.parentWidth && this.parentWidth < 100) {
            return;
        }
        try {
            this.updateTickLength();
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (this.lineThickness.length() > 0 && !this.lineThickness.equals("1px")) {
            logger.finer("disabling clip for thicker axis");
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        logger.log(Level.FINEST, "DasAxis clip={0} @ {1},{2}", new Object[]{graphics.getClip(), this.getX(), this.getY()});
        Graphics2D g = (Graphics2D)graphics.create();
        g.translate(-this.getX(), -this.getY());
        g.setColor(this.getForeground());
        double px = 1.0;
        if (this.lineThickness.length() > 0 && !this.lineThickness.equals("1px")) {
            px = DasDevicePosition.parseLayoutStr(this.lineThickness, this.getEmSize(), this.getCanvas().getWidth(), 1.0);
            g.setStroke(new BasicStroke((float)px, 1, 1));
        }
        int ipx = (int)Math.ceil(px / 2.0);
        if (DEBUG_GRAPHICS) {
            Stroke stroke0 = g.getStroke();
            g.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{3.0f, 3.0f}, 0.0f));
            g.setColor(Color.BLUE);
            if (this.blLabelRect != null) {
                g.draw(this.blLabelRect);
            }
            g.setColor(Color.RED);
            if (this.blLineRect != null) {
                g.draw(this.blLineRect);
            }
            g.setColor(Color.GREEN);
            if (this.blTickRect != null) {
                g.draw(this.blTickRect);
            }
            g.setColor(Color.LIGHT_GRAY);
            if (this.blTitleRect != null) {
                g.draw(this.blTitleRect);
            }
            g.setColor(Color.BLUE);
            if (this.trLabelRect != null) {
                g.draw(this.trLabelRect);
            }
            g.setColor(Color.RED);
            if (this.trLineRect != null) {
                g.draw(this.trLineRect);
            }
            g.setColor(Color.GREEN);
            if (this.trTickRect != null) {
                g.draw(this.trTickRect);
            }
            g.setColor(Color.LIGHT_GRAY);
            if (this.trTitleRect != null) {
                g.draw(this.trTitleRect);
            }
            g.setStroke(stroke0);
            Rectangle r = this.getBounds();
            if (r != null) {
                g.setColor(ColorUtil.CHOCOLATE);
                --r.width;
                --r.height;
                g.draw(r);
            }
            g.setColor(DEBUG_COLORS[this.debugColorIndex++ % 2]);
        }
        if ((tickV1 = this.tickV) == null || tickV1.tickV.getUnits().isConvertibleTo(this.getUnits())) {
            if (this.isHorizontal()) {
                this.paintHorizontalAxis(g);
            } else {
                this.paintVerticalAxis(g);
            }
        } else if (this.getCanvas().isPrintingThread()) {
            this.updateImmediately();
            g.setClip(null);
            logger.info("calculated ticks on printing thread, this may cause problems");
            if (this.isHorizontal()) {
                this.paintHorizontalAxis(g);
            } else {
                this.paintVerticalAxis(g);
            }
        }
        Rectangle clip = g.getClipBounds();
        clip = clip == null ? new Rectangle(this.getX() - ipx, this.getY() - ipx, this.getWidth() + 2 * ipx, this.getHeight() + 2 * ipx) : new Rectangle(clip.x - ipx, clip.y - ipx, clip.width + 2 * ipx, clip.height + 2 * ipx);
        if (this.drawTca && this.getOrientation() == 2 && this.tcaData != null && this.blLabelRect != null && this.blLabelRect.intersects(clip)) {
            this.drawTCALabels(g);
        }
        if (drawBounds = false) {
            Rectangle b = this.getAxisBounds();
            g.setColor(Color.GREEN);
            g.draw(new Rectangle(b.x, b.y, b.width - 1, b.height - 1));
            g.setFont(Font.decode("sans-10"));
            g.drawString(String.format("%dx%d", b.width, b.height), b.x + 2, b.y + b.height - 3);
        }
        g.dispose();
        this.getDasMouseInputAdapter().paint(graphics);
    }

    private void drawTCALabels(Graphics2D g) {
        int position = this.getRow().getDMaximum();
        int DMin = this.getColumn().getDMinimum();
        Font tickLabelFont = this.getTickLabelFont();
        FontMetrics tickLabelFontMetrics = this.getFontMetrics(tickLabelFont);
        int tickLength = this.tickLen;
        int tick_label_gap = this.tickLen / 2;
        if (tick_label_gap < 4) {
            tick_label_gap = 4;
        }
        int lineHeight = tickLabelFont.getSize() + this.getLineSpacing();
        int baseLine = position + Math.max(0, tickLength) + tick_label_gap + tickLabelFont.getSize();
        int tick_label_gap_2023 = this.getFontMetrics(tickLabelFont).stringWidth(" ");
        int rightEdge = DMin - tickLabelFontMetrics.stringWidth("0000") - tick_label_gap_2023;
        GrannyTextRenderer idlt = GraphUtil.newGrannyTextRenderer();
        QDataSet ltcaData = this.tcaData;
        String[] ltcaLabels = this.tcaLabels.split(";");
        if (ltcaLabels.length == 1 && ltcaLabels[0].trim().equals("")) {
            ltcaLabels = null;
        }
        if (ltcaData == null) {
            idlt.setString((Graphics)g, "tcaData not available");
            idlt.draw((Graphics)g, (float)((double)rightEdge - idlt.getWidth()), (float)(baseLine += lineHeight));
        } else {
            int leftEdge;
            int width;
            int lines;
            QDataSet bds;
            String xlabel = "";
            if (ltcaLabels != null && ltcaLabels.length == ltcaData.length(0) + 1) {
                xlabel = ltcaLabels[0];
                ltcaLabels = Arrays.copyOfRange(ltcaLabels, 1, ltcaLabels.length);
            }
            if ((bds = (QDataSet)ltcaData.property("BUNDLE_1")) == null) {
                logger.fine("expected TCA data to have BUNDLE dataset");
                if (ltcaLabels == null) {
                    return;
                }
                lines = ltcaLabels.length;
            } else {
                lines = ltcaLabels != null ? Math.min(32, ltcaLabels.length) : Math.min(32, bds.length());
            }
            Units u = this.getUnits();
            if (UnitsUtil.isRatioMeasurement((Units)u)) {
                String ss = this.getLabel();
                if (xlabel.length() > 0) {
                    ss = xlabel;
                }
                if ((ss = ss.replace("%{RANGE}", "").trim()).trim().length() == 0) {
                    QDataSet dep0 = (QDataSet)ltcaData.property("DEPEND_0");
                    String ll = (String)dep0.property("LABEL");
                    if (ll == null) {
                        ll = (String)dep0.property("NAME");
                    }
                    if (ll == null) {
                        ll = "";
                    }
                    ss = ll;
                }
                idlt.setString((Graphics)g, ss);
                width = (int)Math.floor(idlt.getWidth() + 0.5);
                leftEdge = rightEdge - width;
                idlt.draw((Graphics)g, (float)leftEdge, (float)baseLine);
            }
            for (int i = 0; i < lines; ++i) {
                String ss;
                baseLine += lineHeight;
                if (bds == null) {
                    ss = ltcaLabels == null ? "???" : (i < ltcaLabels.length ? ltcaLabels[i] : "???");
                } else {
                    if (ltcaLabels == null) {
                        ss = (String)bds.property("LABEL", i);
                        if (ss == null) {
                            ss = (String)bds.property("NAME", i);
                        }
                    } else {
                        String string = ss = i < ltcaLabels.length ? ltcaLabels[i] : "???";
                    }
                    if (ss == null) {
                        logger.info("TCA data has no labels");
                        ss = "   ";
                    }
                    if (ss.contains("%{")) {
                        u = (Units)bds.property("UNITS", i);
                        if (u == null) {
                            u = Units.dimensionless;
                        }
                        ss = this.resolveString(ss, "UNITS", u.toString());
                    }
                }
                idlt.setString((Graphics)g, ss);
                width = (int)Math.floor(idlt.getWidth() + 0.5);
                leftEdge = rightEdge - width;
                idlt.draw((Graphics)g, (float)leftEdge, (float)baseLine);
            }
        }
    }

    private String resolveString(String text, String name, String value) {
        if (text.contains("%{")) {
            text = text.replaceAll("%\\{" + name + "\\}", value);
        } else if (text.contains("$(")) {
            text = text.replaceAll("\\$\\(" + name + "\\)", value);
        }
        return text;
    }

    protected String resolveAxisLabel() {
        String sunits = this.getDatumRange().getUnits().toString();
        if ((sunits.contains("!A") || sunits.contains("!E") || sunits.contains("!B") || sunits.contains("!D")) && !sunits.contains("!N")) {
            sunits = sunits + "!N";
        }
        String result = this.resolveString(this.axisLabel, "UNITS", sunits);
        DatumRange dr = this.getDatumRange();
        String sdr = UnitsUtil.isTimeLocation((Units)dr.getUnits()) ? DatumRangeUtil.formatTimeRange((DatumRange)dr, (boolean)true) : dr.toString();
        if (dr instanceof OrbitDatumRange) {
            String abbrevName = ((OrbitDatumRange)dr).toString();
            String[] ss = abbrevName.split(":");
            if (abbrevName.split(":").length > 3) {
                abbrevName = ss[0] + ":" + ss[ss.length - 1];
            }
            result = this.resolveString(result, "RANGE_NOORBIT", sdr);
            sdr = sdr + " (" + abbrevName + ")";
        } else {
            result = this.resolveString(result, "RANGE_NOORBIT", sdr);
        }
        result = this.resolveString(result, "RANGE", sdr);
        result = this.resolveString(result, "SCAN_RANGE", String.valueOf(this.getScanRange()));
        return result;
    }

    protected void paintHorizontalAxis(Graphics2D g) {
        try {
            int tickLength;
            int tickPosition;
            float ftickPosition;
            int i;
            DasPlot otherPlot;
            boolean loppositeAxisVisible;
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
            if ((loppositeAxisVisible = this.oppositeAxisVisible) && (otherPlot = this.getCanvas().otherPlotOnTop(this)) != null && otherPlot.getXAxis().getOrientation() != this.getOrientation() && otherPlot.getXAxis().isVisible()) {
                loppositeAxisVisible = false;
            }
            boolean bottomLine = (this.orientation == 2 || loppositeAxisVisible) && this.blLineRect != null && this.blLineRect.intersects(clip);
            boolean bottomTicks = (this.orientation == 2 || loppositeAxisVisible) && this.blTickRect != null && this.blTickRect.intersects(clip);
            boolean bottomTickLabels = this.orientation == 2 && this.tickLabelsVisible && this.blLabelRect != null && this.blLabelRect.intersects(clip);
            boolean bottomLabel = this.orientation == 2 && !this.axisLabel.equals("");
            boolean topLine = (this.orientation == 1 || loppositeAxisVisible) && this.trLineRect != null && this.trLineRect.intersects(clip);
            boolean topTicks = (this.orientation == 1 || loppositeAxisVisible) && this.trTickRect != null && this.trTickRect.intersects(clip);
            boolean topTickLabels = this.orientation == 1 && this.tickLabelsVisible && this.trLabelRect != null && this.trLabelRect.intersects(clip);
            boolean topLabel = this.orientation == 1 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(clip);
            int axisOffsetPx = this.getAxisOffsetPixels();
            int topPosition = this.getRow().getDMinimum();
            int bottomPosition = this.getRow().getDMaximum() + axisOffsetPx;
            int DMax = this.getColumn().getDMaximum();
            int DMin = this.getColumn().getDMinimum();
            TickVDescriptor ticks = this.getTickV();
            if (this.getCanvas().isPrintingThread()) {
                if (ticks != null) {
                    DatumVector majorTicks = ticks.getMajorTicks();
                    if (majorTicks.getLength() > 0) {
                        DatumRange x = DatumRangeUtil.union((Datum)majorTicks.get(0), (Datum)majorTicks.get(majorTicks.getLength() - 1));
                        int recalcTicks = 0;
                        DatumRange thisDatumRange = this.getDatumRange();
                        if (x.intersects(thisDatumRange)) {
                            if (x.intersection(thisDatumRange).width().divide(thisDatumRange.width()).value() < 0.3) {
                                recalcTicks = 1;
                            }
                        } else {
                            recalcTicks = 1;
                        }
                        if (recalcTicks != 0) {
                            logger.fine("last ditch effort to get useful ticks that we didn't get before because of thread order");
                            TickVDescriptor ticks2 = TickMaster.getInstance().requestTickV(this);
                            if (ticks2 != null) {
                                ticks = ticks2;
                            }
                            if ((x = DatumRangeUtil.union((Datum)(majorTicks = ticks.getMajorTicks()).get(0), (Datum)majorTicks.get(majorTicks.getLength() - 1))).intersects(thisDatumRange)) {
                                if (x.intersection(thisDatumRange).width().divide(thisDatumRange.width()).value() < 0.3) {
                                    recalcTicks = 1;
                                }
                            } else {
                                recalcTicks = 1;
                            }
                            if (recalcTicks != 0) {
                                System.err.println("still doesn't fit, see https://sourceforge.net/p/autoplot/bugs/1820/");
                                ticks2 = TickMaster.getInstance().requestTickV(this);
                            }
                        }
                    }
                } else {
                    throw new IllegalArgumentException("ticks are not calculated");
                }
            }
            if (DMax - DMin < 2) {
                return;
            }
            if (bottomLine) {
                logger.log(Level.FINER, "draw H bottomLine at {0}", bottomPosition);
                g.drawLine(DMin, bottomPosition, DMax, bottomPosition);
            }
            if (topLine) {
                logger.log(Level.FINER, "draw H topLine at {0}", topPosition);
                g.drawLine(DMin, topPosition, DMax, topPosition);
            }
            if (this.reference.length() != 0) {
                DatumRange rr;
                for (String r : rr = this.reference.split(",", -2)) {
                    if ((r = r.trim()).length() <= 0) continue;
                    try {
                        Datum dreference = this.dataRange.getUnits().parse(r);
                        float d = (float)this.transform(dreference);
                        if (!(d > (float)DMin) || !(d < (float)DMax)) continue;
                        g.draw(new Line2D.Float(d, bottomPosition, d, topPosition));
                    }
                    catch (ParseException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
            int tickLengthMajor = this.tickLen;
            int tickLengthMinor = tickLengthMajor / 2;
            if (ticks == null) {
                logger.fine("ticks are not ready");
                return;
            }
            String[] labels = this.tickFormatter(ticks.tickV, this.getDatumRange());
            for (i = 0; i < ticks.tickV.getLength(); ++i) {
                Datum tick1 = ticks.tickV.get(i);
                ftickPosition = (float)this.transform(tick1);
                tickPosition = (int)Math.floor(ftickPosition);
                if (!((float)DMin <= ftickPosition) || !(ftickPosition <= (float)DMax)) continue;
                tickLength = tickLengthMajor;
                if (bottomTicks && tickLength != 0) {
                    logger.log(Level.FINER, "draw H tick at {0}", Float.valueOf(ftickPosition));
                    g.draw(new Line2D.Float(ftickPosition, bottomPosition, ftickPosition, bottomPosition + tickLength));
                }
                if (bottomTickLabels) {
                    this.drawLabel(g, tick1, labels[i], i, tickPosition, bottomPosition + Math.max(0, tickLength));
                }
                if (topTicks && tickLength != 0) {
                    g.draw(new Line2D.Float(ftickPosition, topPosition, ftickPosition, topPosition - tickLength + 1));
                }
                if (!topTickLabels) continue;
                this.drawLabel(g, tick1, labels[i], i, tickPosition, topPosition - Math.max(0, tickLength) + 1);
            }
            for (i = 0; i < ticks.minorTickV.getLength(); ++i) {
                Datum tick = ticks.minorTickV.get(i);
                ftickPosition = (float)this.transform(tick);
                tickPosition = (int)Math.floor(ftickPosition);
                if (DMin > tickPosition || tickPosition > DMax) continue;
                tickLength = tickLengthMinor;
                if (bottomTicks && tickLength != 0) {
                    g.draw(new Line2D.Float(ftickPosition, bottomPosition, ftickPosition, bottomPosition + tickLength));
                }
                if (!topTicks || tickLength == 0) continue;
                g.draw(new Line2D.Float(ftickPosition, topPosition, ftickPosition, topPosition - tickLength));
            }
            boolean debugBoundsBox = false;
            if (debugBoundsBox) {
                Color c0 = g.getColor();
                g.setColor(Color.MAGENTA);
                g.drawRoundRect(clip.x, clip.y, clip.width - 1, clip.height - 1, 14, 14);
                g.setColor(c0);
            }
            if (!this.axisLabel.equals("") && this.isTickLabelsVisible()) {
                int leftEdge;
                int baseline;
                Graphics2D g2 = (Graphics2D)g.create();
                int titlePositionOffset = this.getTitlePositionOffset();
                GrannyTextRenderer gtr = GraphUtil.newGrannyTextRenderer();
                g2.setFont(this.getLabelFont());
                if (this.dasPlot != null) {
                    gtr.setAlignment(this.dasPlot.getMultiLineTextAlignment());
                } else {
                    gtr.setAlignment(0.5f);
                }
                String axislabel1 = this.resolveAxisLabel();
                gtr.setString((Graphics)g2, axislabel1);
                int titleWidth = (int)gtr.getWidth();
                if (debugBoundsBox) {
                    baseline = bottomPosition + titlePositionOffset;
                    g2.drawString(">>" + axislabel1 + "<<", clip.x, clip.y + g2.getFontMetrics().getHeight());
                    gtr.draw((Graphics)g2, (float)clip.x, (float)clip.y + (float)(g2.getFontMetrics().getHeight() * 2));
                    g2.drawString("" + baseline + " " + bottomPosition + " " + titlePositionOffset + " " + bottomLabel, clip.x, clip.y + 3 * g2.getFontMetrics().getHeight());
                }
                if (bottomLabel) {
                    leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                    baseline = bottomPosition + titlePositionOffset;
                    boolean drawBack = this.isOpaqueBackground();
                    if (drawBack) {
                        Rectangle2D back = gtr.getBounds2D();
                        back = new Rectangle2D.Double((double)leftEdge + back.getX(), (double)baseline + back.getY(), back.getWidth(), back.getHeight());
                        Color c0 = g2.getColor();
                        g2.setColor(Color.WHITE);
                        g2.fill(back);
                        g2.setColor(c0);
                    }
                    gtr.draw((Graphics)g2, (float)leftEdge, (float)baseline);
                }
                if (debugBoundsBox) {
                    leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                    baseline = bottomPosition + titlePositionOffset;
                    g2.drawLine(clip.x, clip.y, leftEdge, baseline);
                }
                if (topLabel) {
                    leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                    baseline = topPosition - titlePositionOffset;
                    gtr.draw((Graphics)g2, (float)leftEdge, (float)baseline);
                }
                g2.dispose();
            }
        }
        catch (InconvertibleUnitsException inconvertibleUnitsException) {
            // empty catch block
        }
    }

    protected int getAxisOffsetPixels() {
        int axisOffsetPx = 0;
        try {
            double[] pos = DasDevicePosition.parseLayoutStr(this.getAxisOffset());
            axisOffsetPx = pos[0] == 0.0 ? (int)Math.round(pos[1] * this.getEmSize() + pos[2]) : (int)Math.round(pos[0] * (double)this.getRow().getHeight() + pos[1] * this.getEmSize() + pos[2]);
        }
        catch (ParseException ex) {
            logger.warning(ex.getMessage());
            return 0;
        }
        return axisOffsetPx;
    }

    protected void paintVerticalAxis(Graphics2D g) {
        try {
            int tickLength;
            int i;
            DasPlot otherPlot;
            boolean loppositeAxisVisible;
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
            if ((loppositeAxisVisible = this.oppositeAxisVisible) && (otherPlot = this.getCanvas().otherPlotOnTop(this)) != null && otherPlot.getYAxis().getOrientation() != this.getOrientation() && otherPlot.getXAxis().isVisible()) {
                loppositeAxisVisible = false;
            }
            boolean leftLine = (this.orientation == 3 || loppositeAxisVisible) && this.blLineRect != null && this.blLineRect.intersects(clip);
            boolean leftTicks = (this.orientation == 3 || loppositeAxisVisible) && this.blTickRect != null && this.blTickRect.intersects(clip);
            boolean leftTickLabels = this.orientation == 3 && this.tickLabelsVisible && this.blLabelRect != null && this.blLabelRect.intersects(clip);
            boolean leftLabel = this.orientation == 3 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(clip);
            boolean rightLine = (this.orientation == 4 || loppositeAxisVisible) && this.trLineRect != null && this.trLineRect.intersects(clip);
            boolean rightTicks = (this.orientation == 4 || loppositeAxisVisible) && this.trTickRect != null && this.trTickRect.intersects(clip);
            boolean rightTickLabels = this.orientation == 4 && this.tickLabelsVisible && this.trLabelRect != null && this.trLabelRect.intersects(clip);
            boolean rightLabel = this.orientation == 4 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(clip);
            int leftPosition = this.getColumn().getDMinimum();
            int rightPosition = this.getColumn().getDMaximum();
            int DMax = this.getRow().getDMaximum();
            int DMin = this.getRow().getDMinimum();
            TickVDescriptor ticks = this.getTickV();
            if (DMax - DMin < 2) {
                return;
            }
            if (ticks == null) {
                logger.fine("ticks are not ready");
                return;
            }
            int axisOffsetPx = this.getAxisOffsetPixels();
            if (leftLine) {
                logger.log(Level.FINER, "draw V leftline at {0}", leftPosition -= axisOffsetPx);
                g.drawLine(leftPosition, DMin, leftPosition, DMax);
            }
            if (rightLine) {
                logger.log(Level.FINER, "draw V rightline at {0}", rightPosition += axisOffsetPx);
                g.drawLine(rightPosition, DMin, rightPosition, DMax);
            }
            if (this.reference.length() != 0) {
                String[] rr;
                for (String r : rr = this.reference.split(",", -2)) {
                    if ((r = r.trim()).length() <= 0) continue;
                    try {
                        Datum dreference = this.dataRange.getUnits().parse(r);
                        float f = (float)this.transform(dreference);
                        if (!(f > (float)DMin) || !(f < (float)DMax)) continue;
                        g.draw(new Line2D.Float(rightPosition, f, leftPosition, f));
                    }
                    catch (ParseException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
            int tickLengthMajor = this.tickLen;
            int tickLengthMinor = tickLengthMajor / 2;
            String[] labels = this.tickFormatter(ticks.tickV, this.getDatumRange());
            for (i = 0; i < ticks.tickV.getLength(); ++i) {
                Datum tick1 = ticks.tickV.get(i);
                float ftickPosition = (float)this.transform(tick1);
                int tickPosition = (int)Math.floor(ftickPosition);
                if (DMin > tickPosition || tickPosition > DMax) continue;
                tickLength = tickLengthMajor;
                if (leftTicks && tickLength != 0) {
                    logger.log(Level.FINER, "draw V tick at {0}", Float.valueOf(ftickPosition));
                    g.draw(new Line2D.Float(leftPosition, ftickPosition, leftPosition - tickLength, ftickPosition));
                }
                if (leftTickLabels) {
                    this.drawLabel(g, tick1, labels[i], i, leftPosition - Math.max(0, tickLength), tickPosition);
                }
                if (rightTicks && tickLength != 0) {
                    g.draw(new Line2D.Float(rightPosition, ftickPosition, rightPosition + tickLength, ftickPosition));
                }
                if (!rightTickLabels) continue;
                this.drawLabel(g, tick1, labels[i], i, rightPosition + Math.max(0, tickLength), tickPosition);
            }
            for (i = 0; i < ticks.minorTickV.getLength(); ++i) {
                double tick1 = ticks.minorTickV.doubleValue(i, this.getUnits());
                float ftickPosition = (float)(this.transform(tick1, ticks.units) + 1.0E-4);
                if (!((float)DMin <= ftickPosition) || !(ftickPosition <= (float)DMax)) continue;
                tickLength = tickLengthMinor;
                if (leftTicks && tickLength != 0) {
                    g.draw(new Line2D.Float(leftPosition, ftickPosition, leftPosition - tickLength, ftickPosition));
                }
                if (!rightTicks || tickLength == 0) continue;
                g.draw(new Line2D.Float(rightPosition, ftickPosition, rightPosition + tickLength, ftickPosition));
            }
            if (!this.axisLabel.equals("") && this.isTickLabelsVisible()) {
                int baseline;
                int leftEdge;
                Graphics2D g2 = (Graphics2D)g.create();
                int titlePositionOffset = this.getTitlePositionOffset();
                GrannyTextRenderer gtr = GraphUtil.newGrannyTextRenderer();
                g2.setFont(this.getLabelFont());
                if (this.dasPlot != null) {
                    gtr.setAlignment(this.dasPlot.getMultiLineTextAlignment());
                } else {
                    gtr.setAlignment(0.5f);
                }
                gtr.setString((Graphics)g2, this.resolveAxisLabel());
                int titleWidth = (int)gtr.getWidth();
                if (leftLabel) {
                    g2.rotate(-1.5707963267948966);
                    leftEdge = -DMax + (DMax - DMin - titleWidth) / 2;
                    baseline = leftPosition - titlePositionOffset;
                    gtr.draw((Graphics)g2, (float)leftEdge, (float)baseline);
                }
                if (rightLabel) {
                    if (this.flipLabel) {
                        g2.rotate(-1.5707963267948966);
                        leftEdge = DMin + (DMax - DMin + titleWidth) / 2;
                        baseline = rightPosition + titlePositionOffset;
                        gtr.draw((Graphics)g2, (float)(-leftEdge), (float)baseline);
                        g2.getClipBounds();
                    } else {
                        g2.rotate(1.5707963267948966);
                        leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                        baseline = -rightPosition - titlePositionOffset;
                        gtr.draw((Graphics)g2, (float)leftEdge, (float)baseline);
                    }
                }
                g2.dispose();
            }
        }
        catch (InconvertibleUnitsException inconvertibleUnitsException) {
            // empty catch block
        }
    }

    public void setLeftXLabelOverride(int leftXOverride) {
        this.leftXOverride = leftXOverride;
    }

    public void setLabelOffset(String spec) {
        this.labelOffset = spec;
        this.update();
    }

    public String getLabelOffset() {
        return this.labelOffset;
    }

    public String getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(String axisOffset) {
        String oldAxisOffset = this.axisOffset;
        this.axisOffset = axisOffset;
        this.update();
        this.firePropertyChange(PROP_AXISOFFSET, oldAxisOffset, axisOffset);
    }

    protected int getTitlePositionOffset() {
        int offset;
        Font tickLabelFont = this.getTickLabelFont();
        FontMetrics fm = this.getFontMetrics(tickLabelFont);
        Font labelFont = this.getLabelFont();
        int zeroOrPosTickLen = Math.max(0, this.tickLen);
        GrannyTextRenderer gtr = GraphUtil.newGrannyTextRenderer();
        if (this.dasPlot != null) {
            gtr.setAlignment(this.dasPlot.getMultiLineTextAlignment());
        }
        gtr.setString(labelFont, this.axisLabel);
        switch (this.orientation) {
            case 2: {
                offset = this.tickV != null && this.tickV.minorTickV.getLength() > 0 ? tickLabelFont.getSize() + zeroOrPosTickLen + fm.stringWidth(" ") + labelFont.getSize() + labelFont.getSize() / 2 : labelFont.getSize() + labelFont.getSize() / 2;
                if (this.drawTca && this.tcaData != null) {
                    offset += Math.min(32, this.tcaData.length(0)) * (tickLabelFont.getSize() + this.getLineSpacing());
                } else if (this.formatString.length() > 0) {
                    offset += this.blLabelRect.height - 2 * (tickLabelFont.getSize() + this.getLineSpacing());
                }
                if (this.labelOffset.length() <= 0 || this.axisLabel.length() <= 0) break;
                offset = tickLabelFont.getSize() + (int)DasDevicePosition.parseLayoutStr(this.labelOffset, this.getEmSize(), this.getRow().getHeight(), 0.0);
                break;
            }
            case 1: {
                offset = zeroOrPosTickLen + fm.stringWidth(" ") + labelFont.getSize() + labelFont.getSize() / 2 + (int)gtr.getDescent();
                break;
            }
            case 3: {
                if (this.tickV != null && this.tickV.minorTickV.getLength() > 0) {
                    offset = this.getColumn().getDMinimum() - this.blLabelRect.x + labelFont.getSize() / 2 + (int)gtr.getDescent() - this.getAxisOffsetPixels();
                    break;
                }
                offset = this.getColumn().getDMinimum() - this.blLabelRect.x - this.getAxisOffsetPixels();
                break;
            }
            default: {
                offset = this.trLabelRect == null ? 20 : this.trLabelRect.x + this.trLabelRect.width - this.getColumn().getDMaximum() + labelFont.getSize() / 2 + (int)(this.flipLabel ? gtr.getAscent() : gtr.getDescent());
            }
        }
        return offset;
    }

    public int getLineSpacing() {
        return this.getTickLabelFont().getSize() / 4;
    }

    protected void drawLabel(Graphics2D g, Datum value, String label, int index, int x, int y) {
        if (!this.tickLabelsVisible) {
            return;
        }
        g.setFont(this.getTickLabelFont());
        GrannyTextRenderer idlt = GraphUtil.newGrannyTextRenderer();
        idlt.setString((Graphics)g, label);
        int width = (int)(this.isHorizontal() ? idlt.getLineOneWidth() : idlt.getWidth());
        int height = (int)idlt.getHeight();
        int ascent = (int)idlt.getAscent();
        int tick_label_gap = this.tickLen / 2;
        if (tick_label_gap < 4) {
            tick_label_gap = 4;
        }
        switch (this.orientation) {
            case 2: {
                x -= width / 2;
                y += this.getTickLabelFont().getSize() + tick_label_gap;
                break;
            }
            case 1: {
                x -= width / 2;
                y = (int)((double)y - ((double)tick_label_gap + idlt.getDescent()));
                break;
            }
            case 3: {
                x -= width + tick_label_gap;
                y += ascent - height / 2;
                break;
            }
            default: {
                x += tick_label_gap;
                y += ascent - height / 2;
            }
        }
        boolean drawBack = this.isOpaqueBackground();
        if (drawBack) {
            Color c = g.getColor();
            g.setColor(g.getBackground());
            Rectangle r = idlt.getBounds();
            r.translate(x, y);
            g.fillRoundRect(r.x, r.y, r.width, r.height, 3, 3);
            g.setColor(c);
        }
        idlt.draw((Graphics)g, (float)x, (float)y);
        if (this.orientation == 2 && this.drawTca && this.tcaData != null) {
            this.drawTCAItems(g, value, x, y, width);
        }
    }

    private void drawTCAItems(Graphics g, Datum value, int x, int y, int width) {
        double limit;
        QDataSet ltcaData = this.tcaData;
        if (ltcaData == null || ltcaData.length() == 0) {
            return;
        }
        QDataSet dep0 = (QDataSet)ltcaData.property("DEPEND_0");
        int baseLine = y;
        int leftEdge = x;
        int rightEdge = leftEdge + width;
        if (!SemanticOps.getUnits((QDataSet)dep0).isConvertibleTo(value.getUnits())) {
            return;
        }
        int index = DataSetUtil.closestIndex((QDataSet)dep0, (Datum)value);
        if (index < 0 || index >= ltcaData.length()) {
            return;
        }
        double pixelSize = this.getDatumRange().width().divide((double)this.getDLength()).doubleValue(this.getUnits().getOffsetUnits());
        if (ltcaData.length() == 0) {
            g.drawString("tca data is empty", leftEdge, baseLine);
            return;
        }
        double tcaValue = dep0.value(index);
        RankZeroDataSet xTagWidth = DataSetUtil.guessCadenceNew((QDataSet)dep0, null);
        try {
            UnitsConverter uc = UnitsConverter.getConverter((Units)SemanticOps.getUnits((QDataSet)dep0).getOffsetUnits(), (Units)this.getUnits().getOffsetUnits());
            limit = Math.max(uc.convert(xTagWidth.value()), pixelSize);
        }
        catch (InconvertibleUnitsException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        if (Math.abs(tcaValue - value.doubleValue(this.getUnits())) > limit) {
            return;
        }
        Font tickLabelFont = this.getTickLabelFont();
        FontMetrics fm = this.getFontMetrics(tickLabelFont);
        int lineHeight = tickLabelFont.getSize() + this.getLineSpacing();
        int lines = Math.min(32, ltcaData.length(0));
        for (int i = 0; i < lines; ++i) {
            try {
                String item;
                baseLine += lineHeight;
                QDataSet test1 = ltcaData.slice(index);
                ArrayDataSet v1 = ArrayDataSet.copy((QDataSet)test1.slice(i));
                try {
                    item = DataSetUtil.getStringValue((QDataSet)v1, (double)v1.value());
                }
                catch (IllegalArgumentException ex) {
                    item = String.valueOf(v1.value());
                }
                width = fm.stringWidth(item);
                leftEdge = rightEdge - width;
                g.drawString(item, leftEdge, baseLine);
                continue;
            }
            catch (RuntimeException ex) {
                if (i == 0) {
                    ex.printStackTrace();
                }
                g.drawString("exception", leftEdge, baseLine);
            }
        }
    }

    public Font getTickLabelFont() {
        Font f = this.getFont();
        if (f == null) {
            f = Font.decode("sans-12");
        }
        return f;
    }

    public Font getLabelFont() {
        Font f = this.getFont();
        if (f == null) {
            logger.warning("2285: font was null, using sans-12");
            f = Font.decode("sans-12");
        }
        if (this.fontSize.length() > 0 && !this.fontSize.equals("1em")) {
            try {
                double[] dd = DasDevicePosition.parseLayoutStr(this.getFontSize());
                if (dd[1] != 1.0 || dd[2] != 0.0) {
                    double parentSize = f.getSize2D();
                    double newSize = dd[1] * parentSize + dd[2];
                    f = f.deriveFont((float)newSize);
                    return f;
                }
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return f;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        String oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.firePropertyChange(PROP_FONTSIZE, oldFontSize, fontSize);
    }

    public Memento getMemento() {
        Memento result = new Memento();
        result.range = this.getDatumRange();
        if (this.isHorizontal()) {
            if (this.getColumn() != DasColumn.NULL) {
                result.dmin = this.getColumn().getDMinimum();
                result.dmax = this.getColumn().getDMaximum();
            } else {
                result.dmin = 0;
                result.dmax = 0;
            }
        } else if (this.getRow() != DasRow.NULL) {
            result.dmin = this.getRow().getDMinimum();
            result.dmax = this.getRow().getDMaximum();
        } else {
            result.dmin = 0;
            result.dmax = 0;
        }
        result.log = this.isLog();
        result.flipped = this.flipped;
        result.horizontal = this.isHorizontal();
        return result;
    }

    public AffineTransform getAffineTransform(Memento memento, AffineTransform at) {
        double dmin1;
        if (at == null) {
            return null;
        }
        if (memento.log != this.isLog()) {
            return null;
        }
        if (memento.flipped != this.flipped) {
            return null;
        }
        if (!memento.range.getUnits().isConvertibleTo(this.getUnits())) {
            return null;
        }
        double dmin0 = this.transform(memento.range.min());
        double dmax0 = this.transform(memento.range.max());
        double scale2 = (0.0 + (double)this.getMemento().dmin - (double)this.getMemento().dmax) / (double)(memento.dmin - memento.dmax);
        double trans2 = (double)(-1 * memento.dmin) * scale2 + (double)this.getMemento().dmin;
        if (dmin0 == 10000.0 || dmin0 == -10000.0 | dmax0 == 10000.0 | dmax0 == 10000.0) {
            logger.fine("unable to create transform in getAffineTransform");
        }
        if (!(this.isHorizontal() ^ this.flipped)) {
            double tmp = dmin0;
            dmin0 = dmax0;
            dmax0 = tmp;
        }
        if (!this.isHorizontal()) {
            dmin1 = this.getRow().getDMinimum();
            double dmax1 = this.getRow().getDMaximum();
            double scaley = (dmin0 - dmax0) / (dmin1 - dmax1);
            double transy = -1.0 * dmin1 * scaley + dmin0;
            at.translate(0.0, transy);
            at.scale(1.0, scaley);
            at.translate(0.0, trans2);
            at.scale(1.0, scale2);
        } else {
            dmin1 = this.getColumn().getDMinimum();
            double dmax1 = this.getColumn().getDMaximum();
            double scalex = (dmin0 - dmax0) / (dmin1 - dmax1);
            double transx = -1.0 * dmin1 * scalex + dmin0;
            at.translate(transx, 0.0);
            at.scale(scalex, 1.0);
            at.translate(trans2, 0.0);
            at.scale(scale2, 1.0);
        }
        if (at.getDeterminant() == 0.0) {
            return null;
        }
        return at;
    }

    public Object clone() {
        try {
            DasAxis result = (DasAxis)super.clone();
            result.dataRange = (DataRange)result.dataRange.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Assertion failure");
        }
    }

    private void setTickDirection(int direction) {
        switch (direction) {
            case 4: 
            case 995: {
                this.tickDirection = -1;
                break;
            }
            case 3: 
            case 996: {
                this.tickDirection = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tick direction");
            }
        }
    }

    private int getMaxLabelWidth() {
        try {
            Font f = this.getTickLabelFont();
            TickVDescriptor ticks = this.getTickV();
            if (ticks == null) {
                return 10;
            }
            DatumVector tickv = ticks.tickV;
            int size = Integer.MIN_VALUE;
            for (int i = 0; i < tickv.getLength(); ++i) {
                String label = this.tickFormatter(tickv.get(i));
                GrannyTextRenderer idlt = GraphUtil.newGrannyTextRenderer();
                idlt.setString(f, label);
                int labelSize = (int)Math.round(idlt.getWidth());
                if (labelSize <= size) continue;
                size = labelSize;
            }
            logger.log(Level.FINE, "Max label width: {0}", size);
            return size;
        }
        catch (InconvertibleUnitsException ex) {
            return 10;
        }
    }

    protected int getMaxLabelWidth(FontMetrics fm) {
        try {
            TickVDescriptor ticks = this.getTickV();
            DatumVector tickv = ticks.tickV;
            int size = Integer.MIN_VALUE;
            Graphics g = this.getGraphics();
            for (int i = 0; i < tickv.getLength(); ++i) {
                String label = this.tickFormatter(tickv.get(i));
                GrannyTextRenderer idlt = GraphUtil.newGrannyTextRenderer();
                idlt.setString(g, label);
                int labelSize = (int)Math.round(idlt.getWidth());
                if (labelSize <= size) continue;
                size = labelSize;
            }
            return size;
        }
        catch (InconvertibleUnitsException ex) {
            return 10;
        }
    }

    @Override
    public void resize() {
        this.resetTransform();
        if (this.getFont() == null) {
            return;
        }
        this.parentHeight = this.getParent().getHeight();
        this.parentWidth = this.getParent().getWidth();
        Rectangle oldBounds = this.getBounds();
        Rectangle newBounds = this.getAxisBounds();
        this.setBounds(newBounds);
        this.invalidate();
        TickVDescriptor ltickV = this.tickV;
        if (ltickV == null || ltickV.tickV.getUnits().isConvertibleTo(this.getUnits())) {
            this.validate();
        }
        this.firePropertyChange(PROP_BOUNDS, oldBounds, newBounds);
    }

    protected Rectangle getLabelBounds(Rectangle bounds) {
        double dmax;
        double dmin;
        TickVDescriptor ltickV = this.getTickV();
        DatumRange dr = this.getDatumRange();
        if (ltickV == null || !ltickV.tickV.getUnits().isConvertibleTo(this.getUnits())) {
            logger.fine("tickV cannot be used because of units.");
            return bounds;
        }
        String[] labels = this.tickFormatter(ltickV.tickV, dr);
        GrannyTextRenderer gtr = GraphUtil.newGrannyTextRenderer();
        Font labelFont = this.getLabelFont();
        Font font = this.getFont();
        if (this.isHorizontal()) {
            dmin = this.getColumn().getDMinimum();
            dmax = this.getColumn().getDMaximum();
        } else {
            dmin = this.getRow().getDMinimum();
            dmax = this.getRow().getDMaximum();
        }
        if (font == null) {
            return bounds;
        }
        FontMetrics fm = this.getFontMetrics(font);
        int fontDecent = fm.getMaxDescent();
        if (fontDecent < 0) {
            fontDecent = 5 - fontDecent;
            logger.finest("negative font descent");
        }
        int axisOffsetPx = this.getAxisOffsetPixels();
        DatumVector ticks = ltickV.tickV;
        for (int i = 0; i < labels.length; ++i) {
            Datum d = ticks.get(i);
            if (!DatumRangeUtil.sloppyContains((DatumRange)dr, (Datum)d)) continue;
            gtr.setString(font, labels[i]);
            Rectangle rmin = gtr.getBounds();
            Rectangle rmax = new Rectangle(rmin);
            double flw = gtr.getLineOneWidth();
            int tick_label_gap = this.tickLen / 2;
            if (tick_label_gap < 5) {
                tick_label_gap = 4;
            }
            int space = tick_label_gap;
            int zeroOrPosTickLen = Math.max(0, this.tickLen);
            if (this.isHorizontal()) {
                if (this.getOrientation() == 2) {
                    rmin.translate((int)(dmin - flw / 2.0), this.getRow().bottom() + space + zeroOrPosTickLen + labelFont.getSize() + axisOffsetPx);
                    rmax.translate((int)(dmax - flw / 2.0), this.getRow().bottom() + space + zeroOrPosTickLen + labelFont.getSize() + axisOffsetPx);
                } else {
                    rmin.translate((int)(dmin - flw / 2.0), this.getRow().top() - space - zeroOrPosTickLen - (int)(rmin.getHeight() + (double)rmin.y));
                    rmax.translate((int)(dmax - flw / 2.0), this.getRow().top() - space - zeroOrPosTickLen - (int)(rmax.getHeight() + (double)rmax.y));
                }
                if (bounds == null) {
                    bounds = rmin;
                }
                bounds.add(rmin);
                bounds.add(rmax);
                continue;
            }
            double delta = gtr.getAscent() - gtr.getHeight() / 2.0;
            if (this.getOrientation() == 3) {
                rmin.translate(-((int)rmin.getWidth()) - space - zeroOrPosTickLen + this.getColumn().left() - axisOffsetPx, (int)dmin - (int)delta);
                rmax.translate(-((int)rmax.getWidth()) - space - zeroOrPosTickLen + this.getColumn().left() - axisOffsetPx, (int)(dmax + (double)fontDecent + 3.0));
            } else {
                rmin.translate(space + zeroOrPosTickLen + this.getColumn().right() + axisOffsetPx, (int)dmin + (int)delta);
                rmax.translate(space + zeroOrPosTickLen + this.getColumn().right() + axisOffsetPx, (int)(dmax + (double)fontDecent + 3.0));
            }
            if (bounds == null) {
                bounds = rmin;
            }
            bounds.add(rmin);
            bounds.add(rmax);
        }
        return bounds;
    }

    public Rectangle getAxisBounds() {
        try {
            this.updateTickLength();
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        Rectangle bounds = this.isHorizontal() ? this.getHorizontalAxisBounds() : this.getVerticalAxisBounds();
        if (this.getOrientation() == 2 && this.isVisible() && this.isTickLabelsVisible()) {
            QDataSet ltcaData = this.tcaData;
            String[] ltcaLabels = this.tcaLabels.split(";");
            if (this.drawTca && (this.tcaRows >= 0 || ltcaLabels.length > 1 || ltcaData != null && ltcaData.length() != 0)) {
                int DMin = this.getColumn().getDMinimum();
                Font tickLabelFont = this.getTickLabelFont();
                int tick_label_gap_2023 = this.getFontMetrics(tickLabelFont).stringWidth(" ");
                int lines = this.tcaRows >= 0 ? this.tcaRows : this.getTickLines() - 1;
                int tcaHeight = (tickLabelFont.getSize() + this.getLineSpacing()) * lines;
                int maxLabelWidth = this.getMaxLabelWidth();
                bounds.height += tcaHeight;
                this.blLabelRect.height += tcaHeight;
                if (this.blTitleRect != null) {
                    this.blTitleRect.y += tcaHeight;
                }
                GrannyTextRenderer idlt = GraphUtil.newGrannyTextRenderer();
                idlt.setString(tickLabelFont, "SCET");
                int tcaLabelWidth = (int)Math.floor(idlt.getWidth() + 0.5);
                QDataSet bds = null;
                if (ltcaData != null) {
                    bds = (QDataSet)ltcaData.property("BUNDLE_1");
                }
                if (bds != null && lines > bds.length()) {
                    lines = bds.length();
                }
                String xlabel = "";
                if (ltcaData != null && ltcaLabels.length == ltcaData.length(0) + 1) {
                    xlabel = ltcaLabels[0];
                    ltcaLabels = Arrays.copyOfRange(ltcaLabels, 1, ltcaLabels.length);
                }
                for (int i = 0; i < lines; ++i) {
                    String ss;
                    if (bds == null) {
                        ss = ltcaLabels.length == 1 && ltcaLabels[0].trim().equals("") ? "???" : (i < ltcaLabels.length ? ltcaLabels[i] : "???");
                    } else {
                        if (ltcaLabels.length == 1 && ltcaLabels[0].trim().equals("")) {
                            ss = (String)bds.property("LABEL", i);
                            if (ss == null) {
                                ss = (String)bds.property("NAME", i);
                            }
                        } else {
                            String string = ss = i < ltcaLabels.length ? ltcaLabels[i] : "???";
                        }
                        if (ss == null) {
                            ss = "   ";
                        }
                        if (ss.contains("%{")) {
                            Units u = (Units)bds.property("UNITS", i);
                            if (u == null) {
                                u = Units.dimensionless;
                            }
                            ss = this.resolveString(ss, "UNITS", u.toString());
                        }
                    }
                    if (ss == null) {
                        ss = "   ";
                    }
                    idlt.setString(tickLabelFont, ss);
                    int width = (int)Math.floor(idlt.getWidth() + 0.5);
                    tcaLabelWidth = Math.max(tcaLabelWidth, width);
                }
                FontMetrics tickLabelFontMetrics = this.getFontMetrics(tickLabelFont);
                int rightEdgeGap = tickLabelFontMetrics.stringWidth("0000") + tick_label_gap_2023;
                if (tcaLabelWidth > 0) {
                    int tcaLabelSpace = DMin - (tcaLabelWidth += rightEdgeGap) - tick_label_gap_2023;
                    int minX = Math.min(tcaLabelSpace - maxLabelWidth / 2, bounds.x);
                    int maxX = bounds.x + bounds.width;
                    bounds.x = minX;
                    bounds.width = maxX - minX;
                    this.blLabelRect.x = minX;
                    this.blLabelRect.width = maxX - minX;
                }
            }
        }
        return bounds;
    }

    public int getTickLines() {
        QDataSet ltcaData = this.tcaData;
        String ltcaLabels = this.tcaLabels;
        boolean ldrawTca = this.drawTca;
        if (ldrawTca && ltcaData != null) {
            int ntca = ltcaData.length();
            int tcaLines = Math.min(32, Math.max(ltcaData.length(ntca - 1), Math.max(ltcaData.length(ntca / 2), ltcaData.length(0))));
            return 1 + tcaLines;
        }
        if (ldrawTca && ltcaLabels.trim().length() > 0) {
            String[] ss = ltcaLabels.split(";");
            return 1 + ss.length;
        }
        return 2;
    }

    private Rectangle getHorizontalAxisBounds() {
        int height;
        int width;
        int y;
        int x;
        int height2;
        int width2;
        int y2;
        int x2;
        boolean bottomTicks = this.orientation == 2 || this.oppositeAxisVisible;
        boolean bottomTickLabels = this.orientation == 2 && this.tickLabelsVisible;
        boolean bottomLabel = bottomTickLabels && !this.axisLabel.equals("");
        boolean topTicks = this.orientation == 1 || this.oppositeAxisVisible;
        boolean topTickLabels = this.orientation == 1 && this.tickLabelsVisible;
        boolean topLabel = topTickLabels && !this.axisLabel.equals("");
        int axisOffsetPx = this.getAxisOffsetPixels();
        int topPosition = this.getRow().getDMinimum();
        int bottomPosition = this.getRow().getDMaximum() + axisOffsetPx;
        DasColumn range = this.getColumn();
        int DMax = range.getDMaximum();
        int DMin = range.getDMinimum();
        int DWidth = DMax - DMin;
        if (bottomTicks) {
            if (this.blLineRect == null) {
                this.blLineRect = new Rectangle();
            }
            this.blLineRect.setBounds(DMin, bottomPosition, DWidth + 1, 1);
        }
        if (topTicks) {
            if (this.trLineRect == null) {
                this.trLineRect = new Rectangle();
            }
            this.trLineRect.setBounds(DMin, topPosition, DWidth + 1, 1);
        }
        if (this.reference.length() > 0 && this.blLineRect != null) {
            this.blLineRect.add(DMin, topPosition);
            this.blLineRect.add(DMin, bottomPosition);
        }
        double lineThicknessDouble = this.getLineThicknessDouble(this.lineThickness);
        int tickLength = this.tickLen + (this.tickLen < 0 ? -1 : 1) * (int)(lineThicknessDouble / 2.0);
        if (bottomTicks) {
            x2 = DMin;
            y2 = bottomPosition + 1 - Math.max(-tickLength, 0);
            width2 = DWidth;
            height2 = Math.abs(tickLength);
            this.blTickRect = this.isVisible() ? DasAxis.setRectangleBounds(this.blTickRect, x2, y2, width2 + 1, height2) : DasAxis.setRectangleBounds(this.blTickRect, x2, y2, width2 + 1, 1);
        }
        if (topTicks) {
            x2 = DMin;
            y2 = topPosition - Math.max(0, tickLength + (int)(lineThicknessDouble / 2.0));
            width2 = DWidth;
            height2 = Math.abs(tickLength + (int)(lineThicknessDouble / 2.0));
            this.trTickRect = this.isVisible() ? DasAxis.setRectangleBounds(this.trTickRect, x2, y2, width2 + 1, height2) : DasAxis.setRectangleBounds(this.trTickRect, x2, y2, 1, height2);
        }
        if (bottomTickLabels) {
            this.blLabelRect = this.getLabelBounds(new Rectangle(DMin, this.blTickRect.y, DWidth, 10));
            if (this.labelOffset.length() > 0 && this.axisLabel.length() > 0) {
                this.blLabelRect.y = bottomPosition + (int)DasDevicePosition.parseLayoutStr(this.labelOffset, this.getEmSize(), 0, 0.0);
            }
        }
        if (topTickLabels) {
            this.trLabelRect = this.getLabelBounds(new Rectangle(this.trTickRect.x, topPosition - 10, DWidth, 10));
            if (this.labelOffset.length() > 0 && this.axisLabel.length() > 0) {
                this.trLabelRect.y = bottomPosition - (int)DasDevicePosition.parseLayoutStr(this.labelOffset, this.getEmSize(), 0, 0.0);
            }
        }
        Font labelFont = this.getLabelFont();
        GrannyTextRenderer gtr = GraphUtil.newGrannyTextRenderer();
        gtr.setString(labelFont, this.resolveAxisLabel());
        int labelSpacing = (int)gtr.getHeight() + labelFont.getSize() / 2;
        boolean v = this.isVisible();
        if (bottomLabel && v) {
            x = DMin;
            y = this.blLabelRect.y + this.blLabelRect.height;
            width = DMax - DMin;
            height = labelSpacing;
            this.blTitleRect = DasAxis.setRectangleBounds(this.blTitleRect, x, y, width, height);
        }
        if (topLabel && v) {
            x = DMin;
            y = this.trLabelRect.y - labelSpacing;
            width = DMax - DMin;
            height = labelSpacing;
            this.trTitleRect = DasAxis.setRectangleBounds(this.trTitleRect, x, y, width, height);
        }
        Rectangle bounds = new Rectangle(this.orientation == 2 ? this.blLineRect : this.trLineRect);
        if (bottomTicks && v) {
            bounds.add(this.blLineRect);
            bounds.add(this.blTickRect);
        }
        if (bottomTickLabels && v) {
            bounds.add(this.blLabelRect);
        }
        if (bottomLabel && v) {
            bounds.add(this.blTitleRect);
        }
        if (topTicks && v) {
            bounds.add(this.trLineRect);
            bounds.add(this.trTickRect);
        }
        if (topTickLabels && v) {
            bounds.add(this.trLabelRect);
        }
        if (topLabel && v) {
            bounds.add(this.trTitleRect);
        }
        if (this.stepPrevious != null && this.stepNext != null) {
            Dimension prevSize = this.stepPrevious.getPreferredSize();
            Dimension nextSize = this.stepPrevious.getPreferredSize();
            int minX = Math.min(DMin - prevSize.width, bounds.x);
            int maxX = Math.max(DMax + nextSize.width, bounds.x + bounds.width);
            bounds.x = minX;
            bounds.width = maxX - minX;
        }
        return bounds;
    }

    private Rectangle getVerticalAxisBounds() {
        int height;
        int width;
        int y;
        int x;
        int height2;
        int width2;
        int y2;
        int x2;
        boolean leftTicks = this.orientation == 3 || this.oppositeAxisVisible;
        boolean leftTickLabels = this.orientation == 3 && this.tickLabelsVisible;
        boolean leftLabel = this.orientation == 3 && !this.axisLabel.equals("");
        boolean rightTicks = this.orientation == 4 || this.oppositeAxisVisible;
        boolean rightTickLabels = this.orientation == 4 && this.tickLabelsVisible;
        boolean rightLabel = this.orientation == 4 && !this.axisLabel.equals("");
        int axisOffsetPx = this.getAxisOffsetPixels();
        int leftPosition = this.getColumn().getDMinimum() - axisOffsetPx;
        int rightPosition = this.getColumn().getDMaximum() + axisOffsetPx;
        int DMax = this.getRow().getDMaximum();
        int DMin = this.getRow().getDMinimum();
        int DWidth = DMax - DMin;
        if (leftTicks) {
            if (this.blLineRect == null) {
                this.blLineRect = new Rectangle();
            }
            this.blLineRect.setBounds(leftPosition, DMin, 1, DWidth + 1);
        }
        if (rightTicks) {
            if (this.trLineRect == null) {
                this.trLineRect = new Rectangle();
            }
            this.trLineRect.setBounds(rightPosition, DMin, 1, DWidth + 1);
        }
        if (this.reference.length() > 0 && this.blLineRect != null) {
            this.blLineRect.add(rightPosition, DMax);
            this.blLineRect.add(leftPosition, DMin);
        }
        double lineThicknessDouble = this.getLineThicknessDouble(this.lineThickness);
        int tickLength = this.tickLen + (this.tickLen < 0 ? -1 : 1) * (int)(lineThicknessDouble / 2.0);
        if (leftTicks) {
            x2 = leftPosition - Math.max(0, tickLength);
            y2 = DMin;
            width2 = Math.abs(tickLength);
            height2 = DWidth;
            this.blTickRect = DasAxis.setRectangleBounds(this.blTickRect, x2, y2, width2, height2 + 1);
        }
        if (rightTicks) {
            x2 = rightPosition + 1 + Math.min(0, tickLength);
            y2 = DMin;
            width2 = Math.abs(tickLength);
            height2 = DWidth;
            this.trTickRect = DasAxis.setRectangleBounds(this.trTickRect, x2, y2, width2, height2 + 1);
        }
        if (leftTickLabels) {
            this.blLabelRect = this.getLabelBounds(new Rectangle(this.blTickRect.x - 10, DMin, 10, DWidth));
            if (this.labelOffset.length() > 0 && this.axisLabel.length() > 0) {
                this.blLabelRect.x = leftPosition + 1 - (int)DasDevicePosition.parseLayoutStr(this.labelOffset, this.getEmSize(), DWidth, 0.0);
            }
            if (this.leftXOverride != null) {
                this.blLabelRect.x = this.leftXOverride;
            }
        } else {
            this.blLabelRect = leftLabel ? this.getLabelBounds(new Rectangle(this.getColumn().getDMinimum(), DMin, 1, DWidth)) : this.blTickRect;
        }
        if (rightTickLabels) {
            this.trLabelRect = this.getLabelBounds(new Rectangle(this.trTickRect.x + this.trTickRect.width, DMin, 10, DWidth));
            if (this.labelOffset.length() > 0 && this.axisLabel.length() > 0) {
                this.trLabelRect.width = rightPosition + (int)DasDevicePosition.parseLayoutStr(this.labelOffset, this.getEmSize(), DWidth, 0.0) - rightPosition;
            }
        } else {
            this.trLabelRect = this.trTickRect;
        }
        Font labelFont = this.getLabelFont();
        GrannyTextRenderer gtr = GraphUtil.newGrannyTextRenderer();
        gtr.setString(labelFont, this.resolveAxisLabel());
        int labelSpacing = (int)gtr.getHeight() + labelFont.getSize() / 2;
        if (leftLabel) {
            x = this.blLabelRect.x - labelSpacing;
            y = DMin;
            width = labelSpacing;
            height = DWidth;
            this.blTitleRect = DasAxis.setRectangleBounds(this.blTitleRect, x, y, width, height);
        }
        if (rightLabel) {
            x = this.trLabelRect.x + this.trLabelRect.width;
            y = DMin;
            width = labelSpacing;
            height = DWidth;
            this.trTitleRect = DasAxis.setRectangleBounds(this.trTitleRect, x, y, width, height);
        }
        boolean v = this.isVisible();
        Rectangle bounds = new Rectangle(this.orientation == 3 ? this.blLineRect : this.trLineRect);
        if (leftTicks && v) {
            bounds.add(this.blLineRect);
            bounds.add(this.blTickRect);
        }
        if (leftTickLabels && v) {
            bounds.add(this.blLabelRect);
        }
        if (leftLabel && v) {
            bounds.add(this.blTitleRect);
        }
        if (rightTicks && v) {
            bounds.add(this.trLineRect);
            bounds.add(this.trTickRect);
        }
        if (rightTickLabels && v) {
            bounds.add(this.trLabelRect);
        }
        if (rightLabel && v) {
            bounds.add(this.trTitleRect);
        }
        return bounds;
    }

    private static Rectangle setRectangleBounds(Rectangle rc, int x, int y, int width, int height) {
        if (rc == null) {
            return new Rectangle(x, y, width, height);
        }
        rc.setBounds(x, y, width, height);
        return rc;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isHorizontal() {
        return this.orientation == 2 || this.orientation == 1;
    }

    public int getTickDirection() {
        return this.tickDirection;
    }

    public DatumFormatter getDatumFormatter() {
        return this.datumFormatter;
    }

    public double transform(Datum datum) {
        return this.transform(datum.doubleValue(this.getUnits()), this.getUnits());
    }

    protected double transformFast(double data, Units units) {
        if (this.dataRange.isLog()) {
            data = data <= 0.0 ? this.dataRange.getMinimum() - 3.0 : Math.log10(data);
        }
        double result = this.at_m * data + this.at_b;
        return result;
    }

    public double transform(double data, Units units) {
        if (this.isHorizontal()) {
            DasColumn range = this.getColumn();
            return this.transform(data, units, range.getDMinimum(), range.getDMaximum());
        }
        DasRow range = this.getRow();
        return this.transform(data, units, range.getDMaximum(), range.getDMinimum());
    }

    public double transform(QDataSet data, Units units) {
        double d;
        if (units == data.property("UNITS")) {
            d = data.value();
        } else if (units == Units.dimensionless && data.property("UNITS") == null) {
            d = data.value();
        } else {
            UnitsConverter uc = SemanticOps.getUnits((QDataSet)data).getConverter(units);
            d = uc.convert(data.value());
        }
        if (this.isHorizontal()) {
            DasColumn range = this.getColumn();
            return this.transform(d, units, range.getDMinimum(), range.getDMaximum());
        }
        DasRow range = this.getRow();
        return this.transform(d, units, range.getDMaximum(), range.getDMinimum());
    }

    public double transform(QDataSet data) {
        double d = data.value();
        Units units = (Units)data.property("UNITS");
        if (units == null) {
            units = Units.dimensionless;
        }
        if (this.isHorizontal()) {
            DasColumn range = this.getColumn();
            return this.transform(d, units, range.getDMinimum(), range.getDMaximum());
        }
        DasRow range = this.getRow();
        return this.transform(d, units, range.getDMaximum(), range.getDMinimum());
    }

    protected double transform(double data, Units units, int dmin, int dmax) {
        if (units != this.dataRange.getUnits()) {
            data = units.convertDoubleTo(this.dataRange.getUnits(), data);
        }
        double device_range = dmax - dmin;
        if (this.dataRange.isLog()) {
            data = data <= 0.0 ? -1.0E308 : Math.log10(data);
        }
        double minimum = this.dataRange.getMinimum();
        double maximum = this.dataRange.getMaximum();
        double data_range = maximum - minimum;
        double result = this.flipped ? (double)dmax - device_range * (data - minimum) / data_range : device_range * (data - minimum) / data_range + (double)dmin;
        if (result > 10000.0) {
            result = 10000.0;
        }
        if (result < -10000.0) {
            result = -10000.0;
        }
        return result;
    }

    public DatumRange invTransform(double idata1, double idata2) {
        Datum d2;
        Datum d1 = this.invTransform(idata1);
        if (d1.lt(d2 = this.invTransform(idata2))) {
            return new DatumRange(d1, d2);
        }
        return new DatumRange(d2, d1);
    }

    public Datum invTransform(double idata) {
        DasDevicePosition range = this.isHorizontal() ? this.getColumn() : this.getRow();
        double alpha = (idata - (double)range.getDMinimum()) / (double)this.getDLength();
        if (!this.isHorizontal()) {
            alpha = 1.0 - alpha;
        }
        if (this.flipped) {
            alpha = 1.0 - alpha;
        }
        double minimum = this.dataRange.getMinimum();
        double maximum = this.dataRange.getMaximum();
        double data_range = maximum - minimum;
        double data = data_range * alpha + minimum;
        double resolution = data_range / (double)this.getDLength();
        if (this.dataRange.isLog()) {
            data = Math.pow(10.0, data);
            resolution = data * (Math.pow(10.0, resolution) - 1.0);
        }
        Datum result = Datum.create((double)data, (Units)this.dataRange.getUnits(), (double)resolution);
        return result;
    }

    protected String tickFormatter(Datum d) {
        return this.datumFormatter.grannyFormat(d, d.getUnits());
    }

    protected String[] tickFormatter(DatumVector tickV, DatumRange datumRange) {
        return this.datumFormatter.axisFormat(tickV, datumRange);
    }

    @Override
    public void dataRangeSelected(DataRangeSelectionEvent e) {
        this.setDataRange(e.getMinimum(), e.getMaximum());
    }

    public Datum findTick(Datum xDatum, double direction, boolean minor) {
        return this.getTickV().findTick(xDatum, direction, minor);
    }

    private void animateChange(double min0, double max0, double min1, double max1) {
        if (this.animated && EventQueue.isDispatchThread()) {
            DataRange tempRange;
            logger.fine("animate axis");
            boolean drawTca0 = this.isDrawTca();
            this.setDrawTca(false);
            long t0 = System.currentTimeMillis();
            long frames = 0L;
            DataRange dataRange0 = this.dataRange;
            this.dataRange = tempRange = DataRange.getAnimationDataRange(this.dataRange.getDatumRange(), this.dataRange.isLog());
            double transitionTime = 300.0;
            double alpha = (double)(System.currentTimeMillis() - t0) / transitionTime;
            while (alpha < 1.0) {
                alpha = (double)(System.currentTimeMillis() - t0) / transitionTime;
                double[] aa = new double[]{0.0, 0.3, 0.85, 1.0};
                double[] aa1 = new double[]{0.0, 0.05, 0.9, 1.0};
                double f1 = DasMath.findex((double[])aa, (double)alpha, (int)0);
                double a1 = DasMath.interpolate((double[])aa1, (double)f1);
                double a0 = 1.0 - a1;
                tempRange.setRange(min0 * a0 + min1 * a1, max0 * a0 + max1 * a1);
                this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
                if (this.dasPlot != null) {
                    this.dasPlot.paintImmediately(0, 0, this.dasPlot.getWidth(), this.dasPlot.getHeight());
                }
                ++frames;
            }
            logger.log(Level.FINE, "animation frames/sec= {0}", 1000.0 * (double)frames / transitionTime);
            this.setDrawTca(drawTca0);
            this.dataRange = dataRange0;
        }
    }

    @Override
    protected void updateImmediately() {
        super.updateImmediately();
        logger.log(Level.FINE, "updateImmadiately{0} {1}", new Object[]{this.getDatumRange(), this.isLog()});
        this.resetTransform();
        try {
            this.updateTickV();
        }
        catch (InconvertibleUnitsException ex) {
            this.updateTickV();
        }
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean b) {
        if (this.tickLabelsVisible == b) {
            return;
        }
        boolean oldValue = this.tickLabelsVisible;
        this.tickLabelsVisible = b;
        this.update();
        this.firePropertyChange("tickLabelsVisible", oldValue, b);
    }

    @Override
    protected void installComponent() {
        super.installComponent();
        QFunction ltcaFunction = this.tcaFunction;
        if (ltcaFunction != null) {
            this.maybeStartTCATimer();
        }
    }

    @Override
    protected void uninstallComponent() {
        super.uninstallComponent();
        this.tcaTimer = null;
    }

    public DasAxis createAttachedAxis() {
        DasAxis result = new DasAxis(this.dataRange, this.getOrientation());
        result.setScanRange(this.getScanRange());
        return result;
    }

    public DasAxis createAttachedAxis(int orientation) {
        DasAxis result = new DasAxis(this.dataRange, orientation);
        result.setScanRange(this.getScanRange());
        return result;
    }

    public void setPlot(DasPlot p) {
        this.dasPlot = p;
    }

    public void scanPrevious() {
        DatumRange dr = this.getDatumRange();
        dr = this.dataRange.isLog() ? DatumRangeUtil.rescaleLog((DatumRange)dr, (double)-1.0, (double)0.0) : dr.previous();
        this.setDatumRange(dr);
    }

    public void scanNext() {
        DatumRange dr = this.getDatumRange();
        dr = this.dataRange.isLog() ? DatumRangeUtil.rescaleLog((DatumRange)dr, (double)1.0, (double)2.0) : this.getDatumRange().next();
        this.setDatumRange(dr);
    }

    @Override
    public Shape getActiveRegion() {
        Rectangle primaryBounds = this.primaryInputPanel.getBounds();
        primaryBounds.translate(this.getX(), this.getY());
        if (this.oppositeAxisVisible) {
            Rectangle secondaryBounds = this.secondaryInputPanel.getBounds();
            secondaryBounds.translate(this.getX(), this.getY());
            GeneralPath path = new GeneralPath(primaryBounds);
            path.setWindingRule(0);
            path.append(secondaryBounds, false);
            return path;
        }
        return primaryBounds;
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseWheelListener(l);
        this.secondaryInputPanel.addMouseWheelListener(l);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseWheelListener(l);
        this.secondaryInputPanel.removeMouseWheelListener(l);
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseListener(l);
        this.secondaryInputPanel.addMouseListener(l);
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseListener(l);
        this.secondaryInputPanel.removeMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseMotionListener(l);
        this.secondaryInputPanel.addMouseMotionListener(l);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseMotionListener(l);
        this.secondaryInputPanel.removeMouseMotionListener(l);
    }

    @Override
    public void timeRangeSelected(TimeRangeSelectionEvent e) {
        if (e.getSource() != this && !e.equals(this.lastProcessedEvent)) {
            this.setDatumRange(e.getRange());
            this.lastProcessedEvent = e;
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        if (this.timeRangeListenerList == null) {
            this.timeRangeListenerList = new EventListenerList();
        }
        this.timeRangeListenerList.add(TimeRangeSelectionListener.class, listener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        this.timeRangeListenerList.remove(TimeRangeSelectionListener.class, listener);
    }

    private synchronized void fireTimeRangeSelectionListenerTimeRangeSelected(TimeRangeSelectionEvent event) {
        if (this.timeRangeListenerList == null) {
            return;
        }
        Object[] listeners = this.timeRangeListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TimeRangeSelectionListener.class) continue;
            String logmsg = "fire event: " + this.getClass().getName() + "-->" + listeners[i + 1].getClass().getName() + " " + event;
            DasLogger.getLogger(DasLogger.GUI_LOG).fine(logmsg);
            ((TimeRangeSelectionListener)listeners[i + 1]).timeRangeSelected(event);
        }
    }

    private static String format(double d, String f) {
        String result;
        DecimalFormat form;
        int i;
        Matcher m = pattern.matcher(f);
        if (!m.matches()) {
            throw new IllegalArgumentException("\"" + f + "\" is not a valid format specifier");
        }
        int length = Integer.parseInt(f.substring(2, f.indexOf(46)));
        int fracLength = Integer.parseInt(f.substring(f.indexOf(46) + 1, f.indexOf(41)));
        char[] buf = new char[length];
        if (f.charAt(1) == 'f' || f.charAt(1) == 'F') {
            for (i = 0; i < length - fracLength - 2; ++i) {
                buf[i] = 35;
            }
            buf[i] = 48;
            buf[++i] = 46;
            ++i;
            while (i < length) {
                buf[i] = 48;
                ++i;
            }
            form = new DecimalFormat(new String(buf));
            result = form.format(d);
        } else {
            for (i = 0; i < length - fracLength - 6; ++i) {
                buf[i] = 35;
            }
            buf[i] = 48;
            buf[++i] = 46;
            ++i;
            while (i < length - 5) {
                buf[i] = 48;
                ++i;
            }
            buf[i] = 69;
            buf[i + 1] = d > -1.0 && d < 1.0 ? 45 : 43;
            buf[i + 2] = 48;
            buf[i + 3] = 48;
            form = new DecimalFormat(new String(buf));
            result = form.format(d);
        }
        if (result.length() > length) {
            Arrays.fill(buf, '*');
            return new String(buf);
        }
        while (result.length() < length) {
            result = " " + result;
        }
        return result;
    }

    @Override
    public String toString() {
        String retValue = super.toString() + "(" + this.getUnits() + ")";
        return retValue;
    }

    private void refreshScanButtons(boolean reset) {
        boolean t;
        if (this.stepNext == null) {
            return;
        }
        if (this.scanRange != null && !this.scanRange.getUnits().isConvertibleTo(this.getDatumRange().getUnits())) {
            this.scanRange = null;
        }
        if (reset || this.stepPrevious.hover) {
            t = this.scanRange == null || this.scanRange.intersects(this.getDatumRange().previous());
            this.stepPrevious.hover = t;
        }
        if (reset || this.stepNext.hover) {
            t = this.scanRange == null || this.scanRange.intersects(this.getDatumRange().next());
            this.stepNext.hover = t;
        }
    }

    public void setNextActionLabel(String label, String tooltip) {
        if (this.stepNext != null) {
            this.stepNext.setText(label);
            this.stepNext.setToolTipText(tooltip);
        }
    }

    public void setPreviousActionLabel(String label, String tooltip) {
        if (this.stepPrevious != null) {
            this.stepPrevious.setText(label);
            this.stepPrevious.setToolTipText(tooltip);
        }
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    private void updateTickLength() throws ParseException {
        double[] pos = DasDevicePosition.parseLayoutStr(this.tickLenStr);
        this.tickLen = pos[0] == 0.0 ? (int)Math.round(pos[1] * this.getEmSize() + pos[2]) : (int)Math.round(pos[0] * (double)this.getRow().getHeight() + pos[1] * this.getEmSize() + pos[2]);
    }

    public String getTickLength() {
        return this.tickLenStr;
    }

    public void setTickLength(String tickLengthStr) {
        this.tickLenStr = tickLengthStr;
        try {
            this.updateTickLength();
            this.resize();
            this.repaint();
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public String getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(String lineThickness) {
        String oldLineThickness = this.lineThickness;
        this.lineThickness = lineThickness;
        this.firePropertyChange(PROP_LINETHICKNESS, oldLineThickness, lineThickness);
        this.repaint();
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean b) {
        boolean oldFlipped = this.flipped;
        this.update();
        this.flipped = b;
        this.firePropertyChange(PROP_FLIPPED, oldFlipped, this.flipped);
    }

    public String getFormat() {
        return this.formatString;
    }

    public boolean isFlipLabel() {
        return this.flipLabel;
    }

    public void setFlipLabel(boolean flipLabel) {
        boolean oldFlipLabel = this.flipLabel;
        this.flipLabel = flipLabel;
        this.repaint();
        this.firePropertyChange(PROP_FLIPLABEL, oldFlipLabel, flipLabel);
    }

    public DatumFormatter getDividerDatumFormatter() {
        return this.dividerDatumFormatter;
    }

    public void setDividerDatumFormatter(DatumFormatter dividerDatumFormatter) {
        DatumFormatter oldDividerDatumFormatter = this.dividerDatumFormatter;
        this.dividerDatumFormatter = dividerDatumFormatter;
        this.firePropertyChange(PROP_DIVIDERDATUMFORMATTER, oldDividerDatumFormatter, dividerDatumFormatter);
    }

    public DomainDivider getMinorTicksDomainDivider() {
        return this.minorTicksDomainDivider;
    }

    public void setMinorTicksDomainDivider(DomainDivider minorTicksDomainDivider) {
        DomainDivider oldMinorTicksDomainDivider = this.minorTicksDomainDivider;
        this.minorTicksDomainDivider = minorTicksDomainDivider;
        this.firePropertyChange(PROP_MINORTICKSDOMAINDIVIDER, oldMinorTicksDomainDivider, minorTicksDomainDivider);
    }

    public DomainDivider getMajorTicksDomainDivider() {
        return this.majorTicksDomainDivider;
    }

    public void setMajorTicksDomainDivider(DomainDivider majorTicksDomainDivider) {
        DomainDivider oldMajorTicksDomainDivider = this.majorTicksDomainDivider;
        this.majorTicksDomainDivider = majorTicksDomainDivider;
        this.firePropertyChange(PROP_MAJORTICKSDOMAINDIVIDER, oldMajorTicksDomainDivider, majorTicksDomainDivider);
    }

    public boolean isUseDomainDivider() {
        return this.useDomainDivider;
    }

    public void setUseDomainDivider(boolean useDomainDivider) {
        boolean oldUseDomainDivider = this.useDomainDivider;
        this.useDomainDivider = useDomainDivider;
        if (oldUseDomainDivider != useDomainDivider) {
            this.updateTickV();
        }
        this.firePropertyChange(PROP_USEDOMAINDIVIDER, oldUseDomainDivider, useDomainDivider);
    }

    public boolean isLockDomainDivider() {
        return this.lockDomainDivider;
    }

    public void setLockDomainDivider(boolean lockDomainDivider) {
        boolean oldLockDomainDivider = this.lockDomainDivider;
        this.lockDomainDivider = lockDomainDivider;
        this.firePropertyChange(PROP_LOCKDOMAINDIVIDER, oldLockDomainDivider, lockDomainDivider);
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.update();
    }

    public void setFormat(String formatString) {
        try {
            String oldFormatString = this.formatString;
            this.formatString = formatString;
            if (formatString.equals("")) {
                this.setUserDatumFormatter(null);
            } else {
                if (formatString.contains("$") && !formatString.contains("%")) {
                    formatString = formatString.replaceAll("\\$", "%");
                }
                this.setUserDatumFormatter(this.getUnits().getDatumFormatterFactory().newFormatter(formatString));
            }
            this.updateTickV();
            this.repaint();
            this.firePropertyChange(PROP_FORMAT, oldFormatString, formatString);
        }
        catch (ParseException e) {
            this.setUserDatumFormatter(null);
        }
    }

    private void resetTransform() {
        DasDevicePosition pos;
        if (this.isHorizontal() ? (pos = this.getColumn()) == DasColumn.NULL : (pos = this.getRow()) == DasRow.NULL) {
            return;
        }
        double dmin = pos.getDMinimum();
        double dmax = pos.getDMaximum();
        if (this.isFlipped()) {
            double t = dmin;
            dmin = dmax;
            dmax = t;
        }
        double[] at = GraphUtil.getSlopeIntercept(this.dataRange.getMinimum(), dmin, this.dataRange.getMaximum(), dmax);
        this.at_m = at[0];
        this.at_b = at[1];
    }

    public Lock mutatorLock() {
        return this.dataRange.mutatorLock();
    }

    public boolean valueIsAdjusting() {
        return this.dataRange.valueIsAdjusting();
    }

    private final class ScanButton
    extends JButton {
        private boolean hover;
        private boolean pressed;
        private boolean nextButton;

        public ScanButton(String text) {
            this.setOpaque(true);
            this.setContentAreaFilled(false);
            this.setText(text);
            this.setFocusable(false);
            this.nextButton = DasAxis.STEP_NEXT_LABEL.equals(text);
            this.setBorder(new CompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(2, 2, 2, 2)));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ScanButton.this.setForeground(Color.LIGHT_GRAY);
                        ScanButton.this.pressed = DasAxis.this.scanRange == null || (ScanButton.this.nextButton ? DasAxis.this.scanRange.intersects(DasAxis.this.getDatumRange().next()) : DasAxis.this.scanRange.intersects(DasAxis.this.getDatumRange().previous()));
                        ScanButton.this.repaint();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ScanButton.this.setForeground(Color.BLACK);
                        ScanButton.this.pressed = false;
                        ScanButton.this.repaint();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ScanButton.this.hover = true;
                    if (!ScanButton.this.hover) {
                        logger.finest("hover false");
                    }
                    ScanButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ScanButton.this.hover = false;
                    ScanButton.this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (DasAxis.this.getCanvas().isPrintingThread()) {
                return;
            }
            if (this.hover || this.pressed) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(Color.white);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                Object aaHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                Object aaOn = RenderingHints.VALUE_ANTIALIAS_ON;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaOn);
                super.paintComponent(g2);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
            } else {
                logger.finer("not drawing step button");
            }
        }

        @Override
        protected void paintBorder(Graphics g) {
            if (this.hover || this.pressed) {
                super.paintBorder(g);
            }
        }
    }

    protected class AxisLayoutManager
    implements LayoutManager {
        protected AxisLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (DasAxis.this != parent) {
                throw new IllegalArgumentException();
            }
            if (DasAxis.this.isHorizontal()) {
                this.horizontalLayout();
            } else {
                this.verticalLayout();
            }
            if (DasAxis.this.tcaRows >= 0) {
                Rectangle bounds = DasAxis.this.primaryInputPanel.getBounds();
                int tcaHeight = (DasAxis.this.getTickLabelFont().getSize() + DasAxis.this.getLineSpacing()) * Math.min(32, DasAxis.this.tcaRows);
                bounds.height += tcaHeight;
                DasAxis.this.primaryInputPanel.setBounds(bounds);
            } else if (DasAxis.this.drawTca && DasAxis.this.getOrientation() == 2 && DasAxis.this.tcaData != null) {
                Rectangle bounds = DasAxis.this.primaryInputPanel.getBounds();
                int tcaHeight = (DasAxis.this.getTickLabelFont().getSize() + DasAxis.this.getLineSpacing()) * Math.min(32, DasAxis.this.tcaData.length(0));
                bounds.height += tcaHeight;
                DasAxis.this.primaryInputPanel.setBounds(bounds);
            }
        }

        protected void horizontalLayout() {
            Rectangle secondaryBounds;
            int topPosition = DasAxis.this.getRow().getDMinimum() - 1;
            int bottomPosition = DasAxis.this.getRow().getDMaximum();
            int DMax = DasAxis.this.getColumn().getDMaximum();
            int DMin = DasAxis.this.getColumn().getDMinimum();
            boolean bottomTicks = DasAxis.this.orientation == 2 || DasAxis.this.oppositeAxisVisible;
            boolean bottomTickLabels = DasAxis.this.orientation == 2 && DasAxis.this.tickLabelsVisible;
            boolean topTickLabels = DasAxis.this.orientation == 1 && DasAxis.this.tickLabelsVisible;
            Font tickLabelFont = DasAxis.this.getTickLabelFont();
            int tickSize = tickLabelFont.getSize() * 2 / 3;
            Rectangle bottomBounds = new Rectangle(DMin, bottomPosition, DMax - DMin + 1, 1);
            bottomBounds.height += tickSize;
            Rectangle topBounds = new Rectangle(DMin, topPosition, DMax - DMin + 1, 1);
            topBounds.height += tickSize;
            topBounds.y -= tickSize;
            int tick_label_gap = DasAxis.this.getFontMetrics(tickLabelFont).stringWidth(" ");
            if (bottomTickLabels) {
                assert (bottomBounds != null);
                bottomBounds.height += tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
            }
            if (topTickLabels) {
                topBounds.y -= tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
                topBounds.height += tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
            }
            Rectangle primaryBounds = bottomTicks ? bottomBounds : topBounds;
            Rectangle rectangle = secondaryBounds = bottomTicks ? topBounds : bottomBounds;
            assert (primaryBounds != null);
            primaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            if (DasAxis.this.oppositeAxisVisible) {
                assert (secondaryBounds != null);
                secondaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            }
            DasAxis.this.primaryInputPanel.setBounds(primaryBounds);
            if (DasAxis.this.oppositeAxisVisible) {
                DasAxis.this.secondaryInputPanel.setBounds(secondaryBounds);
            } else {
                DasAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
            if (DasAxis.this.stepPrevious != null && DasAxis.this.stepNext != null) {
                Dimension preferred = DasAxis.this.stepPrevious.getPreferredSize();
                int x = DMin - preferred.width - DasAxis.this.getX();
                int y = (DasAxis.this.orientation == 2 ? bottomPosition : topPosition - preferred.height) - DasAxis.this.getY();
                DasAxis.this.stepPrevious.setBounds(x, y, preferred.width, preferred.height);
                preferred = DasAxis.this.stepNext.getPreferredSize();
                x = DMax - DasAxis.this.getX();
                DasAxis.this.stepNext.setBounds(x, y, preferred.width, preferred.height);
            }
        }

        protected void verticalLayout() {
            Rectangle secondaryBounds;
            boolean leftTicks = DasAxis.this.orientation == 3 || DasAxis.this.oppositeAxisVisible;
            boolean leftTickLabels = DasAxis.this.orientation == 3 && DasAxis.this.tickLabelsVisible;
            boolean rightTickLabels = DasAxis.this.orientation == 4 && DasAxis.this.tickLabelsVisible;
            int leftPosition = DasAxis.this.getColumn().getDMinimum() - 1;
            int rightPosition = DasAxis.this.getColumn().getDMaximum();
            int DMax = DasAxis.this.getRow().getDMaximum();
            int DMin = DasAxis.this.getRow().getDMinimum();
            Font tickLabelFont = DasAxis.this.getTickLabelFont();
            int tickSize = tickLabelFont.getSize() * 2 / 3;
            Rectangle leftBounds = new Rectangle(leftPosition, DMin, 1, DMax - DMin + 1);
            leftBounds.width += tickSize;
            leftBounds.x -= tickSize;
            Rectangle rightBounds = new Rectangle(rightPosition, DMin, 1, DMax - DMin + 1);
            rightBounds.width += tickSize;
            int maxLabelWidth = DasAxis.this.getMaxLabelWidth();
            int tick_label_gap = DasAxis.this.getFontMetrics(tickLabelFont).stringWidth(" ");
            if (leftTickLabels) {
                leftBounds.x -= maxLabelWidth + tick_label_gap;
                leftBounds.width += maxLabelWidth + tick_label_gap;
            }
            if (rightTickLabels) {
                assert (rightBounds != null);
                rightBounds.width += maxLabelWidth + tick_label_gap;
            }
            Rectangle primaryBounds = leftTicks ? leftBounds : rightBounds;
            Rectangle rectangle = secondaryBounds = leftTicks ? rightBounds : leftBounds;
            assert (primaryBounds != null);
            primaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            if (DasAxis.this.oppositeAxisVisible) {
                assert (secondaryBounds != null);
                secondaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            }
            DasAxis.this.primaryInputPanel.setBounds(primaryBounds);
            if (DasAxis.this.oppositeAxisVisible) {
                DasAxis.this.secondaryInputPanel.setBounds(secondaryBounds);
            } else {
                DasAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    public static class Memento {
        private DatumRange range;
        private int dmin;
        private int dmax;
        private boolean log;
        private boolean flipped;
        private boolean horizontal;

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + (this.range != null ? this.range.hashCode() : 0);
            hash = 29 * hash + this.dmin;
            hash = 29 * hash + this.dmax;
            hash = 29 * hash + (this.log ? 1 : 0);
            hash = 29 * hash + (this.flipped ? 1 : 0);
            hash = 29 * hash + (this.horizontal ? 1 : 0);
            return hash;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Memento)) {
                return false;
            }
            Memento m = (Memento)o;
            return this == m || this.range.equals((Object)m.range) && this.dmin == m.dmin && this.dmax == m.dmax && this.log == m.log && this.flipped == m.flipped && this.horizontal == m.horizontal;
        }

        public String toString() {
            return (this.log ? "log " : "") + this.range.toString() + " (" + DatumUtil.asOrderOneUnits((Datum)this.range.width()).toString() + ") " + (this.dmax - this.dmin) + " pixels @ " + this.dmin;
        }
    }

    public static interface Lock {
        public void lock();

        public void unlock();
    }
}

