/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.das2.DasApplication;
import org.das2.DasProperties;
import org.das2.dataset.VectorUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.LengthDragRenderer;
import org.das2.event.LengthMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DataGeneralPathBuilder;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.ErrorBarType;
import org.das2.graph.FillStyle;
import org.das2.graph.GraphUtil;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PsymConnector;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.qds.util.Reduction;
import org.das2.system.DasLogger;
import org.das2.util.ColorUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SeriesRenderer
extends Renderer {
    public static String VERSION = "20220209.1624";
    private DefaultPlotSymbol psym = DefaultPlotSymbol.CIRCLES;
    private float symSize = 3.0f;
    private float lineWidth = 1.0f;
    private boolean histogram = false;
    private PsymConnector psymConnector = PsymConnector.SOLID;
    private FillStyle fillStyle = FillStyle.STYLE_SOLID;
    private Color color = Color.BLACK;
    private long lastUpdateMillis;
    private boolean antiAliased = "on".equals(DasProperties.getInstance().get("antiAlias"));
    public static final String CONTROL_KEY_BACKGROUND_THICK = "backgroundThick";
    public static final String CONTROL_KEY_FILL_STYLE = "fillStyle";
    private int firstIndex = -1;
    private int lastIndex = -1;
    private boolean dataIsMonotonic = false;
    private int numberOfPoints;
    private int firstIndex_v = -1;
    private int lastIndex_v = -1;
    private int dslen = -1;
    boolean unitsWarning = false;
    boolean xunitsWarning = false;
    private static final Logger logger = LoggerManager.getLogger((String)"das2.graphics.renderer.series");
    private boolean dataSetClipped;
    private boolean dataSetReduced;
    Image psymImage;
    Image[] coloredPsyms;
    Map<Color, Image> specialColorPsyms;
    int cmx;
    int cmy;
    FillRenderElement fillElement = new FillRenderElement();
    ErrorBarRenderElement errorElement = new ErrorBarRenderElement();
    PsymConnectorRenderElement psymConnectorElement = new PsymConnectorRenderElement();
    PsymRenderElement psymsElement = new PsymRenderElement();
    QDataSet xds;
    QDataSet yds;
    QDataSet zds;
    private boolean showLimits = true;
    public static final String PROP_SHOWLIMITS = "showLimits";
    private String specialColors = "";
    public static final String PROP_SPECIALCOLORS = "specialColors";
    private String fillTexture = "";
    public static final String PROP_FILLTEXTURE = "fillTexture";
    Shape selectionArea;
    boolean haveValidColor = true;
    private static final int SIMPLIFY_PATHS_MIN_LIMIT = 1000;
    QDataSet xdsc;
    QDataSet ydsc;
    int firstIndexc;
    int lastIndexc;
    Datum cadencec;
    private boolean additionalClip = true;
    public static final String PROP_ADDITIONALCLIP = "additionalClip";
    private float listIconSymSize = 3.0f;
    private boolean drawError = true;
    public static final String PROP_DRAWERROR = "drawError";
    private String backgroundThick = "";
    public static final String PROP_BACKGROUNDWIDTH = "backgroundWidth";
    private Color fillColor = Color.lightGray;
    private String fillDirection = "both";
    public static final String PROP_FILLDIRECTION = "fillDirection";
    private String colorByDataSetId = "";
    PropertyChangeListener colorBarListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("")) {
                if (evt.getPropertyName().equals("type")) {
                    SeriesRenderer.this.updatePsym();
                    SeriesRenderer.this.update();
                } else if (evt.getPropertyName().equals("datumRange")) {
                    SeriesRenderer.this.update();
                } else if (evt.getPropertyName().equals("log")) {
                    SeriesRenderer.this.update();
                }
            }
        }
    };
    private boolean fillToReference;
    private Datum reference = Units.dimensionless.createDatum(0);
    private ErrorBarType errorBarType = ErrorBarType.BAR;
    public static final String PROP_ERRORBARTYPE = "errorBarType";
    private Datum moduloY = Units.dimensionless.createDatum(0);
    public static final String PROP_MODULO_Y = "moduloY";
    private boolean resetDebugCounters;
    private boolean simplifyPaths = true;
    private boolean stampPsyms = true;
    public static final String PROP_STAMPPSYMS = "stampPsyms";
    private int dataSetSizeLimit = 200000;
    private double updatesPointsPerMillisecond;
    public static final String PROP_UPDATESPOINTSPERMILLISECOND = "updatesPointsPerMillisecond";
    private double renderPointsPerMillisecond;
    public static final String PROP_RENDERPOINTSPERMILLISECOND = "renderPointsPerMillisecond";
    protected boolean cadenceCheck = true;
    public static final String PROP_CADENCECHECK = "cadenceCheck";

    public SeriesRenderer() {
        this.updatePsym();
    }

    @Override
    public void setDataSet(QDataSet ds) {
        if (ds == null || ds.rank() > 0) {
            super.setDataSet(ds);
        } else {
            QDataSet xtags = this.getXTags(ds);
            QDataSet d = Ops.bundle((QDataSet)xtags, (QDataSet)ds);
            QDataSet bds = (QDataSet)d.property("BUNDLE_0");
            QDataSet j = Ops.join(null, (QDataSet)d);
            j = Ops.putProperty((QDataSet)j, (String)"BUNDLE_1", (Object)bds);
            super.setDataSet(j);
        }
        if (ds == null) {
            this.xds = null;
            this.yds = null;
            this.zds = null;
        } else {
            this.xds = this.getXTags(ds);
            this.yds = this.ytagsDataSet(ds);
            this.zds = this.colorByDataSet(ds);
            if (this.xds.rank() == 2 && !SemanticOps.isBins((QDataSet)this.xds)) {
                logger.warning("xtags part of data is rank 2 but xtags are not bins.");
            }
        }
    }

    public boolean isShowLimits() {
        return this.showLimits;
    }

    public void setShowLimits(boolean showLimits) {
        boolean oldShowLimits = this.showLimits;
        this.showLimits = showLimits;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_SHOWLIMITS, oldShowLimits, showLimits);
    }

    public String getSpecialColors() {
        return this.specialColors;
    }

    public void setSpecialColors(String specialColors) {
        String oldSpecialColors = this.specialColors;
        this.specialColors = specialColors;
        this.updatePsym();
        this.propertyChangeSupport.firePropertyChange(PROP_SPECIALCOLORS, oldSpecialColors, specialColors);
    }

    public String getFillTexture() {
        return this.fillTexture;
    }

    public void setFillTexture(String fillTexture) {
        String oldFillTexture = this.fillTexture;
        this.fillTexture = fillTexture;
        this.propertyChangeSupport.firePropertyChange(PROP_FILLTEXTURE, oldFillTexture, fillTexture);
    }

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.setColor(this.getColorControl("color", this.color));
        this.setFillColor(this.getColorControl("fillColor", this.fillColor));
        this.setFillDirection(this.getControl(PROP_FILLDIRECTION, "both"));
        this.setLineWidth(this.getDoubleControl("lineThick", this.lineWidth));
        this.setSymSize(this.getDoubleControl("symbolSize", this.symSize));
        this.setPsym(SeriesRenderer.decodePlotSymbolControl(this.getControl("symbol", SeriesRenderer.encodePlotSymbolControl(this.psym)), this.psym));
        this.setDrawError(this.getBooleanControl(PROP_DRAWERROR, this.drawError));
        this.setBackgroundThick(this.getControl(CONTROL_KEY_BACKGROUND_THICK, this.backgroundThick));
        this.setFillStyle(SeriesRenderer.decodeFillStyle(this.getControl(CONTROL_KEY_FILL_STYLE, SeriesRenderer.encodeFillStyle(this.fillStyle)), this.fillStyle));
        this.setSpecialColors(this.getControl(PROP_SPECIALCOLORS, ""));
        this.setFillTexture(this.getControl(PROP_FILLTEXTURE, ""));
        this.setModuloY(SeriesRenderer.decodeDatum(this.getControl(PROP_MODULO_Y, SeriesRenderer.encodeDatum(this.moduloY)), this.moduloY));
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("color", SeriesRenderer.encodeColorControl(this.color));
        controls.put("fillColor", SeriesRenderer.encodeColorControl(this.fillColor));
        controls.put(PROP_FILLDIRECTION, String.valueOf(this.fillDirection));
        controls.put("lineThick", String.valueOf(this.lineWidth));
        controls.put("symbolSize", String.valueOf(this.symSize));
        controls.put("symbol", SeriesRenderer.encodePlotSymbolControl(this.psym));
        controls.put(PROP_DRAWERROR, SeriesRenderer.encodeBooleanControl(this.drawError));
        controls.put(CONTROL_KEY_BACKGROUND_THICK, this.backgroundThick);
        controls.put(CONTROL_KEY_FILL_STYLE, SeriesRenderer.encodeFillStyle(this.fillStyle));
        controls.put(PROP_SPECIALCOLORS, this.specialColors);
        controls.put(PROP_FILLTEXTURE, this.fillTexture);
        controls.put(PROP_MODULO_Y, SeriesRenderer.encodeDatum(this.moduloY));
        return SeriesRenderer.formatControl(controls);
    }

    private QDataSet ytagsDataSet(QDataSet ds) {
        QDataSet vds;
        if (ds.rank() == 2 && SemanticOps.isBundle((QDataSet)ds)) {
            vds = SemanticOps.ytagsDataSet((QDataSet)ds);
        } else {
            if (ds.rank() == 2) {
                this.postMessage("dataset is rank 2 and not a bundle", DasPlot.INFO, null, null);
                return null;
            }
            vds = ds;
        }
        return vds;
    }

    private QDataSet colorByDataSet(QDataSet ds) {
        QDataSet colorByDataSet1 = null;
        if (this.colorByDataSetId.length() > 0) {
            if (this.colorByDataSetId.equals("PLANE_0")) {
                colorByDataSet1 = (QDataSet)ds.property("PLANE_0");
                if (colorByDataSet1 == null && ds.rank() == 2) {
                    colorByDataSet1 = DataSetOps.unbundleDefaultDataSet((QDataSet)ds);
                }
                if (colorByDataSet1 != null && colorByDataSet1.rank() != 1) {
                    colorByDataSet1 = null;
                }
            } else if (ds.rank() == 2) {
                colorByDataSet1 = DataSetOps.unbundle((QDataSet)ds, (String)this.colorByDataSetId);
            }
        }
        return colorByDataSet1;
    }

    private double doubleValue(Datum d, Units u) {
        if (d.getUnits().isConvertibleTo(u)) {
            return d.doubleValue(u);
        }
        try {
            return d.value();
        }
        catch (IllegalArgumentException ex) {
            throw new InconvertibleUnitsException(d.getUnits(), u);
        }
    }

    private DataGeneralPathBuilder getPathBuilderForData(DasAxis xAxis, DasAxis yAxis, QDataSet xds, QDataSet vds) {
        DataGeneralPathBuilder pathBuilder = new DataGeneralPathBuilder(xAxis, yAxis);
        Object modulo = null;
        Datum sw = null;
        try {
            sw = this.getCadence(xds, vds, this.firstIndex, this.lastIndex);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.WARNING, null, ex);
        }
        if (sw != null) {
            boolean logStep;
            double xSampleWidth;
            if (UnitsUtil.isRatiometric((Units)sw.getUnits())) {
                xSampleWidth = sw.doubleValue(Units.logERatio);
                logStep = true;
            } else {
                Units xUnits = SemanticOps.getUnits((QDataSet)xds);
                xSampleWidth = this.doubleValue(sw, xUnits.getOffsetUnits());
                logStep = false;
                if (xUnits == Units.decimalYear) {
                    xSampleWidth = Units.days.createDatum(xSampleWidth * 366.0).doubleValue(Units.days);
                    sw = Units.days.createDatum(xSampleWidth);
                }
            }
            int cadenceGapCount = 0;
            double xSampleWidthFudge = xSampleWidth * 1.2;
            if (logStep) {
                for (int i = 1; i < xds.length(); ++i) {
                    if (!(Math.log(xds.value(i) / xds.value(i - 1)) > xSampleWidthFudge)) continue;
                    ++cadenceGapCount;
                }
            } else {
                for (int i = 1; i < xds.length(); ++i) {
                    if (!(xds.value(i) - xds.value(i - 1) > xSampleWidthFudge)) continue;
                    ++cadenceGapCount;
                }
            }
            if (cadenceGapCount > vds.length() / 2 || !this.cadenceCheck) {
                pathBuilder.setCadence(null);
            } else {
                pathBuilder.setCadence(sw);
            }
        }
        return pathBuilder;
    }

    private double midPointData(DasAxis axis, double d1, Units units, double delta, boolean ratiometric, double alpha) {
        double fx1 = axis.isLog() && ratiometric ? Math.exp(Math.log(d1) + delta * alpha) : d1 + delta * alpha;
        return fx1;
    }

    private double midPointData(DasAxis axis, double d1, double d2, boolean ratiometric) {
        double fx1 = axis.isLog() && ratiometric ? Math.exp((Math.log(d1) + Math.log(d2)) / 2.0) : (d1 + d2) / 2.0;
        return fx1;
    }

    private Datum getCadence(QDataSet xds, QDataSet yds, int firstIndex, int lastIndex) {
        if (xds == this.xdsc && yds == this.ydsc && firstIndex == this.firstIndexc && lastIndex == this.lastIndexc && this.cadencec != null) {
            logger.finer("cache hit avoids recalculating cadence");
            return this.cadencec;
        }
        logger.finer("cache miss means we must recalculate cadence");
        WritableDataSet xds1 = Ops.copy((QDataSet)xds.trim(firstIndex, lastIndex));
        QDataSet yds1 = yds.trim(firstIndex, lastIndex);
        xds1.putProperty("CADENCE", null);
        if (xds1.rank() == 2) {
            return null;
        }
        QDataSet explicitCadence = (QDataSet)xds.property("CADENCE");
        this.cadencec = SemanticOps.guessXTagWidth((QDataSet)xds1, (QDataSet)yds1);
        if (explicitCadence != null) {
            this.cadencec = DataSetUtil.asDatum((QDataSet)explicitCadence);
        }
        this.xdsc = xds;
        this.ydsc = yds;
        this.firstIndexc = firstIndex;
        this.lastIndexc = lastIndex;
        return this.cadencec;
    }

    private void updatePsym() {
        double dcmy;
        double dcmx;
        if (!this.isActive()) {
            return;
        }
        int sx = 6 + (int)Math.ceil(this.symSize + 2.0f * this.lineWidth);
        int sy = 6 + (int)Math.ceil(this.symSize + 2.0f * this.lineWidth);
        if (this.fillStyle == FillStyle.STYLE_OUTLINE) {
            dcmx = this.lineWidth + (float)((int)Math.ceil(this.symSize / 2.0f)) + 2.0f;
            dcmy = this.lineWidth + (float)((int)Math.ceil(this.symSize / 2.0f)) + 2.0f;
        } else {
            dcmx = (double)((int)Math.ceil(this.symSize / 2.0f)) + 2.5;
            dcmy = (double)((int)Math.ceil(this.symSize / 2.0f)) + 2.5;
        }
        BufferedImage image = new BufferedImage(sx, sy, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        Object rendering = this.antiAliased ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rendering);
        g.setColor(this.color);
        DasPlot lparent = this.getParent();
        if (lparent == null) {
            return;
        }
        g.setBackground(lparent.getBackground());
        g.setStroke(new BasicStroke(this.lineWidth));
        this.psym.draw(g, dcmx, dcmy, this.symSize, this.fillStyle);
        this.psymImage = image;
        DasColorBar lcolorBar = this.colorBar;
        if (this.colorByDataSetId != null && !this.colorByDataSetId.equals("") && lcolorBar != null) {
            this.initColoredPsyms(sx, sy, image, g, lparent, lcolorBar, rendering, dcmx, dcmy);
            this.initSpecialColorPsyms(sx, sy, image, g, lparent, lcolorBar, rendering, dcmx, dcmy);
        }
        this.cmx = (int)dcmx;
        this.cmy = (int)dcmy;
        this.update();
    }

    private void initColoredPsyms(int sx, int sy, BufferedImage image, Graphics2D g, DasPlot lparent, DasColorBar lcolorBar, Object rendering, double dcmx, double dcmy) {
        IndexColorModel model = lcolorBar.getIndexColorModel();
        this.coloredPsyms = new Image[model.getMapSize()];
        for (int i = 0; i < model.getMapSize(); ++i) {
            Color c = new Color(model.getRGB(i));
            image = this.drawPlotSymbolStamp(c, sx, sy, lparent, rendering, dcmx, dcmy);
            this.coloredPsyms[i] = image;
        }
    }

    private void initSpecialColorPsyms(int sx, int sy, BufferedImage image, Graphics2D g, DasPlot lparent, DasColorBar lcolorBar, Object rendering, double dcmx, double dcmy) {
        String[] ss;
        this.specialColorPsyms = new LinkedHashMap<Color, Image>();
        for (String s : ss = this.specialColors.split(",", -2)) {
            String[] dc = s.split(":", -2);
            if (dc.length <= 1) continue;
            Color c = ColorUtil.decodeColor((String)dc[1]);
            image = this.drawPlotSymbolStamp(c, sx, sy, lparent, rendering, dcmx, dcmy);
            this.specialColorPsyms.put(c, image);
        }
    }

    private BufferedImage drawPlotSymbolStamp(Color c, int sx, int sy, DasPlot lparent, Object rendering, double dcmx, double dcmy) {
        BufferedImage image = new BufferedImage(sx, sy, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setBackground(lparent.getBackground());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rendering);
        g.setColor(c);
        g.setStroke(new BasicStroke(this.lineWidth));
        this.psym.draw(g, dcmx, dcmy, this.symSize, this.fillStyle);
        return image;
    }

    private synchronized void updateFirstLast(DasAxis xAxis, DasAxis yAxis, QDataSet xds, QDataSet dataSet) {
        int index;
        int ixmax;
        int ixmin;
        long t0 = System.currentTimeMillis();
        this.firstIndex = -1;
        QDataSet yds = dataSet;
        if (xds.length() != yds.length()) {
            logger.fine("xds and yds have different lengths.  Assuming transitional case.");
            this.firstIndex_v = 0;
            this.lastIndex_v = xds.length();
            this.firstIndex = 0;
            this.lastIndex = xds.length();
            return;
        }
        if (yds.rank() == 2) {
            MutablePropertyDataSet yds1 = DataSetOps.slice1((QDataSet)yds, (int)0);
            if (Ops.total((QDataSet)Ops.valid((QDataSet)yds1), (int)0).value() == 0.0) {
                yds1 = DataSetOps.slice1((QDataSet)yds, (int)(yds.length(0) / 3));
            }
            yds = yds1;
        }
        if (yds.rank() == 3) {
            this.firstIndex = 0;
            this.lastIndex = xds.length();
            this.dataIsMonotonic = false;
            return;
        }
        if (xds.rank() == 2) {
            if (SemanticOps.isRank3JoinOfRank2Waveform((QDataSet)dataSet)) {
                xds = DataSetOps.slice1((QDataSet)xds, (int)0);
            } else if (xds.property("BINS_1") != null) {
                xds = Ops.reduceMean((QDataSet)xds, (int)1);
            } else {
                this.firstIndex = 0;
                this.lastIndex = xds.length();
                this.dataIsMonotonic = false;
                return;
            }
        }
        QDataSet wxds = SemanticOps.weightsDataSet((QDataSet)xds);
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)yds);
        DasPlot lparent = this.getParent();
        this.dslen = xds.length();
        this.dataIsMonotonic = SemanticOps.isMonotonic((QDataSet)xds);
        if (this.dataIsMonotonic) {
            DatumRange visibleRange = xAxis.getDatumRange();
            Units xdsu = SemanticOps.getUnits((QDataSet)xds);
            if (!visibleRange.getUnits().isConvertibleTo(xdsu)) {
                visibleRange = new DatumRange(visibleRange.min().doubleValue(visibleRange.getUnits()), visibleRange.max().doubleValue(visibleRange.getUnits()), xdsu);
            }
            this.firstIndex_v = DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)visibleRange.min());
            this.lastIndex_v = DataSetUtil.getNextIndex((QDataSet)xds, (Datum)visibleRange.max()) + 1;
            if (lparent != null && lparent.isOverSize()) {
                Rectangle plotBounds = lparent.getUpdateImageBounds();
                if (plotBounds != null) {
                    visibleRange = xAxis.invTransform(plotBounds.x, plotBounds.x + plotBounds.width);
                }
                try {
                    ixmin = DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)visibleRange.min());
                    ixmax = DataSetUtil.getNextIndex((QDataSet)xds, (Datum)visibleRange.max()) + 1;
                }
                catch (IllegalArgumentException ex) {
                    ixmin = this.firstIndex_v;
                    ixmax = this.lastIndex_v;
                }
            } else {
                ixmin = this.firstIndex_v;
                ixmax = this.lastIndex_v;
            }
        } else {
            ixmin = 0;
            ixmax = xds.length();
            this.firstIndex_v = ixmin;
            this.lastIndex_v = ixmax;
        }
        for (index = ixmin; index < ixmax; ++index) {
            boolean isValid;
            boolean bl = isValid = wds.value(index) > 0.0 && wxds.value(index) > 0.0;
            if (!isValid) continue;
            this.firstIndex = index++;
            break;
        }
        if (this.firstIndex == -1) {
            this.lastIndex = ixmax;
            this.firstIndex = ixmax;
        }
        int pointsPlotted = 0;
        for (index = this.firstIndex; index < ixmax && pointsPlotted < this.dataSetSizeLimit; ++index) {
            boolean isValid;
            boolean bl = isValid = wds.value(index) > 0.0 && wxds.value(index) > 0.0;
            if (!isValid) continue;
            ++pointsPlotted;
        }
        if (index < ixmax && pointsPlotted == this.dataSetSizeLimit) {
            this.dataSetReduced = true;
            this.lastIndex = ixmax;
        } else {
            this.lastIndex = index;
        }
        if (this.firstIndex == this.lastIndex && this.lastIndex == xds.length()) {
            logger.info("all data removed in firstIndex/lastIndex");
        } else {
            logger.fine("some data found in firstIndex/lastIndex");
        }
        logger.log(Level.FINE, "updateFirstLast ds: {0},  firstIndex={1} to lastIndex={2} in {3}ms", new Object[]{String.valueOf(this.ds), this.firstIndex, this.lastIndex, System.currentTimeMillis() - t0});
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.updatePsym();
        }
    }

    public boolean isAdditionalClip() {
        return this.additionalClip;
    }

    public void setAdditionalClip(boolean additionalClip) {
        boolean oldAdditionalClip = this.additionalClip;
        this.additionalClip = additionalClip;
        this.propertyChangeSupport.firePropertyChange(PROP_ADDITIONALCLIP, oldAdditionalClip, additionalClip);
    }

    @Override
    public synchronized void render(Graphics2D g, DasAxis xAxis, DasAxis yAxis) {
        int connectCount;
        boolean drawBackground;
        boolean yaxisUnitsOkay;
        Units yunits;
        NullProgressMonitor monitor = new NullProgressMonitor();
        DasPlot lparent = this.getParent();
        logger.log(Level.FINE, "enter {0}.render: {1}", new Object[]{this.id, String.valueOf(this.getDataSet())});
        logger.log(Level.FINER, "ds: {0},  drawing indeces {1} to {2}", new Object[]{String.valueOf(this.ds), this.firstIndex, this.lastIndex});
        if (this.ds == null && this.lastException != null) {
            if (lparent != null) {
                lparent.postException(this, this.lastException);
            }
            return;
        }
        if (this.renderException != null) {
            if (lparent != null) {
                lparent.postException(this, this.renderException);
            }
            return;
        }
        long timer0 = System.currentTimeMillis();
        QDataSet dataSet = this.getDataSet();
        if (dataSet == null) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("null data set");
            if (lparent != null) {
                lparent.postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
            }
            return;
        }
        if (dataSet.rank() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("rank 0 data set");
        } else {
            if (dataSet.length() == 0) {
                DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("empty data set");
                if (lparent != null) {
                    lparent.postMessage((Renderer)this, "empty data set", DasPlot.INFO, null, null);
                }
                return;
            }
            if (!(dataSet.rank() == 1 || SemanticOps.isBundle((QDataSet)this.ds) || SemanticOps.isRank2Waveform((QDataSet)this.ds) || SemanticOps.isRank3JoinOfRank2Waveform((QDataSet)this.ds))) {
                DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("dataset is not rank 1 or a rank 2 waveform");
                if (lparent != null) {
                    lparent.postMessage((Renderer)this, "dataset is not rank 1 or a rank 2 waveform", DasPlot.INFO, null, null);
                }
                return;
            }
        }
        if (this.psym == DefaultPlotSymbol.NONE && this.psymConnector == PsymConnector.NONE && !this.drawError) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("plot symbol and symbol connector are set to none");
            if (lparent != null) {
                lparent.postMessage((Renderer)this, "plot symbol and symbol connector are set to none", DasPlot.INFO, null, null);
            }
        }
        if (lparent != null) {
            boolean foreBackSameColor = true;
            if (!this.color.equals(lparent.getBackground())) {
                foreBackSameColor = false;
            }
            if (this.fillToReference && !this.color.equals(lparent.getBackground())) {
                foreBackSameColor = false;
            }
            if (lparent.getRenderers().length > 1) {
                foreBackSameColor = false;
            }
            if (foreBackSameColor) {
                DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("foreground and background colors are the same");
                if (this.getPsym() != DefaultPlotSymbol.NONE) {
                    lparent.postMessage((Renderer)this, "symbol color and background color are the same", DasPlot.INFO, null, null);
                } else {
                    lparent.postMessage((Renderer)this, "line color and background color are the same", DasPlot.INFO, null, null);
                }
            }
        }
        QDataSet tds = null;
        QDataSet vds = null;
        QDataSet xds = this.getXTags(dataSet);
        boolean xaxisUnitsOkay = SemanticOps.getUnits((QDataSet)xds).isConvertibleTo(xAxis.getUnits());
        if (!SemanticOps.isTableDataSet((QDataSet)dataSet)) {
            vds = this.ytagsDataSet(this.ds);
            yunits = SemanticOps.getUnits((QDataSet)vds);
            yaxisUnitsOkay = yunits.isConvertibleTo(yAxis.getUnits());
        } else {
            tds = dataSet;
            yunits = SemanticOps.getUnits((QDataSet)tds);
            yaxisUnitsOkay = SemanticOps.getUnits((QDataSet)tds).isConvertibleTo(yAxis.getUnits());
        }
        boolean haveReportedUnitProblem = false;
        if (!xaxisUnitsOkay && !yaxisUnitsOkay && vds != null && SemanticOps.getUnits((QDataSet)xds) == SemanticOps.getUnits((QDataSet)vds) && xAxis.getUnits() == yAxis.getUnits()) {
            if (this.unitsWarning) {
                if (lparent != null) {
                    lparent.postMessage((Renderer)this, "axis units changed from \"" + SemanticOps.getUnits((QDataSet)vds) + "\" to \"" + yAxis.getUnits() + "\"", DasPlot.INFO, null, null);
                }
                haveReportedUnitProblem = true;
            } else {
                if (lparent != null) {
                    lparent.postMessage((Renderer)this, "inconvertible axis units", DasPlot.INFO, null, null);
                }
                return;
            }
        }
        if (!haveReportedUnitProblem && !yaxisUnitsOkay) {
            if (this.unitsWarning) {
                if (vds != null) {
                    if (yAxis.getUnits() == Units.dimensionless) {
                        logger.log(Level.FINE, "data units \"{0}\" plotted on dimensionless axis", SemanticOps.getUnits((QDataSet)vds));
                    } else if (lparent != null) {
                        lparent.postMessage((Renderer)this, "yaxis units changed from \"" + SemanticOps.getUnits((QDataSet)vds) + "\" to \"" + yAxis.getUnits() + "\"", DasPlot.INFO, null, null);
                    }
                }
            } else {
                if (lparent != null) {
                    lparent.postMessage((Renderer)this, "inconvertible yaxis units", DasPlot.INFO, null, null);
                }
                return;
            }
        }
        if (!haveReportedUnitProblem && !xaxisUnitsOkay) {
            if (this.xunitsWarning) {
                if (xAxis.getUnits() == Units.dimensionless) {
                    logger.log(Level.FINE, "data units \"{0}\" plotted on dimensionless axis", SemanticOps.getUnits((QDataSet)xds));
                } else if (lparent != null) {
                    lparent.postMessage((Renderer)this, "xaxis units changed from \"" + SemanticOps.getUnits((QDataSet)xds) + "\" to \"" + xAxis.getUnits() + "\"", DasPlot.INFO, null, null);
                }
            } else {
                if (lparent != null) {
                    lparent.postMessage((Renderer)this, "inconvertible xaxis units", DasPlot.INFO, null, null);
                }
                return;
            }
        }
        int messageCount = 0;
        logger.log(Level.FINER, "rendering points: ds[{0}:{1}]", new Object[]{this.firstIndex, this.lastIndex});
        if (dataSet.rank() > 0 && this.lastIndex == -1) {
            if (messageCount++ == 0 && lparent != null) {
                lparent.postMessage((Renderer)this, "need to update first/last", DasPlot.INFO, null, null);
            }
            this.update();
            Timer t = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SeriesRenderer.this.update();
                }
            });
            t.setRepeats(false);
            t.restart();
        }
        if (lparent != null && this.lastIndex == this.firstIndex && dataSet.rank() > 0 && this.firstValidIndex == this.lastValidIndex && !this.dataSetReduced && messageCount++ == 0) {
            lparent.postMessage((Renderer)this, "dataset contains no valid data", DasPlot.INFO, null, null);
        }
        Graphics2D graphics = g;
        if (this.antiAliased) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        monitor.started();
        boolean bl = drawBackground = this.backgroundThick.length() > 0;
        if (SemanticOps.isRank2Waveform((QDataSet)dataSet)) {
            if (drawBackground) {
                this.psymConnectorElement.renderBackground(graphics);
                if (this.drawError) {
                    this.errorElement.renderBackground(graphics);
                }
            }
            graphics.setColor(this.color);
            logger.log(Level.FINEST, "drawing psymConnector in {0}", this.color);
            connectCount = this.psymConnectorElement.render((Graphics2D)graphics.create(), xAxis, yAxis, dataSet, monitor.getSubtaskMonitor("psymConnectorElement.render"));
            logger.log(Level.FINEST, "connectCount: {0}", connectCount);
            if (this.drawError) {
                this.errorElement.render((Graphics2D)graphics.create(), xAxis, yAxis, dataSet, monitor.getSubtaskMonitor("errorElement.render"));
            }
            if (this.psym != DefaultPlotSymbol.NONE) {
                int symCount = this.psymsElement.render((Graphics2D)graphics.create(), xAxis, yAxis, dataSet, monitor.getSubtaskMonitor("psymsElement.render"));
                logger.log(Level.FINEST, "symCount: {0}", symCount);
            }
        } else if (dataSet.rank() == 2 && dataSet.length(0) == 3 && !SemanticOps.isRank2Waveform((QDataSet)dataSet)) {
            QDataSet xx = SemanticOps.xtagsDataSet((QDataSet)dataSet);
            QDataSet yy = SemanticOps.ytagsDataSet((QDataSet)dataSet);
            QDataSet zz = Ops.slice1((QDataSet)dataSet, (int)2);
            QDataSet theDs = Ops.link((QDataSet)xx, (QDataSet)yy);
            theDs = Ops.putProperty((QDataSet)theDs, (String)"PLANE_0", (Object)zz);
            if (drawBackground) {
                this.fillElement.renderBackground(g);
                this.psymConnectorElement.renderBackground(graphics);
                if (this.drawError) {
                    this.errorElement.renderBackground(graphics);
                }
                if (this.psym != DefaultPlotSymbol.NONE) {
                    this.psymsElement.renderBackground(graphics);
                }
            }
            if (this.fillToReference) {
                this.fillElement.render((Graphics2D)graphics.create(), xAxis, yAxis, theDs, monitor.getSubtaskMonitor("fillElement.render"));
            }
            graphics.setColor(this.color);
            logger.log(Level.FINEST, "drawing psymConnector in {0}", this.color);
            if (this.drawError) {
                this.errorElement.render((Graphics2D)graphics.create(), xAxis, yAxis, theDs, monitor.getSubtaskMonitor("errorElement.render"));
            }
            int connectCount2 = this.psymConnectorElement.render(graphics, xAxis, yAxis, theDs, monitor.getSubtaskMonitor("psymConnectorElement.render"));
            logger.log(Level.FINEST, "connectCount: {0}", connectCount2);
            if (this.psym != DefaultPlotSymbol.NONE) {
                int symCount = this.psymsElement.render((Graphics2D)graphics.create(), xAxis, yAxis, theDs, monitor.getSubtaskMonitor("psymsElement.render"));
                logger.log(Level.FINEST, "symCount: {0}", symCount);
            }
        } else if (tds != null) {
            if (drawBackground) {
                this.psymConnectorElement.renderBackground(graphics);
                if (this.drawError) {
                    this.errorElement.renderBackground(graphics);
                }
            }
            graphics.setColor(this.color);
            logger.log(Level.FINEST, "drawing psymConnector in {0}", this.color);
            connectCount = this.psymConnectorElement.render((Graphics2D)graphics.create(), xAxis, yAxis, tds, monitor.getSubtaskMonitor("psymConnectorElement.render"));
            logger.log(Level.FINEST, "connectCount: {0}", connectCount);
            if (this.drawError) {
                this.errorElement.render((Graphics2D)graphics.create(), xAxis, yAxis, tds, monitor.getSubtaskMonitor("errorElement.render"));
            }
        } else {
            if (drawBackground) {
                this.fillElement.renderBackground(g);
                this.psymConnectorElement.renderBackground(graphics);
                if (this.drawError) {
                    this.errorElement.renderBackground(graphics);
                }
                if (this.psym != DefaultPlotSymbol.NONE) {
                    this.psymsElement.renderBackground(graphics);
                }
            }
            if (this.fillToReference) {
                this.fillElement.render((Graphics2D)graphics.create(), xAxis, yAxis, vds, monitor.getSubtaskMonitor("fillElement.render"));
            }
            graphics.setColor(this.color);
            logger.log(Level.FINEST, "drawing psymConnector in {0}", this.color);
            if (this.drawError) {
                this.errorElement.render((Graphics2D)graphics.create(), xAxis, yAxis, vds, monitor.getSubtaskMonitor("errorElement.render"));
            }
            connectCount = this.psymConnectorElement.render(graphics, xAxis, yAxis, vds, monitor.getSubtaskMonitor("psymConnectorElement.render"));
            logger.log(Level.FINEST, "connectCount: {0}", connectCount);
            if (this.psym != DefaultPlotSymbol.NONE) {
                int symCount = this.psymsElement.render((Graphics2D)graphics.create(), xAxis, yAxis, vds, monitor.getSubtaskMonitor("psymsElement.render"));
                logger.log(Level.FINEST, "symCount: {0}", symCount);
            }
        }
        this.drawLimits(graphics, yAxis, yunits);
        monitor.finished();
        long milli = System.currentTimeMillis();
        long renderTime = milli - timer0;
        double dppms = (double)(this.lastIndex - this.firstIndex) / (double)renderTime;
        this.addToStats(this.numberOfPoints, renderTime, 'r');
        this.setRenderPointsPerMillisecond(dppms);
        logger.log(Level.FINE, "render: {0}ms total:{1} fps:{2} pts/ms:{3}", new Object[]{renderTime, milli - this.lastUpdateMillis, 1000.0 / (double)(milli - this.lastUpdateMillis), dppms});
        this.lastUpdateMillis = milli;
        int ldataSetSizeLimit = this.getDataSetSizeLimit();
        if (lparent != null) {
            if (this.dataSetClipped) {
                lparent.postMessage((Renderer)this, "dataset clipped at " + ldataSetSizeLimit + " points", DasPlot.WARNING, null, null);
            }
            if (!this.dataSetReduced) {
                if (this.lastIndex_v - this.firstIndex_v < 2 && dataSet.rank() > 0 && dataSet.length() > 1 && messageCount++ == 0) {
                    if (this.lastIndex_v < 2) {
                        if (this.firstValidIndex == this.lastValidIndex) {
                            if (this.firstValidIndex == 0) {
                                lparent.postMessage((Renderer)this, "data starts after range", DasPlot.INFO, null, null);
                            } else {
                                lparent.postMessage((Renderer)this, "dataset contains no plottable data", DasPlot.INFO, null, null);
                            }
                        } else {
                            lparent.postMessage((Renderer)this, "data starts after range", DasPlot.INFO, null, null);
                        }
                    } else if (this.dslen - this.firstIndex_v < 2) {
                        lparent.postMessage((Renderer)this, "data ends before range", DasPlot.INFO, null, null);
                    } else {
                        lparent.postMessage((Renderer)this, "fewer than two points visible", DasPlot.INFO, null, null);
                    }
                }
            } else if (this.lastIndex_v - this.firstIndex_v < 1 && dataSet.rank() > 0 && dataSet.length() > 1) {
                lparent.postMessage((Renderer)this, "no data is visible", DasPlot.INFO, null, null);
            }
        }
        graphics.dispose();
    }

    private void drawLimits(Graphics2D graphics, DasAxis yAxis, Units yunits) {
        Map meta = (Map)this.ds.property("METADATA");
        if (meta != null && this.showLimits) {
            Line2D.Double l;
            double iy;
            DasColumn col = this.getParent().getColumn();
            Graphics2D graphics1 = (Graphics2D)graphics.create();
            Number d = SeriesRenderer.getKey(meta, "LIMITS_WARN_MIN", Number.class);
            if (d != null) {
                iy = yAxis.transform(d.doubleValue(), yunits);
                l = new Line2D.Double(col.getDMinimum(), iy, col.getDMaximum(), iy);
                graphics1.setColor(Color.RED);
                graphics1.setStroke(PsymConnector.DASHES.getStroke(1.0f));
                graphics1.draw(l);
            }
            if ((d = SeriesRenderer.getKey(meta, "LIMITS_WARN_MAX", Number.class)) != null) {
                iy = yAxis.transform(d.doubleValue(), yunits);
                l = new Line2D.Double(col.getDMinimum(), iy, col.getDMaximum(), iy);
                graphics1.setColor(Color.RED);
                graphics1.setStroke(PsymConnector.DASHES.getStroke(1.0f));
                graphics1.draw(l);
            }
            if ((d = SeriesRenderer.getKey(meta, "LIMITS_NOMINAL_MIN", Number.class)) != null) {
                iy = yAxis.transform(d.doubleValue(), yunits);
                l = new Line2D.Double(col.getDMinimum(), iy, col.getDMaximum(), iy);
                graphics1.setColor(Color.YELLOW);
                graphics1.setStroke(PsymConnector.DASHES.getStroke(1.0f));
                graphics1.draw(l);
            }
            if ((d = SeriesRenderer.getKey(meta, "LIMITS_NOMINAL_MAX", Number.class)) != null) {
                iy = yAxis.transform(d.doubleValue(), yunits);
                l = new Line2D.Double(col.getDMinimum(), iy, col.getDMaximum(), iy);
                graphics1.setColor(Color.YELLOW);
                graphics1.setStroke(PsymConnector.DASHES.getStroke(1.0f));
                graphics1.draw(l);
            }
        }
    }

    private static <T> T getKey(Map<String, Object> meta, String key, Class<T> type) {
        Object o = meta.get(key);
        if (o == null || !type.isInstance(o)) {
            return null;
        }
        return type.cast(o);
    }

    private QDataSet doDataSetReduce(DasAxis xAxis, DasAxis yAxis, QDataSet vds, int xlimit, int ylimit) {
        int jj;
        int ii;
        QDataSet hds;
        QDataSet yyy;
        double max;
        double min;
        int nstep;
        QDataSet xxx;
        double max2;
        double min2;
        int nstep2;
        DatumRange xdr = xAxis.getDatumRange();
        if (xAxis.isLog()) {
            nstep2 = Math.max(2, 2 * xAxis.getDLength());
            min2 = Math.log10(xdr.min().doubleValue(xdr.getUnits()));
            max2 = Math.log10(xdr.max().doubleValue(xdr.getUnits()));
            xxx = Ops.exp10((QDataSet)Ops.linspace((double)min2, (double)max2, (int)nstep2));
        } else {
            nstep2 = Math.max(2, 2 * xAxis.getDLength() / xlimit);
            min2 = xdr.min().doubleValue(xdr.getUnits());
            max2 = xdr.max().doubleValue(xdr.getUnits());
            xxx = Ops.linspace((double)min2, (double)max2, (int)nstep2);
        }
        MutablePropertyDataSet mxxx = DataSetOps.makePropertiesMutable((QDataSet)xxx);
        mxxx.putProperty("UNITS", (Object)xdr.getUnits());
        if (xAxis.isLog()) {
            mxxx.putProperty("SCALE_TYPE", (Object)"log");
        }
        DatumRange ydr = yAxis.getDatumRange();
        if (yAxis.isLog()) {
            nstep = Math.max(2, 2 * yAxis.getDLength());
            min = Math.log10(ydr.min().doubleValue(ydr.getUnits()));
            max = Math.log10(ydr.max().doubleValue(ydr.getUnits()));
            yyy = Ops.exp10((QDataSet)Ops.linspace((double)min, (double)max, (int)nstep));
        } else {
            nstep = Math.max(2, 2 * yAxis.getDLength() / ylimit);
            min = ydr.min().doubleValue(ydr.getUnits());
            max = ydr.max().doubleValue(ydr.getUnits());
            yyy = Ops.linspace((double)min, (double)max, (int)nstep);
        }
        MutablePropertyDataSet myyy = DataSetOps.makePropertiesMutable((QDataSet)yyy);
        myyy.putProperty("UNITS", (Object)ydr.getUnits());
        if (yAxis.isLog()) {
            myyy.putProperty("SCALE_TYPE", (Object)"log");
        }
        long tt0 = System.currentTimeMillis();
        if (mxxx.length() < 2 || myyy.length() < 2) {
            logger.warning("that strange case where Kris saw  rte_1852410924");
            return vds;
        }
        try {
            hds = Reduction.histogram2D((QDataSet)vds, (QDataSet)mxxx, (QDataSet)myyy);
        }
        catch (InconvertibleUnitsException u) {
            if (!(SemanticOps.getUnits((QDataSet)myyy).isConvertibleTo(SemanticOps.getUnits((QDataSet)vds)) || SemanticOps.getUnits((QDataSet)myyy) != Units.dimensionless && SemanticOps.getUnits((QDataSet)vds) != Units.dimensionless)) {
                myyy.putProperty("UNITS", (Object)SemanticOps.getUnits((QDataSet)vds));
            }
            if (vds.property("DEPEND_0") != null) {
                Units dsxunits = SemanticOps.getUnits((QDataSet)((QDataSet)vds.property("DEPEND_0")));
                if (!(SemanticOps.getUnits((QDataSet)mxxx).isConvertibleTo(dsxunits) || SemanticOps.getUnits((QDataSet)mxxx) != Units.dimensionless && dsxunits != Units.dimensionless)) {
                    mxxx.putProperty("UNITS", (Object)dsxunits);
                }
            }
            hds = Reduction.histogram2D((QDataSet)vds, (QDataSet)mxxx, (QDataSet)myyy);
        }
        QDataSet colors = this.colorByDataSet(vds);
        if (colors != null) {
            colors = Reduction.lastPointAt2D((QDataSet)colors, (QDataSet)SemanticOps.xtagsDataSet((QDataSet)vds), (QDataSet)SemanticOps.ytagsDataSet((QDataSet)vds), (QDataSet)mxxx, (QDataSet)myyy);
        }
        logger.log(Level.FINEST, "done histogram2D ({0}ms)", System.currentTimeMillis() - tt0);
        DataSetBuilder buildx = new DataSetBuilder(1, 100);
        DataSetBuilder buildy = new DataSetBuilder(1, 100);
        DataSetBuilder buildc = null;
        if (colors != null) {
            buildc = new DataSetBuilder(1, 100);
            buildc.putProperty("UNITS", colors.property("UNITS"));
            for (ii = 0; ii < hds.length(); ++ii) {
                for (jj = 0; jj < hds.length(0); ++jj) {
                    if (!(hds.value(ii, jj) > 0.0)) continue;
                    buildx.nextRecord(xxx.value(ii));
                    buildy.nextRecord(yyy.value(jj));
                    buildc.nextRecord(colors.value(ii, jj));
                }
            }
        } else {
            for (ii = 0; ii < hds.length(); ++ii) {
                for (jj = 0; jj < hds.length(0); ++jj) {
                    if (!(hds.value(ii, jj) > 0.0)) continue;
                    buildx.putValue(-1, xxx.value(ii));
                    buildy.putValue(-1, yyy.value(jj));
                    buildx.nextRecord();
                    buildy.nextRecord();
                }
            }
        }
        buildx.putProperty("UNITS", (Object)xdr.getUnits());
        buildy.putProperty("UNITS", (Object)ydr.getUnits());
        MutablePropertyDataSet mvds = DataSetOps.makePropertiesMutable((QDataSet)Ops.link((QDataSet)buildx.getDataSet(), (QDataSet)buildy.getDataSet()));
        Map p = DataSetUtil.getDimensionProperties((QDataSet)vds, null);
        p.remove("VALID_MIN");
        p.remove("VALID_MAX");
        p.remove("FILL_VALUE");
        p.remove("UNITS");
        DataSetUtil.putProperties((Map)p, (MutablePropertyDataSet)mvds);
        if (buildc != null) {
            mvds.putProperty("PLANE_0", (Object)buildc.getDataSet());
        }
        return mvds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) {
        boolean plottable;
        Units yunits;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        long t0 = System.currentTimeMillis();
        logger.log(Level.FINE, "enter {0}.updatePlotImage: {1}", new Object[]{this.id, String.valueOf(this.getDataSet())});
        super.incrementUpdateCount();
        QDataSet dataSet = this.getDataSet();
        this.selectionArea = SelectionUtil.NULL;
        if (dataSet == null) {
            logger.fine("dataset was null");
            return;
        }
        if (dataSet.rank() == 0) {
            logger.fine("rank 0 dataset will not work with older Autoplots");
        } else if (dataSet.length() == 0) {
            logger.fine("dataset was empty");
            return;
        }
        if (!this.isActive()) {
            return;
        }
        QDataSet tds = null;
        QDataSet vds = null;
        QDataSet xds = this.getXTags(dataSet);
        if (dataSet.rank() > 0 && dataSet.rank() < 3 && !SemanticOps.isRank2Waveform((QDataSet)dataSet)) {
            vds = this.ytagsDataSet(this.ds);
            if (vds == null) {
                logger.fine("dataset is not rank 1 or a rank 2 waveform");
                return;
            }
            if (xds.rank() != 1) {
                if (xds.rank() == 2 && xds.property("BINS_1") != null) {
                    logger.info("dataset xtags is a bins dataset");
                } else if (xds.rank() == 2 && xds.length(0) == 2) {
                    logger.info("dataset xtags are undeclared bins dataset");
                } else {
                    logger.info("dataset xtags are not rank 1.");
                    return;
                }
            }
            if (vds.rank() != 1) {
                logger.fine("dataset is rank 2 and not a bundle.");
                return;
            }
            if (this.ds.rank() != 1 && !SemanticOps.isBundle((QDataSet)this.ds)) {
                logger.fine("dataset is rank 2 and not a bundle");
                return;
            }
            if (vds.length() != this.ds.length()) {
                logger.fine("dataset is rank 2 and will cause problems");
                return;
            }
            this.unitsWarning = false;
            yunits = SemanticOps.getUnits((QDataSet)vds);
            boolean bl = plottable = yunits.isConvertibleTo(yAxis.getUnits()) || yAxis.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement((Units)yunits);
            if (!plottable) {
                if (UnitsUtil.isRatioMeasurement((Units)yunits) && UnitsUtil.isRatioMeasurement((Units)yAxis.getUnits())) {
                    this.unitsWarning = true;
                }
            } else if (!yunits.isConvertibleTo(yAxis.getUnits()) && yAxis.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement((Units)yunits)) {
                this.unitsWarning = true;
            }
        } else if (SemanticOps.isRank2Waveform((QDataSet)dataSet)) {
            tds = dataSet;
            yunits = SemanticOps.getUnits((QDataSet)tds);
            boolean bl = plottable = yunits.isConvertibleTo(yAxis.getUnits()) || yAxis.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement((Units)yunits);
            if (!plottable && UnitsUtil.isRatioMeasurement((Units)yunits) && UnitsUtil.isRatioMeasurement((Units)yAxis.getUnits())) {
                this.unitsWarning = true;
            }
        } else if (SemanticOps.isRank3JoinOfRank2Waveform((QDataSet)dataSet)) {
            tds = dataSet;
            yunits = SemanticOps.getUnits((QDataSet)tds);
            boolean bl = plottable = yunits.isConvertibleTo(yAxis.getUnits()) || yAxis.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement((Units)yunits);
            if (!plottable && UnitsUtil.isRatioMeasurement((Units)yunits) && UnitsUtil.isRatioMeasurement((Units)yAxis.getUnits())) {
                this.unitsWarning = true;
            }
        }
        boolean isAlongTrajectory = vds != null && vds.rank() == 1 && xds.rank() == 2 && xds.length(0) == 2 && xds.property("BINS_1") == null;
        plottable = SemanticOps.getUnits((QDataSet)xds).isConvertibleTo(xAxis.getUnits());
        this.xunitsWarning = false;
        if (!plottable && UnitsUtil.isRatioMeasurement((Units)SemanticOps.getUnits((QDataSet)xds)) && UnitsUtil.isRatioMeasurement((Units)xAxis.getUnits())) {
            plottable = true;
            this.xunitsWarning = true;
        }
        if (!plottable) {
            return;
        }
        this.dataSetClipped = false;
        this.dataSetReduced = false;
        this.firstIndex = -1;
        this.lastIndex = -1;
        monitor.started();
        try {
            if (vds != null) {
                try {
                    this.updateFirstLast(xAxis, yAxis, xds, vds);
                }
                catch (IllegalArgumentException ex) {
                    this.renderException = ex;
                    logger.log(Level.INFO, ex.getMessage(), ex);
                    monitor.finished();
                    return;
                }
                this.numberOfPoints = this.lastIndex - this.firstIndex;
                if (Schemes.isBundleDataSet((QDataSet)this.ds)) {
                    this.dataSetReduced = false;
                }
                if (this.dataSetReduced) {
                    QDataSet mvds;
                    logger.fine("reducing data that is bigger than dataSetSizeLimit");
                    try {
                        mvds = this.doDataSetReduce(xAxis, yAxis, vds, 1, 1);
                    }
                    catch (InconvertibleUnitsException ex) {
                        logger.warning("InconvertibleUnitsException");
                        logger.log(Level.INFO, ex.getMessage(), ex);
                        monitor.finished();
                        return;
                    }
                    vds = mvds;
                    xds = SemanticOps.xtagsDataSet((QDataSet)vds);
                    this.updateFirstLast(xAxis, yAxis, xds, vds);
                    logger.log(Level.FINER, "data reduced to {0} {1}", new Object[]{vds, Ops.extent((QDataSet)xds)});
                    logger.log(Level.FINER, "reduceDataSet complete ({0}ms)", System.currentTimeMillis() - t0);
                } else {
                    logger.log(Level.FINER, "data not reduced");
                }
                if (this.fillToReference) {
                    this.fillElement.update(xAxis, yAxis, this.ds, monitor.getSubtaskMonitor("fillElement.update"));
                    logger.log(Level.FINER, "fillElement.update complete ({0}ms)", System.currentTimeMillis() - t0);
                }
            } else if (tds != null) {
                DRank0DataSet res;
                LoggerManager.resetTimer((String)"render waveform");
                this.updateFirstLast(xAxis, yAxis, xds, tds);
                LoggerManager.markTime((String)"updateFirstLast");
                if (SemanticOps.isRank2Waveform((QDataSet)dataSet)) {
                    res = DataSetUtil.asDataSet((Datum)xAxis.getDatumRange().width().divide((double)xAxis.getWidth()));
                    vds = dataSet.trim(this.firstIndex, this.lastIndex);
                    LoggerManager.markTime((String)"trim");
                    QDataSet dep1 = (QDataSet)vds.property("DEPEND_1");
                    if (dep1.rank() == 1) {
                        vds = Reduction.reducex((QDataSet)vds, (QDataSet)res);
                    }
                    LoggerManager.markTime((String)"reducex");
                    if (vds.rank() == 2) {
                        vds = DataSetOps.flattenWaveform((QDataSet)vds);
                        LoggerManager.markTime((String)"flatten");
                    }
                    xds = SemanticOps.xtagsDataSet((QDataSet)vds);
                    this.updateFirstLast(xAxis, yAxis, xds, vds);
                    LoggerManager.markTime((String)"updateFirstLast again");
                } else if (SemanticOps.isRank3JoinOfRank2Waveform((QDataSet)dataSet)) {
                    res = DataSetUtil.asDataSet((Datum)xAxis.getDatumRange().width().divide((double)xAxis.getWidth()));
                    Units dsxu = SemanticOps.getUnits((QDataSet)((QDataSet)dataSet.slice(0).property("DEPEND_0")));
                    if (!SemanticOps.getUnits((QDataSet)res).isConvertibleTo(dsxu.getOffsetUnits())) {
                        res = Ops.putProperty((QDataSet)res, (String)"UNITS", (Object)dsxu.getOffsetUnits());
                    }
                    vds = null;
                    for (int k = this.firstIndex; k < this.lastIndex; ++k) {
                        int lastIndex1;
                        boolean xmono = true;
                        QDataSet ds1 = dataSet.slice(k);
                        QDataSet xds1 = (QDataSet)ds1.property("DEPEND_0");
                        int firstIndex1 = xmono ? DataSetUtil.getPreviousIndex((QDataSet)xds1, (Datum)xAxis.getDatumRange().min()) : 0;
                        int n = lastIndex1 = xmono ? DataSetUtil.getNextIndex((QDataSet)xds1, (Datum)xAxis.getDatumRange().max()) : ds1.length();
                        if (firstIndex1 == lastIndex1 && lastIndex1 == ds1.length() - 1) {
                            lastIndex1 = ds1.length();
                        }
                        if (firstIndex1 == lastIndex1) continue;
                        ds1 = ds1.trim(firstIndex1, lastIndex1);
                        LoggerManager.markTime((String)"trim");
                        QDataSet vds1 = Reduction.reducex((QDataSet)ds1, (QDataSet)res);
                        LoggerManager.markTime((String)"reducex");
                        if (SemanticOps.isRank2Waveform((QDataSet)vds1)) {
                            vds1 = DataSetOps.flattenWaveform((QDataSet)vds1);
                            LoggerManager.markTime((String)"flatten");
                        } else if (vds1.rank() == 2) continue;
                        vds = vds == null ? vds1 : Ops.append((QDataSet)vds, (QDataSet)vds1);
                    }
                    if (vds == null) {
                        this.getParent().postMessage((Renderer)this, "first point of waveform package is not visible", Level.WARNING, null, null);
                        return;
                    }
                    xds = SemanticOps.xtagsDataSet((QDataSet)vds);
                    this.updateFirstLast(xAxis, yAxis, xds, vds);
                    LoggerManager.markTime((String)"updateFirstLast again");
                }
                logger.log(Level.FINER, "renderWaveform updateFirstLast complete ({0}ms)", System.currentTimeMillis() - t0);
            } else if (this.ds.rank() != 0) {
                System.err.println("both tds and vds are null");
            }
            logger.log(Level.FINER, "updatePlotImage uses subset from firstIndex, lastIndex: {0}, {1} ({2} points})", new Object[]{this.firstIndex, this.lastIndex, this.lastIndex - this.firstIndex});
            if (this.psymConnector != PsymConnector.NONE) {
                try {
                    if (vds != null && vds.rank() == 1 && dataSet.rank() == 2 && SemanticOps.isBundle((QDataSet)dataSet)) {
                        this.psymConnectorElement.update(xAxis, yAxis, dataSet, monitor.getSubtaskMonitor("psymConnectorElement.update"));
                    } else if (dataSet.rank() == 0) {
                        this.psymConnectorElement.update(xAxis, yAxis, dataSet, monitor.getSubtaskMonitor("psymConnectorElement.update"));
                    } else if (isAlongTrajectory) {
                        this.psymConnectorElement.update(xAxis, yAxis, xds, monitor.getSubtaskMonitor("psymConnectorElement.update"));
                    } else {
                        this.psymConnectorElement.update(xAxis, yAxis, vds, monitor.getSubtaskMonitor("psymConnectorElement.update"));
                    }
                }
                catch (InconvertibleUnitsException ex) {
                    monitor.finished();
                    return;
                }
            }
            try {
                if (dataSet.rank() != 0) {
                    if (!isAlongTrajectory) {
                        this.errorElement.update(xAxis, yAxis, vds, monitor.getSubtaskMonitor("errorElement.update"));
                    }
                    if (vds != null && vds.rank() == 1 && dataSet.rank() == 2 && SemanticOps.isBundle((QDataSet)dataSet)) {
                        this.psymsElement.update(xAxis, yAxis, dataSet, monitor.getSubtaskMonitor("psymsElement.update"));
                    } else if (isAlongTrajectory) {
                        this.psymsElement.update(xAxis, yAxis, xds, monitor.getSubtaskMonitor("psymsElement.update"));
                    } else {
                        this.psymsElement.update(xAxis, yAxis, vds, monitor.getSubtaskMonitor("psymsElement.update"));
                    }
                    logger.log(Level.FINER, "psymsElement.update complete ({0}ms)", System.currentTimeMillis() - t0);
                }
            }
            catch (InconvertibleUnitsException ex) {
                monitor.finished();
                return;
            }
            if (vds != null) {
                if (vds.rank() != 1) {
                    return;
                }
                this.selectionArea = this.firstIndex == 0 && this.lastIndex == xds.length() ? this.calcSelectionArea(xAxis, yAxis, xds, vds) : (this.firstIndex == -1 && this.lastIndex == -1 ? SelectionUtil.NULL : this.calcSelectionArea(xAxis, yAxis, xds.trim(this.firstIndex, this.lastIndex), vds.trim(this.firstIndex, this.lastIndex)));
            }
            logger.log(Level.FINER, "calcSelectionArea complete ({0}ms)", System.currentTimeMillis() - t0);
        }
        finally {
            monitor.finished();
        }
        long milli = System.currentTimeMillis();
        long renderTime = milli - t0;
        double dppms = (double)(this.lastIndex - this.firstIndex) / (double)renderTime;
        this.addToStats(this.numberOfPoints, renderTime, 'u');
        logger.log(Level.FINE, "done updatePlotImage ({0}ms)", renderTime);
        this.setUpdatesPointsPerMillisecond(dppms);
    }

    private QDataSet getXTags(QDataSet dataSet) {
        QDataSet xds;
        if (dataSet.rank() == 0) {
            xds = (QDataSet)dataSet.property("CONTEXT_0");
            if (xds == null) {
                xds = DataSetUtil.asDataSet((double)0.0);
            } else if (xds.rank() == 1) {
                xds = xds.slice(0);
            }
        } else {
            xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
        }
        return xds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Shape calcSelectionArea(DasAxis xaxis, DasAxis yaxis, QDataSet xds, QDataSet ds) {
        ArrayDataSet ds3;
        boolean _xunitsWarning;
        boolean _unitsWarning;
        long t0 = System.currentTimeMillis();
        SeriesRenderer seriesRenderer = this;
        synchronized (seriesRenderer) {
            _unitsWarning = this.unitsWarning;
            _xunitsWarning = this.xunitsWarning;
        }
        Datum widthx = xaxis.isLog() ? Units.logERatio.createDatum(Math.log(xaxis.getDataMaximum(xaxis.getUnits()) - xaxis.getDataMinimum(xaxis.getUnits()))) : xaxis.getDatumRange().width();
        Datum widthy = yaxis.isLog() ? Units.logERatio.createDatum(Math.log(yaxis.getDataMaximum(yaxis.getUnits()) - yaxis.getDataMinimum(yaxis.getUnits()))) : yaxis.getDatumRange().width();
        if (xaxis.getColumn().getWidth() == 0 || yaxis.getRow().getHeight() == 0) {
            return null;
        }
        QDataSet ds2 = ds;
        if (_unitsWarning) {
            ds3 = ArrayDataSet.copy((QDataSet)ds);
            ds3.putProperty("UNITS", (Object)yaxis.getUnits());
            ds2 = ds3;
        }
        if (_xunitsWarning) {
            ds3 = ArrayDataSet.copy((QDataSet)xds);
            ds3.putProperty("UNITS", (Object)xaxis.getUnits());
            xds = ds3;
        }
        if (ds2.rank() == 2) {
            ds2 = DataSetOps.slice1((QDataSet)ds2, (int)0);
        }
        try {
            Shape s;
            Shape reduce;
            if (this.psymConnector == PsymConnector.NONE || ds2.length() > 10000) {
                Shape s2;
                if (ds2.property("DEPEND_0") == null) {
                    ds2 = Ops.putProperty((QDataSet)ds2, (String)"DEPEND_0", (Object)xds);
                }
                reduce = this.doDataSetReduce(xaxis, yaxis, ds2, 5, 5);
                logger.fine(String.format("reduce path in calcSelectionArea: %s\n", reduce));
                GeneralPath path = GraphUtil.getPath(xaxis, yaxis, SemanticOps.xtagsDataSet((QDataSet)reduce), (QDataSet)reduce, "scatter", true);
                Shape shape = s2 = new BasicStroke(Math.min(14.0f, (float)this.getSymSize() + 8.0f), 1, 1).createStrokedShape(path);
                return shape;
            }
            if (xds.length() != ds2.length()) {
                reduce = SelectionUtil.NULL;
                return reduce;
            }
            QDataSet xx = xds;
            QDataSet yy = ds2;
            if (xds.rank() == 2 && xds.length(0) == 2) {
                xx = Ops.slice1((QDataSet)xds, (int)0);
                yy = Ops.slice1((QDataSet)xds, (int)1);
            }
            QDataSet reduce2 = VectorUtil.reduce2D(xx, yy, 0, xx.length(), widthx.divide((double)xaxis.getColumn().getWidth() / 5.0), widthy.divide((double)yaxis.getRow().getHeight() / 5.0));
            logger.fine(String.format("reduce path in calcSelectionArea: %s\n", reduce2));
            GeneralPath path = GraphUtil.getPath(xaxis, yaxis, SemanticOps.xtagsDataSet((QDataSet)reduce2), reduce2, this.histogram ? "histogram" : "series", true);
            Shape shape = s = new BasicStroke(Math.min(14.0f, (float)this.getSymSize() + 8.0f), 1, 1).createStrokedShape(path);
            return shape;
        }
        catch (InconvertibleUnitsException ex) {
            logger.fine("failed to convert units in calcSelectionArea");
            Shape shape = SelectionUtil.NULL;
            return shape;
        }
        finally {
            logger.log(Level.FINE, "done calcSelectionArea ({0}ms)", System.currentTimeMillis() - t0);
        }
    }

    @Override
    protected void installRenderer() {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            DasPlot lparent = this.getParent();
            if (lparent == null) {
                throw new IllegalArgumentException("parent not set");
            }
            DasMouseInputAdapter mouseAdapter = lparent.mouseAdapter;
            DasPlot p = lparent;
            mouseAdapter.addMouseModule(new LengthMouseModule((DasCanvasComponent)p, new LengthDragRenderer(p, p.getXAxis(), p.getYAxis()), "Length"));
            CrossHairMouseModule ch = new CrossHairMouseModule(lparent, this, lparent.getXAxis(), lparent.getYAxis());
            mouseAdapter.addMouseModule(ch);
        }
        this.updatePsym();
    }

    @Override
    protected void uninstallRenderer() {
    }

    public Element getDOMElement(Document document) {
        return null;
    }

    @Override
    public Icon getListIcon() {
        BufferedImage i = new BufferedImage(15, 10, 2);
        Graphics2D g = (Graphics2D)((Image)i).getGraphics();
        this.drawListIcon(g, 0, 0);
        return new ImageIcon(i);
    }

    @Override
    public void drawListIcon(Graphics2D g1, int x, int y) {
        Graphics2D g = (Graphics2D)g1.create(x, y, 16, 16);
        g.setRenderingHints(DasProperties.getRenderingHints());
        DasPlot lparent = this.getParent();
        if (lparent != null) {
            g.setBackground(lparent.getBackground());
        }
        if (this.color.equals(Color.white)) {
            g.setColor(Color.GRAY);
        } else {
            g.setColor(new Color(0, 0, 0, 0));
        }
        g.fillRect(0, 0, 15, 10);
        if (this.fillToReference) {
            g.setColor(this.fillColor);
            Polygon p = new Polygon(new int[]{2, 13, 13, 2}, new int[]{3, 7, 10, 10}, 4);
            g.fillPolygon(p);
        }
        g.setColor(this.color);
        Stroke stroke0 = g.getStroke();
        this.getPsymConnector().drawLine(g, 2.0, 3.0, 13.0, 7.0, this.lineWidth);
        g.setStroke(stroke0);
        float llistIconSymSize = Math.min(12.0f, this.symSize);
        DasColorBar lcolorBar = this.colorBar;
        if (this.colorByDataSetId != null && !this.colorByDataSetId.equals("") && lcolorBar != null) {
            Units cu = lcolorBar.getUnits();
            double d1 = lcolorBar.getDatumRange().min().doubleValue(cu);
            double d2 = lcolorBar.getDatumRange().max().doubleValue(cu);
            if (lcolorBar.isLog()) {
                d1 = Math.log10(d1);
                d2 = Math.log10(d2);
            }
            double t = d2 - d1;
            double d3 = (2.0 * d1 + d2) / 3.0;
            double d4 = (d1 + 2.0 * d2) / 3.0;
            d1 += t * 0.1;
            d2 -= t * 0.1;
            if (lcolorBar.isLog()) {
                d1 = Math.pow(10.0, d1);
                d2 = Math.pow(10.0, d2);
                d3 = Math.pow(10.0, d3);
                d4 = Math.pow(10.0, d4);
            }
            Color c = new Color(lcolorBar.rgbTransform(d1, cu));
            g.setColor(c);
            this.psym.draw(g, 3.0, 8.0, llistIconSymSize, this.fillStyle);
            c = new Color(lcolorBar.rgbTransform(d3, cu));
            g.setColor(c);
            this.psym.draw(g, 5.0, 4.0, llistIconSymSize, this.fillStyle);
            c = new Color(lcolorBar.rgbTransform(d2, cu));
            g.setColor(c);
            this.psym.draw(g, 9.0, 6.0, llistIconSymSize, this.fillStyle);
            c = new Color(lcolorBar.rgbTransform(d4, cu));
            g.setColor(c);
            this.psym.draw(g, 11.0, 2.0, llistIconSymSize, this.fillStyle);
        } else if ((double)llistIconSymSize < 3.0 && this.psymConnector.equals(PsymConnector.NONE)) {
            this.psym.draw(g, 3.0, 8.0, llistIconSymSize, this.fillStyle);
            this.psym.draw(g, 5.0, 4.0, llistIconSymSize, this.fillStyle);
            this.psym.draw(g, 9.0, 6.0, llistIconSymSize, this.fillStyle);
            this.psym.draw(g, 11.0, 2.0, llistIconSymSize, this.fillStyle);
        } else {
            this.psym.draw(g, 7.0, 5.0, llistIconSymSize, this.fillStyle);
        }
    }

    public void setListIconSymSize(float newSize) {
        this.listIconSymSize = newSize;
        this.refreshRender();
    }

    @Override
    public String getListLabel() {
        return "series";
    }

    private void refreshRender() {
        DasPlot lparent = this.getParent();
        if (lparent != null) {
            lparent.invalidateCacheImage();
            lparent.repaint();
        }
    }

    public PsymConnector getPsymConnector() {
        return this.psymConnector;
    }

    public void setPsymConnector(PsymConnector p) {
        PsymConnector old = this.psymConnector;
        if (!p.equals(this.psymConnector)) {
            this.psymConnector = p;
            this.updateCacheImage();
            this.propertyChangeSupport.firePropertyChange("psymConnector", old, p);
        }
    }

    public PlotSymbol getPsym() {
        return this.psym;
    }

    public void setPsym(PlotSymbol psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        if (psym != this.psym) {
            DefaultPlotSymbol oldValue = this.psym;
            this.psym = (DefaultPlotSymbol)psym;
            this.updatePsym();
            this.refreshRender();
            this.propertyChangeSupport.firePropertyChange("psym", oldValue, psym);
        }
    }

    public boolean isDrawError() {
        return this.drawError;
    }

    public void setDrawError(boolean drawError) {
        boolean oldDrawError = this.drawError;
        this.drawError = drawError;
        if (oldDrawError != drawError) {
            this.update();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_DRAWERROR, oldDrawError, drawError);
    }

    public double getSymSize() {
        return this.symSize;
    }

    public void setSymSize(double symSize) {
        float old = this.symSize;
        if ((double)this.symSize != symSize) {
            this.symSize = (float)symSize;
            this.setPsym(this.psym);
            this.updatePsym();
            this.refreshRender();
            this.propertyChangeSupport.firePropertyChange("symSize", Float.valueOf(old), symSize);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("null color");
        }
        Color old = this.color;
        if (!this.color.equals(color)) {
            this.color = color;
            this.updatePsym();
            this.refreshRender();
            this.propertyChangeSupport.firePropertyChange("color", old, color);
        }
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double f) {
        double old = this.lineWidth;
        if ((double)this.lineWidth != f) {
            this.lineWidth = (float)f;
            this.updatePsym();
            this.refreshRender();
            this.propertyChangeSupport.firePropertyChange("lineWidth", old, f);
        }
    }

    public String getBackgroundThick() {
        return this.backgroundThick;
    }

    public void setBackgroundThick(String backgroundThick) {
        String oldBackgroundWidth = this.backgroundThick;
        this.backgroundThick = backgroundThick;
        if (!oldBackgroundWidth.equals(backgroundThick)) {
            this.updatePsym();
            this.refreshRender();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_BACKGROUNDWIDTH, oldBackgroundWidth, backgroundThick);
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        boolean old = this.antiAliased;
        this.antiAliased = antiAliased;
        this.updatePsym();
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange("antiAliased", old, antiAliased);
    }

    public boolean isHistogram() {
        return this.histogram;
    }

    public void setHistogram(boolean b) {
        boolean old = b;
        if (b != this.histogram) {
            this.histogram = b;
            this.updateCacheImage();
            this.propertyChangeSupport.firePropertyChange("histogram", old, this.antiAliased);
        }
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        Color old = this.fillColor;
        if (!this.fillColor.equals(color)) {
            this.fillColor = color;
            this.update();
            this.propertyChangeSupport.firePropertyChange("fillColor", old, color);
        }
    }

    public String getFillDirection() {
        return this.fillDirection;
    }

    public void setFillDirection(String fillDirection) {
        String oldFillDirection = this.fillDirection;
        this.fillDirection = fillDirection;
        this.update();
        this.propertyChangeSupport.firePropertyChange(PROP_FILLDIRECTION, oldFillDirection, fillDirection);
    }

    public String getColorByDataSetId() {
        return this.colorByDataSetId;
    }

    public void setColorByDataSetId(String colorByDataSetId) {
        String oldVal = this.colorByDataSetId;
        this.colorByDataSetId = colorByDataSetId;
        this.update();
        if (!colorByDataSetId.equals("")) {
            this.updatePsym();
        }
        this.propertyChangeSupport.firePropertyChange("colorByDataSetId", oldVal, colorByDataSetId);
    }

    @Override
    public void setColorBar(DasColorBar cb) {
        if (this.colorBar == cb) {
            return;
        }
        if (this.colorBar != null) {
            this.colorBar.removePropertyChangeListener(this.colorBarListener);
        }
        super.setColorBar(cb);
        if (this.colorBar != null) {
            DasPlot parent = this.getParent();
            if (parent != null && parent.getCanvas() != null) {
                final DasCanvas dasCanvas = parent.getCanvas();
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        dasCanvas.add(SeriesRenderer.this.colorBar);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    run.run();
                } else {
                    SwingUtilities.invokeLater(run);
                }
            }
            this.colorBar.addPropertyChangeListener(this.colorBarListener);
        }
        this.updateCacheImage();
        this.updatePsym();
    }

    public boolean isFillToReference() {
        return this.fillToReference;
    }

    public void setFillToReference(boolean fillToReference) {
        boolean old = this.fillToReference;
        if (this.fillToReference != fillToReference) {
            this.fillToReference = fillToReference;
            this.update();
            this.propertyChangeSupport.firePropertyChange("fillToReference", old, fillToReference);
        }
    }

    public Datum getReference() {
        return this.reference;
    }

    public void setReference(Datum reference) {
        Datum old = this.reference;
        if (!this.reference.equals(reference)) {
            this.reference = reference;
            this.updateCacheImage();
            this.propertyChangeSupport.firePropertyChange("reference", old, reference);
        }
    }

    public ErrorBarType getErrorBarType() {
        return this.errorBarType;
    }

    public void setErrorBarType(ErrorBarType errorBarType) {
        ErrorBarType oldErrorBarType = this.errorBarType;
        this.errorBarType = errorBarType;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_ERRORBARTYPE, (Object)oldErrorBarType, (Object)errorBarType);
    }

    public Datum getModuloY() {
        return this.moduloY;
    }

    public void setModuloY(Datum modulo) {
        Datum oldModulo = this.moduloY;
        this.moduloY = modulo;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_MODULO_Y, oldModulo, modulo);
    }

    public boolean isResetDebugCounters() {
        return this.resetDebugCounters;
    }

    public void setResetDebugCounters(boolean resetDebugCounters) {
        if (resetDebugCounters) {
            this.update();
        }
    }

    public boolean isSimplifyPaths() {
        return this.simplifyPaths;
    }

    public void setSimplifyPaths(boolean simplifyPaths) {
        this.simplifyPaths = simplifyPaths;
        this.updateCacheImage();
    }

    public boolean isStampPsyms() {
        return this.stampPsyms;
    }

    public void setStampPsyms(boolean newstampPsyms) {
        boolean oldstampPsyms = this.stampPsyms;
        this.stampPsyms = newstampPsyms;
        this.propertyChangeSupport.firePropertyChange(PROP_STAMPPSYMS, oldstampPsyms, newstampPsyms);
        this.updateCacheImage();
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(FillStyle fillStyle) {
        this.fillStyle = fillStyle;
        this.updatePsym();
        this.updateCacheImage();
    }

    public synchronized Shape selectionArea() {
        return this.selectionArea == null ? SelectionUtil.NULL : this.selectionArea;
    }

    @Override
    public boolean acceptContext(int x, int y) {
        boolean accept = false;
        Point2D.Double dp = new Point2D.Double(x, y);
        if (this.fillToReference && this.fillElement.acceptContext(dp)) {
            accept = true;
        }
        if (!accept && this.psymConnectorElement.acceptContext(dp)) {
            accept = true;
        }
        if (!accept && this.psymsElement.acceptContext(dp)) {
            accept = true;
        }
        if (!accept && this.drawError && this.errorElement.acceptContext(dp)) {
            accept = true;
        }
        return accept;
    }

    public synchronized int getDataSetSizeLimit() {
        return this.dataSetSizeLimit;
    }

    public synchronized void setDataSetSizeLimit(int dataSetSizeLimit) {
        int oldDataSetSizeLimit = this.dataSetSizeLimit;
        this.dataSetSizeLimit = dataSetSizeLimit;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange("dataSetSizeLimit", oldDataSetSizeLimit, dataSetSizeLimit);
    }

    public double getUpdatesPointsPerMillisecond() {
        return this.updatesPointsPerMillisecond;
    }

    public void setUpdatesPointsPerMillisecond(double newupdatesPointsPerMillisecond) {
        this.updatesPointsPerMillisecond = newupdatesPointsPerMillisecond;
    }

    public double getRenderPointsPerMillisecond() {
        return this.renderPointsPerMillisecond;
    }

    public void setRenderPointsPerMillisecond(double newrenderPointsPerMillisecond) {
        this.renderPointsPerMillisecond = newrenderPointsPerMillisecond;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public boolean isCadenceCheck() {
        return this.cadenceCheck;
    }

    public void setCadenceCheck(boolean cadenceCheck) {
        boolean oldCadenceCheck = this.cadenceCheck;
        this.cadenceCheck = cadenceCheck;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_CADENCECHECK, oldCadenceCheck, cadenceCheck);
    }

    @Override
    public boolean acceptsDataSet(QDataSet dataSet) {
        boolean plottable;
        QDataSet ds1 = dataSet;
        if (!SemanticOps.isTableDataSet((QDataSet)dataSet)) {
            if (!(ds1.rank() == 2 && SemanticOps.isBundle((QDataSet)ds1) || ds1.rank() == 1)) {
                logger.fine("dataset rank error");
                return false;
            }
            this.unitsWarning = false;
            plottable = true;
        } else {
            plottable = true;
        }
        return plottable;
    }

    class FillRenderElement
    implements RenderElement {
        private GeneralPath fillToRefPath1;

        FillRenderElement() {
        }

        @Override
        public void renderBackground(Graphics2D g) {
        }

        @Override
        public int render(Graphics2D g, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            Rectangle canvasRect;
            if (this.fillToRefPath1 == null) {
                return 0;
            }
            Rectangle b = this.fillToRefPath1.getBounds();
            if (b.height == 0) {
                b.height = 1;
            }
            if (b.width == 0) {
                b.width = 1;
            }
            if (!b.intersects(canvasRect = DasDevicePosition.toRectangle(yAxis.getRow(), xAxis.getColumn()))) {
                logger.log(Level.FINE, "all data is off-page");
                return 0;
            }
            if (SeriesRenderer.this.fillColor.getAlpha() == 0) {
                double y;
                try {
                    y = yAxis.transform(SeriesRenderer.this.reference);
                }
                catch (InconvertibleUnitsException ex) {
                    y = yAxis.transform(SeriesRenderer.this.reference.value(), yAxis.getUnits());
                }
                DasColumn column = xAxis.getColumn();
                g.draw(new Line2D.Double(column.getDMinimum(), y, column.getDMaximum(), y));
            } else {
                g.setColor(SeriesRenderer.this.fillColor);
                GraphUtil.fillWithTexture(g, this.fillToRefPath1, null, SeriesRenderer.this.fillTexture);
                g.draw(this.fillToRefPath1);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            boolean allowSimplify;
            GeneralPath p;
            Rectangle2D.Double rect;
            Area a;
            SeriesRenderer seriesRenderer;
            if (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex == 0) {
                this.fillToRefPath1 = null;
                return;
            }
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
            QDataSet vds = SeriesRenderer.this.ytagsDataSet(dataSet);
            QDataSet wds = SemanticOps.weightsDataSet((QDataSet)vds);
            Units xUnits = SemanticOps.getUnits((QDataSet)xds);
            Units yUnits = SemanticOps.getUnits((QDataSet)vds);
            SeriesRenderer seriesRenderer2 = SeriesRenderer.this;
            synchronized (seriesRenderer2) {
                if (SeriesRenderer.this.unitsWarning) {
                    yUnits = yAxis.getUnits();
                }
                if (SeriesRenderer.this.xunitsWarning) {
                    xUnits = xAxis.getUnits();
                }
            }
            boolean above = SeriesRenderer.this.fillDirection.equals("above") || SeriesRenderer.this.fillDirection.equals("both");
            boolean below = SeriesRenderer.this.fillDirection.equals("below") || SeriesRenderer.this.fillDirection.equals("both");
            Units xaxisUnits = xAxis.getUnits();
            Units yaxisUnits = yAxis.getUnits();
            if (!yUnits.isConvertibleTo(yaxisUnits)) {
                yUnits = yAxis.getUnits();
                seriesRenderer = SeriesRenderer.this;
                synchronized (seriesRenderer) {
                    SeriesRenderer.this.unitsWarning = true;
                }
            }
            if (!xUnits.isConvertibleTo(xaxisUnits)) {
                xUnits = xAxis.getUnits();
                seriesRenderer = SeriesRenderer.this;
                synchronized (seriesRenderer) {
                    SeriesRenderer.this.xunitsWarning = true;
                }
            }
            DataGeneralPathBuilder pathBuilder = SeriesRenderer.this.getPathBuilderForData(xAxis, yAxis, xds, vds);
            String pathBuilderName = "";
            pathBuilder.setName(pathBuilderName);
            double xSampleWidthExact = pathBuilder.getCadenceDouble();
            pathBuilder.setHistogramMode(SeriesRenderer.this.histogram);
            UnitsConverter xuc = xUnits.getConverter(xAxis.getUnits());
            UnitsConverter yuc = yUnits.getConverter(yAxis.getUnits());
            if (SeriesRenderer.this.reference == null) {
                SeriesRenderer.this.reference = yUnits.createDatum(yAxis.isLog() ? 1.0 : 0.0);
            }
            double yref = SeriesRenderer.this.doubleValue(SeriesRenderer.this.reference, yUnits);
            int index = SeriesRenderer.this.firstIndex;
            double x = xuc.convert(xds.value(index));
            double y = yuc.convert(vds.value(index));
            pathBuilder.addDataPoint(true, x, yref);
            double ireferenceY = yAxis.transform(yref, yUnits);
            if (pathBuilderName.length() > 0) {
                System.err.println(String.format("ireferenceY=%.2f", ireferenceY));
            }
            pathBuilder.setHistogramFillFlag();
            pathBuilder.addDataPoint(true, x, y);
            ++index;
            int invalidInterleaveCount = 0;
            for (int i = 1; i < xds.length(); ++i) {
                if (!(wds.value(i - 1) > 0.0) || wds.value(i) != 0.0) continue;
                ++invalidInterleaveCount;
            }
            boolean notInvalidInterleave = invalidInterleaveCount < wds.length() / 3;
            boolean lastIsValid = true;
            double lastX = x;
            if (pathBuilderName.length() > 0) {
                System.err.println("# here invalid");
            }
            while (index < SeriesRenderer.this.lastIndex) {
                Point2D last;
                boolean isValid;
                if (pathBuilderName.length() > 0) {
                    System.err.println(String.format("# x=%.2f, y=%.2f", xds.value(index), vds.value(index)));
                }
                x = xuc.convert(xds.value(index));
                y = yuc.convert(vds.value(index));
                boolean bl = isValid = wds.value(index) > 0.0;
                if (Math.abs(x - lastX) > xSampleWidthExact * 1.2) {
                    pathBuilder.finishThought();
                    last = pathBuilder.getPenPosition();
                    pathBuilder.insertLineTo(last.getX(), ireferenceY);
                    lastIsValid = false;
                }
                if (isValid || notInvalidInterleave) {
                    if (!lastIsValid) {
                        pathBuilder.addDataPoint(isValid, x, yref);
                        last = pathBuilder.getPenPosition();
                        if (isValid) {
                            pathBuilder.insertLineTo(last.getX(), yAxis.transform(pathBuilder.getYUnits().createDatum(y)));
                            pathBuilder.setHistogramFillFlag();
                        }
                        pathBuilder.addDataPoint(isValid, x, y);
                    } else {
                        pathBuilder.addDataPoint(isValid, x, y);
                    }
                }
                if (!isValid && lastIsValid) {
                    last = pathBuilder.getPenPosition();
                    pathBuilder.insertLineTo(last.getX(), ireferenceY);
                    lastIsValid = false;
                } else if (isValid) {
                    lastIsValid = true;
                }
                lastX = x;
                ++index;
            }
            pathBuilder.finishThought();
            pathBuilder.insertLineTo(pathBuilder.getPenPosition().getX(), ireferenceY);
            GeneralPath fillPath = pathBuilder.getGeneralPath();
            double fyref = yAxis.transform(yref, yUnits);
            if (!above) {
                a = new Area(fillPath);
                rect = new Rectangle2D.Double(0.0, fyref, SeriesRenderer.this.getParent().getColumn().getDMaximum(), SeriesRenderer.this.getParent().getRow().getHeight());
                a.intersect(new Area(rect));
                fillPath = p = new GeneralPath(a);
            }
            if (!below) {
                a = new Area(fillPath);
                rect = new Rectangle2D.Double(0.0, 0.0, SeriesRenderer.this.getParent().getColumn().getDMaximum(), fyref);
                a.intersect(new Area(rect));
                fillPath = p = new GeneralPath(a);
            }
            this.fillToRefPath1 = fillPath;
            boolean bl = allowSimplify = SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex > 1000 && xSampleWidthExact < 1.0E37;
            if (!SeriesRenderer.this.histogram && SeriesRenderer.this.simplifyPaths && allowSimplify && SeriesRenderer.this.colorByDataSetId.length() == 0) {
                int pathLengthApprox = Math.max(5, 110 * (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex) / 100);
                GeneralPath newPath = new GeneralPath(1, pathLengthApprox);
                int count = GraphUtil.reducePath(this.fillToRefPath1.getPathIterator(null), newPath);
                this.fillToRefPath1 = newPath;
                logger.fine(String.format("reduce path(fill) in=%d  out=%d\n", SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex, count));
            }
        }

        @Override
        public boolean acceptContext(Point2D.Double dp) {
            return this.fillToRefPath1 != null && this.fillToRefPath1.contains(dp);
        }
    }

    private class PsymConnectorRenderElement
    implements RenderElement {
        private GeneralPath path1;
        private boolean pathWasReduced = true;

        private PsymConnectorRenderElement() {
        }

        @Override
        public void renderBackground(Graphics2D g) {
            GeneralPath lpath1 = this.getPath();
            if (lpath1 == null) {
                return;
            }
            Color color0 = g.getColor();
            Color backgroundColor = g.getBackground();
            g.setColor(backgroundColor);
            double backWidth = GraphUtil.parseLayoutLength(SeriesRenderer.this.backgroundThick, SeriesRenderer.this.lineWidth, SeriesRenderer.this.symSize);
            PsymConnector.SOLID.draw(g, lpath1, (float)backWidth);
            g.setBackground(backgroundColor);
            g.setColor(color0);
        }

        @Override
        public int render(Graphics2D g, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            long t0 = System.currentTimeMillis();
            boolean debug = false;
            logger.log(Level.FINE, "enter connector render");
            logger.log(Level.FINER, "path was reduced: {0}", this.pathWasReduced);
            GeneralPath lpath1 = this.getPath();
            if (lpath1 == null) {
                return 0;
            }
            Rectangle b = lpath1.getBounds();
            if (b.height == 0) {
                b.height = 1;
            }
            if (b.width == 0) {
                b.width = 1;
            }
            Rectangle canvasRect = DasDevicePosition.toRectangle(yAxis.getRow(), xAxis.getColumn());
            long t = System.currentTimeMillis() - t0;
            if (!b.intersects(canvasRect)) {
                logger.log(Level.FINE, "all data is off-page ({0}ms)", t - t0);
                return 0;
            }
            SeriesRenderer.this.psymConnector.draw(g, lpath1, SeriesRenderer.this.lineWidth);
            logger.log(Level.FINE, "done connector render ({0}ms)", System.currentTimeMillis() - t0);
            return 0;
        }

        private synchronized GeneralPath getPath() {
            return this.path1;
        }

        @Override
        public synchronized void update(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            boolean allowSimplify;
            boolean notInvalidInterleave;
            logger.log(Level.FINE, "enter connector update");
            if (dataSet.rank() == 0) {
                return;
            }
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
            if (xds.rank() == 2 && xds.property("BINS_1") != null) {
                xds = Ops.reduceMean((QDataSet)xds, (int)1);
            }
            QDataSet vds = SeriesRenderer.this.ytagsDataSet(dataSet);
            QDataSet wds = SemanticOps.weightsDataSet((QDataSet)vds);
            QDataSet xwds = SemanticOps.weightsDataSet((QDataSet)xds);
            Units xUnits = SemanticOps.getUnits((QDataSet)xds);
            Units yUnits = SemanticOps.getUnits((QDataSet)vds);
            Units xaxisUnits = xAxis.getUnits();
            Units yaxisUnits = yAxis.getUnits();
            if (!yUnits.isConvertibleTo(yaxisUnits)) {
                yUnits = yAxis.getUnits();
                SeriesRenderer.this.unitsWarning = true;
            }
            if (!xUnits.isConvertibleTo(xaxisUnits)) {
                xUnits = xAxis.getUnits();
                SeriesRenderer.this.unitsWarning = true;
            }
            if (vds.rank() == 0) {
                GeneralPath gp = new GeneralPath();
                gp.moveTo(xAxis.transform(xAxis.getDataMinimum()), yAxis.transform(DataSetUtil.asDatum((QDataSet)vds)));
                gp.lineTo(xAxis.transform(xAxis.getDataMaximum()), yAxis.transform(DataSetUtil.asDatum((QDataSet)vds)));
                this.path1 = gp;
                return;
            }
            if (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex == 0) {
                this.path1 = null;
                return;
            }
            long t0 = System.currentTimeMillis();
            DataGeneralPathBuilder pathBuilder = SeriesRenderer.this.getPathBuilderForData(xAxis, yAxis, xds, vds);
            pathBuilder.setHistogramMode(SeriesRenderer.this.histogram);
            Datum lmoduloY = SeriesRenderer.this.moduloY;
            String avgTypeMody = (String)vds.property("AVERAGE_TYPE");
            if (avgTypeMody != null && lmoduloY.value() == 0.0) {
                if (avgTypeMody.equals("mod24")) {
                    lmoduloY = yUnits.createDatum(12);
                } else if (avgTypeMody.equals("mod360")) {
                    lmoduloY = yUnits.createDatum(180);
                } else if (avgTypeMody.equals("modpi")) {
                    lmoduloY = yUnits.createDatum(1.5707963267948966);
                } else if (avgTypeMody.equals("modtau")) {
                    lmoduloY = yUnits.createDatum(Math.PI);
                }
            }
            if (lmoduloY.value() > 0.0) {
                try {
                    if (yAxis.getUnits() == Units.dimensionless) {
                        pathBuilder.setModuloY(Units.dimensionless.createDatum(lmoduloY.doubleValue(lmoduloY.getUnits())));
                    } else {
                        pathBuilder.setModuloY(lmoduloY);
                    }
                }
                catch (InconvertibleUnitsException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            double xSampleWidthExact = pathBuilder.getCadenceDouble();
            UnitsConverter xuc = xUnits.getConverter(xaxisUnits);
            UnitsConverter yuc = yUnits.getConverter(yaxisUnits);
            int index = SeriesRenderer.this.firstIndex;
            double x = xuc.convert(xds.value(index));
            double y = yuc.convert(vds.value(index));
            pathBuilder.addDataPoint(true, x, y);
            ++index;
            int invalidInterleaveCount = 0;
            for (int i = 1; i < xds.length(); ++i) {
                if (!(wds.value(i - 1) > 0.0) || wds.value(i) != 0.0) continue;
                ++invalidInterleaveCount;
            }
            boolean bl = notInvalidInterleave = invalidInterleaveCount < wds.length() / 3;
            while (index < SeriesRenderer.this.lastIndex) {
                boolean isValid;
                x = xuc.convert(xds.value(index));
                y = yuc.convert(vds.value(index));
                boolean bl2 = isValid = wds.value(index) > 0.0 && xwds.value(index) > 0.0;
                if (isValid || notInvalidInterleave) {
                    pathBuilder.addDataPoint(isValid, x, y);
                }
                ++index;
            }
            logger.log(Level.FINE, "done create general path ({0}ms)", System.currentTimeMillis() - t0);
            pathBuilder.finishThought();
            boolean bl3 = allowSimplify = xSampleWidthExact < 1.0E37;
            if (!SeriesRenderer.this.histogram && SeriesRenderer.this.simplifyPaths && allowSimplify && SeriesRenderer.this.colorByDataSetId.length() == 0) {
                int pathLengthApprox = Math.max(5, 110 * (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex) / 100);
                this.path1 = new GeneralPath(1, pathLengthApprox);
                int count = GraphUtil.reducePath20140622(pathBuilder.getPathIterator(), this.path1, 1, 5);
                if (SeriesRenderer.this.additionalClip) {
                    GeneralPath path2 = new GeneralPath(1, pathLengthApprox);
                    DasPlot p = SeriesRenderer.this.getParent();
                    if (p != null) {
                        int x2 = GraphUtil.clipPath(this.path1.getPathIterator(null), path2, GraphUtil.shrinkRectangle(SeriesRenderer.this.getParent().getAxisClip(), 110));
                        logger.log(Level.FINE, "additionalClip: {0}", x2);
                    } else {
                        logger.log(Level.FINE, "additionalClip skipped because no parent");
                    }
                    this.path1 = path2;
                }
                this.pathWasReduced = true;
                logger.fine(String.format("reduce path in=%d  out=%d\n", SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex, count));
            } else {
                this.path1 = pathBuilder.getGeneralPath();
                this.pathWasReduced = false;
            }
            logger.log(Level.FINE, "done connector update ({0}ms)", System.currentTimeMillis() - t0);
        }

        @Override
        public boolean acceptContext(Point2D.Double dp) {
            GeneralPath gp = this.getPath();
            if (gp == null) {
                return false;
            }
            Rectangle2D.Double hitbox = new Rectangle2D.Double(dp.x - 5.0, dp.y - 5.0, 10.0, 10.0);
            double[] coords = new double[6];
            PathIterator it = gp.getPathIterator(null);
            it.currentSegment(coords);
            double x1 = coords[0];
            double y1 = coords[1];
            it.next();
            while (!it.isDone()) {
                int segType = it.currentSegment(coords);
                if (segType == 1 && hitbox.intersectsLine(x1, y1, coords[0], coords[1])) {
                    return true;
                }
                x1 = coords[0];
                y1 = coords[1];
                it.next();
            }
            return false;
        }
    }

    private class ErrorBarRenderElement
    implements RenderElement {
        GeneralPath p;

        private ErrorBarRenderElement() {
        }

        @Override
        public void renderBackground(Graphics2D g) {
        }

        @Override
        public int render(Graphics2D g, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            Rectangle canvasRect;
            GeneralPath lp = this.getPath();
            if (lp == null) {
                return 0;
            }
            Rectangle b = lp.getBounds();
            if (b.height == 0) {
                b.height = 1;
            }
            if (b.width == 0) {
                b.width = 1;
            }
            if (!b.intersects(canvasRect = DasDevicePosition.toRectangle(yAxis.getRow(), xAxis.getColumn()))) {
                logger.log(Level.FINE, "all data is off-page");
                return 0;
            }
            g.setStroke(new BasicStroke(SeriesRenderer.this.lineWidth, 1, 1));
            if (SeriesRenderer.this.errorBarType == ErrorBarType.SHADE) {
                GraphUtil.fillWithTexture(g, lp, SeriesRenderer.this.fillColor, SeriesRenderer.this.fillTexture);
            } else {
                g.draw(lp);
            }
            return SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex;
        }

        private synchronized GeneralPath getPath() {
            return this.p;
        }

        @Override
        public synchronized void update(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            GeneralPath lp;
            block37: {
                Point2D.Double returnTo;
                Units yunits;
                Units xunits;
                QDataSet[] binMinMax;
                QDataSet xds;
                QDataSet vds;
                block36: {
                    vds = SeriesRenderer.this.ytagsDataSet(dataSet);
                    if (vds == null) {
                        this.p = null;
                        return;
                    }
                    xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
                    binMinMax = this.getMinMax(vds);
                    QDataSet binMax = binMinMax[1];
                    QDataSet binMin = binMinMax[0];
                    xunits = SemanticOps.getUnits((QDataSet)xds);
                    yunits = SemanticOps.getUnits((QDataSet)vds);
                    if (SeriesRenderer.this.unitsWarning) {
                        yunits = yAxis.getUnits();
                    }
                    if (SeriesRenderer.this.xunitsWarning) {
                        xunits = xAxis.getUnits();
                    }
                    lp = null;
                    returnTo = null;
                    if (binMax != null && binMin != null) {
                        try {
                            double ix;
                            int i;
                            lp = new GeneralPath();
                            QDataSet p1 = binMax;
                            QDataSet p2 = binMin;
                            QDataSet w1 = Ops.valid((QDataSet)p2);
                            QDataSet w2 = Ops.valid((QDataSet)p1);
                            boolean penUp = true;
                            if (SeriesRenderer.this.firstIndex == -1) {
                                return;
                            }
                            block14: for (i = SeriesRenderer.this.firstIndex; i < SeriesRenderer.this.lastIndex; ++i) {
                                ix = xAxis.transform(xds.value(i), xunits);
                                if (!(w1.value(i) > 0.0) || !(w2.value(i) > 0.0)) continue;
                                double iym = yAxis.transform(p1.value(i), yunits);
                                double iyp = yAxis.transform(p2.value(i), yunits);
                                switch (SeriesRenderer.this.errorBarType) {
                                    case BAR: {
                                        lp.moveTo(ix, iym);
                                        lp.lineTo(ix, iyp);
                                        continue block14;
                                    }
                                    case SERIF_BAR: {
                                        lp.moveTo(ix - 2.0, iym);
                                        lp.lineTo(ix + 2.0, iym);
                                        lp.moveTo(ix, iym);
                                        lp.lineTo(ix, iyp);
                                        lp.moveTo(ix - 2.0, iyp);
                                        lp.lineTo(ix + 2.0, iyp);
                                        continue block14;
                                    }
                                    case SHADE: {
                                        if (penUp) {
                                            lp.moveTo(ix, iym);
                                            returnTo = new Point2D.Double(ix, iym);
                                            penUp = false;
                                        } else {
                                            lp.lineTo(ix, iym);
                                        }
                                    }
                                    default: {
                                        logger.log(Level.INFO, "unsupported ErrorBarType: {0}", (Object)SeriesRenderer.this.errorBarType);
                                    }
                                }
                            }
                            if (SeriesRenderer.this.errorBarType == ErrorBarType.SHADE) {
                                for (i = SeriesRenderer.this.lastIndex - 1; i >= SeriesRenderer.this.firstIndex; --i) {
                                    ix = xAxis.transform(xds.value(i), xunits);
                                    double iyp = yAxis.transform(p2.value(i), yunits);
                                    if (penUp) {
                                        lp.moveTo(ix, iyp);
                                        penUp = false;
                                        continue;
                                    }
                                    lp.lineTo(ix, iyp);
                                }
                                if (returnTo != null) {
                                    lp.lineTo(returnTo.x, returnTo.y);
                                }
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            if (SeriesRenderer.this.getParent() == null) break block36;
                            SeriesRenderer.this.getParent().postException(SeriesRenderer.this, ex);
                        }
                    }
                }
                binMinMax = this.getMinMax(xds);
                QDataSet xbinMax = binMinMax[1];
                QDataSet xbinMin = binMinMax[0];
                if (xbinMax != null && xbinMin != null) {
                    try {
                        int i;
                        if (lp == null) {
                            lp = new GeneralPath();
                        }
                        QDataSet p1 = xbinMin;
                        QDataSet p2 = xbinMax;
                        QDataSet w1 = Ops.valid((QDataSet)p1);
                        QDataSet w2 = Ops.valid((QDataSet)p2);
                        boolean penUp = true;
                        block16: for (i = SeriesRenderer.this.firstIndex; i < SeriesRenderer.this.lastIndex; ++i) {
                            double iy = yAxis.transform(vds.value(i), yunits);
                            if (!(w1.value(i) > 0.0) || !(w2.value(i) > 0.0)) continue;
                            double ixm = xAxis.transform(p1.value(i), xunits);
                            double ixp = xAxis.transform(p2.value(i), xunits);
                            switch (SeriesRenderer.this.errorBarType) {
                                case BAR: {
                                    lp.moveTo(ixm, iy);
                                    lp.lineTo(ixp, iy);
                                    continue block16;
                                }
                                case SERIF_BAR: {
                                    if (ixm < 0.0) {
                                        System.err.println("here stop");
                                    }
                                    lp.moveTo(ixm, iy - 2.0);
                                    lp.lineTo(ixm, iy + 2.0);
                                    lp.moveTo(ixm, iy);
                                    lp.lineTo(ixp, iy);
                                    lp.moveTo(ixp, iy - 2.0);
                                    lp.lineTo(ixp, iy + 2.0);
                                    continue block16;
                                }
                                case SHADE: {
                                    if (penUp) {
                                        lp.moveTo(ixm, iy);
                                        returnTo = new Point2D.Double(ixm, iy);
                                        penUp = false;
                                    } else {
                                        lp.lineTo(ixm, iy);
                                    }
                                }
                                default: {
                                    logger.log(Level.INFO, "unsupported ErrorBarType: {0}", (Object)SeriesRenderer.this.errorBarType);
                                }
                            }
                        }
                        if (SeriesRenderer.this.errorBarType == ErrorBarType.SHADE) {
                            for (i = SeriesRenderer.this.lastIndex - 1; i >= SeriesRenderer.this.firstIndex; --i) {
                                double ixp = xAxis.transform(p2.value(i), xunits);
                                double iy = yAxis.transform(vds.value(i), yunits);
                                if (penUp) {
                                    lp.moveTo(ixp, iy);
                                    penUp = false;
                                    continue;
                                }
                                lp.lineTo(ixp, iy);
                            }
                            if (returnTo != null) {
                                lp.lineTo(returnTo.x, returnTo.y);
                            }
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        if (SeriesRenderer.this.getParent() == null) break block37;
                        SeriesRenderer.this.getParent().postException(SeriesRenderer.this, ex);
                    }
                }
            }
            this.p = lp;
        }

        @Override
        public boolean acceptContext(Point2D.Double dp) {
            GeneralPath gp = this.getPath();
            return gp != null && gp.contains(dp.x - 2.0, dp.y - 2.0, 5.0, 5.0);
        }

        private QDataSet[] getMinMax(QDataSet vds) {
            QDataSet m;
            QDataSet binMin = null;
            QDataSet binMax = null;
            QDataSet deltaPlusY = (QDataSet)vds.property("DELTA_PLUS");
            QDataSet deltaMinusY = (QDataSet)vds.property("DELTA_MINUS");
            if (deltaPlusY == null) {
                m = (QDataSet)vds.property("BIN_PLUS");
                if (m != null) {
                    deltaPlusY = m;
                }
                if ((m = (QDataSet)vds.property("BIN_MINUS")) != null) {
                    deltaMinusY = m;
                }
            }
            if (deltaPlusY == null) {
                m = (QDataSet)vds.property("BIN_MAX");
                if (m != null) {
                    binMax = m;
                }
                if ((m = (QDataSet)vds.property("BIN_MIN")) != null) {
                    binMin = m;
                }
            }
            if (deltaPlusY == null) {
                if (vds.rank() == 2 && "min,max".equals(vds.property("BINS_1"))) {
                    binMin = Ops.slice1((QDataSet)vds, (int)0);
                    binMax = Ops.slice1((QDataSet)vds, (int)1);
                }
            } else {
                binMax = Ops.add((QDataSet)vds, (QDataSet)deltaPlusY);
                binMin = Ops.subtract((QDataSet)vds, (QDataSet)deltaMinusY);
            }
            return new QDataSet[]{binMin, binMax};
        }
    }

    private class PsymRenderElement
    implements RenderElement {
        int[] colors;
        int[] rgbColors;
        double[] dpsymsPathX;
        double[] dpsymsPathY;
        int count;

        private PsymRenderElement() {
        }

        private int renderStamp(Graphics2D g, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            DasPlot lparent = SeriesRenderer.this.getParent();
            if (lparent == null) {
                return 0;
            }
            long t0 = System.currentTimeMillis();
            logger.log(Level.FINE, "enter PsymRenderElement.renderStamp");
            QDataSet colorByDataSet = null;
            if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("")) {
                colorByDataSet = SeriesRenderer.this.colorByDataSet(SeriesRenderer.this.ds);
            }
            if (colorByDataSet != null) {
                for (int i = 0; i < this.count; ++i) {
                    if (this.colors[i] == -1) continue;
                    Image img = SeriesRenderer.this.specialColorPsyms.get(new Color(this.rgbColors[i]));
                    if (img == null) {
                        g.drawImage(SeriesRenderer.this.coloredPsyms[this.colors[i]], (int)this.dpsymsPathX[i] - SeriesRenderer.this.cmx, (int)this.dpsymsPathY[i] - SeriesRenderer.this.cmy, lparent);
                        continue;
                    }
                    g.drawImage(img, (int)this.dpsymsPathX[i] - SeriesRenderer.this.cmx, (int)this.dpsymsPathY[i] - SeriesRenderer.this.cmy, lparent);
                }
            } else {
                try {
                    for (int i = 0; i < this.count; ++i) {
                        g.drawImage(SeriesRenderer.this.psymImage, (int)this.dpsymsPathX[i] - SeriesRenderer.this.cmx, (int)this.dpsymsPathY[i] - SeriesRenderer.this.cmy, lparent);
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
            logger.log(Level.FINE, "done PsymRenderElement.renderStamp ({0}ms)", System.currentTimeMillis() - t0);
            return this.count;
        }

        private int renderDraw(Graphics2D graphics, DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            logger.log(Level.FINE, "enter PsymRenderElement.renderDraw");
            long t0 = System.currentTimeMillis();
            float fsymSize = SeriesRenderer.this.symSize;
            DasColorBar lcolorBar = SeriesRenderer.this.colorBar;
            QDataSet colorByDataSet = null;
            if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("")) {
                colorByDataSet = SeriesRenderer.this.colorByDataSet(SeriesRenderer.this.ds);
                if (colorByDataSet != null) {
                    if (colorByDataSet.length() != dataSet.length()) {
                        throw new IllegalArgumentException("colorByDataSet and dataSet do not have same length");
                    }
                } else {
                    System.err.println("why is colorByDataSetId set?");
                }
            }
            graphics.setStroke(new BasicStroke(SeriesRenderer.this.lineWidth));
            boolean rgbColor = false;
            Color[] ccolors = null;
            if (colorByDataSet != null) {
                if (lcolorBar == null) {
                    return 0;
                }
                rgbColor = Units.rgbColor.equals(colorByDataSet.property("UNITS"));
                IndexColorModel icm = lcolorBar.getIndexColorModel();
                ccolors = new Color[icm.getMapSize()];
                for (int j = 0; j < icm.getMapSize(); ++j) {
                    ccolors[j] = new Color(icm.getRGB(j));
                }
            }
            if (colorByDataSet != null) {
                if (rgbColor) {
                    for (int i = 0; i < this.count; ++i) {
                        int alpha = this.colors[i] >> 24 & 0xFF;
                        if (alpha > 0) {
                            graphics.setColor(new Color(this.colors[i], true));
                            SeriesRenderer.this.psym.draw(graphics, this.dpsymsPathX[i], this.dpsymsPathY[i], fsymSize, SeriesRenderer.this.fillStyle);
                            continue;
                        }
                        if (alpha == 0) {
                            graphics.setColor(new Color(this.colors[i]));
                            SeriesRenderer.this.psym.draw(graphics, this.dpsymsPathX[i], this.dpsymsPathY[i], fsymSize, SeriesRenderer.this.fillStyle);
                            continue;
                        }
                        graphics.setColor(new Color(this.colors[i], true));
                        SeriesRenderer.this.psym.draw(graphics, this.dpsymsPathX[i], this.dpsymsPathY[i], fsymSize, SeriesRenderer.this.fillStyle);
                    }
                } else {
                    for (int i = 0; i < this.count; ++i) {
                        if (this.colors[i] > 999) {
                            graphics.setColor(new Color(this.rgbColors[i]));
                            SeriesRenderer.this.psym.draw(graphics, this.dpsymsPathX[i], this.dpsymsPathY[i], fsymSize, SeriesRenderer.this.fillStyle);
                            continue;
                        }
                        if (this.colors[i] < 0 || this.colors[i] >= 999) continue;
                        graphics.setColor(ccolors[this.colors[i]]);
                        SeriesRenderer.this.psym.draw(graphics, this.dpsymsPathX[i], this.dpsymsPathY[i], fsymSize, SeriesRenderer.this.fillStyle);
                    }
                }
            } else {
                for (int i = 0; i < this.count; ++i) {
                    try {
                        SeriesRenderer.this.psym.draw(graphics, this.dpsymsPathX[i], this.dpsymsPathY[i], fsymSize, SeriesRenderer.this.fillStyle);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
            }
            logger.log(Level.FINE, "done PsymRenderElement.renderDraw ({0}ms)", System.currentTimeMillis() - t0);
            return this.count;
        }

        @Override
        public synchronized void renderBackground(Graphics2D graphics) {
            Color color0 = graphics.getColor();
            Color backgroundColor = graphics.getBackground();
            graphics.setColor(backgroundColor);
            double backLineWidth = GraphUtil.parseLayoutLength(SeriesRenderer.this.backgroundThick, SeriesRenderer.this.lineWidth, SeriesRenderer.this.symSize);
            graphics.setStroke(new BasicStroke((float)backLineWidth));
            double backWidth = GraphUtil.parseLayoutLength(SeriesRenderer.this.backgroundThick, SeriesRenderer.this.symSize, SeriesRenderer.this.symSize);
            for (int i1 = 0; i1 < this.count; ++i1) {
                SeriesRenderer.this.psym.draw(graphics, this.dpsymsPathX[i1], this.dpsymsPathY[i1], (float)backWidth, SeriesRenderer.this.fillStyle);
            }
            graphics.setBackground(backgroundColor);
            graphics.setColor(color0);
        }

        @Override
        public synchronized int render(Graphics2D graphics, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            Units zunits;
            DasPlot lparent;
            if (vds.rank() > 1 && !SemanticOps.isBundle((QDataSet)vds) && !SemanticOps.isRank2Waveform((QDataSet)vds)) {
                SeriesRenderer.this.renderException(graphics, xAxis, yAxis, new IllegalArgumentException("dataset is not rank 1"));
            }
            if ((lparent = SeriesRenderer.this.getParent()) == null) {
                return 0;
            }
            QDataSet colorByDataSet = SeriesRenderer.this.colorByDataSet(SeriesRenderer.this.ds);
            logger.log(Level.FINER, "colorByDataSet: {0}", colorByDataSet);
            boolean rgbColor = colorByDataSet != null && Units.rgbColor.equals(colorByDataSet.property("UNITS"));
            int i = SeriesRenderer.this.stampPsyms && !rgbColor && !lparent.getCanvas().isPrintingThread() ? this.renderStamp(graphics, xAxis, yAxis, vds, mon) : this.renderDraw(graphics, xAxis, yAxis, vds, mon);
            if (!SeriesRenderer.this.haveValidColor) {
                lparent.postMessage((Renderer)SeriesRenderer.this, "no valid data to color plot symbols", Level.INFO, null, null);
            }
            DasColorBar lcolorBar = SeriesRenderer.this.colorBar;
            if (colorByDataSet != null && lcolorBar != null && !(zunits = SemanticOps.getUnits((QDataSet)colorByDataSet)).isConvertibleTo(lcolorBar.getUnits())) {
                lparent.postMessage((Renderer)SeriesRenderer.this, "colorbar units do not match, data units are \"" + zunits + "\"", Level.INFO, null, null);
            }
            return i;
        }

        @Override
        public synchronized void update(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            QDataSet colorByDataSet1 = SeriesRenderer.this.colorByDataSet(dataSet);
            QDataSet wdsz = null;
            if (colorByDataSet1 != null) {
                wdsz = SemanticOps.weightsDataSet((QDataSet)colorByDataSet1);
                SeriesRenderer.this.haveValidColor = false;
            } else {
                SeriesRenderer.this.haveValidColor = true;
            }
            DasColorBar fcolorBar = SeriesRenderer.this.colorBar;
            Units zunits = null;
            if (fcolorBar != null) {
                if (colorByDataSet1 != null && !(zunits = SemanticOps.getUnits((QDataSet)colorByDataSet1)).isConvertibleTo(fcolorBar.getUnits())) {
                    zunits = fcolorBar.getUnits();
                }
                fcolorBar.setSpecialColors(SeriesRenderer.this.specialColors);
            }
            this.count = 0;
            this.dpsymsPathX = new double[SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex];
            this.dpsymsPathY = new double[SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex];
            this.colors = new int[SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex + 2];
            this.rgbColors = new int[SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex + 2];
            int index = SeriesRenderer.this.firstIndex;
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
            QDataSet vds = SeriesRenderer.this.ytagsDataSet(dataSet);
            if (xds.rank() == 2 && xds.property("BINS_1") != null) {
                xds = Ops.reduceMean((QDataSet)xds, (int)1);
            }
            if (dataSet.rank() == 2 && xds.length() != vds.length()) {
                return;
            }
            Units xUnits = SemanticOps.getUnits((QDataSet)xds);
            Units yUnits = SemanticOps.getUnits((QDataSet)vds);
            if (SeriesRenderer.this.unitsWarning) {
                yUnits = yAxis.getUnits();
            }
            if (SeriesRenderer.this.xunitsWarning) {
                xUnits = xAxis.getUnits();
            }
            double dx0 = -99.0;
            double dy0 = -99.0;
            QDataSet wds = SemanticOps.weightsDataSet((QDataSet)vds);
            int buffer = (int)Math.ceil(Math.max(20.0, SeriesRenderer.this.getSymSize()));
            Rectangle window = DasDevicePosition.toRectangle(yAxis.getRow(), xAxis.getColumn());
            window = new Rectangle(window.x - buffer, window.y - buffer, window.width + 2 * buffer, window.height + 2 * buffer);
            DasPlot lparent = SeriesRenderer.this.getParent();
            if (lparent == null) {
                return;
            }
            window = lparent.isOverSize() ? new Rectangle(window.x - window.width / 3, window.y - buffer, 5 * window.width / 3, window.height + 2 * buffer) : new Rectangle(window.x - buffer, window.y - buffer, window.width + 2 * buffer, window.height + 2 * buffer);
            boolean rgbColor = colorByDataSet1 != null && Units.rgbColor.equals(zunits);
            int i = 0;
            while (index < SeriesRenderer.this.lastIndex) {
                block26: {
                    double dy;
                    double dx;
                    block25: {
                        block24: {
                            double x = xds.value(index);
                            double y = vds.value(index);
                            boolean isValid = wds.value(index) > 0.0 && xUnits.isValid(x);
                            dx = xAxis.transform(x, xUnits);
                            dy = yAxis.transform(y, yUnits);
                            if (!isValid || !window.contains(dx, dy)) break block25;
                            if (SeriesRenderer.this.simplifyPaths && dx == dx0 && dy == dy0) break block26;
                            this.dpsymsPathX[i] = dx;
                            this.dpsymsPathY[i] = dy;
                            if (wdsz != null && colorByDataSet1 != null && fcolorBar != null) {
                                try {
                                    if (wdsz.value(index) > 0.0) {
                                        SeriesRenderer.this.haveValidColor = true;
                                        if (rgbColor) {
                                            this.colors[i] = (int)colorByDataSet1.value(index);
                                        } else {
                                            this.rgbColors[i] = fcolorBar.rgbTransform(colorByDataSet1.value(index), zunits);
                                            this.colors[i] = fcolorBar.indexColorTransform(colorByDataSet1.value(index), zunits);
                                        }
                                        break block24;
                                    }
                                    this.rgbColors[i] = -1;
                                    this.colors[i] = -1;
                                }
                                catch (NullPointerException ex) {
                                    logger.log(Level.WARNING, ex.getMessage(), ex);
                                }
                            } else if (wdsz != null && rgbColor) {
                                if (wdsz.value(index) > 0.0) {
                                    SeriesRenderer.this.haveValidColor = true;
                                    assert (colorByDataSet1 != null);
                                    this.colors[i] = (int)colorByDataSet1.value(index);
                                } else {
                                    this.colors[i] = -1;
                                }
                            }
                        }
                        ++i;
                    }
                    dx0 = dx;
                    dy0 = dy;
                }
                ++index;
            }
            this.count = i;
            if (this.count == 0) {
                SeriesRenderer.this.haveValidColor = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean acceptContext(Point2D.Double dp) {
            double[] py;
            double[] px;
            PsymRenderElement psymRenderElement = this;
            synchronized (psymRenderElement) {
                px = this.dpsymsPathX;
                py = this.dpsymsPathY;
            }
            if (px == null) {
                return false;
            }
            double rad = Math.max(SeriesRenderer.this.symSize, 5.0f);
            int np = px.length;
            int index = 0;
            while (index < np) {
                int i;
                if (!(dp.distance(px[i = index++], py[i]) < rad)) continue;
                return true;
            }
            return false;
        }
    }

    static interface RenderElement {
        public void renderBackground(Graphics2D var1);

        public int render(Graphics2D var1, DasAxis var2, DasAxis var3, QDataSet var4, ProgressMonitor var5);

        public void update(DasAxis var1, DasAxis var2, QDataSet var3, ProgressMonitor var4);

        public boolean acceptContext(Point2D.Double var1);
    }
}

