/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

import java.awt.Color;
import org.das2.math.Circle;
import org.das2.math.RealPoint;
import org.das2.math.RealWindow;
import org.das2.math.RealWindowGraphics;
import org.das2.math.Triangulation;
import org.das2.math.TriangulationAlgorithm;

class QuarticAlgorithm
extends TriangulationAlgorithm {
    int i;
    int j;
    int k;
    int l;
    Circle c = new Circle();
    static final String algName = "O(n^4)";

    public QuarticAlgorithm(Triangulation t, RealWindow w, int nPoints) {
        super(t, w, algName, nPoints);
    }

    @Override
    public void reset() {
        this.l = 0;
        this.k = 0;
        this.j = 0;
        this.i = 0;
        super.reset();
    }

    @Override
    public void draw(RealWindowGraphics rWG, Triangulation t) {
        if (this.state[2]) {
            if (this.aniControl.animate(1)) {
                rWG.drawTriangle(t.point[this.i], t.point[this.j], t.point[this.k], Color.green);
            }
            if (this.aniControl.animate(3)) {
                rWG.drawCircle(this.c, Color.green);
            }
        } else if (this.state[1]) {
            if (this.aniControl.animate(2)) {
                rWG.drawPoint(t.point[this.l], Color.orange);
            }
        } else if (this.state[4]) {
            if (this.aniControl.animate(1)) {
                rWG.drawTriangle(t.point[this.i], t.point[this.j], t.point[this.k], Color.red);
            }
            if (this.aniControl.animate(3)) {
                rWG.drawCircle(this.c, Color.red);
            }
            if (this.aniControl.animate(2)) {
                rWG.drawPoint(t.point[this.l], Color.red);
            }
        } else if (this.state[0]) {
            t.draw(rWG, Color.black, Color.black);
        } else {
            t.draw(rWG, Color.black, Color.black);
        }
    }

    @Override
    public synchronized void triangulate(Triangulation t) {
        int n = t.nPoints;
        RealPoint[] p = t.point;
        this.i = 0;
        while (this.i < n - 2) {
            this.j = this.i + 1;
            while (this.j < n - 1) {
                if (this.j != this.i) {
                    this.k = this.j + 1;
                    while (this.k < n) {
                        if (this.k != this.i && this.k != this.j) {
                            this.c.circumCircle(p[this.i], p[this.j], p[this.k]);
                            this.animate(2);
                            boolean pointFree = true;
                            this.l = 0;
                            while (this.l < n) {
                                if (this.l != this.i && this.l != this.j && this.l != this.k) {
                                    this.animate(1);
                                    if (this.c.inside(p[this.l])) {
                                        this.animate(4);
                                        pointFree = false;
                                        break;
                                    }
                                }
                                ++this.l;
                            }
                            if (pointFree) {
                                t.addTriangle(this.i, this.j, this.k);
                            }
                            this.animate(0);
                        }
                        ++this.k;
                    }
                }
                ++this.j;
            }
            ++this.i;
        }
    }
}

