/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class MicrophoneStream
extends Thread {
    private TargetDataLine m_line;
    private AudioFileFormat.Type m_targetType;
    private AudioInputStream m_audioInputStream;
    private File m_outputFile;

    public MicrophoneStream(TargetDataLine line, AudioFileFormat.Type targetType, File file) {
        this.m_line = line;
        this.m_audioInputStream = new AudioInputStream(line);
        this.m_targetType = targetType;
        this.m_outputFile = file;
    }

    @Override
    public void start() {
        this.m_line.start();
        super.start();
    }

    public void stopRecording() {
        this.m_line.stop();
        this.m_line.close();
    }

    @Override
    public void run() {
        try {
            AudioSystem.write(this.m_audioInputStream, this.m_targetType, this.m_outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length != 1 || args[0].equals("-h")) {
            MicrophoneStream.printUsageAndExit();
        }
        String strFilename = args[0];
        File outputFile = new File(strFilename);
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = null;
        try {
            targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            targetDataLine.open(audioFormat);
        }
        catch (LineUnavailableException e) {
            MicrophoneStream.out("unable to get a recording line");
            e.printStackTrace();
            System.exit(1);
        }
        AudioFileFormat.Type targetType = AudioFileFormat.Type.WAVE;
        MicrophoneStream recorder = new MicrophoneStream(targetDataLine, targetType, outputFile);
        MicrophoneStream.out("Press ENTER to start the recording.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recorder.start();
        MicrophoneStream.out("Recording...");
        MicrophoneStream.out("Press ENTER to stop the recording.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recorder.stopRecording();
        MicrophoneStream.out("Recording stopped.");
    }

    private static void printUsageAndExit() {
        MicrophoneStream.out("SimpleAudioRecorder: usage:");
        MicrophoneStream.out("\tjava SimpleAudioRecorder -h");
        MicrophoneStream.out("\tjava SimpleAudioRecorder <soundfile>");
        System.exit(0);
    }

    private static void out(String strMessage) {
        System.out.println(strMessage);
    }
}

