/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.util.IdentityHashMap;
import java.util.Map;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.stream.DataTransferType;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.StreamComment;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamHandler;
import org.das2.stream.StreamScalarDescriptor;
import org.das2.stream.StreamYScanDescriptor;

public class ToAscii
implements StreamHandler {
    private Map descriptors = new IdentityHashMap();
    private StreamHandler handler;

    public ToAscii(StreamHandler handler) {
        this.handler = handler;
    }

    @Override
    public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
        PacketDescriptor outpd = (PacketDescriptor)this.descriptors.get(pd);
        this.handler.packet(outpd, xTag, vectors);
    }

    @Override
    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        DataTransferType ascii24 = DataTransferType.getByName("ascii24");
        DataTransferType ascii10 = DataTransferType.getByName("ascii10");
        PacketDescriptor outpd = (PacketDescriptor)pd.clone();
        outpd.getXDescriptor().setDataTransferType(ascii24);
        for (int i = 0; i < outpd.getYCount(); ++i) {
            if (outpd.getYDescriptor(i) instanceof StreamScalarDescriptor) {
                ((StreamScalarDescriptor)outpd.getYDescriptor(i)).setDataTransferType(ascii10);
                continue;
            }
            if (!(outpd.getYDescriptor(i) instanceof StreamYScanDescriptor)) continue;
            ((StreamYScanDescriptor)outpd.getYDescriptor(i)).setDataTransferType(ascii10);
        }
        this.handler.packetDescriptor(outpd);
        this.descriptors.put(pd, outpd);
    }

    @Override
    public void streamClosed(StreamDescriptor sd) throws StreamException {
        this.handler.streamClosed(sd);
    }

    @Override
    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        this.handler.streamDescriptor(sd);
    }

    @Override
    public void streamException(StreamException se) throws StreamException {
        this.handler.streamException(se);
    }

    @Override
    public void streamComment(StreamComment se) throws StreamException {
        this.handler.streamComment(se);
    }

    public void packet(PacketDescriptor pd, DatumVector vector) throws StreamException {
    }
}

