/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.Renderer;
import org.das2.qds.QDataSet;

public class MyRenderer
extends Renderer {
    private double scale = 1.0;

    @Override
    public void render(Graphics2D g, DasAxis xAxis, DasAxis yAxis) {
        if (this.ds == null || this.ds.rank() != 2 || this.ds.length(0) != 4) {
            this.getParent().postMessage((Renderer)this, "dataset not ready or appropriate", Level.INFO, null, null);
            return;
        }
        QDataSet bds = (QDataSet)this.ds.property("BUNDLE_1");
        Units xunits = (Units)bds.property("UNITS", 0);
        Units yunits = (Units)bds.property("UNITS", 1);
        for (int i = 0; i < this.ds.length(); ++i) {
            QDataSet ds1 = this.ds.slice(i);
            int ix = (int)xAxis.transform(ds1.value(0), xunits);
            int iy = (int)yAxis.transform(ds1.value(1), yunits);
            int radius = (int)(this.scale * (xAxis.transform(ds1.value(0) + ds1.value(2), yunits) - (double)ix));
            int irgb = (int)ds1.value(3);
            g.setColor(new Color(irgb));
            g.fillOval(ix - radius, iy - radius, radius * 2, radius * 2);
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double s) {
        this.scale = s;
        this.update();
    }

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.scale = this.getDoubleControl(s, this.scale);
        this.update();
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        if (this.scale != 1.0) {
            controls.put("scale", String.valueOf(this.scale));
        }
        return Renderer.formatControl(controls);
    }
}

