/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qstream.AsciiHexIntegerTransferType;
import org.das2.qstream.AsciiIntegerTransferType;
import org.das2.qstream.AsciiTimeTransferType;
import org.das2.qstream.AsciiTransferType;
import org.das2.qstream.DoubleTransferType;
import org.das2.qstream.FloatTransferType;
import org.das2.qstream.IntegerTransferType;
import org.das2.qstream.StreamException;
import org.das2.qstream.TransferType;

public class BundleStreamFormatter {
    private static final Logger logger = LoggerManager.getLogger((String)"qstream");
    public static final String FORMAT_PATTERN = "(\\%)?(\\d*)(\\.\\d*)?([f|e|d|x])";
    public static final String HEX_FORMAT_PATTERN = "0x(\\%)?(\\d*)?(x)";

    private void formatProperties(StringBuilder build, QDataSet bds, int i) {
        Number n;
        String s = (String)bds.property("DEPENDNAME_0", i);
        if (s != null) {
            build.append(String.format("        <property name=\"DEPENDNAME_0\" type=\"String\" value=\"%s\"/>\n", s));
        } else {
            Object o = bds.property("DEPEND_0", i);
            logger.fine("DEPEND_0 found that is carrying a name of a dataset instead of the reference to the dataset.");
            if (o != null && o instanceof String) {
                build.append(String.format("        <property name=\"DEPENDNAME_0\" type=\"String\" value=\"%s\"/>\n", (String)o));
            }
        }
        Units u = (Units)bds.property("UNITS", i);
        if (u != null) {
            if (u instanceof EnumerationUnits) {
                build.append(String.format("        <property name=\"UNITS\" type=\"enumerationUnit\" value=\"%s\"/>\n", u.getId()));
            } else {
                build.append(String.format("        <property name=\"UNITS\" type=\"units\" value=\"%s\"/>\n", u.getId()));
            }
        }
        if ((n = (Number)bds.property("FILL_VALUE", i)) != null) {
            build.append(String.format("        <property name=\"FILL_VALUE\" type=\"Number\" value=\"%s\"/>\n", n));
        }
        if ((n = (Number)bds.property("VALID_MIN", i)) != null) {
            build.append(String.format("        <property name=\"VALID_MIN\" type=\"Number\" value=\"%s\"/>\n", n));
        }
        if ((n = (Number)bds.property("VALID_MAX", i)) != null) {
            build.append(String.format("        <property name=\"VALID_MAX\" type=\"Number\" value=\"%s\"/>\n", n));
        }
        if ((n = (Number)bds.property("TYPICAL_MIN", i)) != null) {
            build.append(String.format("        <property name=\"TYPICAL_MIN\" type=\"Number\" value=\"%s\"/>\n", n));
        }
        if ((n = (Number)bds.property("TYPICAL_MAX", i)) != null) {
            build.append(String.format("        <property name=\"TYPICAL_MAX\" type=\"Number\" value=\"%s\"/>\n", n));
        }
        if ((s = (String)bds.property("NAME", i)) != null) {
            build.append(String.format("        <property name=\"NAME\" type=\"String\" value=\"%s\"/>\n", s));
        }
        if ((s = (String)bds.property("LABEL", i)) != null) {
            build.append(String.format("        <property name=\"LABEL\" type=\"String\" value=\"%s\"/>\n", s));
        }
        if ((s = (String)bds.property("TITLE", i)) != null) {
            build.append(String.format("        <property name=\"TITLE\" type=\"String\" value=\"%s\"/>\n", s));
        }
    }

    private String nameFor(QDataSet bds, int j) {
        String name = (String)bds.property("NAME", j);
        if (name == null) {
            name = (String)bds.property("LABEL", j);
            if (name != null) {
                name = Ops.safeName((String)name);
            } else {
                String base = "data_";
                Units u = (Units)bds.property("UNITS", j);
                if (u != null && UnitsUtil.isTimeLocation((Units)u)) {
                    base = "time_";
                }
                name = base + j;
            }
        }
        return name;
    }

    public static TransferType guessAsciiTransferType(QDataSet ds) {
        Units u = SemanticOps.getUnits((QDataSet)ds);
        String format = (String)ds.property("FORMAT");
        if (format != null) {
            Pattern p = Pattern.compile(FORMAT_PATTERN);
            Matcher m = p.matcher(format);
            if (m.matches()) {
                AsciiTransferType result;
                char ch = format.charAt(format.length() - 1);
                int len = Integer.parseInt(m.group(1));
                String sdec = m.group(2);
                int dec = sdec != null ? Integer.parseInt(sdec) : 2;
                switch (ch) {
                    case 'f': {
                        result = new AsciiTransferType(len, false, dec);
                        break;
                    }
                    case 'e': {
                        result = new AsciiTransferType(len, true, dec);
                        break;
                    }
                    case 'd': {
                        result = new AsciiIntegerTransferType(len);
                        break;
                    }
                    case 'x': {
                        result = new AsciiIntegerTransferType(len);
                        break;
                    }
                    default: {
                        result = new AsciiTransferType(10, true);
                    }
                }
                return result;
            }
            logger.warning("format string must match (\\%)?(\\d*)(\\.\\d*)?([f|e|d|x])");
            return new AsciiTransferType(10, true);
        }
        if (UnitsUtil.isRatioMeasurement((Units)u)) {
            QDataSet gcd = DataSetUtil.gcd((QDataSet)Ops.diff((QDataSet)ds), (QDataSet)Ops.dataset((Object)u.getOffsetUnits().createDatum(1.0E-4)));
            int fracDigits = (int)Math.ceil(-1.0 * Math.log10(gcd.value()));
            QDataSet extent = Ops.extent((QDataSet)ds);
            int intDigits = -1 * (int)Math.log10(Math.abs(extent.value(0)));
            intDigits = Math.max(intDigits, (int)Math.log10(Math.abs(extent.value(1))));
            return new AsciiTransferType(intDigits + 1 + fracDigits, false, fracDigits);
        }
        return new AsciiTransferType(10, true);
    }

    public void format(QDataSet ds, OutputStream osout, boolean asciiTypes) throws StreamException, IOException {
        String defaultName;
        Units u;
        if (ds.property("BUNDLE_1") == null) {
            throw new IllegalArgumentException("only rank 2 bundles");
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            QDataSet newBundle = Ops.bundle((QDataSet)dep0, (QDataSet)Ops.unbundle((QDataSet)ds, (int)0));
            for (int j = 1; j < ds.length(0); ++j) {
                newBundle = Ops.bundle((QDataSet)newBundle, (QDataSet)Ops.unbundle((QDataSet)ds, (int)j));
            }
            ds = newBundle;
        }
        QDataSet bds = (QDataSet)ds.property("BUNDLE_1");
        int nf = bds.length();
        TransferType[] tt = new TransferType[bds.length()];
        int recordLength = 0;
        if (dep0 != null) {
            // empty if block
        }
        Units[] units = new Units[bds.length()];
        for (int j = 0; j < bds.length(); ++j) {
            if (asciiTypes) {
                String format = (String)bds.property("FORMAT", j);
                Units u2 = (Units)bds.property("UNITS", j);
                if (u2 == null) {
                    u2 = Units.dimensionless;
                }
                units[j] = u2;
                boolean useGuess = false;
                if (useGuess && format != null && !UnitsUtil.isTimeLocation((Units)u2)) {
                    tt[j] = BundleStreamFormatter.guessAsciiTransferType(Ops.slice1((QDataSet)ds, (int)j));
                } else if (UnitsUtil.isTimeLocation((Units)u2)) {
                    tt[j] = new AsciiTimeTransferType(24, u2);
                } else if (UnitsUtil.isNominalMeasurement((Units)u2)) {
                    tt[j] = new AsciiIntegerTransferType(10);
                } else if (format != null) {
                    int isize = 10;
                    String stype = "f";
                    Pattern p = Pattern.compile(FORMAT_PATTERN);
                    Matcher m = p.matcher(format);
                    if (m.matches()) {
                        String ssize = m.group(2);
                        isize = ssize == null || ssize.length() == 0 ? 10 : Integer.parseInt(ssize);
                        stype = m.group(4);
                    } else {
                        p = Pattern.compile(HEX_FORMAT_PATTERN);
                        m = p.matcher(format);
                        if (m.matches()) {
                            String ssize = m.group(2);
                            isize = ssize == null ? 11 : 3 + Integer.parseInt(ssize);
                            stype = "x";
                        }
                    }
                    if (stype != null && stype.length() > 0) {
                        char ch = stype.charAt(0);
                        switch (ch) {
                            case 'x': {
                                tt[j] = new AsciiHexIntegerTransferType(isize);
                                break;
                            }
                            case 'd': {
                                tt[j] = new AsciiIntegerTransferType(isize);
                                break;
                            }
                            case 'e': {
                                tt[j] = new AsciiTransferType(isize, true);
                                break;
                            }
                            case 'f': {
                                tt[j] = new AsciiTransferType(isize, false);
                                break;
                            }
                        }
                    } else {
                        tt[j] = new AsciiTransferType(10, true);
                    }
                } else {
                    tt[j] = new AsciiTransferType(10, true);
                }
            } else {
                u = (Units)bds.property("UNITS", j);
                if (u == null) {
                    u = Units.dimensionless;
                }
                units[j] = u;
                tt[j] = UnitsUtil.isTimeLocation((Units)u) ? new DoubleTransferType() : (UnitsUtil.isNominalMeasurement((Units)u) ? new IntegerTransferType() : new FloatTransferType());
            }
            recordLength += tt[j].sizeBytes();
        }
        int defaultColumn = bds.length() < 3 ? bds.length() - 1 : 1;
        u = (Units)bds.property("UNITS", defaultColumn);
        if (u != null && UnitsUtil.isTimeLocation((Units)u) && bds.length() > 2) {
            ++defaultColumn;
        }
        if ((defaultName = (String)bds.property("NAME")) == null) {
            defaultName = "Bundle1";
        }
        String rec = String.format("<stream dataset_id=\"%s\"/>\n", defaultName);
        byte[] bytes = rec.getBytes("UTF-8");
        osout.write(String.format("[00]%06d", bytes.length).getBytes("UTF-8"));
        osout.write(bytes);
        StringBuilder build = new StringBuilder();
        build.append("<packet>\n");
        StringBuilder bdsNames = new StringBuilder();
        for (int j = 0; j < bds.length(); ++j) {
            String name = this.nameFor(bds, j);
            if (j > 0) {
                bdsNames.append(",");
            }
            bdsNames.append(name);
            build.append(String.format("  <qdataset id=\"%s\" rank=\"1\">\n", name));
            build.append(String.format("     <properties>\n", new Object[0]));
            this.formatProperties(build, bds, j);
            build.append(String.format("     </properties>\n", new Object[0]));
            build.append(String.format("     <values encoding=\"%s\" length=\"%d\"/>\n", tt[j].name(), 1));
            build.append(String.format("  </qdataset>\n", new Object[0]));
        }
        build.append("</packet>\n");
        bytes = build.toString().getBytes("UTF-8");
        osout.write(String.format("[01]%06d", bytes.length).getBytes("UTF-8"));
        osout.write(bytes);
        build = new StringBuilder();
        build.append("<packet>\n");
        build.append(String.format("<qdataset id=\"%s\" rank=\"2\">\n", defaultName));
        build.append("<properties>\n");
        build.append("   <property name=\"BUNDLE_1\" type=\"qdataset\" value=\"ds_1\"/>\n");
        build.append("   <property name=\"QUBE\" type=\"Boolean\" value=\"true\"/>\n");
        build.append("</properties>\n");
        build.append(String.format("<values bundle=\"%s\"/>\n", bdsNames));
        build.append("</qdataset>\n");
        build.append("</packet>\n");
        bytes = build.toString().getBytes("UTF-8");
        osout.write(String.format("[02]%06d", bytes.length).getBytes("UTF-8"));
        osout.write(bytes);
        HashMap<Integer, String> enumerations = new HashMap<Integer, String>();
        byte[] packet = String.format(":01:", new Object[0]).getBytes("UTF-8");
        ByteBuffer buf = ByteBuffer.allocate(recordLength);
        for (int i = 0; i < ds.length(); ++i) {
            int j;
            for (j = 0; j < ds.length(0); ++j) {
                int iv;
                if (!(units[j] instanceof EnumerationUnits) || enumerations.containsKey(iv = (int)ds.value(i, j))) continue;
                EnumerationUnits eu = (EnumerationUnits)units[j];
                Datum d = eu.createDatum(iv);
                int c = eu.getColor(d);
                String label = d.toString();
                String ss = String.format("<enumerationUnit name=\"%s\"  value=\"%d\" color=\"0x%06x\" label=\"%s\" />\n", eu.getId(), iv, c, label);
                bytes = ss.getBytes("UTF-8");
                osout.write(String.format("[xx]%06d", bytes.length).getBytes("UTF-8"));
                osout.write(bytes);
                enumerations.put(iv, label);
            }
            osout.write(packet);
            for (j = 0; j < nf; ++j) {
                tt[j].write(ds.value(i, j), buf);
            }
            byte[] array = buf.array();
            if (tt[nf - 1].isAscii() && array[recordLength - 1] == 32) {
                array[recordLength - 1] = 10;
            }
            osout.write(array);
            buf.flip();
        }
        osout.close();
    }
}

