/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d.viewer;

import ProGAL.geom2d.LSC;
import ProGAL.geom2d.viewer.J2DScene;
import ProGAL.geom2d.viewer.ShapePainter;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;

class LSCPainter
implements ShapePainter {
    LSCPainter() {
    }

    @Override
    public void paintShape(J2DScene.ShapeOptions shape, Graphics2D g2d) {
        LSC lsc = (LSC)shape.shape;
        Point gPoint0 = shape.transformPoint(lsc.getSegment().getA());
        Point gPoint1 = shape.transformPoint(lsc.getSegment().getB());
        if (shape.fill) {
            g2d.setStroke(new BasicStroke((float)(shape.getScale() * (lsc.getRadius() * 2.0 + shape.borderWidth)), 1, 1));
        } else {
            CompositeStroke str = new CompositeStroke(new BasicStroke((float)(shape.getScale() * lsc.getRadius() * 2.0), 1, 1), new BasicStroke((float)(shape.getScale() * shape.borderWidth)));
            g2d.setStroke(str);
        }
        g2d.drawLine(gPoint0.x, gPoint0.y, gPoint1.x, gPoint1.y);
    }

    private static class CompositeStroke
    implements Stroke {
        private Stroke stroke1;
        private Stroke stroke2;

        CompositeStroke(Stroke stroke1, Stroke stroke2) {
            this.stroke1 = stroke1;
            this.stroke2 = stroke2;
        }

        @Override
        public Shape createStrokedShape(Shape shape) {
            return this.stroke2.createStrokedShape(this.stroke1.createStrokedShape(shape));
        }
    }
}

