/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.complex;

import ProGAL.geom3d.Point;
import ProGAL.geom3d.complex.CEdge;
import ProGAL.geom3d.complex.CTetrahedron;
import ProGAL.geom3d.complex.CTriangle;
import java.util.ArrayList;
import java.util.List;

public class CVertex
extends Point {
    private static final long serialVersionUID = 1L;
    private boolean degenerate = false;
    private DegenerateCase degCase;
    private CVertex degPointOpposite;
    private CVertex degPointA;
    private CVertex degPointB;
    private final boolean bigPoint;
    public final int idx;
    private final List<CEdge> adjacentEdges = new ArrayList<CEdge>();

    public boolean isBigpoint() {
        return this.bigPoint;
    }

    public CVertex getDegPointA() {
        return this.degPointA;
    }

    public void setDegPointA(CVertex degPointA) {
        this.degPointA = degPointA;
    }

    public CVertex getDegPointB() {
        return this.degPointB;
    }

    public void setDegPointB(CVertex degPointB) {
        this.degPointB = degPointB;
    }

    public DegenerateCase getDegCase() {
        return this.degCase;
    }

    public void setDegCase(DegenerateCase degCase) {
        this.degCase = degCase;
    }

    public boolean isDegenerate() {
        return this.degenerate;
    }

    public void setDegenerate(boolean degenerate) {
        this.degenerate = degenerate;
    }

    public CVertex(Point p, int idx) {
        this(p, false, idx);
    }

    public CVertex(Point p, boolean bigpoint, int idx) {
        super(p);
        this.setDegenerate(false);
        this.bigPoint = bigpoint;
        this.idx = idx;
    }

    public CVertex getDegPointOpposite() {
        return this.degPointOpposite;
    }

    public void setDegPointOpposite(CVertex degPointOpposite) {
        this.degPointOpposite = degPointOpposite;
    }

    public void addAdjacentEdge(CEdge e) {
        this.adjacentEdges.add(e);
    }

    public List<CEdge> getAdjacentEdges() {
        return this.adjacentEdges;
    }

    public List<CTriangle> getAdjacentTriangles() {
        ArrayList<CTriangle> adjacentTriangles = new ArrayList<CTriangle>();
        for (CEdge edge : this.adjacentEdges) {
            List<CTriangle> triangles = edge.getAdjacentTriangles();
            for (CTriangle triangle : triangles) {
                if (adjacentTriangles.contains(triangle)) continue;
                adjacentTriangles.add(triangle);
            }
        }
        return adjacentTriangles;
    }

    public List<CTriangle> getOppositeTriangles() {
        ArrayList<CTriangle> oppositeTriangles = new ArrayList<CTriangle>();
        for (CTetrahedron tetr : this.getAllAdjacentTetrahedra()) {
            int index = tetr.findpoint(this);
            if (tetr.containsBigPoint()) continue;
            oppositeTriangles.add(tetr.getTriangle(index));
        }
        return oppositeTriangles;
    }

    public List<CTetrahedron> getAdjacentTetrahedra() {
        ArrayList<CTetrahedron> adjacentTetrahedra = new ArrayList<CTetrahedron>();
        for (CTriangle triangle : this.getAdjacentTriangles()) {
            for (int i = 0; i < 2; ++i) {
                CTetrahedron tetr = triangle.getAdjacentTetrahedron(i);
                if (tetr.containsBigPoint() || adjacentTetrahedra.contains(tetr)) continue;
                adjacentTetrahedra.add(tetr);
            }
        }
        return adjacentTetrahedra;
    }

    public List<CTetrahedron> getAllAdjacentTetrahedra() {
        ArrayList<CTetrahedron> adjacentTetrahedra = new ArrayList<CTetrahedron>();
        for (CTriangle triangle : this.getAdjacentTriangles()) {
            for (int i = 0; i < 2; ++i) {
                CTetrahedron tetr = triangle.getAdjacentTetrahedron(i);
                if (adjacentTetrahedra.contains(tetr)) continue;
                adjacentTetrahedra.add(tetr);
            }
        }
        return adjacentTetrahedra;
    }

    public List<CTetrahedron> getBigAdjacentTetrahedra() {
        ArrayList<CTetrahedron> adjacentBigTetrahedra = new ArrayList<CTetrahedron>();
        for (CTetrahedron tetr : this.getAllAdjacentTetrahedra()) {
            if (!tetr.containsBigPoint() || adjacentBigTetrahedra.contains(tetr)) continue;
            adjacentBigTetrahedra.add(tetr);
        }
        return adjacentBigTetrahedra;
    }

    @Override
    public String toString() {
        return this.toString(2);
    }

    @Override
    public String toString(int dec) {
        return String.format("CVertex[x=%." + dec + "f,y=%." + dec + "f,z=%." + dec + "f%s]", this.x(), this.y(), this.z(), this.bigPoint ? ",big point" : "");
    }

    public static enum DegenerateCase {
        ONFACE,
        ONEDGE;

    }
}

