/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.kineticDelaunay;

import ProGAL.geom3d.Point;
import ProGAL.geom3d.Shape;
import ProGAL.geom3d.Triangle;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.kineticDelaunay.Edge;
import ProGAL.geom3d.kineticDelaunay.Hole;
import ProGAL.geom3d.kineticDelaunay.Tri;
import ProGAL.geom3d.kineticDelaunay.Vertex;
import ProGAL.geom3d.viewer.J3DScene;
import ProGAL.geom3d.volumes.LSS;
import ProGAL.geom3d.volumes.Sphere;
import ProGAL.geom3d.volumes.Tetrahedron;
import ProGAL.math.Constants;
import ProGAL.math.Matrix;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Tet {
    Vertex[] corners = new Vertex[4];
    private Set<Edge> edges = new HashSet<Edge>();
    private Tri[] tris = new Tri[4];
    Tet[] neighbors = new Tet[4];
    int[] oppIndex = new int[4];
    Sphere circumSphere = null;
    Integer count = null;
    boolean dAlive = true;
    boolean cAlive = true;
    Shape[] LSSs;
    Shape[] faces;
    Shape faceShape = null;
    boolean onStack = false;
    Hole.Face selectedFace = null;
    private boolean[] oppositeInside;
    private boolean centerInside;
    boolean flag = false;
    Integer depth = null;
    int helper;
    boolean inAlphaComplex = false;
    int alph = 0;
    private static final double reci6 = 0.16666666666666666;

    public Tet(Vertex[] corners) {
        this.corners = corners;
        this.sortCorners();
    }

    public Tet(Vertex v0, Vertex v1, Vertex v2, Vertex v3) {
        this.corners[0] = v0;
        this.corners[1] = v1;
        this.corners[2] = v2;
        this.corners[3] = v3;
        this.sortCorners();
    }

    public Tet(Tetrahedron tetra) {
        for (int i = 0; i < 4; ++i) {
            this.corners[i] = new Vertex(tetra.getCorner(i));
        }
        this.sortCorners();
    }

    public Tet clone() {
        Tet nt = new Tet(this.corners);
        for (int i = 0; i < 4; ++i) {
            nt.neighbors[i] = this.neighbors[i];
        }
        return nt;
    }

    public void setEdge(Edge e) {
        this.edges.add(e);
    }

    public void removeEdge(Edge e) {
        this.edges.remove(e);
    }

    public void setTri(Tri t, int i) {
        this.tris[i] = t;
    }

    public Tri getTri(int i) {
        return this.tris[i];
    }

    public Tri getTri(Vertex v) {
        for (int i = 0; i < 4; ++i) {
            if (!this.corners[i].equals(v)) continue;
            return this.tris[i];
        }
        return null;
    }

    public Tri[] getTris() {
        return this.tris;
    }

    public Vertex getCorner(int i) {
        return this.corners[i];
    }

    public Tet getNeighbor(int i) {
        return this.neighbors[i];
    }

    public boolean getFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public Vertex[] getCornerPair(Vertex a, Vertex b) {
        Vertex[] pair = new Vertex[2];
        for (int k = 0; k < 4; ++k) {
            pair[0] = this.corners[k];
            if (pair[0] != a && pair[0] != b) break;
        }
        for (int l = k + 1; l < 4; ++l) {
            pair[1] = this.corners[l];
            if (pair[1] != a && pair[1] != b) break;
        }
        return pair;
    }

    public Sphere getCircumSphere() {
        this.setCircumSphere();
        return this.circumSphere;
    }

    public double getCircumSphereRadius() {
        return this.getCircumSphere().getRadius();
    }

    public void setCircumSphere() {
        Vector a = this.corners[3].vectorTo(this.corners[0]);
        Vector b = this.corners[3].vectorTo(this.corners[1]);
        Vector c = this.corners[3].vectorTo(this.corners[2]);
        Vector O = b.cross(c).multiplyThis(a.dot(a));
        O.addThis(c.cross(a).multiplyThis(b.dot(b)));
        O.addThis(a.cross(b).multiplyThis(c.dot(c)));
        O.multiplyThis(1.0 / (2.0 * a.dot(b.crossThis(c))));
        this.circumSphere = new Sphere(this.corners[3].add(O), O.length());
    }

    public double circumRadius() {
        Vector a = this.corners[3].vectorTo(this.corners[0]);
        Vector b = this.corners[3].vectorTo(this.corners[1]);
        Vector c = this.corners[3].vectorTo(this.corners[2]);
        Vector O = b.cross(c).multiplyThis(a.dot(a));
        O.addThis(c.cross(a).multiplyThis(b.dot(b)));
        O.addThis(a.cross(b).multiplyThis(c.dot(c)));
        O.multiplyThis(1.0 / (2.0 * a.dot(b.crossThis(c))));
        return O.length();
    }

    public double getVolume() {
        double x1 = this.corners[1].x() - this.corners[0].x();
        double y1 = this.corners[1].y() - this.corners[0].y();
        double z1 = this.corners[1].z() - this.corners[0].z();
        double x2 = this.corners[2].x() - this.corners[0].x();
        double y2 = this.corners[2].y() - this.corners[0].y();
        double z2 = this.corners[2].z() - this.corners[0].z();
        double x3 = this.corners[3].x() - this.corners[0].x();
        double y3 = this.corners[3].y() - this.corners[0].y();
        double z3 = this.corners[3].z() - this.corners[0].z();
        double cx = y2 * z3 - z2 * y3;
        double cy = z2 * x3 - x2 * z3;
        double cz = x2 * y3 - y2 * x3;
        double ret = Math.abs(x1 * cx + y1 * cy + z1 * cz);
        return ret * 0.16666666666666666;
    }

    public void setAlph(int i) {
        this.alph = i;
    }

    public int getAlph() {
        return this.alph;
    }

    public boolean hasVertex(Vertex v) {
        for (int i = 0; i < 4; ++i) {
            if (this.corners[i] != v) continue;
            return true;
        }
        return false;
    }

    public boolean hasEdge(Edge e) {
        return this.edges.contains(e);
    }

    public Edge[] getCommonEdges(Tet t) {
        Edge[] es = new Edge[4];
        int num = 0;
        for (Edge e : this.edges) {
            if (!t.hasEdge(e)) continue;
            es[num] = e;
            ++num;
        }
        return es;
    }

    public boolean hasNeighbor(Tet t) {
        for (int i = 0; i < 4; ++i) {
            if (this.neighbors[i] != t) continue;
            return true;
        }
        return false;
    }

    public boolean isAlive() {
        return this.dAlive;
    }

    public void setAlive(boolean dAlive) {
        this.dAlive = dAlive;
    }

    public boolean isBig() {
        return this.corners[0].getId() < 4 || this.corners[1].getId() < 4 || this.corners[2].getId() < 4 || this.corners[3].getId() < 4;
    }

    public boolean isFlat() {
        return Point.coplanar(this.corners[0], this.corners[1], this.corners[2], this.corners[3]);
    }

    public boolean isConvex(Tet tet) {
        Vertex q;
        Vertex p;
        Triangle tr = this.commonFace(tet);
        return tr.getIntersection(p = this.corners[this.apex(tet)], q = tet.corners[tet.apex(this)]) != null;
    }

    public boolean isAlpha(double alpha) {
        return this.getCircumSphereRadius() < alpha + Constants.EPSILON;
    }

    private void normalizePredicates() {
        if (this.oppositeInside == null) {
            this.oppositeInside = new boolean[4];
        }
        for (int i = 0; i < 4; ++i) {
            this.oppositeInside[i] = this.orient(i, this.corners[i]);
        }
        this.centerInside = this.inSphere(Point.getMidpoint(this.corners[0], this.corners[1]));
    }

    public int getCount() {
        this.count = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.corners[i].getType() != Vertex.VertexType.R) continue;
            this.count = this.count + (int)Math.pow(2.0, i);
        }
        return this.count;
    }

    public int nrRotating() {
        int ret = 0;
        for (Vertex v : this.corners) {
            if (v.getType() != Vertex.VertexType.R) continue;
            ++ret;
        }
        return ret;
    }

    public Vertex getOppVertexSlow(Tet tet) {
        for (int k = 0; k < 4; ++k) {
            if (this.hasVertex(tet.corners[k])) continue;
            return tet.corners[k];
        }
        return null;
    }

    public Vertex getOppVertex(Tet tet) {
        int i = 0;
        while (this.corners[i].getId() == tet.corners[i].getId()) {
            ++i;
        }
        if (tet.corners[i].getId() < this.corners[i].getId()) {
            return tet.corners[i];
        }
        while (i < 3 && this.corners[i + 1].getId() == tet.corners[i].getId()) {
            ++i;
        }
        return tet.corners[i];
    }

    public List<Tet> getFaceSharingTetrahedra() {
        ArrayList<Tet> nList = new ArrayList<Tet>();
        for (int k = 0; k < 4; ++k) {
            if (this.neighbors[k].isBig()) continue;
            nList.add(this.neighbors[k]);
        }
        return nList;
    }

    public Tet getNeighbour(int i) {
        return this.neighbors[i];
    }

    public void getEdgeSharingTetrahedra(Vertex a, Vertex b, HashSet<Tet> processedTets, HashSet<Vertex> processedVers) {
        Vertex[] pair = this.getCornerPair(a, b);
        this.getEdgeSharingTetrahedra(a, b, pair, processedTets, processedVers, this, this);
    }

    private void getEdgeSharingTetrahedra(Vertex a, Vertex b, Vertex[] pair, HashSet<Tet> processedTets, HashSet<Vertex> processedVers, Tet prev, Tet first) {
        Tet tet;
        if (!processedTets.contains(this) && !this.isBig()) {
            processedTets.add(this);
        }
        if (!processedVers.contains(pair[0])) {
            processedVers.add(pair[0]);
        }
        if (!processedVers.contains(pair[1])) {
            processedVers.add(pair[1]);
        }
        if ((tet = this.neighbors[this.indexOf(pair[0])]) != prev && tet != first) {
            tet.getEdgeSharingTetrahedra(a, b, tet.getCornerPair(a, b), processedTets, processedVers, this, first);
        } else {
            tet = this.neighbors[this.indexOf(pair[1])];
            if (tet != prev && tet != first) {
                tet.getEdgeSharingTetrahedra(a, b, tet.getCornerPair(a, b), processedTets, processedVers, this, first);
            }
        }
    }

    public void getVertexSharingTetrahedra(Vertex a, double alpha, HashSet<Tet> alphaTets, HashSet<Tet> processedTets, HashSet<Vertex> processedVers) {
        if (!processedTets.contains(this)) {
            processedTets.add(this);
            if (!this.isBig() && this.getCircumSphereRadius() < alpha) {
                alphaTets.add(this);
            }
            int indxA = this.indexOf(a);
            for (int k = 0; k < 4; ++k) {
                if (k == indxA) continue;
                Vertex b = this.corners[k];
                if (!processedVers.contains(b) && !b.isBig() && this.getCircumSphereRadius() < alpha && indxA < b.getId()) {
                    processedVers.add(b);
                }
                if (this.neighbors[k] == null) continue;
                this.neighbors[k].getVertexSharingTetrahedra(a, alpha, alphaTets, processedTets, processedVers);
            }
        }
    }

    private boolean orient(int face, Point p) {
        Matrix m = new Matrix(4, 4);
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                m.set(r, c, this.corners[(r + (r >= face ? 1 : 0)) % 4].getCoord(c));
            }
            m.set(r, 3, 1.0);
        }
        for (int c = 0; c < 3; ++c) {
            m.set(3, c, p.getCoord(c));
        }
        m.set(3, 3, 1.0);
        double det = m.determinant();
        if (Math.abs(det) < Constants.EPSILON) {
            return true;
        }
        return det < 0.0;
    }

    public Set<Edge> getEdges() {
        return this.edges;
    }

    public void killEdges() {
        for (Edge e : this.edges) {
            e.setAlive(false);
        }
    }

    public void reviveEdges() {
        for (Edge e : this.edges) {
            e.setAlive(true);
        }
    }

    private boolean inSphere(Point p) {
        Matrix m = new Matrix(5, 5);
        for (int r = 0; r < 4; ++r) {
            for (int c = 0; c < 3; ++c) {
                m.set(r, c, this.corners[r].getCoord(c));
            }
            m.set(r, 3, this.corners[r].dot(this.corners[r]));
            m.set(r, 4, 1.0);
        }
        for (int c = 0; c < 3; ++c) {
            m.set(4, c, p.getCoord(c));
        }
        m.set(4, 3, p.dot(p));
        m.set(4, 4, 1.0);
        double det = m.determinant();
        if (Math.abs(det) < Constants.EPSILON) {
            return true;
        }
        return det < 0.0;
    }

    public boolean insideFace(int face, Point p) {
        if (this.oppositeInside == null) {
            this.normalizePredicates();
        }
        return this.orient(face, p) == this.oppositeInside[face];
    }

    public boolean insideCircumsphere(Point p) {
        if (this.oppositeInside == null) {
            this.normalizePredicates();
        }
        return this.inSphere(p) == this.centerInside;
    }

    public int apex(Tet tet) {
        for (int i = 0; i < 4; ++i) {
            if (this.neighbors[i] != tet) continue;
            return i;
        }
        return -1;
    }

    public Triangle commonFace(Tet t) {
        Point[] common = new Vertex[3];
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.corners[i] == t.corners[j]) {
                    common[k++] = this.corners[i];
                    continue;
                }
                if (k == 3) break;
            }
            if (k == 3) break;
        }
        return new Triangle(common);
    }

    public int indexOf(Vertex v) {
        for (int i = 0; i < 3; ++i) {
            if (!this.corners[i].equals(v)) continue;
            return i;
        }
        return 3;
    }

    public int indexOf_slow(Vertex v) {
        return Arrays.binarySearch(this.corners, v);
    }

    public int indexOf(Vertex a, Vertex b, Vertex c) {
        for (int i = 0; i < 4; ++i) {
            if (this.corners[i].equals(a) || this.corners[i].equals(b) || this.corners[i].equals(c)) continue;
            return i;
        }
        return -1;
    }

    private final void swap(int i, int j) {
        Vertex tmpV = this.corners[i];
        Tet tmpT = this.neighbors[i];
        this.corners[i] = this.corners[j];
        this.neighbors[i] = this.neighbors[j];
        this.corners[j] = tmpV;
        this.neighbors[j] = tmpT;
    }

    protected final void sortCorners() {
        if (this.corners[0].compareTo(this.corners[1]) > 0) {
            this.swap(0, 1);
        }
        if (this.corners[2].compareTo(this.corners[3]) > 0) {
            this.swap(2, 3);
        }
        if (this.corners[0].compareTo(this.corners[2]) > 0) {
            this.swap(0, 2);
        }
        if (this.corners[1].compareTo(this.corners[3]) > 0) {
            this.swap(1, 3);
        }
        if (this.corners[1].compareTo(this.corners[2]) > 0) {
            this.swap(1, 2);
        }
    }

    public String toString() {
        return Arrays.toString(this.corners);
    }

    public void toConsole() {
        System.out.println(this.toString());
    }

    public void toConsoleNeighbors() {
        System.out.print(this.toString() + " has neighbours: ");
        for (int i = 0; i < 4; ++i) {
            if (this.neighbors[i] != null) {
                System.out.print(this.neighbors[i].toString());
                if (this.neighbors[i].hasNeighbor(this)) continue;
                System.out.print("?");
                continue;
            }
            System.out.print("[null]");
        }
        System.out.println();
    }

    public void fromSceneEdges(J3DScene scene) {
        for (int i = 0; i < 6; ++i) {
            scene.removeShape(this.LSSs[i]);
        }
        scene.repaint();
    }

    public void toSceneEdges(J3DScene scene, Color clr, double width) {
        if (this.LSSs == null) {
            this.LSSs = new Shape[6];
        }
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                if (this.LSSs[k] == null) {
                    this.LSSs[k] = new LSS(this.corners[i], this.corners[j], width);
                }
                scene.addShape(this.LSSs[k++], clr, 3);
            }
        }
        scene.repaint();
    }

    public void toSceneEdges(J3DScene scene, Color clr, double width, double bigWidth) {
        if (this.LSSs == null) {
            this.LSSs = new Shape[6];
        }
        double edgeWidth = width;
        for (int i = 0; i < 4; ++i) {
            if (this.corners[i].getId() >= 4) continue;
            edgeWidth = bigWidth;
        }
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                if (this.LSSs[k] == null) {
                    this.LSSs[k] = new LSS(this.corners[i], this.corners[j], edgeWidth);
                }
                scene.addShape(this.LSSs[k++], clr, 3);
            }
        }
        scene.repaint();
    }

    public void toSceneFaces(J3DScene scene, Color clr) {
        if (this.faces == null) {
            this.faces = new Shape[4];
        }
        if (this.faces[0] == null) {
            this.faces[0] = new Triangle(this.corners[1], this.corners[2], this.corners[3]);
        }
        if (this.faces[1] == null) {
            this.faces[1] = new Triangle(this.corners[0], this.corners[2], this.corners[3]);
        }
        if (this.faces[2] == null) {
            this.faces[2] = new Triangle(this.corners[0], this.corners[1], this.corners[3]);
        }
        if (this.faces[3] == null) {
            this.faces[3] = new Triangle(this.corners[0], this.corners[1], this.corners[2]);
        }
        for (int i = 0; i < 4; ++i) {
            scene.addShape(this.faces[i], clr, 1);
        }
    }

    public Shape toSceneFace(J3DScene scene, int i, Color clr) {
        if (this.faces == null) {
            this.faces = new Shape[4];
        }
        if (this.faces[i] == null) {
            this.faces[i] = new Triangle(this.corners[(i + 1) % 4], this.corners[(i + 2) % 4], this.corners[(i + 3) % 4]);
        }
        scene.addShape(this.faces[i], clr, 1);
        return this.faces[i];
    }

    public void fromSceneFaces(J3DScene scene) {
        for (int i = 0; i < 4; ++i) {
            scene.removeShape(this.faces[i]);
        }
        scene.repaint();
    }

    public void fromSceneFace(J3DScene scene, int i) {
        scene.removeShape(this.faces[i]);
        scene.repaint();
    }

    public ArrayList<Tet> breadthFirstTetrahedra(int maxDepth) {
        ArrayList<Tet> tets = new ArrayList<Tet>();
        this.depth = 0;
        tets.add(this);
        int sz = 1;
        for (int i = 0; i < sz; ++i) {
            Tet tet = (Tet)tets.get(i);
            for (int k = 0; k < 4; ++k) {
                Tet nTet = tet.neighbors[k];
                if (nTet.depth != null) continue;
                nTet.depth = tet.depth + 1;
                if (nTet.depth >= maxDepth) continue;
                tets.add(nTet);
                ++sz;
            }
        }
        for (Tet tet : tets) {
            tet.depth = null;
        }
        return tets;
    }

    public List<Tri> getListOfTris() {
        ArrayList<Tri> ts = new ArrayList<Tri>(4);
        for (Tri t : this.tris) {
            ts.add(t);
        }
        return ts;
    }

    public ArrayList<Vertex> breadthFirstVertices(int maxDepth) {
        Tet nTet;
        ArrayList<Tet> tets = new ArrayList<Tet>();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        int sz = 0;
        this.depth = 0;
        for (int i = 0; i < 4; ++i) {
            this.corners[i].flag = true;
            vertices.add(this.corners[i]);
            nTet = this.neighbors[i];
            if (nTet.isBig()) continue;
            nTet.depth = 1;
            if (maxDepth <= 1) continue;
            tets.add(nTet);
            nTet.helper = this.oppIndex[i];
            ++sz;
        }
        for (int i = 0; i < sz; ++i) {
            Tet tet = (Tet)tets.get(i);
            int k = tet.helper;
            Vertex v = tet.corners[k];
            if (!v.flag) {
                v.flag = true;
                vertices.add(v);
            }
            for (int j = 1; j < 4; ++j) {
                int indx = (k + j) % 4;
                nTet = tet.neighbors[indx];
                if (nTet.depth != null || nTet.isBig()) continue;
                nTet.depth = tet.depth + 1;
                if (nTet.depth >= maxDepth) continue;
                tets.add(nTet);
                nTet.helper = tet.oppIndex[indx];
                ++sz;
            }
        }
        for (Tet t : tets) {
            t.depth = null;
        }
        return vertices;
    }

    public int hashCode() {
        return this.corners[0].getId() + this.corners[1].getId() * 2 + this.corners[2].getId() * 4 + this.corners[3].getId() * 8;
    }
}

