/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.volumes;

import ProGAL.geom3d.Point;
import ProGAL.geom3d.Triangle;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.viewer.J3DScene;
import ProGAL.geom3d.volumes.InfCone;
import ProGAL.geom3d.volumes.LSS;
import ProGAL.geom3d.volumes.Sphere;
import ProGAL.geom3d.volumes.Volume;
import java.awt.Color;

public class Cone
extends InfCone
implements Volume {
    private double axisLength;
    private double baseRad;

    public Cone(Point apex, Vector axis, double angle, double axisLength) {
        super(apex, axis, angle);
        this.axisLength = axisLength;
        this.baseRad = Math.tan(angle) * axisLength;
    }

    public Cone(Point apex, Point baseCenter, double baseRad) {
        super(apex, apex.vectorTo(baseCenter).normalizeThis(), Math.atan(baseRad / apex.distance(baseCenter)));
        this.axisLength = apex.distance(baseCenter);
        this.baseRad = baseRad;
    }

    public double getAxisLength() {
        return this.axisLength;
    }

    public Point getBaseCenter() {
        return this.apex.add(this.axis.multiply(this.axisLength));
    }

    public double getBaseRadius() {
        return this.baseRad;
    }

    @Override
    public double getVolume() {
        return Math.PI * this.baseRad * this.baseRad * this.axisLength / 3.0;
    }

    @Override
    public Point getCenter() {
        return this.apex.add(this.axis.multiply(this.axisLength / 2.0));
    }

    @Override
    public Cone clone() {
        return new Cone(this.apex, this.axis, this.angle, this.axisLength);
    }

    @Override
    public boolean overlaps(Volume vol) {
        throw new RuntimeException("Overlaps not implemented");
    }

    public static void main(String[] args) {
        J3DScene scene = J3DScene.createJ3DSceneInFrame();
        Cone c1 = new Cone(new Point(0.0, 0.0, 0.0), new Vector(-1.0, 0.0, 0.0), 2.0943951023931953, 1.0);
        Cone c2 = new Cone(new Point(0.0, 0.0, 0.0), new Vector(0.5, Math.sqrt(3.0) / 2.0, 0.0), 2.0943951023931953, 1.0);
        Cone c3 = new Cone(new Point(0.0, 0.0, 0.0), new Vector(0.5, -Math.sqrt(3.0) / 2.0, 0.0), 2.0943951023931953, 1.0);
        scene.addShape(c1, new Color(200, 0, 0, 100), 100);
        scene.addShape(new Sphere(new Point(-0.5, 0.0, 0.0), 0.01), Color.BLACK);
        scene.addShape(new LSS(new Point(-0.5, 0.0, 0.0), new Point(-0.5, 1.0, 0.0), 0.01));
        scene.addShape(new LSS(new Point(-0.5, 0.0, 0.0), new Point(-0.5, -0.5, Math.sqrt(3.0) / 2.0), 0.01));
        scene.addShape(new LSS(new Point(-0.5, 0.0, 0.0), new Point(-0.5, -0.5, -Math.sqrt(3.0) / 2.0), 0.01));
        Point p1 = new Point(-0.2, 0.0, Math.tan(1.0471975511965976) * 0.2);
        double r = Math.tan(1.0471975511965976) * 0.6;
        Point p2 = new Point(-0.6, Math.cos(1.0471975511965976) * r, Math.sin(1.0471975511965976) * r);
        Point p3 = new Point(-0.6, Math.cos(-1.0471975511965976) * r, Math.sin(-1.0471975511965976) * r);
        scene.addShape(new Sphere(p1, 0.02));
        scene.addShape(new Sphere(p2, 0.02));
        scene.addShape(new Sphere(p3, 0.02));
        scene.addShape(new Triangle(p1, p2, p3), Color.GREEN);
        scene.addShape(new LSS(new Point(0.0, 0.0, 0.0), p1, 0.01));
        scene.addShape(new LSS(new Point(0.0, 0.0, 0.0), p2, 0.01));
        scene.addShape(new LSS(new Point(0.0, 0.0, 0.0), p3, 0.01));
    }
}

