/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.volumes;

import ProGAL.geom3d.Point;
import ProGAL.geom3d.PointList;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.volumes.Volume;
import ProGAL.math.Matrix;
import ProGAL.math.Matrix3x3;
import java.util.List;

public class OBB
implements Volume {
    protected Point anchor;
    protected Vector[] bases;
    public double[] extents;

    public OBB(Point anchor, Vector xdir, Vector ydir, Vector zdir) {
        this.anchor = anchor;
        this.extents = new double[]{xdir.length(), ydir.length(), zdir.length()};
        this.bases = new Vector[]{xdir.scaleToLength(1.0), ydir.scaleToLength(1.0), zdir.scaleToLength(1.0)};
    }

    public OBB(Point anchor, Vector[] bases, double[] extents) {
        this.anchor = anchor;
        this.bases = bases;
        this.extents = extents;
    }

    public Point getAnchor() {
        return this.anchor;
    }

    public Vector getXDir() {
        return this.bases[0];
    }

    public Vector getYDir() {
        return this.bases[1];
    }

    public Vector getZDir() {
        return this.bases[2];
    }

    public Vector[] getBases() {
        return this.bases;
    }

    public void setAnchor(Point pos) {
        this.anchor = pos;
    }

    public double cutArealYZ() {
        return 4.0 * this.extents[1] * this.extents[2];
    }

    public static OBB createBoundingBox_Covariance(PointList points) {
        Matrix3x3 m = points.getCovariance();
        Matrix.EigenvalueDecomposition ed = m.getEigenvalueDecomposition();
        ProGAL.geomNd.Vector r = ed.getV().getColumn(2);
        ProGAL.geomNd.Vector s = ed.getV().getColumn(1);
        ProGAL.geomNd.Vector t = ed.getV().getColumn(0);
        OBB ret = OBB.createBoxFromBases(new Vector[]{new Vector(r), new Vector(s), new Vector(t)}, points);
        return ret;
    }

    public static OBB createBoxFromBases(Vector[] bases, List<Point> points) {
        double[][] extremeDots = new double[][]{{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}, {Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}, {Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}};
        for (int b = 0; b < 3; ++b) {
            for (Point p : points) {
                double dot = bases[b].dot(p.toVector());
                if (dot < extremeDots[b][0]) {
                    extremeDots[b][0] = dot;
                }
                if (!(dot > extremeDots[b][1])) continue;
                extremeDots[b][1] = dot;
            }
        }
        Point center = bases[0].multiply((extremeDots[0][0] + extremeDots[0][1]) / 2.0).toPoint();
        center.addThis(bases[1].multiply((extremeDots[1][0] + extremeDots[1][1]) / 2.0));
        center.addThis(bases[2].multiply((extremeDots[2][0] + extremeDots[2][1]) / 2.0));
        double[] extents = new double[]{(extremeDots[0][1] - extremeDots[0][0]) / 2.0, (extremeDots[1][1] - extremeDots[1][0]) / 2.0, (extremeDots[2][1] - extremeDots[2][0]) / 2.0};
        return new OBB(center, bases, extents);
    }

    public boolean overlaps(OBB b) {
        int i;
        double[][] R = new double[3][3];
        double[][] AbsR = new double[3][3];
        double[] ae = this.extents;
        double[] be = b.extents;
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                R[i2][j] = this.bases[i2].dot(b.bases[j]);
            }
        }
        Vector tmp = this.anchor.vectorTo(b.anchor);
        tmp = new Vector(tmp.dot(this.bases[0]), tmp.dot(this.bases[1]), tmp.dot(this.bases[2]));
        double[] t = new double[]{tmp.x(), tmp.y(), tmp.z()};
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                AbsR[i][j] = Math.abs(R[i][j]) + 1.0E-5;
            }
        }
        for (i = 0; i < 3; ++i) {
            if (!(Math.abs(t[i]) > ae[i] + be[0] * AbsR[i][0] + be[1] * AbsR[i][1] + be[2] * AbsR[i][2])) continue;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            if (!(Math.abs(t[0] * R[0][i] + t[1] * R[1][i] + t[2] * R[2][i]) > ae[0] * AbsR[0][i] + ae[1] * AbsR[1][i] + ae[2] * AbsR[2][i] + be[i])) continue;
            return false;
        }
        if (Math.abs(t[2] * R[1][0] - t[1] * R[2][0]) > ae[1] * AbsR[2][0] + ae[2] * AbsR[1][0] + be[1] * AbsR[0][2] + be[2] * AbsR[0][1]) {
            return false;
        }
        if (Math.abs(t[2] * R[1][1] - t[1] * R[2][1]) > ae[1] * AbsR[2][1] + ae[2] * AbsR[1][1] + be[0] * AbsR[0][2] + be[2] * AbsR[0][0]) {
            return false;
        }
        if (Math.abs(t[2] * R[1][2] - t[1] * R[2][2]) > ae[1] * AbsR[2][2] + ae[2] * AbsR[1][2] + be[0] * AbsR[0][1] + be[1] * AbsR[0][0]) {
            return false;
        }
        if (Math.abs(t[0] * R[2][0] - t[2] * R[0][0]) > ae[0] * AbsR[2][0] + ae[2] * AbsR[0][0] + be[1] * AbsR[1][2] + be[2] * AbsR[1][1]) {
            return false;
        }
        if (Math.abs(t[0] * R[2][1] - t[2] * R[0][1]) > ae[0] * AbsR[2][1] + ae[2] * AbsR[0][1] + be[0] * AbsR[1][2] + be[2] * AbsR[1][0]) {
            return false;
        }
        if (Math.abs(t[0] * R[2][2] - t[2] * R[0][2]) > ae[0] * AbsR[2][2] + ae[2] * AbsR[0][2] + be[0] * AbsR[1][1] + be[1] * AbsR[1][0]) {
            return false;
        }
        if (Math.abs(t[1] * R[0][0] - t[0] * R[1][0]) > ae[0] * AbsR[1][0] + ae[1] * AbsR[0][0] + be[1] * AbsR[2][2] + be[2] * AbsR[2][1]) {
            return false;
        }
        if (Math.abs(t[1] * R[0][1] - t[0] * R[1][1]) > ae[0] * AbsR[1][1] + ae[1] * AbsR[0][1] + be[0] * AbsR[2][2] + be[2] * AbsR[2][0]) {
            return false;
        }
        return !(Math.abs(t[1] * R[0][2] - t[0] * R[1][2]) > ae[0] * AbsR[1][2] + ae[1] * AbsR[0][2] + be[0] * AbsR[2][1] + be[1] * AbsR[2][0]);
    }

    @Override
    public Point getCenter() {
        return this.getAnchor();
    }

    public Point[] getVertices() {
        Point[] ret = new Point[]{this.anchor.subtract(this.bases[0].multiply(this.extents[0])).subtractThis(this.bases[1].multiply(this.extents[1])).subtractThis(this.bases[2].multiply(this.extents[2])), this.anchor.subtract(this.bases[0].multiply(this.extents[0])).subtractThis(this.bases[1].multiply(this.extents[1])).addThis(this.bases[2].multiply(this.extents[2])), this.anchor.subtract(this.bases[0].multiply(this.extents[0])).addThis(this.bases[1].multiply(this.extents[1])).subtractThis(this.bases[2].multiply(this.extents[2])), this.anchor.subtract(this.bases[0].multiply(this.extents[0])).addThis(this.bases[1].multiply(this.extents[1])).addThis(this.bases[2].multiply(this.extents[2])), this.anchor.add(this.bases[0].multiply(this.extents[0])).subtractThis(this.bases[1].multiply(this.extents[1])).subtractThis(this.bases[2].multiply(this.extents[2])), this.anchor.add(this.bases[0].multiply(this.extents[0])).subtractThis(this.bases[1].multiply(this.extents[1])).addThis(this.bases[2].multiply(this.extents[2])), this.anchor.add(this.bases[0].multiply(this.extents[0])).addThis(this.bases[1].multiply(this.extents[1])).subtractThis(this.bases[2].multiply(this.extents[2])), this.anchor.add(this.bases[0].multiply(this.extents[0])).addThis(this.bases[1].multiply(this.extents[1])).addThis(this.bases[2].multiply(this.extents[2]))};
        return ret;
    }

    @Override
    public boolean overlaps(Volume s) {
        if (s instanceof OBB) {
            return this.overlaps((OBB)s);
        }
        throw new Error("Unknown volume");
    }

    public double volume() {
        return this.extents[0] * this.extents[1] * this.extents[2] * 8.0;
    }

    @Override
    public OBB clone() {
        Point aClone = this.anchor.clone();
        Vector[] bClone = new Vector[]{this.bases[0].clone(), this.bases[1].clone(), this.bases[2].clone()};
        double[] eClone = new double[]{this.extents[0], this.extents[1], this.extents[2]};
        return new OBB(aClone, bClone, eClone);
    }

    public String toString() {
        return "Box3d[" + this.getAnchor() + "," + this.bases[0] + "," + this.bases[1] + "," + this.bases[2] + "]";
    }

    @Override
    public double getVolume() {
        return 0.0;
    }
}

