/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.math;

import java.util.Random;

public class Randomization {
    private static Random rand = new Random();

    public static Random getGenerator() {
        return rand;
    }

    public static int randBetween(int i1, int i2) {
        int max = Math.max(i1, i2);
        int min = Math.min(i1, i2);
        return (int)(rand.nextDouble() * (double)(max - min) + (double)min);
    }

    public static double randBetween(double d1, double d2) {
        double max = Math.max(d1, d2);
        double min = Math.min(d1, d2);
        return rand.nextDouble() * (max - min) + min;
    }

    public static int[] randomPermutation(int max) {
        int[] ret = new int[max];
        for (int i = 0; i < max; ++i) {
            ret[i] = i;
        }
        Randomization.randomizeInPlace(ret);
        return ret;
    }

    public static void randomizeInPlace(int[] as) {
        for (int i = 0; i < as.length; ++i) {
            int r = Randomization.randBetween(i, as.length);
            int t = as[i];
            as[i] = as[r];
            as[r] = t;
        }
    }

    public static void seed(long s) {
        rand = new Random(s);
    }

    public static Object[] shuffle(Object[] arr) {
        for (int i = arr.length; i > 1; --i) {
            int r = Randomization.randBetween(0, i);
            Object tmp = arr[i - 1];
            arr[i - 1] = arr[r];
            arr[r] = tmp;
        }
        return arr;
    }
}

