/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.text;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.Patch;
import com.github.difflib.text.DiffRow;
import com.github.difflib.text.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class DiffRowGenerator {
    public static final BiPredicate<String, String> DEFAULT_EQUALIZER = Object::equals;
    public static final BiPredicate<String, String> IGNORE_WHITESPACE_EQUALIZER = (original, revised) -> DiffRowGenerator.adjustWhitespace(original).equals(DiffRowGenerator.adjustWhitespace(revised));
    public static final Function<String, String> LINE_NORMALIZER_FOR_HTML = StringUtils::normalize;
    public static final Function<String, List<String>> SPLITTER_BY_CHARACTER = line -> {
        ArrayList<String> list = new ArrayList<String>(line.length());
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            list.add(character.toString());
        }
        return list;
    };
    public static final Pattern SPLIT_BY_WORD_PATTERN = Pattern.compile("\\s+|[,.\\[\\](){}/\\\\*+\\-#]");
    public static final Function<String, List<String>> SPLITTER_BY_WORD = line -> DiffRowGenerator.splitStringPreserveDelimiter(line, SPLIT_BY_WORD_PATTERN);
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private final int columnWidth;
    private final BiPredicate<String, String> equalizer;
    private final boolean ignoreWhiteSpaces;
    private final Function<String, List<String>> inlineDiffSplitter;
    private final boolean mergeOriginalRevised;
    private final BiFunction<DiffRow.Tag, Boolean, String> newTag;
    private final BiFunction<DiffRow.Tag, Boolean, String> oldTag;
    private final boolean reportLinesUnchanged;
    private final Function<String, String> lineNormalizer;
    private final Function<String, String> processDiffs;
    private final boolean showInlineDiffs;
    private final boolean replaceOriginalLinefeedInChangesWithSpaces;

    public static Builder create() {
        return new Builder();
    }

    private static String adjustWhitespace(String raw) {
        return WHITESPACE_PATTERN.matcher(raw.trim()).replaceAll(" ");
    }

    protected static final List<String> splitStringPreserveDelimiter(String str, Pattern SPLIT_PATTERN) {
        ArrayList<String> list = new ArrayList<String>();
        if (str != null) {
            Matcher matcher = SPLIT_PATTERN.matcher(str);
            int pos = 0;
            while (matcher.find()) {
                if (pos < matcher.start()) {
                    list.add(str.substring(pos, matcher.start()));
                }
                list.add(matcher.group());
                pos = matcher.end();
            }
            if (pos < str.length()) {
                list.add(str.substring(pos));
            }
        }
        return list;
    }

    static void wrapInTag(List<String> sequence, int startPosition, int endPosition, DiffRow.Tag tag, BiFunction<DiffRow.Tag, Boolean, String> tagGenerator, Function<String, String> processDiffs, boolean replaceLinefeedWithSpace) {
        for (int endPos = endPosition; endPos >= startPosition; --endPos) {
            while (endPos > startPosition && "\n".equals(sequence.get(endPos - 1))) {
                if (replaceLinefeedWithSpace) {
                    sequence.set(endPos - 1, " ");
                    break;
                }
                --endPos;
            }
            if (endPos == startPosition) break;
            sequence.add(endPos, tagGenerator.apply(tag, false));
            if (processDiffs != null) {
                sequence.set(endPos - 1, processDiffs.apply(sequence.get(endPos - 1)));
            }
            --endPos;
            while (endPos > startPosition) {
                if ("\n".equals(sequence.get(endPos - 1))) {
                    if (!replaceLinefeedWithSpace) break;
                    sequence.set(endPos - 1, " ");
                }
                if (processDiffs != null) {
                    sequence.set(endPos - 1, processDiffs.apply(sequence.get(endPos - 1)));
                }
                --endPos;
            }
            sequence.add(endPos, tagGenerator.apply(tag, true));
        }
    }

    private DiffRowGenerator(Builder builder) {
        this.showInlineDiffs = builder.showInlineDiffs;
        this.ignoreWhiteSpaces = builder.ignoreWhiteSpaces;
        this.oldTag = builder.oldTag;
        this.newTag = builder.newTag;
        this.columnWidth = builder.columnWidth;
        this.mergeOriginalRevised = builder.mergeOriginalRevised;
        this.inlineDiffSplitter = builder.inlineDiffSplitter;
        this.equalizer = builder.equalizer != null ? builder.equalizer : (this.ignoreWhiteSpaces ? IGNORE_WHITESPACE_EQUALIZER : DEFAULT_EQUALIZER);
        this.reportLinesUnchanged = builder.reportLinesUnchanged;
        this.lineNormalizer = builder.lineNormalizer;
        this.processDiffs = builder.processDiffs;
        this.replaceOriginalLinefeedInChangesWithSpaces = builder.replaceOriginalLinefeedInChangesWithSpaces;
        Objects.requireNonNull(this.inlineDiffSplitter);
        Objects.requireNonNull(this.lineNormalizer);
    }

    public List<DiffRow> generateDiffRows(List<String> original, List<String> revised) {
        return this.generateDiffRows(original, DiffUtils.diff(original, revised, this.equalizer));
    }

    public List<DiffRow> generateDiffRows(List<String> original, Patch<String> patch) {
        ArrayList<DiffRow> diffRows = new ArrayList<DiffRow>();
        int endPos = 0;
        List<AbstractDelta<String>> deltaList = patch.getDeltas();
        for (AbstractDelta<String> originalDelta : deltaList) {
            for (AbstractDelta<String> delta : this.decompressDeltas(originalDelta)) {
                endPos = this.transformDeltaIntoDiffRow(original, endPos, diffRows, delta);
            }
        }
        for (String line : original.subList(endPos, original.size())) {
            diffRows.add(this.buildDiffRow(DiffRow.Tag.EQUAL, line, line));
        }
        return diffRows;
    }

    private int transformDeltaIntoDiffRow(List<String> original, int endPos, List<DiffRow> diffRows, AbstractDelta<String> delta) {
        Chunk<String> orig = delta.getSource();
        Chunk<String> rev = delta.getTarget();
        for (String line : original.subList(endPos, orig.getPosition())) {
            diffRows.add(this.buildDiffRow(DiffRow.Tag.EQUAL, line, line));
        }
        switch (delta.getType()) {
            case INSERT: {
                for (String line : rev.getLines()) {
                    diffRows.add(this.buildDiffRow(DiffRow.Tag.INSERT, "", line));
                }
                break;
            }
            case DELETE: {
                for (String line : orig.getLines()) {
                    diffRows.add(this.buildDiffRow(DiffRow.Tag.DELETE, line, ""));
                }
                break;
            }
            default: {
                if (this.showInlineDiffs) {
                    diffRows.addAll(this.generateInlineDiffs(delta));
                    break;
                }
                for (int j = 0; j < Math.max(orig.size(), rev.size()); ++j) {
                    diffRows.add(this.buildDiffRow(DiffRow.Tag.CHANGE, orig.getLines().size() > j ? orig.getLines().get(j) : "", rev.getLines().size() > j ? rev.getLines().get(j) : ""));
                }
            }
        }
        return orig.last() + 1;
    }

    private List<AbstractDelta<String>> decompressDeltas(AbstractDelta<String> delta) {
        if (delta.getType() == DeltaType.CHANGE && delta.getSource().size() != delta.getTarget().size()) {
            ArrayList<AbstractDelta<String>> deltas = new ArrayList<AbstractDelta<String>>();
            int minSize = Math.min(delta.getSource().size(), delta.getTarget().size());
            Chunk<String> orig = delta.getSource();
            Chunk<String> rev = delta.getTarget();
            deltas.add(new ChangeDelta<String>(new Chunk<String>(orig.getPosition(), orig.getLines().subList(0, minSize)), new Chunk<String>(rev.getPosition(), rev.getLines().subList(0, minSize))));
            if (orig.getLines().size() < rev.getLines().size()) {
                deltas.add(new InsertDelta<String>(new Chunk(orig.getPosition() + minSize, Collections.emptyList()), new Chunk<String>(rev.getPosition() + minSize, rev.getLines().subList(minSize, rev.getLines().size()))));
            } else {
                deltas.add(new DeleteDelta<String>(new Chunk<String>(orig.getPosition() + minSize, orig.getLines().subList(minSize, orig.getLines().size())), new Chunk(rev.getPosition() + minSize, Collections.emptyList())));
            }
            return deltas;
        }
        return Collections.singletonList(delta);
    }

    private DiffRow buildDiffRow(DiffRow.Tag type, String orgline, String newline) {
        if (this.reportLinesUnchanged) {
            return new DiffRow(type, orgline, newline);
        }
        String wrapOrg = this.preprocessLine(orgline);
        if (DiffRow.Tag.DELETE == type && (this.mergeOriginalRevised || this.showInlineDiffs)) {
            wrapOrg = this.oldTag.apply(type, true) + wrapOrg + this.oldTag.apply(type, false);
        }
        String wrapNew = this.preprocessLine(newline);
        if (DiffRow.Tag.INSERT == type) {
            if (this.mergeOriginalRevised) {
                wrapOrg = this.newTag.apply(type, true) + wrapNew + this.newTag.apply(type, false);
            } else if (this.showInlineDiffs) {
                wrapNew = this.newTag.apply(type, true) + wrapNew + this.newTag.apply(type, false);
            }
        }
        return new DiffRow(type, wrapOrg, wrapNew);
    }

    private DiffRow buildDiffRowWithoutNormalizing(DiffRow.Tag type, String orgline, String newline) {
        return new DiffRow(type, StringUtils.wrapText(orgline, this.columnWidth), StringUtils.wrapText(newline, this.columnWidth));
    }

    List<String> normalizeLines(List<String> list) {
        return this.reportLinesUnchanged ? list : list.stream().map(this.lineNormalizer::apply).collect(Collectors.toList());
    }

    private List<DiffRow> generateInlineDiffs(AbstractDelta<String> delta) {
        List<String> orig = this.normalizeLines(delta.getSource().getLines());
        List<String> rev = this.normalizeLines(delta.getTarget().getLines());
        String joinedOrig = String.join((CharSequence)"\n", orig);
        String joinedRev = String.join((CharSequence)"\n", rev);
        List<String> origList = this.inlineDiffSplitter.apply(joinedOrig);
        List<String> revList = this.inlineDiffSplitter.apply(joinedRev);
        List<AbstractDelta<String>> inlineDeltas = DiffUtils.diff(origList, revList, this.equalizer).getDeltas();
        Collections.reverse(inlineDeltas);
        for (AbstractDelta<String> inlineDelta : inlineDeltas) {
            Iterator<String> inlineOrig = inlineDelta.getSource();
            Chunk<String> inlineRev = inlineDelta.getTarget();
            if (inlineDelta.getType() == DeltaType.DELETE) {
                DiffRowGenerator.wrapInTag(origList, ((Chunk)((Object)inlineOrig)).getPosition(), ((Chunk)((Object)inlineOrig)).getPosition() + ((Chunk)((Object)inlineOrig)).size(), DiffRow.Tag.DELETE, this.oldTag, this.processDiffs, this.replaceOriginalLinefeedInChangesWithSpaces && this.mergeOriginalRevised);
                continue;
            }
            if (inlineDelta.getType() == DeltaType.INSERT) {
                if (this.mergeOriginalRevised) {
                    origList.addAll(((Chunk)((Object)inlineOrig)).getPosition(), revList.subList(inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size()));
                    DiffRowGenerator.wrapInTag(origList, ((Chunk)((Object)inlineOrig)).getPosition(), ((Chunk)((Object)inlineOrig)).getPosition() + inlineRev.size(), DiffRow.Tag.INSERT, this.newTag, this.processDiffs, false);
                    continue;
                }
                DiffRowGenerator.wrapInTag(revList, inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size(), DiffRow.Tag.INSERT, this.newTag, this.processDiffs, false);
                continue;
            }
            if (inlineDelta.getType() != DeltaType.CHANGE) continue;
            if (this.mergeOriginalRevised) {
                origList.addAll(((Chunk)((Object)inlineOrig)).getPosition() + ((Chunk)((Object)inlineOrig)).size(), revList.subList(inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size()));
                DiffRowGenerator.wrapInTag(origList, ((Chunk)((Object)inlineOrig)).getPosition() + ((Chunk)((Object)inlineOrig)).size(), ((Chunk)((Object)inlineOrig)).getPosition() + ((Chunk)((Object)inlineOrig)).size() + inlineRev.size(), DiffRow.Tag.CHANGE, this.newTag, this.processDiffs, false);
            } else {
                DiffRowGenerator.wrapInTag(revList, inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size(), DiffRow.Tag.CHANGE, this.newTag, this.processDiffs, false);
            }
            DiffRowGenerator.wrapInTag(origList, ((Chunk)((Object)inlineOrig)).getPosition(), ((Chunk)((Object)inlineOrig)).getPosition() + ((Chunk)((Object)inlineOrig)).size(), DiffRow.Tag.CHANGE, this.oldTag, this.processDiffs, this.replaceOriginalLinefeedInChangesWithSpaces && this.mergeOriginalRevised);
        }
        StringBuilder origResult = new StringBuilder();
        StringBuilder revResult = new StringBuilder();
        for (String character : origList) {
            origResult.append(character);
        }
        for (String character : revList) {
            revResult.append(character);
        }
        List<String> original = Arrays.asList(origResult.toString().split("\n"));
        List<String> revised = Arrays.asList(revResult.toString().split("\n"));
        ArrayList<DiffRow> diffRows = new ArrayList<DiffRow>();
        for (int j = 0; j < Math.max(original.size(), revised.size()); ++j) {
            diffRows.add(this.buildDiffRowWithoutNormalizing(DiffRow.Tag.CHANGE, original.size() > j ? original.get(j) : "", revised.size() > j ? revised.get(j) : ""));
        }
        return diffRows;
    }

    private String preprocessLine(String line) {
        if (this.columnWidth == 0) {
            return this.lineNormalizer.apply(line);
        }
        return StringUtils.wrapText(this.lineNormalizer.apply(line), this.columnWidth);
    }

    public static class Builder {
        private boolean showInlineDiffs = false;
        private boolean ignoreWhiteSpaces = false;
        private BiFunction<DiffRow.Tag, Boolean, String> oldTag = (tag, f) -> f != false ? "<span class=\"editOldInline\">" : "</span>";
        private BiFunction<DiffRow.Tag, Boolean, String> newTag = (tag, f) -> f != false ? "<span class=\"editNewInline\">" : "</span>";
        private int columnWidth = 0;
        private boolean mergeOriginalRevised = false;
        private boolean reportLinesUnchanged = false;
        private Function<String, List<String>> inlineDiffSplitter = SPLITTER_BY_CHARACTER;
        private Function<String, String> lineNormalizer = LINE_NORMALIZER_FOR_HTML;
        private Function<String, String> processDiffs = null;
        private BiPredicate<String, String> equalizer = null;
        private boolean replaceOriginalLinefeedInChangesWithSpaces = false;

        private Builder() {
        }

        public Builder showInlineDiffs(boolean val) {
            this.showInlineDiffs = val;
            return this;
        }

        public Builder ignoreWhiteSpaces(boolean val) {
            this.ignoreWhiteSpaces = val;
            return this;
        }

        public Builder reportLinesUnchanged(boolean val) {
            this.reportLinesUnchanged = val;
            return this;
        }

        public Builder oldTag(BiFunction<DiffRow.Tag, Boolean, String> generator) {
            this.oldTag = generator;
            return this;
        }

        public Builder oldTag(Function<Boolean, String> generator) {
            this.oldTag = (tag, f) -> (String)generator.apply((Boolean)f);
            return this;
        }

        public Builder newTag(BiFunction<DiffRow.Tag, Boolean, String> generator) {
            this.newTag = generator;
            return this;
        }

        public Builder newTag(Function<Boolean, String> generator) {
            this.newTag = (tag, f) -> (String)generator.apply((Boolean)f);
            return this;
        }

        public Builder processDiffs(Function<String, String> processDiffs) {
            this.processDiffs = processDiffs;
            return this;
        }

        public Builder columnWidth(int width) {
            if (width >= 0) {
                this.columnWidth = width;
            }
            return this;
        }

        public DiffRowGenerator build() {
            return new DiffRowGenerator(this);
        }

        public Builder mergeOriginalRevised(boolean mergeOriginalRevised) {
            this.mergeOriginalRevised = mergeOriginalRevised;
            return this;
        }

        public Builder inlineDiffByWord(boolean inlineDiffByWord) {
            this.inlineDiffSplitter = inlineDiffByWord ? SPLITTER_BY_WORD : SPLITTER_BY_CHARACTER;
            return this;
        }

        public Builder inlineDiffBySplitter(Function<String, List<String>> inlineDiffSplitter) {
            this.inlineDiffSplitter = inlineDiffSplitter;
            return this;
        }

        public Builder lineNormalizer(Function<String, String> lineNormalizer) {
            this.lineNormalizer = lineNormalizer;
            return this;
        }

        public Builder equalizer(BiPredicate<String, String> equalizer) {
            this.equalizer = equalizer;
            return this;
        }

        public Builder replaceOriginalLinefeedInChangesWithSpaces(boolean replace) {
            this.replaceOriginalLinefeedInChangesWithSpaces = replace;
            return this;
        }
    }
}

