/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.HashMap;
import java.util.Map;
import org.das2.datum.Units;
import org.das2.qds.AbstractQFunction;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class NearestNeighborTcaFunction
extends AbstractQFunction {
    private final QDataSet dep0;
    private final QDataSet data;
    private QDataSet fill;
    private DDataSet outputDescriptor = null;
    private final DDataSet inputDescriptor = DDataSet.createRank2(1, 0);

    public NearestNeighborTcaFunction(QDataSet ds) {
        this.dep0 = (QDataSet)ds.property("DEPEND_0");
        if (this.dep0 == null) {
            throw new IllegalArgumentException("dataset does not have DEPEND_0 and cannot be used.");
        }
        this.data = ds;
        this.exampleInput();
    }

    private int closest(QDataSet d) {
        return (int)(Ops.findex(this.dep0, d).value() + 0.5);
    }

    @Override
    public QDataSet value(QDataSet parm) {
        int i = this.closest(parm.slice(0));
        if (i < 0) {
            return this.fill;
        }
        if (i >= this.data.length()) {
            return this.fill;
        }
        QDataSet result = this.data.rank() == 1 ? Ops.bundle(this.data.slice(i)) : this.data.slice(i);
        ((MutablePropertyDataSet)result).putProperty("BUNDLE_0", this.outputDescriptor);
        return result;
    }

    @Override
    public final QDataSet exampleInput() {
        int i;
        QDataSet q = this.dep0.slice(0);
        MutablePropertyDataSet ret = (MutablePropertyDataSet)Ops.bundle(q);
        Map<String, Object> p = DataSetUtil.getDimensionProperties(q, new HashMap<String, Object>());
        for (Map.Entry<String, Object> e : p.entrySet()) {
            this.inputDescriptor.putProperty(e.getKey(), 0, e.getValue());
        }
        ret.putProperty("BUNDLE_0", this.inputDescriptor);
        QDataSet exampleOutput = this.data.slice(0);
        if (exampleOutput.rank() == 0) {
            Ops.bundle(exampleOutput);
        }
        this.outputDescriptor = DDataSet.createRank2(exampleOutput.length(), 0);
        for (i = 0; i < exampleOutput.length(); ++i) {
            p = DataSetUtil.getDimensionProperties(exampleOutput.slice(i), new HashMap<String, Object>());
            for (Map.Entry<String, Object> e : p.entrySet()) {
                this.outputDescriptor.putProperty(e.getKey(), i, e.getValue());
            }
        }
        this.fill = Ops.bundle(DataSetUtil.asDataSet(Double.NaN, (Units)this.outputDescriptor.property("UNITS", 0)));
        for (i = 1; i < exampleOutput.length(); ++i) {
            this.fill = Ops.bundle(this.fill, DataSetUtil.asDataSet(Double.NaN, (Units)this.outputDescriptor.property("UNITS", i)));
        }
        return ret;
    }
}

