/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.Map;
import java.util.logging.Logger;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.Slice0DataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;

public final class Slice1DataSet
extends AbstractDataSet {
    QDataSet ds;
    int index;
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset.ops");

    public Slice1DataSet(QDataSet ds, int index) {
        this(ds, index, true, false);
    }

    public Slice1DataSet(QDataSet ds, int index, boolean unbundle) {
        this(ds, index, false, unbundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    Slice1DataSet(QDataSet ds, int index, boolean addContext, boolean unbundle) {
        String[] props;
        String prop;
        QDataSet plane0;
        QDataSet context;
        Units dep1units;
        if (ds.rank() > 4) {
            throw new IllegalArgumentException("rank limit > 4");
        }
        if (ds.rank() < 2) {
            throw new IllegalArgumentException("cannot create a Slice1DataSet from rank " + ds.rank() + " dataset");
        }
        if (ds.length() == 0) {
            int[] qube = DataSetUtil.qubeDims(ds);
            if (qube == null) {
                throw new IndexOutOfBoundsException("dataset is empty and index is out of bounds");
            }
            if (index >= qube[1]) {
                throw new IndexOutOfBoundsException("index is out of bounds");
            }
        } else if (index >= ds.length(0)) {
            throw new IndexOutOfBoundsException("index is out of bounds");
        }
        this.ds = ds;
        this.index = index;
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        QDataSet bds = (QDataSet)ds.property("BUNDLE_1");
        String label = null;
        Units units = dep1units = dep1 == null ? null : (Units)dep1.property("UNITS");
        if (dep1 != null && dep1.rank() == 1 && dep1units instanceof EnumerationUnits) {
            label = String.valueOf(dep1units.createDatum(dep1.value(index)));
            addContext = false;
        }
        if (bds != null && dep1 == null) {
            context = null;
            if (addContext) {
                context = DataSetOps.getContextForUnbundle(bds, index);
            }
            if (label != null) {
                if (addContext) {
                    DataSetUtil.addContext(this, context);
                }
                this.putProperty("LABEL", label);
                this.putProperty("NAME", Ops.safeName(label));
            } else if (addContext) {
                if (context != null && context.svalue().equals("null")) {
                    logger.fine("not adding string null, which happens with HAPI datasets when they don't have labels.");
                } else {
                    DataSetUtil.addContext(this, context);
                }
            }
            if (ds.rank() == 2) {
                Map<String, Object> o = DataSetUtil.sliceProperties(bds, index, null);
                DataSetUtil.putProperties(o, this);
            }
        } else if (dep1 != null) {
            switch (dep1.rank()) {
                case 1: {
                    if (label != null) {
                        this.putProperty("LABEL", label);
                        this.putProperty("NAME", Ops.safeName(label));
                        if (!addContext) break;
                        DataSetUtil.addContext(this, (QDataSet)new Slice0DataSet(dep1, index, false));
                        break;
                    }
                    if (!addContext) break;
                    DataSetUtil.addContext(this, (QDataSet)new Slice0DataSet(dep1, index, false));
                    break;
                }
                case 2: {
                    if (dep1.property("BINS_1") == null) {
                        if (!addContext) break;
                        DataSetUtil.addContext(this, (QDataSet)new Slice1DataSet(dep1, index, false));
                        break;
                    }
                    if (dep1.property("BINS_1").equals("min,max")) {
                        if (!addContext) break;
                        DataSetUtil.addContext(this, (QDataSet)new Slice0DataSet(dep1, index, false));
                        break;
                    }
                }
                default: {
                    System.err.println("slice on non-qube, dep1 has rank=" + dep1.rank());
                    break;
                }
            }
        } else {
            Units u;
            Units u1;
            context = DataSetUtil.asDataSet(index);
            ((AbstractDataSet)context).putProperty("NAME", "slice1");
            if (addContext) {
                DataSetUtil.addContext(this, context);
            }
            if (ds.rank() == 2 && ds.length() < 3 && ds.length() > 0) {
                u = u1 = (Units)ds.slice(0).slice(index).property("UNITS");
                for (int i = 1; i < ds.length(); ++i) {
                    Units u2 = (Units)ds.slice(i).slice(index).property("UNITS");
                    if (u1 == u2) continue;
                    u = null;
                }
                if (u != null) {
                    this.putProperty("UNITS", u);
                }
            } else if (ds.length() == 0 && bds != null && (u = (u1 = (Units)bds.property("UNITS", index))) != null) {
                this.putProperty("UNITS", u);
            }
        }
        this.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        QDataSet dep2 = (QDataSet)ds.property("DEPEND_2");
        if (dep2 != null && dep2.rank() > 2) {
            dep2 = new Slice1DataSet(dep2, index);
        }
        this.putProperty("DEPEND_1", dep2);
        QDataSet dep3 = (QDataSet)ds.property("DEPEND_3");
        if (dep3 != null && dep3.rank() > 2) {
            dep3 = new Slice1DataSet(dep3, index);
        }
        this.putProperty("DEPEND_2", dep3);
        this.putProperty("BUNDLE_0", ds.property("BUNDLE_0"));
        this.putProperty("BUNDLE_1", ds.property("BUNDLE_2"));
        this.putProperty("BUNDLE_2", ds.property("BUNDLE_3"));
        this.putProperty("BINS_0", ds.property("BINS_0"));
        this.putProperty("BINS_1", ds.property("BINS_2"));
        this.putProperty("BINS_2", ds.property("BINS_3"));
        for (int i = 0; i < 50 && (plane0 = (QDataSet)ds.property(prop = "PLANE_" + i)) != null; ++i) {
            if (plane0.rank() < 2) {
                this.putProperty(prop, plane0);
                continue;
            }
            this.putProperty(prop, new Slice1DataSet(plane0, index, addContext));
        }
        String[] stringArray = props = DataSetUtil.correlativeProperties();
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.putProperty("WEIGHTS", null);
                DataSetUtil.copyDimensionProperties(ds, this);
                DataSetUtil.maybeCopyRenderType(ds, this);
                return;
            }
            String prop2 = stringArray[n2];
            QDataSet s = (QDataSet)ds.property(prop2);
            if (s != null) {
                if (s.rank() < 2) {
                    this.putProperty(prop2, s);
                } else {
                    this.putProperty(prop2, new Slice1DataSet(s, index, addContext));
                }
            }
            ++n2;
        }
    }

    @Override
    public int rank() {
        return this.ds.rank() - 1;
    }

    @Override
    public double value(int i) {
        return this.ds.value(i, this.index);
    }

    @Override
    public double value(int i0, int i1) {
        return this.ds.value(i0, this.index, i1);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.ds.value(i0, this.index, i1, i2);
    }

    @Override
    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name);
        }
        return null;
    }

    @Override
    public int length() {
        return this.ds.length();
    }

    @Override
    public int length(int i) {
        return this.ds.length(i, this.index);
    }

    @Override
    public int length(int i0, int i1) {
        return this.ds.length(i0, this.index, i1);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Slice1DataSet) {
            Slice1DataSet that = (Slice1DataSet)obj;
            return that.ds.equals(this.ds) && that.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        return this.ds.hashCode() + this.index;
    }
}

