/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.das2.datum.LoggerManager;
import org.das2.qds.filters.TreeUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class AddFilterDialog
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset.filters");
    private static final Preferences prefs = Preferences.userNodeForPackage(AddFilterDialog.class);
    private static final String PREF_EXPANSION_STATE = "expansionState";
    private static final String PREF_TAB = "tabPreference";
    private static final String PREF_INDEX = "indexPreference";
    private String expansionState = prefs.get("expansionState", null);
    DefaultMutableTreeNode root = null;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JTree jTree1;

    public AddFilterDialog() {
        this.initComponents();
        this.jTree1.setModel(new DefaultTreeModel(this.getTree()));
        if (this.expansionState == null) {
            for (int i = 0; i < this.jTree1.getRowCount(); ++i) {
                this.jTree1.expandRow(i);
            }
        } else {
            TreeUtil.restoreExpanstionState(this.jTree1, 0, this.expansionState);
        }
        this.jTree1.setRootVisible(false);
        this.jTree1.setSelectionModel(new RestrictedTreeSelectionModel());
        this.populateList();
        this.jTabbedPane1.setSelectedIndex(prefs.getInt(PREF_TAB, 0));
        int selectedIndex = prefs.getInt(PREF_INDEX, 0);
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (selectedIndex >= this.jList1.getModel().getSize()) {
            selectedIndex = this.jList1.getModel().getSize() - 1;
        }
        this.jList1.addListSelectionListener(e -> {
            Bookmark b = (Bookmark)this.jList1.getSelectedValue();
            this.jLabel1.setText(b.description);
            this.jLabel2.setText(b.filter);
            this.setSelectedValue(b);
        });
        this.jList1.setSelectedIndex(selectedIndex);
        this.jList1.ensureIndexIsVisible(selectedIndex);
        this.jTree1.addTreeSelectionListener(e -> {
            TreePath tp = this.jTree1.getSelectionPath();
            if (tp != null) {
                Object o = tp.getLastPathComponent();
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)o;
                Bookmark b = (Bookmark)tn.getUserObject();
                this.jLabel1.setText(b.description);
                this.jLabel2.setText(b.filter);
                this.setSelectedValue(b);
            }
        });
        Bookmark b = (Bookmark)this.jList1.getSelectedValue();
        this.ensureFolderOpen(0, this.root, b);
    }

    private TreePath find(DefaultMutableTreeNode root, String s) {
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.toString().equalsIgnoreCase(s)) continue;
            return new TreePath(node.getPath());
        }
        return null;
    }

    private void setSelectedValue(Bookmark selected) {
        this.jList1.setSelectedValue(selected, true);
        TreePath tp = this.find((DefaultMutableTreeNode)this.jTree1.getModel().getRoot(), selected.title);
        this.jTree1.getSelectionModel().setSelectionPath(tp);
        this.jTree1.scrollPathToVisible(tp);
    }

    private void populateList() {
        ArrayList<Bookmark> elements = new ArrayList<Bookmark>(100);
        this.getElementsFromTree(elements, (DefaultMutableTreeNode)this.jTree1.getModel().getRoot());
        Collections.sort(elements, (o1, o2) -> o1.filter.compareTo(o2.filter));
        DefaultListModel<Bookmark> model = new DefaultListModel<Bookmark>();
        Bookmark last = null;
        for (Bookmark val : elements) {
            if (last != null && last.title.equals(val.title)) continue;
            model.addElement(val);
            last = val;
        }
        this.jList1.setModel(model);
    }

    private void getElementsFromTree(List<Bookmark> list, DefaultMutableTreeNode node) {
        if (node.isLeaf()) {
            Object o = node.getUserObject();
            if (o instanceof Bookmark) {
                list.add((Bookmark)node.getUserObject());
            } else {
                logger.fine("node is a lead but shouldn't be");
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.getElementsFromTree(list, (DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    private DefaultMutableTreeNode ensureFolderOpen(int depth, DefaultMutableTreeNode node, Bookmark filter) {
        Object uo = node.getUserObject();
        if (uo instanceof String) {
            return this.ensureFolderOpen(depth + 1, (DefaultMutableTreeNode)node.getFirstChild(), filter);
        }
        DefaultMutableTreeNode found = null;
        Enumeration<TreeNode> n = node.children();
        String searchFor = filter.filter;
        int i = searchFor.indexOf("(");
        searchFor = searchFor.substring(0, i);
        DefaultMutableTreeNode aleaf = null;
        while (n.hasMoreElements()) {
            DefaultMutableTreeNode c = (DefaultMutableTreeNode)n.nextElement();
            if (c.isLeaf()) {
                if (((Bookmark)c.getUserObject()).filter.startsWith(searchFor)) {
                    found = c;
                    break;
                }
                if (aleaf != null) continue;
                aleaf = c;
                continue;
            }
            DefaultMutableTreeNode aleaf1 = this.ensureFolderOpen(depth + 1, c, filter);
            if (aleaf1 == null) continue;
            found = aleaf1;
            break;
        }
        if (found == null) {
            return null;
        }
        TreePath tp = new TreePath(found.getPath());
        this.jTree1.expandPath(tp.getParentPath());
        this.jTree1.setSelectionPath(tp);
        this.jTree1.scrollPathToVisible(tp);
        return found;
    }

    static DefaultHandler createHandler(DefaultMutableTreeNode root) {
        final StringBuilder charsBuilder = new StringBuilder();
        final ArrayDeque<DefaultMutableTreeNode> stack = new ArrayDeque<DefaultMutableTreeNode>();
        stack.push(root);
        return new DefaultHandler(){

            @Override
            public void startDocument() throws SAXException {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                switch (localName) {
                    case "bookmark": {
                        DefaultMutableTreeNode m = new DefaultMutableTreeNode();
                        m.setUserObject(new Bookmark());
                        ((DefaultMutableTreeNode)stack.peek()).insert(m, ((DefaultMutableTreeNode)stack.peek()).getChildCount());
                        stack.push(m);
                        break;
                    }
                    case "bookmark-folder": {
                        DefaultMutableTreeNode m = new DefaultMutableTreeNode();
                        m.setUserObject(new Bookmark());
                        ((DefaultMutableTreeNode)stack.peek()).insert(m, ((DefaultMutableTreeNode)stack.peek()).getChildCount());
                        stack.push(m);
                        break;
                    }
                    case "title": {
                        break;
                    }
                    case "filter": {
                        break;
                    }
                    case "description": {
                        break;
                    }
                    case "bookmark-list": {
                        break;
                    }
                    default: {
                        logger.log(Level.INFO, "unrecognized tag: {0}", localName);
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                switch (localName) {
                    case "bookmark": {
                        stack.pop();
                        break;
                    }
                    case "bookmark-folder": {
                        stack.pop();
                        break;
                    }
                    case "title": {
                        ((Bookmark)((DefaultMutableTreeNode)stack.peek()).getUserObject()).title = charsBuilder.toString().trim();
                        break;
                    }
                    case "filter": {
                        ((Bookmark)((DefaultMutableTreeNode)stack.peek()).getUserObject()).filter = charsBuilder.toString().trim();
                        break;
                    }
                    case "description": {
                        ((Bookmark)((DefaultMutableTreeNode)stack.peek()).getUserObject()).description = charsBuilder.toString().trim();
                        break;
                    }
                    case "bookmark-list": {
                        break;
                    }
                    default: {
                        logger.log(Level.INFO, "unrecognized tag: {0}", localName);
                    }
                }
                charsBuilder.delete(0, charsBuilder.length());
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                charsBuilder.append(ch, start, length);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultMutableTreeNode build(InputStream in) {
        DefaultMutableTreeNode result = new DefaultMutableTreeNode("root");
        DefaultHandler sax = AddFilterDialog.createHandler(result);
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(sax);
            try {
                logger.fine("done parsing filters.xml");
                xmlReader.parse(new InputSource(in));
            }
            catch (RuntimeException ex) {
                logger.log(Level.SEVERE, null, ex);
                throw ex;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        catch (ParserConfigurationException | SAXException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return result;
    }

    private TreeNode getTree() {
        DefaultMutableTreeNode result;
        InputStream in = AddFilterDialog.class.getResourceAsStream("filters.xml");
        this.root = result = AddFilterDialog.build(in);
        return result;
    }

    public String getValue() {
        Bookmark result;
        int tabPreference;
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            TreePath tp = this.jTree1.getSelectionPath();
            if (tp == null) {
                return "";
            }
            Object o = tp.getLastPathComponent();
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)o;
            Bookmark b = (Bookmark)tn.getUserObject();
            this.expansionState = TreeUtil.getExpansionState(this.jTree1, 0);
            tabPreference = 0;
            result = b;
        } else {
            Bookmark b = (Bookmark)this.jList1.getSelectedValue();
            this.expansionState = TreeUtil.getExpansionState(this.jTree1, 0);
            tabPreference = 1;
            result = b;
        }
        prefs.put(PREF_EXPANSION_STATE, this.expansionState);
        prefs.putInt(PREF_TAB, tabPreference);
        prefs.putInt(PREF_INDEX, this.jList1.getSelectedIndex());
        return result.filter;
    }

    public static void main(String[] args) {
        AddFilterDialog afd = new AddFilterDialog();
        if (0 == JOptionPane.showConfirmDialog(null, afd)) {
            System.err.println(afd.getValue());
        }
        if (0 == JOptionPane.showConfirmDialog(null, afd = new AddFilterDialog())) {
            System.err.println(afd.getValue());
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jTabbedPane1.addTab("By Category", this.jScrollPane1);
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.jList1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 392, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 204, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Alphabetical", this.jPanel1);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont((float)this.jLabel1.getFont().getSize() - 2.0f));
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont((float)this.jLabel2.getFont().getSize() - 2.0f));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1, -1, 247, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 18, -2)));
        layout.linkSize(1, this.jLabel1, this.jLabel2);
    }

    public static class Bookmark {
        String title = "";
        String filter = "";
        String description = "";

        public String toString() {
            return this.title;
        }
    }

    private static class RestrictedTreeSelectionModel
    extends DefaultTreeSelectionModel {
        private RestrictedTreeSelectionModel() {
        }

        @Override
        public void setSelectionPaths(TreePath[] pPaths) {
            int n;
            ArrayList<TreePath> temp = new ArrayList<TreePath>();
            int n2 = n = pPaths != null ? pPaths.length : 0;
            for (int i = 0; i < n; ++i) {
                Object lastPathComponent = pPaths[i].getLastPathComponent();
                if (!(lastPathComponent instanceof TreeNode) || !((TreeNode)lastPathComponent).isLeaf()) continue;
                temp.add(pPaths[i]);
            }
            if (!temp.isEmpty()) {
                super.setSelectionPaths(temp.toArray(new TreePath[temp.size()]));
            }
        }
    }
}

