/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.das2.qds.QDataSet;
import org.das2.qds.filters.FilterEditorPanel;
import org.das2.qds.filters.FilterEditorPanelUtil;
import org.das2.util.LoggerManager;

public class ApplyIndexEditorPanel
extends JPanel
implements FilterEditorPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset.filters");
    private JComboBox<String> dimensionCB;
    private JComboBox<String> indicesTF;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    public static final String PROP_REGEX = "\\|?applyIndex(\\d)\\((\\~?(\\d+|\\,|\\:|\\-)+)\\)";

    public ApplyIndexEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.dimensionCB = new JComboBox();
        this.indicesTF = new JComboBox();
        this.jButton1 = new JButton();
        this.jLabel1.setText("Dimension:");
        this.jLabel2.setText("Apply Index to a dimension, extracting a subset.");
        this.jLabel3.setText("Indices:");
        this.dimensionCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.indicesTF.setEditable(true);
        this.indicesTF.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2,4,6", "1-3,4:40:2", "~2-4"}));
        this.indicesTF.setSelectedItem("");
        this.jButton1.setText("?");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ApplyIndexEditorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dimensionCB, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 102, Short.MAX_VALUE).addComponent(this.jButton1)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indicesTF, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jButton1)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.dimensionCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.indicesTF, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            URI target = new URI("http://autoplot.org//filters#applyIndex");
            Desktop.getDesktop().browse(target);
        }
        catch (IOException | URISyntaxException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String getFilter() {
        return "|applyIndex" + this.dimensionCB.getSelectedIndex() + "(" + this.indicesTF.getSelectedItem() + ")";
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile(PROP_REGEX);
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            this.dimensionCB.setSelectedIndex(Integer.parseInt(m.group(1)));
            this.indicesTF.setSelectedItem(m.group(2));
        }
    }

    @Override
    public void setInput(QDataSet ds) {
        String[] depNames1 = FilterEditorPanelUtil.getDimensionNames(ds);
        int index = this.dimensionCB.getSelectedIndex();
        this.dimensionCB.setModel(new DefaultComboBoxModel<String>(depNames1));
        try {
            this.dimensionCB.setSelectedIndex(index);
        }
        catch (IllegalArgumentException ex) {
            this.dimensionCB.setSelectedIndex(depNames1.length - 1);
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public boolean validateFilter(String filter, QDataSet in) {
        return true;
    }

    @Override
    public void setExpertMode(boolean expert) {
        this.dimensionCB.setEnabled(expert);
    }
}

