/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.jdesktop.layout.GroupLayout;

public class FftOutputsFilterEditorPanel
extends AbstractFilterEditorPanel {
    private String slide;
    public ButtonGroup buttonGroup1;
    public JLabel descriptionLabel;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JRadioButton lsRB;
    public JRadioButton lsdRB;
    public JRadioButton psRB;
    public JRadioButton psdRB;
    public JTextField sizeTF;
    public JComboBox slideCB;
    public JComboBox windowCB;

    public FftOutputsFilterEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.slideCB = new JComboBox();
        this.sizeTF = new JTextField();
        this.windowCB = new JComboBox();
        this.psdRB = new JRadioButton();
        this.lsdRB = new JRadioButton();
        this.lsRB = new JRadioButton();
        this.descriptionLabel = new JLabel();
        this.psRB = new JRadioButton();
        FormListener formListener = new FormListener();
        this.jLabel1.setText("Window Size: ");
        this.jLabel2.setText("Slide: ");
        this.jLabel3.setText("Window: ");
        this.slideCB.setModel(new DefaultComboBoxModel<String>(new String[]{"No Overlap", "1/2 Overlap", "2/3 Overlap", "3/4 Overlap", "7/8 Overlap"}));
        this.slideCB.setMinimumSize(new Dimension(125, 27));
        this.slideCB.setPreferredSize(new Dimension(125, 27));
        this.sizeTF.setText("512");
        this.sizeTF.setPreferredSize(new Dimension(90, 27));
        this.windowCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Hanning (Hann)", "TenPercentEdgeCosine", "Unity (Boxcar)"}));
        this.windowCB.setPreferredSize(new Dimension(125, 27));
        this.buttonGroup1.add(this.psdRB);
        this.psdRB.setSelected(true);
        this.psdRB.setText("PSD");
        this.psdRB.setToolTipText("Power Spectral Density");
        this.psdRB.addActionListener(formListener);
        this.buttonGroup1.add(this.lsdRB);
        this.lsdRB.setText("LSD");
        this.lsdRB.setToolTipText("Linear (Amplitude) Spectral Density");
        this.lsdRB.addActionListener(formListener);
        this.buttonGroup1.add(this.lsRB);
        this.lsRB.setText("LS");
        this.lsRB.setToolTipText("Linear (Amplitude) Spectrum");
        this.lsRB.addActionListener(formListener);
        this.descriptionLabel.setText("<html>Power Spectral Density  e.g. V&rarr;V**2/Hz");
        this.buttonGroup1.add(this.psRB);
        this.psRB.setText("PS");
        this.psRB.setToolTipText("Power Spectrum");
        this.psRB.addActionListener(formListener);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel1).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.sizeTF, -2, -1, -2).add((Component)this.slideCB, -2, -1, -2).add((Component)this.windowCB, -2, 192, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.psdRB).addPreferredGap(0).add((Component)this.psRB).addPreferredGap(0).add((Component)this.lsdRB).addPreferredGap(0).add((Component)this.lsRB)).add((Component)this.descriptionLabel, -2, -1, -2)).addContainerGap(29, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.descriptionLabel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.psdRB).add((Component)this.lsdRB).add((Component)this.lsRB).add((Component)this.psRB)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.sizeTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.slideCB, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.windowCB, -2, -1, -2).add((Component)this.jLabel3)).addContainerGap()));
    }

    private void psdRBActionPerformed(ActionEvent evt) {
        if (this.psdRB.isSelected()) {
            this.descriptionLabel.setText("<html>Power Spectral Density  e.g. V&rarr;V**2/Hz");
        }
    }

    private void lsdRBActionPerformed(ActionEvent evt) {
        if (this.lsdRB.isSelected()) {
            this.descriptionLabel.setText("<html>Linear Spectral Density  e.g. V&rarr;V/sqrt(Hz)");
        }
    }

    private void lsRBActionPerformed(ActionEvent evt) {
        if (this.lsRB.isSelected()) {
            this.descriptionLabel.setText("<html>Linear Spectrum  e.g. V&rarr;V");
        }
    }

    private void psRBActionPerformed(ActionEvent evt) {
        if (this.psRB.isSelected()) {
            this.descriptionLabel.setText("<html>Power Spectrum  e.g. V&rarr;V**2");
        }
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile("\\|([a-zA-Z]+)\\((\\d+),(\\d),'?(\\w+)\\'?\\)");
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            String f = m.group(1);
            if (f.equals("fftPowerSpectralDensity")) {
                this.psdRB.setSelected(true);
                this.psdRBActionPerformed(null);
            } else if (f.equals("fftLinearSpectralDensity")) {
                this.lsdRB.setSelected(true);
                this.lsdRBActionPerformed(null);
            } else if (f.equals("fftLinearSpectrum")) {
                this.lsRB.setSelected(true);
                this.lsRBActionPerformed(null);
            } else if (f.equals("fftPowerSpectrum")) {
                this.psRB.setSelected(true);
                this.psRBActionPerformed(null);
            }
            this.sizeTF.setText(m.group(2));
            if (m.group(3).equals("1")) {
                this.slideCB.setSelectedIndex(0);
            } else if (m.group(3).equals("2")) {
                this.slideCB.setSelectedIndex(1);
            } else if (m.group(3).equals("3")) {
                this.slideCB.setSelectedIndex(2);
            } else if (m.group(3).equals("4")) {
                this.slideCB.setSelectedIndex(3);
            } else if (m.group(3).equals("8")) {
                this.slideCB.setSelectedIndex(4);
            } else {
                this.slideCB.setSelectedIndex(0);
            }
            this.windowCB.setSelectedItem(m.group(4));
        } else {
            this.psdRB.setSelected(true);
            this.sizeTF.setText("512");
            this.slideCB.setSelectedIndex(0);
            this.windowCB.setSelectedIndex(0);
        }
    }

    @Override
    public String getFilter() {
        String f;
        if (this.slideCB.getSelectedItem().equals("No Overlap")) {
            this.slide = "1";
        } else if (this.slideCB.getSelectedItem().equals("1/2 Overlap")) {
            this.slide = "2";
        } else if (this.slideCB.getSelectedItem().equals("2/3 Overlap")) {
            this.slide = "3";
        } else if (this.slideCB.getSelectedItem().equals("3/4 Overlap")) {
            this.slide = "4";
        } else if (this.slideCB.getSelectedItem().equals("7/8 Overlap")) {
            this.slide = "8";
        }
        String window = (String)this.windowCB.getSelectedItem();
        if (window.startsWith("Hanning")) {
            window = "Hanning";
        }
        if (window.startsWith("Unity")) {
            window = "Unity";
        }
        if (this.psdRB.isSelected()) {
            f = "fftPowerSpectralDensity";
        } else if (this.lsdRB.isSelected()) {
            f = "fftLinearSpectralDensity";
        } else if (this.lsRB.isSelected()) {
            f = "fftLinearSpectrum";
        } else if (this.psRB.isSelected()) {
            f = "fftPowerSpectrum";
        } else {
            throw new IllegalArgumentException("see code underimplemented line 192 FftOutputsFilterEditorPanel");
        }
        return "|" + f + "(" + this.sizeTF.getText() + "," + this.slide + ",'" + window + "')";
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == FftOutputsFilterEditorPanel.this.psdRB) {
                FftOutputsFilterEditorPanel.this.psdRBActionPerformed(evt);
            } else if (evt.getSource() == FftOutputsFilterEditorPanel.this.lsdRB) {
                FftOutputsFilterEditorPanel.this.lsdRBActionPerformed(evt);
            } else if (evt.getSource() == FftOutputsFilterEditorPanel.this.lsRB) {
                FftOutputsFilterEditorPanel.this.lsRBActionPerformed(evt);
            } else if (evt.getSource() == FftOutputsFilterEditorPanel.this.psRB) {
                FftOutputsFilterEditorPanel.this.psRBActionPerformed(evt);
            }
        }
    }
}

