/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.das2.qds.ops.Ops;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class HistogramFilterEditorPanel
extends AbstractFilterEditorPanel {
    static String PROP_REGEX = "\\|histogram\\(\\s*([^,]+)\\s*,\\s*([^,]+)\\s*,\\s*([^,]+(\\s*[^,]+\\s*))?\\)";
    private JTextField binsizeTF;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JCheckBox manualCB;
    private JTextField maximumTF;
    private JTextField minimumTF;
    private JPanel paramsPanel;
    private BindingGroup bindingGroup;

    public HistogramFilterEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.manualCB = new JCheckBox();
        this.paramsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.binsizeTF = new JTextField();
        this.maximumTF = new JTextField();
        this.minimumTF = new JTextField();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HistogramFilterEditorPanel.this.formFocusLost(evt);
            }
        });
        this.manualCB.setText("Configure Histogram Manually");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.paramsPanel, (Property)ELProperty.create((String)"${visible}"), (Object)this.manualCB, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel1.setText("Minimum:");
        this.jLabel2.setText("Maximum:");
        this.jLabel3.setText("Bin Size:");
        this.binsizeTF.setText("1");
        this.maximumTF.setText("10");
        this.minimumTF.setText("0");
        this.minimumTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistogramFilterEditorPanel.this.minimumTFActionPerformed(evt);
            }
        });
        GroupLayout paramsPanelLayout = new GroupLayout(this.paramsPanel);
        this.paramsPanel.setLayout(paramsPanelLayout);
        paramsPanelLayout.setHorizontalGroup(paramsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(paramsPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(paramsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(paramsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maximumTF, -2, 296, -2).addComponent(this.minimumTF, -2, 301, -2).addComponent(this.binsizeTF, -2, 167, -2)).addContainerGap(13, Short.MAX_VALUE)));
        paramsPanelLayout.linkSize(0, this.maximumTF, this.minimumTF);
        paramsPanelLayout.setVerticalGroup(paramsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, paramsPanelLayout.createSequentialGroup().addContainerGap().addGroup(paramsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.minimumTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(paramsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.maximumTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(paramsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.binsizeTF, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paramsPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.manualCB).addContainerGap(-1, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.manualCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paramsPanel, -2, -1, -2)));
        this.bindingGroup.bind();
    }

    private void minimumTFActionPerformed(ActionEvent evt) {
    }

    private void formFocusLost(FocusEvent evt) {
        System.err.println("hfep: focus lost");
    }

    @Override
    public void setFilter(String filter) {
        Pattern p1 = Pattern.compile(PROP_REGEX);
        Pattern p2 = Pattern.compile("\\|histogram\\(\\s*\\)");
        Matcher m = p1.matcher(filter);
        Matcher n = p2.matcher(filter);
        if (m.matches()) {
            this.minimumTF.setText(m.group(1));
            this.maximumTF.setText(m.group(2));
            this.binsizeTF.setText(m.group(3));
            this.manualCB.setSelected(true);
        } else if (n.matches()) {
            this.manualCB.setSelected(false);
        }
    }

    @Override
    public String getFilter() {
        if (this.manualCB.isSelected()) {
            return "|histogram(" + this.minimumTF.getText() + "," + this.maximumTF.getText() + "," + this.binsizeTF.getText() + ")";
        }
        return "|histogram()";
    }

    @Override
    public void setInput(QDataSet ds) {
        QDataSet h = Ops.autoHistogram(ds);
        QDataSet dep0 = (QDataSet)h.property("DEPEND_0");
        QDataSet extent = Ops.extent(dep0);
        QDataSet s = extent.slice(0);
        Units u = SemanticOps.getUnits(s);
        if (this.manualCB.isSelected()) {
            logger.fine("manual, skip");
        } else if (UnitsUtil.isTimeLocation((Units)u)) {
            this.minimumTF.setText(extent.slice(0).toString().trim());
            this.maximumTF.setText(extent.slice(1).toString().trim());
            this.binsizeTF.setText(Ops.subtract(dep0.slice(1), dep0.slice(0)).toString().trim());
        } else {
            this.minimumTF.setText(String.valueOf(extent.slice(0).value()));
            this.maximumTF.setText(String.valueOf(extent.slice(1).value()));
            this.binsizeTF.setText(String.valueOf(Ops.subtract(dep0.slice(1), dep0.slice(0)).value()));
        }
    }
}

