/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreeUtil {
    public static boolean isDescendant(TreePath path1, TreePath path2) {
        int count2;
        int count1 = path1.getPathCount();
        if (count1 <= (count2 = path2.getPathCount())) {
            return false;
        }
        while (count1 != count2) {
            path1 = path1.getParentPath();
            --count1;
        }
        return path1.equals(path2);
    }

    public static String getExpansionState(JTree tree, int row) {
        TreePath rowPath = tree.getPathForRow(row);
        StringBuilder buf = new StringBuilder();
        int rowCount = tree.getRowCount();
        for (int i = row; i < rowCount; ++i) {
            TreePath path = tree.getPathForRow(i);
            if (i != row && !TreeUtil.isDescendant(path, rowPath)) break;
            if (!tree.isExpanded(path)) continue;
            buf.append(",").append(String.valueOf(i - row));
        }
        return buf.toString();
    }

    public static void restoreExpanstionState(JTree tree, int row, String expansionState) {
        StringTokenizer stok = new StringTokenizer(expansionState, ",");
        while (stok.hasMoreTokens()) {
            int token = row + Integer.parseInt(stok.nextToken());
            tree.expandRow(token);
        }
    }
}

