/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.das2.datum.LoggerManager;
import org.das2.qds.QDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.AsciiParser;
import org.das2.qds.util.BundleBuilder;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OdlParser {
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset.ascii.odl");

    public static String readOdl(BufferedReader r, JSONObject record) throws IOException, JSONException {
        boolean notdone = true;
        Stack<String> objectStack = new Stack<String>();
        Stack<JSONObject> jsonStack = new Stack<JSONObject>();
        StringBuilder sb = new StringBuilder();
        HashSet<String> keepers = new HashSet<String>();
        keepers.add("NAME");
        keepers.add("FORMAT");
        keepers.add("ALIAS");
        keepers.add("UNITS");
        keepers.add("TYPE");
        try {
            String line;
            while (notdone && (line = r.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (s.equals("END_OBJECT")) {
                        sb.append("            ".substring(0, 2 * (objectStack.size() - 1)));
                    } else {
                        sb.append("            ".substring(0, 2 * objectStack.size()));
                    }
                    if (s.equals("OBJECT")) {
                        sb.append(s).append(" ");
                        s = st.nextToken();
                        sb.append(s).append(" ");
                        s = st.nextToken();
                        objectStack.push(s);
                        sb.append(s).append(" ");
                        if (s.equals("RECORD")) {
                            if (record == null) {
                                record = new JSONObject();
                            }
                            record.put("array", (Object)new JSONArray());
                            jsonStack.add(record);
                            continue;
                        }
                        if (jsonStack.empty()) continue;
                        JSONArray nextArray = new JSONArray();
                        JSONObject jo = new JSONObject();
                        jo.put("array", (Object)nextArray);
                        jsonStack.add(jo);
                        continue;
                    }
                    if (s.equals("END_OBJECT")) {
                        sb.append(s).append(" ");
                        sb.append("/* ").append((String)objectStack.pop()).append(" */");
                        if (jsonStack.empty()) continue;
                        JSONObject finishedObject = (JSONObject)jsonStack.pop();
                        if (jsonStack.empty()) continue;
                        JSONObject thisObject = (JSONObject)jsonStack.peek();
                        thisObject.getJSONArray("array").put((Object)finishedObject);
                        continue;
                    }
                    if (keepers.contains(s) && !jsonStack.empty()) {
                        String t = s;
                        sb.append(s).append(" ");
                        s = st.nextToken();
                        sb.append(s).append(" ");
                        s = st.nextToken();
                        sb.append(s).append(" ");
                        JSONObject currentObject = (JSONObject)jsonStack.peek();
                        currentObject.put(t, (Object)s);
                        continue;
                    }
                    sb.append(s).append(" ");
                }
                if (objectStack.isEmpty()) {
                    notdone = false;
                }
                sb.append("\n");
            }
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        return sb.toString();
    }

    public static QDataSet readStream(BufferedReader r, JSONObject record, ProgressMonitor monitor) throws IOException {
        int fieldCount = OdlParser.getFieldCount(record);
        AsciiParser parser = AsciiParser.newParser(fieldCount);
        WritableDataSet result = parser.readStream(r, monitor);
        ArrayList<String> names = new ArrayList<String>();
        OdlParser.getNames(record, "", false, names);
        BundleBuilder bbuild = new BundleBuilder(result.length(0));
        for (int i = 0; i < result.length(0); ++i) {
            bbuild.putProperty("NAME", i, names.get(i));
        }
        result.putProperty("BUNDLE_1", bbuild.getDataSet());
        r.close();
        return result;
    }

    private static QDataSet formTimeTags(QDataSet ds, JSONObject record) {
        try {
            JSONArray array = record.getJSONArray("array");
            if (array.length() == 0) {
                throw new IllegalArgumentException("array is empty");
            }
            JSONObject time = array.getJSONObject(0);
            if (time.has("NAME") && time.getString("NAME").equals("TIME")) {
                JSONArray components = time.getJSONArray("array");
                QDataSet[] cds = new QDataSet[7];
                block22: for (int icomp = 0; icomp < components.length(); ++icomp) {
                    String name;
                    JSONObject comp = components.getJSONObject(icomp);
                    switch (name = comp.optString("NAME")) {
                        case "YEAR": {
                            cds[0] = Ops.slice1(ds, icomp);
                            continue block22;
                        }
                        case "MONTH": {
                            cds[1] = Ops.slice1(ds, icomp);
                            continue block22;
                        }
                        case "DOY": {
                            cds[1] = Ops.dataset(1);
                            cds[2] = Ops.slice1(ds, icomp);
                            continue block22;
                        }
                        case "DAY": {
                            cds[2] = Ops.slice1(ds, icomp);
                            continue block22;
                        }
                        case "HOUR": {
                            cds[3] = Ops.slice1(ds, icomp);
                            continue block22;
                        }
                        case "MIN": {
                            cds[4] = Ops.slice1(ds, icomp);
                            continue block22;
                        }
                        case "SEC": {
                            cds[5] = Ops.slice1(ds, icomp);
                            continue block22;
                        }
                        case "MSEC": {
                            cds[6] = Ops.multiply((Object)Ops.slice1(ds, icomp), 1000000);
                            continue block22;
                        }
                        default: {
                            throw new IllegalArgumentException("unexpected component: " + name);
                        }
                    }
                }
                QDataSet tds = Ops.toTimeDataSet(cds[0], cds[1], cds[2], cds[3], cds[4], cds[5], cds[6]);
                ds = Ops.trim1(ds, components.length(), ds.length(0));
                ds = Ops.link(tds, ds);
                return ds;
            }
            throw new IllegalArgumentException("expected record to have time components, a vector with TIME,YEAR,etc");
        }
        catch (JSONException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static int getFieldCount(JSONObject record) {
        try {
            if (record.has("FORMAT")) {
                return 1;
            }
            int count = 0;
            JSONArray array = record.getJSONArray("array");
            for (int i = 0; i < array.length(); ++i) {
                JSONObject jo = array.getJSONObject(i);
                count += OdlParser.getFieldCount(jo);
            }
            return count;
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getFormat(JSONObject record) {
        try {
            if (record.has("FORMAT")) {
                return record.getString("FORMAT");
            }
            StringBuilder sb = new StringBuilder();
            JSONArray array = record.getJSONArray("array");
            for (int i = 0; i < array.length(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                JSONObject jo = array.getJSONObject(i);
                sb.append(OdlParser.getFormat(jo));
            }
            return sb.toString();
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String[] getNames(JSONObject record, String name, boolean includeComposite, List<String> result) {
        if (result == null) {
            result = new ArrayList<String>();
        }
        JSONArray array = record.optJSONArray("array");
        boolean icol = false;
        for (int i = 0; i < array.length(); ++i) {
            JSONObject child = array.optJSONObject(i);
            String s = child.optString("NAME");
            if (s.isEmpty()) continue;
            if (child.optJSONArray("array").length() == 0) {
                if (name.length() == 0) {
                    result.add(s);
                    continue;
                }
                result.add(name + "." + s);
                continue;
            }
            if (name.length() == 0) {
                if (includeComposite) {
                    result.add(s);
                }
                OdlParser.getNames(child, s, includeComposite, result);
                continue;
            }
            if (!includeComposite) {
                result.add(name + "." + s);
            }
            OdlParser.getNames(child, name + "." + s, includeComposite, result);
        }
        return result.toArray(new String[result.size()]);
    }

    public static int[] getColumns(JSONObject record, int startColumn, String name) {
        String n1 = record.optString("NAME");
        String na = record.optString("ALIAS");
        JSONArray array = record.optJSONArray("array");
        if (n1.equals(name) || na.equals(name)) {
            if (array == null || array.length() == 0) {
                return new int[]{startColumn, startColumn};
            }
            return new int[]{startColumn, startColumn + array.length()};
        }
        int icol = 0;
        for (int i = 0; i < array.length(); ++i) {
            int[] rr;
            JSONObject thisObject = array.optJSONObject(i);
            String s = thisObject.optString("NAME");
            if (!s.isEmpty() && name.startsWith(s) && (name.equals(s) ? (rr = OdlParser.getColumns(thisObject, startColumn + icol, name))[0] > -1 : (rr = OdlParser.getColumns(thisObject, startColumn + icol, name.substring(s.length() + 1)))[0] > -1)) {
                return new int[]{rr[0], rr[1]};
            }
            icol += OdlParser.getFieldCount(thisObject);
        }
        return new int[]{-1, -1};
    }

    public static QDataSet getDataSet(JSONObject record, QDataSet ds, String name) {
        int[] rr = OdlParser.getColumns(record, 0, name);
        QDataSet result = OdlParser.formTimeTags(ds, record);
        if (rr[0] == -1) {
            throw new IllegalArgumentException("no such dataset: " + name);
        }
        QDataSet yy = rr[0] == rr[1] ? Ops.slice1(ds, rr[0]) : Ops.trim1(ds, rr[0], rr[1]);
        return Ops.link(result.property("DEPEND_0"), (Object)yy);
    }
}

