/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.util.ValuesTreeModel;
import org.das2.util.DasMath;

public class PropertiesTreeModel
extends DefaultTreeModel {
    QDataSet ds;
    String dsLabel;
    MutableTreeNode mroot;

    public PropertiesTreeModel(QDataSet ds, int valuesSizeLimit) {
        this(null, ds, valuesSizeLimit);
    }

    public PropertiesTreeModel(String prefix, QDataSet ds, int valuesSizeLimit) {
        super(new DefaultMutableTreeNode((prefix == null ? "" : prefix) + DataSetUtil.toString(ds)));
        this.mroot = (MutableTreeNode)this.root;
        this.ds = ds;
        Map<String, Object> properties = DataSetUtil.getProperties(ds);
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            MutableTreeNode nextChild;
            String key = e.getKey();
            Object value = e.getValue();
            if (key.equals("QUBE") && (ds.rank() < 2 || ds.property("BUNDLE_1") != null)) continue;
            if (key.startsWith("BUNDLE_") && value instanceof QDataSet) {
                QDataSet bdsd = (QDataSet)value;
                StringBuilder svalue = new StringBuilder();
                svalue.append(key).append("=");
                if (bdsd.length() > 0) {
                    svalue.append(bdsd.property("NAME", 0));
                }
                for (int i = 1; i < bdsd.length(); ++i) {
                    svalue.append(",").append(bdsd.property("NAME", i));
                }
                BundleDescriptorTreeModel rm = new BundleDescriptorTreeModel(svalue.toString(), (QDataSet)value);
                nextChild = (MutableTreeNode)rm.getRoot();
            } else if (value instanceof QDataSet) {
                PropertiesTreeModel model = new PropertiesTreeModel(key + "=", (QDataSet)value, valuesSizeLimit);
                nextChild = (MutableTreeNode)model.getRoot();
            } else if (value.getClass().isArray()) {
                value.getClass().getComponentType();
                ArrayList<Object> list = new ArrayList<Object>();
                int nn = Math.min(Array.getLength(value), 5);
                for (int i = 0; i < nn; ++i) {
                    list.add(Array.get(value, i));
                }
                if (Array.getLength(value) > 5) {
                    list.add("...");
                }
                nextChild = new DefaultMutableTreeNode("" + key + "=" + list);
            } else if (Map.class.isAssignableFrom(value.getClass())) {
                nextChild = (MutableTreeNode)new MapTreeModel(key + " (map)", (Map)value).getRoot();
            } else {
                String svalue = String.valueOf(value);
                if (value instanceof Number && (key.equals("VALID_MIN") || key.equals("VALID_MAX") || key.equals("TYPICAL_MIN") || key.equals("TYPICAL_MAX"))) {
                    Units u = (Units)properties.get("UNITS");
                    if (u != null && UnitsUtil.isTimeLocation((Units)u)) {
                        svalue = u.isValid(((Number)value).doubleValue()) ? u.createDatum((Number)value).toString() + " (" + svalue + ")" : "fill (" + svalue + ")";
                    }
                    nextChild = new DefaultMutableTreeNode("" + key + "=" + svalue);
                } else if (key.equals("FILL_VALUE") && value instanceof Number) {
                    svalue = value instanceof Long || value instanceof Integer || value instanceof Short ? String.valueOf(value) : String.valueOf(DasMath.roundNSignificantDigits((double)((Number)value).doubleValue(), (int)6));
                    nextChild = new DefaultMutableTreeNode("" + key + "=" + svalue);
                } else if (key.equals("DESCRIPTION")) {
                    String rootNode = key + "=" + (svalue.length() > 60 ? svalue.substring(0, 60) + "..." : svalue);
                    nextChild = (MutableTreeNode)new LongStringTreeModel(rootNode, svalue).getRoot();
                } else {
                    nextChild = new DefaultMutableTreeNode("" + key + "=" + svalue);
                }
            }
            this.mroot.insert(nextChild, this.mroot.getChildCount());
        }
        if (ds.rank() > 0) {
            if (SemanticOps.isJoin(ds)) {
                int lin = 19;
                for (int i = 0; i < ds.length(); ++i) {
                    if (i < lin || i >= ds.length() - 3) {
                        QDataSet ds1 = ds.slice(i);
                        MutableTreeNode values = (MutableTreeNode)new PropertiesTreeModel(String.format("slice(%d)= ", i), ds1, valuesSizeLimit).getRoot();
                        this.mroot.insert(values, this.mroot.getChildCount());
                        continue;
                    }
                    if (i != lin) continue;
                    this.mroot.insert(new DefaultMutableTreeNode("..."), this.mroot.getChildCount());
                }
            } else {
                DefaultMutableTreeNode values = new DefaultMutableTreeNode("values");
                ValuesTreeModel.valuesTreeNode("value(", values, ds, valuesSizeLimit);
                this.mroot.insert(values, this.mroot.getChildCount());
            }
        }
    }

    private static class LongStringTreeModel
    extends DefaultTreeModel {
        private static final int LINE_LEN = 133;
        String name;
        String value;
        List<Integer> splits;
        boolean hasKids;

        LongStringTreeModel(Object root, String value) {
            super(new DefaultMutableTreeNode(root));
            MutableTreeNode mrt = (MutableTreeNode)this.getRoot();
            this.value = value = value.trim();
            int lastBreak = -1;
            if (value.length() > 133 || value.contains("\n")) {
                int ii = 0;
                while (ii < value.length()) {
                    int i = value.indexOf(10, ii);
                    ii = i - ii > 133 || i == -1 ? (value.length() - ii < 133 ? value.length() : ((i = value.lastIndexOf(32, ii + 133)) == -1 ? (ii += 133) : (i > ii ? i + 1 : value.length()))) : i + 1;
                    if (ii >= value.length()) continue;
                    String schild = lastBreak == -1 ? value.substring(0, ii) : value.substring(lastBreak, ii);
                    mrt.insert(new DefaultMutableTreeNode(schild), mrt.getChildCount());
                    lastBreak = ii;
                }
            } else {
                mrt.insert(new DefaultMutableTreeNode(value), mrt.getChildCount());
            }
        }
    }

    private static class MapTreeModel
    extends DefaultTreeModel {
        MapTreeModel(Object root, Map values) {
            super(new DefaultMutableTreeNode(root));
            MutableTreeNode mrt = (MutableTreeNode)this.getRoot();
            for (Map.Entry o : values.entrySet()) {
                Object nextChild;
                Map.Entry val = o;
                Object value = val.getValue();
                if (value != null && value.getClass().isArray()) {
                    nextChild = new ArrayTreeModel(val.getKey() + "[" + Array.getLength(value) + "]", value);
                    mrt.insert((MutableTreeNode)((DefaultTreeModel)nextChild).getRoot(), mrt.getChildCount());
                    continue;
                }
                if (value != null && Map.class.isAssignableFrom(value.getClass())) {
                    nextChild = (MutableTreeNode)new MapTreeModel(val.getKey(), (Map)value).getRoot();
                    mrt.insert((MutableTreeNode)nextChild, mrt.getChildCount());
                    continue;
                }
                if (value instanceof String && ((String)value).length() > 80) {
                    String svalue = (String)value;
                    String rootString = val.getKey() + "=" + (svalue.length() > 60 ? svalue.substring(0, 60) + "..." : svalue);
                    MutableTreeNode nextChild2 = (MutableTreeNode)new LongStringTreeModel(rootString, (String)value).getRoot();
                    mrt.insert(nextChild2, mrt.getChildCount());
                    continue;
                }
                mrt.insert(new DefaultMutableTreeNode("" + val.getKey() + "=" + val.getValue()), mrt.getChildCount());
            }
        }
    }

    private static class ArrayTreeModel
    extends DefaultTreeModel {
        ArrayTreeModel(Object root, Object values) {
            super(new DefaultMutableTreeNode(root));
            MutableTreeNode mrt = (MutableTreeNode)this.getRoot();
            for (int i = 0; i < Array.getLength(values); ++i) {
                MutableTreeNode nextChild = (MutableTreeNode)new DefaultMutableTreeNode("[" + i + "]=" + Array.get(values, i)).getRoot();
                mrt.insert(nextChild, mrt.getChildCount());
            }
        }
    }

    private static class BundleDescriptorTreeModel
    extends DefaultTreeModel {
        public BundleDescriptorTreeModel(String label, QDataSet root) {
            super(new DefaultMutableTreeNode(root));
            MutableTreeNode mrt = (MutableTreeNode)this.getRoot();
            ((DefaultMutableTreeNode)mrt).setUserObject(label);
            for (int i = 0; i < root.length(); ++i) {
                PropertiesTreeModel m = new PropertiesTreeModel(root.slice(i), 20);
                mrt.insert((MutableTreeNode)m.getRoot(), mrt.getChildCount());
            }
        }
    }
}

