/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util.dd;

import java.util.ArrayList;
import java.util.List;
import org.das2.qds.util.dd.Id;

public class Node {
    private Id id;
    private List<Node> children = new ArrayList<Node>();

    public Node(Id _id) {
        this.id = _id;
    }

    public void add(Node child) {
        this.children.add(child);
    }

    public int numberOfChildren() {
        return this.children.size();
    }

    public Node getChild(int i) {
        return this.children.get(i);
    }

    public Node getChild(int i, int n) {
        if (n != this.children.size()) {
            throw new IllegalArgumentException();
        }
        return this.children.get(i);
    }

    public Id getId() {
        return this.id;
    }

    public void printHead(String prefix, String suffix) {
        System.out.print(prefix + (Object)((Object)this.id));
        System.out.println(" " + suffix);
    }

    public void printChildren(String prefix) {
        if (this.children != null) {
            for (Node n : this.children) {
                if (n == null) continue;
                n.print(prefix + " ");
            }
        }
    }

    public void print(String prefix, String suffix) {
        this.printHead(prefix, suffix);
        this.printChildren(prefix);
    }

    public void print(String prefix) {
        this.print(prefix, "");
    }
}

