/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util.dd;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.das2.qds.util.dd.IdentifierNode;
import org.das2.qds.util.dd.Node;

class Semantic {
    Semantic() {
    }

    static void error(String s) {
        System.out.println(s);
    }

    static boolean checkProgram(List<Node> program) {
        HashSet<String> env = new HashSet<String>();
        boolean programFlag = true;
        for (Node stmnt : program) {
            boolean stmntFlag = Semantic.checkStmnt(stmnt, env);
            programFlag = programFlag && stmntFlag;
        }
        return programFlag;
    }

    static boolean checkStmnt(Node stmnt, Set<String> env) {
        switch (stmnt.getId()) {
            case ASSIGN: {
                IdentifierNode var = (IdentifierNode)stmnt.getChild(0, 2);
                Node exp = stmnt.getChild(1, 2);
                boolean flag = Semantic.checkExp(exp, env);
                env.add(var.getName());
                return flag;
            }
        }
        Semantic.error("Unexpected statement: " + (Object)((Object)stmnt.getId()));
        return false;
    }

    static boolean checkExp(Node exp, Set<String> env) {
        switch (exp.getId()) {
            case DOUBLE: {
                return true;
            }
            case IDENT: {
                String name = ((IdentifierNode)exp).getName();
                if (env.contains(name)) {
                    return true;
                }
                Semantic.error("Variable " + name + " not defined.");
                return false;
            }
            case PLUS: {
                boolean flag1 = Semantic.checkExp(exp.getChild(0, 2), env);
                boolean flag2 = Semantic.checkExp(exp.getChild(1, 2), env);
                return flag1 && flag2;
            }
        }
        Semantic.error("Unexpected expression: " + (Object)((Object)exp.getId()));
        return false;
    }
}

