/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.das2.qstream.Descriptor;
import org.das2.qstream.PlaneDescriptor;
import org.w3c.dom.Element;

public class PacketDescriptor
implements Descriptor,
Cloneable {
    boolean stream;
    int streamRank;
    List<PlaneDescriptor> planes = new ArrayList<PlaneDescriptor>();
    private Element domElement;
    boolean valuesInDescriptor = false;
    private int packetId = -1;

    PacketDescriptor() {
    }

    public Object clone() throws CloneNotSupportedException {
        PacketDescriptor result = (PacketDescriptor)super.clone();
        result.planes = new ArrayList<PlaneDescriptor>();
        for (int i = 0; i < this.planes.size(); ++i) {
            result.planes.add((PlaneDescriptor)this.planes.get(i).clone());
        }
        return result;
    }

    PacketDescriptor(Element element) {
        this();
        this.domElement = element;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public int streamRank() {
        return this.streamRank;
    }

    public void setStreamRank(int streamRank) {
        this.streamRank = streamRank;
    }

    public void addPlane(PlaneDescriptor planeDescriptor) {
        this.planes.add(planeDescriptor);
    }

    public List<PlaneDescriptor> getPlanes() {
        return Collections.unmodifiableList(this.planes);
    }

    void setValuesInDescriptor(boolean b) {
        this.valuesInDescriptor = b;
    }

    boolean isValuesInDescriptor() {
        return this.valuesInDescriptor;
    }

    public void setDomElement(Element packetElement) {
        this.domElement = packetElement;
    }

    @Override
    public Element getDomElement() {
        return this.domElement;
    }

    public int sizeBytes() {
        int sizeBytes = 0;
        for (int iplane = 0; iplane < this.planes.size(); ++iplane) {
            PlaneDescriptor pd = this.planes.get(iplane);
            sizeBytes += pd.sizeBytes();
        }
        return sizeBytes;
    }

    public int getPacketId() {
        if (this.packetId < 1 || this.packetId > 99) {
            throw new IllegalStateException("packetId is invalid: " + this.packetId);
        }
        return this.packetId;
    }

    public void setPacketId(int packetId) {
        if (packetId < 1 || packetId > 99) {
            throw new IllegalArgumentException("packetId is invalid: " + packetId);
        }
        this.packetId = packetId;
    }

    public String toString() {
        return this.planes.toString();
    }
}

