/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.CacheTag;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.RankZeroDataSet;
import org.das2.qstream.CacheTagSerializeDelegate;
import org.das2.qstream.DatumRangeSerializeDelegate;
import org.das2.qstream.DefaultSerializeDelegate;
import org.das2.qstream.EnumerationUnitsSerializeDelegate;
import org.das2.qstream.MapSerializeDelegate;
import org.das2.qstream.NumberArraySerializeDelegate;
import org.das2.qstream.Rank0DataSetSerializeDelegate;
import org.das2.qstream.SerializeDelegate;
import org.das2.qstream.StringSerializeDelegate;
import org.das2.qstream.UnitsSerializeDelegate;
import org.das2.util.ClassMap;

public class SerializeRegistry {
    static Map<Class, SerializeDelegate> delegates = new ClassMap();
    static Map<String, SerializeDelegate> sdelegates = new HashMap<String, SerializeDelegate>();
    private static NumberArraySerializeDelegate numsd;

    public static void register(Class clas, SerializeDelegate sd) {
        delegates.put(clas, sd);
        sdelegates.put(sd.typeId(clas), sd);
    }

    public static SerializeDelegate getDelegate(Class clas) {
        if (clas.isArray() && clas.getComponentType().isPrimitive()) {
            return numsd;
        }
        return delegates.get(clas);
    }

    public static SerializeDelegate getByName(String name) {
        if (name.equals("numberArray")) {
            return numsd;
        }
        return sdelegates.get(name);
    }

    static {
        SerializeRegistry.register(Units.class, new UnitsSerializeDelegate());
        SerializeRegistry.register(EnumerationUnits.class, new EnumerationUnitsSerializeDelegate());
        SerializeRegistry.register(String.class, new StringSerializeDelegate());
        SerializeRegistry.register(CacheTag.class, new CacheTagSerializeDelegate());
        SerializeRegistry.register(AbstractMap.class, new MapSerializeDelegate());
        SerializeRegistry.register(RankZeroDataSet.class, new Rank0DataSetSerializeDelegate());
        SerializeRegistry.register(DatumRange.class, new DatumRangeSerializeDelegate());
        DefaultSerializeDelegate.registerDelegates();
        numsd = new NumberArraySerializeDelegate();
    }
}

