/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.qstream.TransferType;

class TransferTimeAtPrecision
extends TransferType {
    Units units;
    DatumFormatter formatter;
    byte[] aFill;
    int nSize;

    public TransferTimeAtPrecision(Units units, int nFracSec) {
        this.units = units;
        this.nSize = 20;
        StringBuilder sFmt = new StringBuilder("yyyy-MM-dd'T'HH:mm:ss");
        StringBuilder sFill = new StringBuilder("                   ");
        if (nFracSec > 0) {
            sFmt.append(".");
            sFill.append(" ");
        }
        for (int i = 0; i < nFracSec; ++i) {
            sFmt.append("S");
            sFill.append(" ");
        }
        sFmt.append(" ");
        sFill.append(" ");
        this.aFill = sFill.toString().getBytes(StandardCharsets.US_ASCII);
        try {
            this.formatter = new TimeDatumFormatter(sFmt.toString());
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        if (nFracSec > 0) {
            ++this.nSize;
        }
        this.nSize += nFracSec;
    }

    @Override
    public void write(double rVal, ByteBuffer buffer) {
        if (this.units.isFill(rVal)) {
            buffer.put(this.aFill);
        } else {
            String sOut = this.formatter.format(this.units.createDatum(rVal));
            buffer.put(sOut.getBytes(StandardCharsets.US_ASCII));
        }
    }

    @Override
    public double read(ByteBuffer buffer) {
        try {
            byte[] aBuf = new byte[this.nSize];
            buffer.get(aBuf);
            String sTime = new String(aBuf, "US-ASCII").trim();
            double result = TimeUtil.create((String)sTime).doubleValue(this.units);
            return result;
        }
        catch (UnsupportedEncodingException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int sizeBytes() {
        return this.nSize;
    }

    @Override
    public boolean isAscii() {
        return true;
    }

    @Override
    public String name() {
        return String.format("time%d", this.nSize);
    }
}

