/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream.filter;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qstream.CacheTagSerializeDelegate;
import org.das2.qstream.PacketDescriptor;
import org.das2.qstream.PlaneDescriptor;
import org.das2.qstream.Rank0DataSetSerializeDelegate;
import org.das2.qstream.StreamComment;
import org.das2.qstream.StreamDescriptor;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReduceFilter
implements StreamHandler {
    protected static final Logger logger = Logger.getLogger("qstream");
    StreamHandler sink;
    ByteOrder byteOrder;
    double lengthSeconds = 60.0;
    double reportCadenceSeconds;
    double length;
    Map<String, Accum> accum = new HashMap<String, Accum>();
    Map<PacketDescriptor, Boolean> skip = new HashMap<PacketDescriptor, Boolean>();
    Map<PacketDescriptor, Double> nextTags = new HashMap<PacketDescriptor, Double>();
    StreamDescriptor sd;
    private static final char CHAR_NEWLINE = '\n';

    @Override
    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        this.sd = sd;
        this.sink.streamDescriptor(sd);
        this.byteOrder = sd.getByteOrder();
    }

    @Override
    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        Element ele = pd.getDomElement();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            int id = this.sd.descriptorId(pd);
            this.unload(id);
            this.clear(id);
        }
        catch (IllegalArgumentException ex) {
            logger.fine("Illegal Argument Exception at line 113");
            ex.printStackTrace();
        }
        try {
            String sunits;
            boolean lskip = false;
            XPathExpression expr = xpath.compile("/packet/qdataset[1]/properties/property[@name='UNITS']/@value");
            Node xp = (Node)expr.evaluate(ele, XPathConstants.NODE);
            String string = sunits = xp == null ? null : xp.getNodeValue();
            if (sunits != null) {
                try {
                    Units xunits = Units.lookupTimeUnits((String)sunits);
                    double secmult = Units.seconds.getConverter(xunits.getOffsetUnits()).convert(1.0);
                    this.length = secmult * this.lengthSeconds;
                }
                catch (InconvertibleUnitsException ex) {
                    lskip = true;
                }
                catch (ParseException ex) {
                    lskip = true;
                }
            } else {
                lskip = true;
            }
            if (!lskip) {
                this.initAccumulators(pd);
                expr = xpath.compile("/packet/qdataset[1]/properties/property[@name='CADENCE']/@value");
                xp = (Node)expr.evaluate(ele, XPathConstants.NODE);
                if (xp != null) {
                    String scadence = xp.getNodeValue();
                    Rank0DataSetSerializeDelegate ser = new Rank0DataSetSerializeDelegate();
                    try {
                        QDataSet o = (QDataSet)ser.parse("rank0dataset", scadence);
                        double oldCadenceSeconds = DataSetUtil.asDatum((QDataSet)o).doubleValue(Units.seconds);
                        if (this.lengthSeconds < oldCadenceSeconds) {
                            this.reportCadenceSeconds = oldCadenceSeconds;
                        }
                    }
                    catch (ParseException ex) {
                        throw new StreamException(String.format("unable to parse cadence \"%s\"", scadence), ex);
                    }
                    xp.setNodeValue(ser.format(DataSetUtil.asDataSet((double)this.reportCadenceSeconds, (Units)Units.seconds)));
                }
                if ((xp = (Node)(expr = xpath.compile("/packet/qdataset[1]/properties/property[@name='CACHE_TAG']/@value")).evaluate(ele, XPathConstants.NODE)) != null) {
                    String scachetag = xp.getNodeValue();
                    CacheTagSerializeDelegate ser = new CacheTagSerializeDelegate();
                    try {
                        CacheTag ct0 = (CacheTag)ser.parse("cacheTag", scachetag);
                        CacheTag ct1 = new CacheTag(ct0.getRange(), Units.seconds.createDatum(this.lengthSeconds));
                        xp.setNodeValue(ser.format(ct1));
                    }
                    catch (ParseException ex) {
                        throw new StreamException(String.format("unable to parse cacheTag \"%s\"", scachetag), ex);
                    }
                }
            }
            this.skip.put(pd, lskip);
            this.nextTags.put(pd, Double.NEGATIVE_INFINITY);
        }
        catch (XPathExpressionException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.sink.packetDescriptor(pd);
    }

    @Override
    public void streamClosed(StreamDescriptor sd) throws StreamException {
        HashSet<PacketDescriptor> unloaded = new HashSet<PacketDescriptor>();
        for (Map.Entry<String, Accum> entry : this.accum.entrySet()) {
            Accum ac1 = entry.getValue();
            if (unloaded.contains(ac1.pd)) continue;
            this.unload(ac1.pd);
            unloaded.add(ac1.pd);
        }
        this.sink.streamClosed(sd);
    }

    @Override
    public void streamException(StreamException se) throws StreamException {
        this.sink.streamException(se);
    }

    @Override
    public void streamComment(StreamComment se) throws StreamException {
        this.sink.streamComment(se);
    }

    private void initAccumulators(PacketDescriptor pd) {
        List<PlaneDescriptor> planes = pd.getPlanes();
        for (int i = 0; i < planes.size(); ++i) {
            PlaneDescriptor planed = planes.get(i);
            double[] ss = new double[DataSetUtil.product((int[])planed.getQube())];
            Accum ac1 = new Accum();
            ac1.pd = pd;
            ac1.id = this.sd.descriptorId(pd);
            ac1.dsid = planed.getName();
            ac1.S = ss;
            ac1.N = 0;
            ac1.B = -1.0E38;
            this.accum.put(planed.getName(), ac1);
        }
    }

    private void clear(int id) {
        ArrayList<String> remove = new ArrayList<String>();
        for (Map.Entry<String, Accum> entry : this.accum.entrySet()) {
            Accum a = entry.getValue();
            if (a.id != id) continue;
            remove.add(a.dsid);
        }
        for (String a : remove) {
            this.accum.remove(a);
        }
    }

    private void unload(int id) throws StreamException {
        for (Map.Entry<String, Accum> entry : this.accum.entrySet()) {
            Accum a = entry.getValue();
            if (a.id != id) continue;
            this.unload(a.pd);
        }
    }

    private void unload(PacketDescriptor pd) throws StreamException {
        ByteBuffer data = ByteBuffer.allocate(pd.sizeBytes());
        data.order(this.byteOrder);
        int np = pd.getPlanes().size();
        int ip = 0;
        for (PlaneDescriptor planed : pd.getPlanes()) {
            Accum ac1 = this.accum.get(planed.getName());
            if (ac1 == null) {
                this.initAccumulators(pd);
                return;
            }
            double[] ss = ac1.S;
            int nn = ac1.N;
            double bb = ac1.B;
            if (nn == 0) {
                this.initAccumulators(pd);
                return;
            }
            if (planed.getElements() > 1) {
                for (int ii = 0; ii < planed.getElements(); ++ii) {
                    double avg = ss[ii] / (double)nn + bb;
                    planed.getType().write(avg, data);
                }
            } else {
                double avg = ss[0] / (double)nn + bb;
                planed.getType().write(avg, data);
            }
            if (ip == np - 1 && planed.getType().isAscii() && Character.isWhitespace(data.get(data.capacity() - 1))) {
                data.put(data.capacity() - 1, (byte)10);
            }
            ++ip;
        }
        data.flip();
        this.sink.packet(pd, data);
    }

    @Override
    public void packet(PacketDescriptor pd, ByteBuffer data) throws StreamException {
        boolean lskip = this.skip.get(pd);
        if (lskip) {
            this.sink.packet(pd, data);
        } else {
            double nextTag;
            List<PlaneDescriptor> planes = pd.getPlanes();
            PlaneDescriptor t0 = planes.get(0);
            double ttag = t0.getType().read(data);
            if (ttag > (nextTag = this.nextTags.get(pd).doubleValue())) {
                this.unload(pd);
                this.initAccumulators(pd);
                nextTag = (1.0 + Math.floor(ttag / this.length)) * this.length;
                this.nextTags.put(pd, nextTag);
            }
            data.rewind();
            for (PlaneDescriptor planed : pd.getPlanes()) {
                Accum ac1 = this.accum.get(planed.getName());
                double[] ss = ac1.S;
                double bb = ac1.B;
                if (bb == -1.0E38) {
                    int pos = data.position();
                    bb = planed.getType().read(data);
                    data.position(pos);
                    ac1.B = bb;
                }
                if (planed.getElements() > 1) {
                    int ii = 0;
                    while (ii < planed.getElements()) {
                        int n = ii++;
                        ss[n] = ss[n] + (planed.getType().read(data) - bb);
                    }
                } else {
                    ss[0] = ss[0] + (planed.getType().read(data) - bb);
                }
                ++ac1.N;
            }
        }
    }

    public void setCadence(Datum cadence) {
        this.reportCadenceSeconds = this.lengthSeconds = cadence.doubleValue(Units.seconds);
    }

    public void setSink(StreamHandler sink) {
        this.sink = sink;
    }

    private static class Accum {
        PacketDescriptor pd;
        int id;
        String dsid;
        double[] S;
        int N;
        double B;

        private Accum() {
        }
    }
}

