/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.jythonsupport.DatasetCommand;
import org.autoplot.jythonsupport.GetDataSetCommand;
import org.autoplot.jythonsupport.GetDataSetsCommand;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.Param;
import org.autoplot.jythonsupport.PyDatum;
import org.autoplot.jythonsupport.PyDatumAdapter;
import org.autoplot.jythonsupport.PyQDataSet;
import org.autoplot.jythonsupport.PyQDataSetAdapter;
import org.autoplot.jythonsupport.SimplifyScriptSupport;
import org.autoplot.jythonsupport.StaticCodeAnalysis;
import org.autoplot.jythonsupport.Util;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.FileUtil;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySyntaxError;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.adapter.PyObjectAdapter;
import org.python.core.parser;
import org.python.parser.SimpleNode;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Attribute;
import org.python.parser.ast.BinOp;
import org.python.parser.ast.Call;
import org.python.parser.ast.Expr;
import org.python.parser.ast.If;
import org.python.parser.ast.Import;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Module;
import org.python.parser.ast.Name;
import org.python.parser.ast.Num;
import org.python.parser.ast.Print;
import org.python.parser.ast.Str;
import org.python.parser.ast.Subscript;
import org.python.parser.ast.TryExcept;
import org.python.parser.ast.VisitorBase;
import org.python.parser.ast.exprType;
import org.python.parser.ast.stmtType;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class JythonUtil {
    private static final Logger logger = LoggerManager.getLogger((String)"jython");
    private static boolean haveloadedAdapters = false;
    static final String[] okay = new String[]{"range,", "xrange,", "irange,", "map,", "join,", "len,", "dict,", "zip,", "list,", "getParam,", "lower,", "upper,", "URI,", "URL,", "PWD,", "File,", "setScriptDescription", "setScriptTitle", "setScriptLabel", "setScriptIcon", "DatumRangeUtil,", "TimeParser,", "str,", "int,", "long,", "float,", "datum,", "datumRange,", "dataset,", "indgen,", "findgen,", "dindgen,", "ones,", "zeros,", "linspace,", "logspace,", "dblarr,", "fltarr,", "strarr,", "intarr,", "bytarr,", "ripples,", "split,", "color,", "colorFromString,", "isinstance,", "readConfiguration,"};
    public static final ScriptDescriptor EMPTY = new ScriptDescriptor(){

        @Override
        public String getLabel() {
            return "";
        }

        @Override
        public String getTitle() {
            return "";
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public String getIconURL() {
            return "";
        }

        @Override
        public List<Param> getParams() {
            return new ArrayList<Param>();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InteractiveInterpreter createInterpreter(boolean sandbox) throws IOException {
        String[] loadClasses;
        if (PySystemState.cachedir == null) {
            String autoplotData = AutoplotSettings.settings().resolveProperty("autoplotData");
            System.setProperty("python.cachedir", autoplotData + "/pycache");
        }
        PySystemState pySys = new PySystemState();
        String[] stringArray = loadClasses = new String[]{"glob.py", "autoplot2025.py", "autoplotapp2025.py"};
        int n = stringArray.length;
        block11: for (int i = 0; i < n; ++i) {
            String pysrc;
            switch (pysrc = stringArray[i]) {
                case "glob.py": {
                    String f;
                    URL jarUrl = InteractiveInterpreter.class.getResource("/" + pysrc);
                    if (jarUrl != null) {
                        f = JythonUtil.getLocalJythonLib();
                        pySys.path.insert(0, (PyObject)new PyString(f));
                        continue block11;
                    }
                    logger.log(Level.WARNING, "Couldn''t find jar containing {0}.  See https://sourceforge.net/p/autoplot/bugs/576/", pysrc);
                    continue block11;
                }
                case "autoplotapp2017.py": {
                    String f = JythonUtil.getLocalJythonAutoplotAppLib();
                    if (pySys.path.contains((Object)new PyString(f))) continue block11;
                    pySys.path.insert(0, (PyObject)new PyString(f));
                    continue block11;
                }
                default: {
                    String f = JythonUtil.getLocalJythonAutoplotLib();
                    if (pySys.path.contains((Object)new PyString(f))) continue block11;
                    pySys.path.insert(0, (PyObject)new PyString(f));
                    continue block11;
                }
            }
        }
        InteractiveInterpreter interp = new InteractiveInterpreter(null, pySys);
        boolean loadAutoplotStuff = true;
        if (loadAutoplotStuff) {
            JythonUtil.maybeLoadAdapters();
            if (Util.isLegacyImports()) {
                URL imports = JythonOps.class.getResource("/imports2025.py");
                if (imports == null) {
                    throw new RuntimeException("unable to locate imports2025.py on classpath");
                }
                logger.log(Level.FINE, "loading imports2025.py from {0}", imports);
                InputStream in = imports.openStream();
                byte[] bimports = FileUtil.readBytes((InputStream)in);
                try {
                    interp.execfile((InputStream)new ByteArrayInputStream(bimports), "/imports2025.py");
                }
                finally {
                    in.close();
                }
            }
        }
        interp.set("dataset", (PyObject)new DatasetCommand());
        interp.set("getDataSet", (PyObject)new GetDataSetCommand());
        interp.set("getDataSets", (PyObject)new GetDataSetsCommand());
        interp.set("monitor", (Object)new NullProgressMonitor());
        return interp;
    }

    public static void setupInterp(PythonInterpreter interp, String pwd, String resourceUri, Map<String, String> paramsl, ProgressMonitor mon) {
        interp.set("PWD", (Object)pwd);
        interp.exec("import autoplot2025 as autoplot");
        interp.exec("autoplot.params=dict()");
        for (Map.Entry<String, String> e : paramsl.entrySet()) {
            String s = e.getKey();
            if (s.equals("arg_0") || s.equals("script")) continue;
            String sval = e.getValue();
            sval = JythonUtil.maybeQuoteString(sval);
            logger.log(Level.FINE, "autoplot.params[''{0}'']={1}", new Object[]{s, sval});
            interp.exec("autoplot.params['" + s + "']=" + sval);
        }
        if (resourceUri != null) {
            interp.set("resourceURI", (Object)resourceUri);
            interp.exec("autoplot.params['resourceURI']=" + JythonUtil.maybeQuoteString(resourceUri));
        }
        interp.set("monitor", (Object)mon);
        try (InputStream in = JythonOps.class.getResource("/autoplot2025.py").openStream();){
            interp.execfile(in, "/autoplot2025.py");
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transferStream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[2048];
        try {
            int n = in.read(buf);
            while (n > -1) {
                out.write(buf, 0, n);
                n = in.read(buf);
            }
        }
        finally {
            out.close();
            in.close();
        }
    }

    private static boolean makeHomeFor(File file) {
        File f = file.getParentFile();
        if (!f.exists()) {
            return f.mkdirs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLocalJythonLib() throws IOException {
        File ff2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
        File ff3 = new File(ff2.toString() + "/jython");
        File ff4 = new File(ff2.toString() + "/jython/zlib.py");
        if (ff4.exists()) {
            return ff3.toString();
        }
        Class<JythonUtil> clazz = JythonUtil.class;
        synchronized (JythonUtil.class) {
            if (!ff3.exists() && !ff3.mkdirs()) {
                throw new IOException("Unable to mkdirs " + ff3);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (JythonUtil.class.getResource("/pylisting.txt") == null) {
                throw new IllegalArgumentException("unable to find pylisting.txt in application, which is needed to install Jython codes.");
            }
            logger.log(Level.FINE, "unpacking jython codes in {0}", JythonUtil.class.getResource("/pylisting.txt"));
            try (BufferedReader r = new BufferedReader(new InputStreamReader(JythonUtil.class.getResourceAsStream("/pylisting.txt")));){
                String s = r.readLine();
                while (s != null) {
                    File ff5 = new File(ff3, s);
                    logger.log(Level.FINER, "copy to local folder Jython code: {0}", s);
                    InputStream in = JythonUtil.class.getResourceAsStream("/" + s);
                    if (in == null) {
                        throw new IllegalArgumentException("unable to find Jython code which should be embedded in application: " + s);
                    }
                    if (s.contains("/") && !JythonUtil.makeHomeFor(ff5)) {
                        throw new IOException("Unable to makeHomeFor " + ff5);
                    }
                    try (FileOutputStream out = new FileOutputStream(ff5);){
                        JythonUtil.transferStream(in, out);
                    }
                    finally {
                        in.close();
                        if (!new File(ff3, s).setReadOnly()) {
                            logger.log(Level.FINER, "set read-only on file {0} failed", s);
                        }
                        if (!new File(ff3, s).setWritable(true, true)) {
                            logger.log(Level.FINER, "set write for user only on file {0} failed", s);
                        }
                    }
                    s = r.readLine();
                }
            }
            logger.fine("   ...done");
            return ff3.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLocalJythonAutoplotAppLib() throws IOException {
        File ff2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
        File ff3 = new File(ff2.toString() + "/jython");
        File ff4 = new File(ff3.toString(), "pylistingapp2017.txt");
        if (ff4.exists()) {
            return ff3.toString();
        }
        Class<JythonUtil> clazz = JythonUtil.class;
        synchronized (JythonUtil.class) {
            if (!ff3.exists() && !ff3.mkdirs()) {
                throw new IOException("Unable to mkdirs " + ff3);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (JythonUtil.class.getResource("/pylistingapp2017.txt") == null) {
                logger.log(Level.FINE, "unable to find pylistingapp2017.txt in application, assuming this is not the Autoplot client application.");
            } else {
                logger.log(Level.FINE, "unpacking jython codes in {0}", JythonUtil.class.getResource("/pylistingapp2017.txt"));
                try (BufferedReader r = new BufferedReader(new InputStreamReader(JythonUtil.class.getResourceAsStream("/pylistingapp2017.txt")));){
                    String s = r.readLine();
                    while (s != null) {
                        int i = s.indexOf("#");
                        if (i > -1) {
                            s = s.substring(0, i);
                        }
                        if ((s = s.trim()).length() > 0) {
                            File ff5 = new File(ff3, s);
                            logger.log(Level.FINER, "copy to local folder Jython code: {0}", s);
                            if (s.contains("/") && !JythonUtil.makeHomeFor(ff5)) {
                                throw new IOException("Unable to makeHomeFor " + ff5);
                            }
                            if (ff5.exists()) {
                                logger.fine("already have file, skip...");
                                s = r.readLine();
                                continue;
                            }
                            InputStream in = JythonUtil.class.getResourceAsStream("/" + s);
                            if (in == null) {
                                throw new IllegalArgumentException("unable to find jython code which should be embedded in application: " + s);
                            }
                            try (FileOutputStream out = new FileOutputStream(ff5);){
                                JythonUtil.transferStream(in, out);
                            }
                            finally {
                                in.close();
                                if (!new File(ff3, s).setReadOnly()) {
                                    logger.log(Level.FINER, "set read-only on file {0} failed", s);
                                }
                                if (!new File(ff3, s).setWritable(true, true)) {
                                    logger.log(Level.FINER, "set write for user only on file {0} failed", s);
                                }
                            }
                        }
                        s = r.readLine();
                    }
                }
            }
            return ff3.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static String getLocalJythonAutoplotLib() throws IOException {
        Object r;
        File ff2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
        File ff3 = new File(ff2.toString() + "/jython");
        File ff4 = new File(ff3, "autoplot2025.py");
        String vers = "";
        double currentVersion = 5.1;
        if (ff4.exists()) {
            r = new BufferedReader(new FileReader(ff4));
            String[] stringArray = null;
            try {
                Pattern versPattern;
                Matcher m;
                String line = ((BufferedReader)r).readLine();
                if (line != null && (m = (versPattern = Pattern.compile("# autoplot2025.py v([\\d\\.]+) .*")).matcher(line)).matches()) {
                    vers = m.group(1);
                }
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
            finally {
                if (r != null) {
                    if (stringArray != null) {
                        try {
                            ((BufferedReader)r).close();
                        }
                        catch (Throwable throwable) {
                            stringArray.addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedReader)r).close();
                    }
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("== JythonUtil getLocalJythonAutoplotLib ==");
            logger.log(Level.FINE, "ff4.exists()={0}", ff4.exists());
            logger.log(Level.FINE, "vers={0}", vers);
            logger.log(Level.FINE, "currentVersion={0}", currentVersion);
        }
        if (!ff4.exists() || vers.equals("") || Double.parseDouble(vers) < currentVersion) {
            String[] ss;
            logger.log(Level.FINE, "looking for version={0} of {1}, but didn''t find it.", new Object[]{currentVersion, ff4});
            logger.log(Level.FINE, "doesn't seem like we have the right file, downloading...");
            r = JythonUtil.class;
            // MONITORENTER : org.autoplot.jythonsupport.JythonUtil.class
            if (!ff3.exists() && !ff3.mkdir()) {
                throw new IOException("Unable to mkdir " + ff3);
            }
            // MONITOREXIT : r
            for (String s : ss = new String[]{"autoplot2025.py", "autoplotapp2025.py"}) {
                try (InputStream in = JythonUtil.class.getResourceAsStream("/" + s);
                     FileOutputStream out = new FileOutputStream(new File(ff3, s));){
                    JythonUtil.transferStream(in, out);
                }
                if (!new File(ff3, s).setReadOnly()) {
                    logger.log(Level.FINER, "set read-only on file {0} failed", s);
                }
                if (new File(ff3, s).setWritable(true, true)) continue;
                logger.log(Level.FINER, "set write for user only on file {0} failed", s);
            }
        }
        logger.fine("   ...done");
        return ff3.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pythonLint(URI uri, List<String> errs) throws IOException {
        File src = DataSetURI.getFile((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        try (LineNumberReader reader = new LineNumberReader(new BufferedReader(new FileReader(src)));){
            boolean bl = JythonUtil.pythonLint(reader, errs);
            return bl;
        }
    }

    public static boolean pythonLint(LineNumberReader reader, List<String> errs) throws IOException {
        String line;
        StringBuilder build = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            build.append(line).append("\n");
        }
        String script = build.toString();
        List<SimpleNode> ll = StaticCodeAnalysis.showReassignFunctionCall(script, true, null);
        for (int i = 0; i < ll.size(); ++i) {
            SimpleNode n = ll.get(i);
            if (n instanceof Name) {
                errs.add(String.format("%d:%s", n.beginLine, ((Name)n).id));
                continue;
            }
            exprType f = ((Call)n).func;
            if (f instanceof Name) {
                errs.add(String.format("%d:%s", n.beginLine, ((Name)f).id));
                continue;
            }
            errs.add(String.format("%d:%s", n.beginLine, f.toString()));
        }
        return errs.size() > 0;
    }

    private static synchronized void maybeLoadAdapters() {
        if (!haveloadedAdapters) {
            Py.getAdapter().addPostClass((PyObjectAdapter)new PyQDataSetAdapter());
            Py.getAdapter().addPostClass((PyObjectAdapter)new PyDatumAdapter());
            haveloadedAdapters = true;
        }
    }

    public static Map<String, String> getDocumentation(BufferedReader reader) throws IOException {
        return JythonUtil.getDocumentation(reader, null);
    }

    public static Map<String, String> getDocumentation(BufferedReader reader, URI resourceURI) throws IOException {
        String line = reader.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (line != null) {
            scriptBuilder.append(line).append('\n');
            line = reader.readLine();
        }
        String script = scriptBuilder.toString();
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (resourceURI != null) {
            URISplit split = URISplit.parse((String)resourceURI.toString());
            env.put("PWD", split.path);
        }
        ScriptDescriptor sd = JythonUtil.describeScript(env, script, null);
        HashMap<String, String> result = new HashMap<String, String>();
        if (sd.getDescription().length() > 0) {
            result.put("DESCRIPTION", sd.getDescription());
        }
        if (sd.getTitle().length() > 0) {
            result.put("TITLE", sd.getTitle());
        }
        if (sd.getLabel().length() > 0) {
            result.put("LABEL", sd.getLabel());
        }
        if (sd.getIconURL().length() > 0) {
            result.put("ICONURL", sd.getIconURL());
        }
        if (result.isEmpty()) {
            reader = new BufferedReader(new StringReader(script));
            String s = reader.readLine();
            Pattern p = Pattern.compile("#\\s*([a-zA-Z]+)\\s*:(.*)");
            while (s != null) {
                Matcher m = p.matcher(s);
                if (m.matches()) {
                    String prop = m.group(1).toUpperCase();
                    String value = m.group(2).trim();
                    if (prop.equals("LABEL") || prop.equals("TITLE") || prop.equals("DESCRIPTION")) {
                        result.put(prop, value);
                    }
                }
                s = reader.readLine();
            }
            reader.close();
        }
        return result;
    }

    private static boolean trivialFunctionCall(SimpleNode sn) {
        if (sn instanceof Call) {
            Call c = (Call)sn;
            boolean klugdyOkay = false;
            String ss = c.func.toString();
            for (String s : okay) {
                if (!ss.contains(s)) continue;
                klugdyOkay = true;
            }
            if (ss.startsWith("Attribute[")) {
                klugdyOkay = true;
            }
            if (!klugdyOkay && ss.contains("TimeUtil") && ss.contains("now")) {
                klugdyOkay = true;
            }
            logger.log(Level.FINER, "trivialFunctionCall={0} for {1}", new Object[]{klugdyOkay, c.func.toString()});
            return klugdyOkay;
        }
        if (sn instanceof Num) {
            return true;
        }
        if (sn instanceof Name) {
            return true;
        }
        return sn instanceof Str;
    }

    private static boolean simplifyScriptToGetParamsOkayNoCalls(SimpleNode o, HashSet<String> variableNames) {
        Call c;
        if (o instanceof Call && !JythonUtil.trivialFunctionCall((SimpleNode)(c = (Call)o))) {
            logger.finest(String.format("%04d simplify->false: %s", o.beginLine, o.toString()));
            return false;
        }
        MyVisitorBase vb = new MyVisitorBase(variableNames, o);
        try {
            o.traverse(vb);
            logger.finest(String.format(" %04d simplify->%s: %s", o.beginLine, vb.looksOkay(), o));
            return vb.looksOkay();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            logger.finest(String.format("!! %04d simplify->false: %s", o.beginLine, o));
            return false;
        }
    }

    private static boolean simplifyScriptToGetParamsCanResolve(SimpleNode o, HashSet<String> variableNames) {
        Name c;
        if (o instanceof Name) {
            c = (Name)o;
            if (!variableNames.contains(c.id)) {
                logger.finest(String.format("%04d canResolve->false: %s", o.beginLine, o.toString()));
                return false;
            }
        }
        if (o instanceof Attribute) {
            Attribute at = (Attribute)o;
            while (at.value instanceof Attribute || at.value instanceof Subscript) {
                if (at.value instanceof Attribute) {
                    at = (Attribute)at.value;
                    continue;
                }
                Subscript s = (Subscript)at.value;
                if (s.value instanceof Attribute) {
                    at = (Attribute)s.value;
                    continue;
                }
                return false;
            }
            if (at.value instanceof Name) {
                Name n = (Name)at.value;
                if (!variableNames.contains(n.id)) {
                    return false;
                }
            } else {
                if (at.value instanceof Call) {
                    return JythonUtil.simplifyScriptToGetParamsCanResolve((SimpleNode)at.value, variableNames);
                }
                return false;
            }
        }
        if (o instanceof Call) {
            c = (Call)o;
            if (c.func instanceof Attribute && !JythonUtil.simplifyScriptToGetParamsCanResolve((SimpleNode)c.func, variableNames)) {
                return false;
            }
        }
        MyVisitorBase vb = new MyVisitorBase(variableNames, o);
        try {
            o.traverse(vb);
            logger.finest(String.format(" %04d canResolve->%s: %s", o.beginLine, vb.visitNameFail, o));
            return !vb.visitNameFail;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            logger.finest(String.format("!! %04d canResolve->false: %s", o.beginLine, o));
            return false;
        }
    }

    public static String maybeQuoteString(String sval) {
        boolean isNumber = false;
        try {
            Double.parseDouble(sval);
        }
        catch (NumberFormatException ex) {
            isNumber = false;
        }
        if (!(isNumber || sval.equals("True") || sval.equals("False") || sval.length() != 0 && sval.startsWith("'") && sval.endsWith("'"))) {
            sval = String.format("'%s'", sval);
        }
        return sval;
    }

    public static String maybeUnquoteString(String sval) {
        if (sval.startsWith("'") && sval.endsWith("'") || sval.startsWith("\"") && sval.endsWith("\"")) {
            return sval.substring(1, sval.length() - 1);
        }
        return sval;
    }

    public static void setParams(PythonInterpreter interp, Map<String, String> paramsl) {
        interp.exec("import autoplot2025 as autoplot");
        interp.exec("autoplot.params=dict()");
        for (Map.Entry<String, String> e : paramsl.entrySet()) {
            String s = e.getKey();
            if (s.length() == 0) {
                throw new IllegalArgumentException("param name is \"\": " + s);
            }
            if (s.equals("arg_0") || s.equals("script")) continue;
            try {
                String sval = e.getValue();
                sval = JythonUtil.maybeQuoteString(sval);
                logger.log(Level.FINE, "autoplot.params[''{0}'']={1}", new Object[]{s, sval});
                interp.exec("autoplot.params['" + s + "']=" + sval);
            }
            catch (Exception ex) {
                logger.warning(ex.getMessage());
            }
        }
    }

    private static boolean isSetScriptCall(stmtType o, HashSet<String> variableNames) {
        if (o instanceof Expr) {
            Expr expr = (Expr)o;
            if (expr.value instanceof Call) {
                Call c = (Call)expr.value;
                if (c.func instanceof Name) {
                    Name n = (Name)c.func;
                    if (n.id.equals("setScriptTitle") || n.id.equals("setScriptDescription") || n.id.equals("setScriptLabel") || n.id.equals("setScriptIcon")) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private static boolean simplifyScriptToGetParamsOkay(stmtType o, HashSet<String> variableNames) {
        if (o instanceof ImportFrom) {
            return true;
        }
        if (o instanceof Import) {
            return true;
        }
        if (o instanceof Assign) {
            Assign a = (Assign)o;
            for (exprType a1 : a.targets) {
                if (a1 instanceof Subscript) {
                    Subscript ss = (Subscript)a1;
                    if (!JythonUtil.simplifyScriptToGetParamsCanResolve((SimpleNode)ss.value, variableNames)) {
                        return false;
                    }
                    if (JythonUtil.simplifyScriptToGetParamsCanResolve((SimpleNode)ss.slice, variableNames)) continue;
                    return false;
                }
                if (!(a1 instanceof Attribute)) continue;
                return false;
            }
            if (JythonUtil.simplifyScriptToGetParamsOkayNoCalls((SimpleNode)a.value, variableNames)) {
                if (!JythonUtil.simplifyScriptToGetParamsCanResolve((SimpleNode)a.value, variableNames)) {
                    return false;
                }
                for (exprType target : a.targets) {
                    exprType et = target;
                    if (et instanceof Name) {
                        String id = ((Name)target).id;
                        variableNames.add(id);
                        logger.log(Level.FINEST, "assign to variable {0}", id);
                        continue;
                    }
                    if (!(et instanceof Attribute)) continue;
                    Attribute at = (Attribute)et;
                    while (at.value instanceof Attribute || at.value instanceof Subscript) {
                        if (at.value instanceof Attribute) {
                            at = (Attribute)at.value;
                            continue;
                        }
                        Subscript s = (Subscript)at.value;
                        if (s.value instanceof Attribute) {
                            at = (Attribute)s.value;
                            continue;
                        }
                        return false;
                    }
                    if (!(at.value instanceof Name)) continue;
                    Name n = (Name)at.value;
                    if (variableNames.contains(n.id)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (o instanceof If) {
            return JythonUtil.simplifyScriptToGetParamsOkayNoCalls((SimpleNode)o, variableNames);
        }
        if (o instanceof Print) {
            return false;
        }
        if (o instanceof Expr) {
            Expr exp = (Expr)o;
            if (exp.value instanceof Str) {
                return true;
            }
        }
        logger.log(Level.FINEST, "not okay to simplify: {0}", o);
        return false;
    }

    private static void maybeAppendSort(String theLine, StringBuilder result) {
        int i = theLine.indexOf("getParam");
        if (i != -1) {
            i = theLine.indexOf("=");
            String v = theLine.substring(0, i).trim();
            int indent = theLine.indexOf(v);
            if (indent > 0) {
                result.append(theLine.substring(0, indent));
            }
            result.append("sort_.append( '").append(v).append("')\n");
        }
    }

    protected static String indentForLine(String line) {
        String[] ss2 = line.split("\\S", -2);
        String indent = ss2[0];
        return indent;
    }

    protected static int handleContinue(String[] lines, int iline) {
        if (iline == lines.length - 1) {
            return iline;
        }
        String theLine = lines[iline];
        int i = theLine.indexOf("#");
        if (i > -1) {
            theLine = theLine.substring(0, i);
        }
        if (theLine.trim().endsWith(":")) {
            logger.finer("line opens to block");
        }
        String thisIndent = JythonUtil.indentForLine(theLine);
        String nextIndent = JythonUtil.indentForLine(lines[iline + 1]);
        while (iline < lines.length - 2 && nextIndent.startsWith(thisIndent) && nextIndent.length() > thisIndent.length()) {
            nextIndent = JythonUtil.indentForLine(lines[++iline + 1]);
        }
        if (iline < lines.length - 1 && lines[iline + 1].trim().startsWith(")")) {
            ++iline;
        }
        return iline;
    }

    private static StringBuilder appendToResult(StringBuilder result, String line) {
        result.append(line);
        return result;
    }

    public static String[] splitCodeIntoLines(String zerothLine, String script) {
        String[] ss1 = script.split("\n");
        int headerOffset = zerothLine == null ? 0 : 1;
        int lineCount = ss1.length + headerOffset;
        String[] ss = new String[lineCount];
        if (headerOffset == 1) {
            ss[0] = zerothLine;
        }
        System.arraycopy(ss1, 0, ss, headerOffset, ss1.length);
        return ss;
    }

    public static String simplifyScriptToGetParams(String[] ss, stmtType[] stmts, HashSet variableNames, int beginLine, int lastLine, int depth) {
        String spaces = "                                                                                          ";
        if (lastLine >= ss.length) {
            throw new IllegalArgumentException("lastLine is >= number of lines");
        }
        if (!ss[0].equals("# simplifyScriptToGetParams")) {
            throw new IllegalArgumentException("first line must be '# simplifyScriptToGetParams'");
        }
        int acceptLine = -1;
        int currentLine = 1;
        StringBuilder result = new StringBuilder();
        for (int istatement = 0; istatement < stmts.length; ++istatement) {
            int i;
            stmtType o = stmts[istatement];
            String theLine = SimplifyScriptSupport.getSourceForStatement(ss, o);
            int lineCount = theLine.split("\n", -2).length;
            if (depth == 0) {
                logger.finest(theLine);
            }
            logger.log(Level.FINER, "line {0}: {1}", new Object[]{o.beginLine, theLine});
            if (o.beginLine > 0) {
                if (beginLine < 0 && istatement == 0) {
                    acceptLine = o.beginLine;
                }
                beginLine = lineCount > 1 ? o.beginLine - (lineCount - 1) : o.beginLine;
            } else {
                acceptLine = beginLine;
            }
            if (beginLine > lastLine) continue;
            if (o instanceof TryExcept) {
                acceptLine = -1;
                continue;
            }
            if (o instanceof If) {
                int lastLine1;
                boolean includeBlock;
                if (acceptLine > -1) {
                    for (int i2 = acceptLine; i2 < beginLine; ++i2) {
                        JythonUtil.appendToResult(result, ss[i2]).append("\n");
                    }
                }
                If iff = (If)o;
                if (JythonUtil.simplifyScriptToGetParamsCanResolve((SimpleNode)iff.test, variableNames)) {
                    for (i = beginLine; i < iff.body[0].beginLine; ++i) {
                        result.append(ss[i]).append("\n");
                    }
                    includeBlock = true;
                } else {
                    includeBlock = false;
                }
                int elseLine = -1;
                if (iff.orelse != null && iff.orelse.length > 0) {
                    if (iff.orelse[0].beginLine > 0) {
                        lastLine1 = iff.orelse[0].beginLine - 1;
                        if (ss[lastLine1].trim().startsWith("else")) {
                            elseLine = lastLine1--;
                        } else if (ss[lastLine1].trim().startsWith("elif")) {
                            elseLine = lastLine1--;
                        }
                    } else if (iff.orelse[0] instanceof If) {
                        elseLine = ((If)iff.orelse[0]).test.beginLine;
                        lastLine1 = elseLine - 1;
                    } else {
                        lastLine1 = elseLine + 1;
                        logger.fine("failure to deal with another day...");
                    }
                } else {
                    lastLine1 = istatement + 1 < stmts.length ? stmts[istatement + 1].beginLine - 1 : lastLine;
                }
                if (includeBlock) {
                    String ss1 = JythonUtil.simplifyScriptToGetParams(ss, iff.body, variableNames, -1, lastLine1, depth + 1);
                    if (ss1.trim().length() == 0) {
                        String line = iff.body[0].beginLine > 0 ? ss[iff.body[0].beginLine] : ss[iff.beginLine];
                        String indent = JythonUtil.indentForLine(line);
                        result.append(indent).append("pass  # ").append(line).append("\n");
                        logger.fine("things have probably gone wrong...");
                    } else {
                        JythonUtil.appendToResult(result, ss1);
                    }
                    if (iff.orelse != null) {
                        if (elseLine > -1) {
                            JythonUtil.appendToResult(result, ss[elseLine]);
                        } else {
                            logger.fine("failure #2 to deal with another day...");
                        }
                        int lastLine2 = istatement + 1 < stmts.length ? stmts[istatement + 1].beginLine - 1 : lastLine;
                        String ss2 = JythonUtil.simplifyScriptToGetParams(ss, iff.orelse, variableNames, elseLine + 1, lastLine2, depth + 1);
                        if (ss2.length() > 0) {
                            result.append("\n");
                        }
                        JythonUtil.appendToResult(result, ss2);
                        if (ss2.length() == 0) {
                            String line = ss[iff.orelse[0].beginLine];
                            String indent = JythonUtil.indentForLine(line);
                            result.append("\n").append(indent).append("pass  # ").append(line).append("\n");
                        } else {
                            result.append("\n");
                        }
                    }
                }
                acceptLine = -1;
                continue;
            }
            if (JythonUtil.simplifyScriptToGetParamsOkay(o, variableNames)) {
                if (acceptLine >= 0) continue;
                acceptLine = beginLine;
                for (int i3 = currentLine; i3 < acceptLine; ++i3) {
                    String indent = JythonUtil.indentForLine(ss[i3]);
                    int icomment = ss[i3].indexOf("#");
                    if (icomment >= 0) {
                        String line = indent + spaces.substring(indent.length(), icomment) + ss[i3].substring(icomment);
                        result.append(line).append("\n");
                    }
                    currentLine = acceptLine;
                }
                continue;
            }
            if (JythonUtil.isSetScriptCall(o, variableNames)) {
                if (acceptLine >= 0) continue;
                acceptLine = beginLine;
                for (int i4 = currentLine + 1; i4 < acceptLine; ++i4) {
                    result.append("\n");
                    currentLine = acceptLine;
                }
                continue;
            }
            if (acceptLine <= -1) continue;
            int thisLine = JythonUtil.getBeginLine(ss, o);
            String indent = JythonUtil.indentForLine(ss[acceptLine]);
            for (i = acceptLine; i < thisLine; ++i) {
                if (ss[i].contains("getDataSet")) {
                    JythonUtil.appendToResult(result, indent + "pass  #1139  " + ss[i]).append("\n");
                    continue;
                }
                JythonUtil.appendToResult(result, ss[i]).append("\n");
            }
            JythonUtil.appendToResult(result, "\n");
            currentLine = o.beginLine;
            acceptLine = -1;
        }
        if (acceptLine > -1) {
            int thisLine = lastLine = JythonUtil.handleContinue(ss, lastLine);
            for (int i = acceptLine; i <= thisLine; ++i) {
                JythonUtil.appendToResult(result, ss[i]).append("\n");
            }
        }
        return result.toString();
    }

    public static int getBeginLine(String[] ss, stmtType o) {
        int beginLine = o.beginLine;
        if (o instanceof Expr) {
            Expr expr = (Expr)o;
            int bl2 = expr.value.beginLine;
            if (bl2 < beginLine) {
                beginLine = bl2;
            }
        }
        return beginLine;
    }

    public static String simplifyScriptToGetParams(String script, boolean addSort) throws PySyntaxError {
        String closeParenCheck;
        Logger llogger = LoggerManager.getLogger((String)"jython.simplify");
        String[] ss1 = script.split("\n");
        String[] ss = new String[ss1.length + 1];
        System.arraycopy(ss1, 0, ss, 1, ss1.length);
        ss[0] = "# simplifyScriptToGetParams";
        int lastLine = -1;
        boolean withinSimplifyLine = false;
        boolean withinTripleQuote = false;
        for (int ilineNum = 1; ilineNum < ss.length; ++ilineNum) {
            String line = ss[ilineNum];
            int ich = line.indexOf(35);
            if (ich > -1) {
                line = line.substring(0, ich);
            }
            if (line.contains("getParam")) {
                llogger.log(Level.FINER, "getParam at line {0}", ilineNum);
                lastLine = ilineNum;
                withinSimplifyLine = true;
            } else if (line.contains("setScriptTitle")) {
                llogger.log(Level.FINER, "setScriptTitle at line {0}", ilineNum);
                lastLine = ilineNum;
                withinSimplifyLine = true;
            } else if (line.contains("setScriptDescription")) {
                llogger.log(Level.FINER, "setScriptDescription at line {0}", ilineNum);
                lastLine = ilineNum;
                withinSimplifyLine = true;
            } else if (line.contains("setScriptLabel")) {
                llogger.log(Level.FINER, "setScriptLabel at line {0}", ilineNum);
                lastLine = ilineNum;
                withinSimplifyLine = true;
            } else if (line.contains("setScriptIcon")) {
                llogger.log(Level.FINER, "setScriptIcon at line {0}", ilineNum);
                lastLine = ilineNum;
                withinSimplifyLine = true;
            } else if (!withinTripleQuote) {
                withinSimplifyLine = false;
            }
            if (!line.contains("'''")) continue;
            if (withinTripleQuote && !Character.isWhitespace(line.charAt(0)) && withinSimplifyLine) {
                lastLine = ilineNum;
            }
            if (withinTripleQuote) {
                llogger.log(Level.FINER, "close triple quote at line {0}", ilineNum);
            } else {
                llogger.log(Level.FINER, "open triple quote at line {0}", ilineNum);
            }
            withinTripleQuote = !withinTripleQuote;
        }
        if (lastLine == -1) {
            return "";
        }
        while (ss.length > lastLine + 1 && ss[lastLine].trim().length() > 0 && Character.isWhitespace(ss[lastLine].charAt(0))) {
            ++lastLine;
        }
        if (lastLine < ss.length && ((closeParenCheck = ss[lastLine].trim()).equals(")") || closeParenCheck.equals("]"))) {
            ++lastLine;
        }
        HashSet<String> variableNames = new HashSet<String>();
        variableNames.add("getParam");
        variableNames.add("map");
        variableNames.add("str");
        variableNames.add("int");
        variableNames.add("long");
        variableNames.add("float");
        variableNames.add("datum");
        variableNames.add("datumRange");
        variableNames.add("URI");
        variableNames.add("URL");
        variableNames.add("True");
        variableNames.add("False");
        variableNames.add("range");
        variableNames.add("xrange");
        variableNames.add("list");
        variableNames.add("len");
        variableNames.add("map");
        variableNames.add("dict");
        variableNames.add("zip");
        variableNames.add("PWD");
        variableNames.add("dom");
        Module n = (Module)parser.parse((String)script, (String)"exec");
        return JythonUtil.simplifyScriptToGetParams(ss, n.body, variableNames, 1, lastLine, 0);
    }

    public static List<Param> getGetParams(Reader reader) throws IOException, PySyntaxError {
        return JythonUtil.getGetParams(null, JythonUtil.readScript(reader), new HashMap<String, String>());
    }

    public static ScriptDescriptor errorScriptDescriptor(final PySyntaxError ex) {
        return new ScriptDescriptor(){

            @Override
            public String getLabel() {
                return "ERROR";
            }

            @Override
            public String getTitle() {
                return "PySyntaxError";
            }

            @Override
            public String getDescription() {
                return ex.traceback.dumpStack();
            }

            @Override
            public String getIconURL() {
                return "";
            }

            @Override
            public List<Param> getParams() {
                return Collections.emptyList();
            }
        };
    }

    public static ScriptDescriptor describeScript(String script, Map<String, String> params) throws IOException {
        return JythonUtil.describeScript(null, script, params);
    }

    private static PyObject getConstraintP(PyDictionary dict, PyObject key, PyObject deft) {
        PyObject o = dict.get(key, deft);
        if (Py.isInstance((PyObject)o, (PyObject)deft.getType())) {
            return o;
        }
        throw new IllegalArgumentException("constaints contains the wrong type");
    }

    public static ScriptDescriptor describeScript(Map<String, Object> env, String script, Map<String, String> params) throws IOException {
        InteractiveInterpreter interp;
        String prog;
        try {
            prog = JythonUtil.simplifyScriptToGetParams(script, true);
        }
        catch (PySyntaxError ex) {
            return JythonUtil.errorScriptDescriptor(ex);
        }
        logger.log(Level.FINER, "Simplified script: {0}", prog);
        try {
            interp = JythonUtil.createInterpreter(true);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            return EMPTY;
        }
        if (env != null) {
            for (Map.Entry<String, Object> ent : env.entrySet()) {
                if (ent.getKey() == null) {
                    logger.log(Level.WARNING, "parameter name was null");
                    continue;
                }
                if (ent.getValue() == null) {
                    if (ent.getKey().equals("dom")) {
                        logger.log(Level.FINE, "parameter \"dom\" value was set to null");
                        continue;
                    }
                    logger.log(Level.WARNING, "parameter value was null");
                    continue;
                }
                logger.log(Level.FINER, "setting env {0} to {1}", new Object[]{ent.getKey(), ent.getValue()});
                interp.set(ent.getKey(), ent.getValue());
            }
        }
        interp.set("autoplot2025._scriptLabel", (Object)"");
        interp.set("autoplot2025._scriptTitle", (Object)"");
        interp.set("autoplot2025._scriptDescription", (Object)"");
        interp.set("autoplot2025._scriptIcon", (Object)"");
        if (params != null) {
            JythonUtil.setParams((PythonInterpreter)interp, params);
        }
        try {
            prog = JythonRefactory.fixImports(prog, "<J>");
        }
        catch (IOException ex) {
            Logger.getLogger(JythonUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        interp.exec(prog);
        interp.exec("import autoplot2025 as autoplot\n");
        PyList sort = (PyList)interp.eval("autoplot._paramSort");
        boolean altWhy = false;
        if (sort.isEmpty()) {
            try {
                sort = (PyList)interp.eval("_paramSort");
                if (sort.size() > 0) {
                    logger.warning("things are suddenly in the wrong space.  This is because things are incorrectly imported.");
                    altWhy = true;
                }
            }
            catch (PyException pyException) {
                // empty catch block
            }
        }
        LinkedList<String> jsort = new LinkedList<String>();
        for (int i = 0; i < sort.__len__(); ++i) {
            String item = (String)sort.get(i);
            if (jsort.contains(item)) {
                jsort.remove(item);
            }
            jsort.add(item);
        }
        final ArrayList<Param> result = new ArrayList<Param>();
        for (int i = 0; i < jsort.size(); ++i) {
            String theParamName = (String)jsort.get(i);
            PyList oo = (PyList)interp.eval("autoplot._paramMap['" + theParamName + "']");
            if (altWhy) {
                oo = (PyList)interp.eval("_paramMap['" + theParamName + "']");
            }
            Param p = new Param();
            p.label = theParamName;
            if (p.label.startsWith("__")) continue;
            p.name = oo.__getitem__(0).toString();
            p.deft = oo.__getitem__(1);
            p.doc = oo.__getitem__(2).toString();
            p.constraints = new HashMap<String, Object>();
            PyObject oconstraints = oo.__getitem__(3);
            if (oconstraints instanceof PyList) {
                PyList pyList = (PyList)oconstraints;
                ArrayList<Object> enums = new ArrayList<Object>(pyList.size());
                for (int j = 0; j < pyList.size(); ++j) {
                    enums.add(j, pyList.get(j));
                }
                p.enums = enums;
            } else if (oconstraints instanceof PyDictionary) {
                PyString stringType;
                PyString regex;
                int j;
                ArrayList<Object> labels;
                PyList labelsList;
                PyObject labelsObject;
                PyObject enumsObject;
                PyDictionary pyDict = (PyDictionary)oconstraints;
                if (pyDict.has_key((PyObject)new PyString("enum"))) {
                    logger.warning("values should be used instead of enum");
                    enumsObject = pyDict.get((PyObject)new PyString("enum"));
                } else {
                    enumsObject = pyDict.has_key((PyObject)new PyString("values")) ? pyDict.get((PyObject)new PyString("values")) : null;
                }
                PyObject examplesObject = pyDict.has_key((PyObject)new PyString("examples")) ? pyDict.get((PyObject)new PyString("examples")) : null;
                HashMap<String, Object> constraints = new HashMap<String, Object>();
                if (enumsObject != null) {
                    if (enumsObject instanceof PyList) {
                        PyList enumsList = (PyList)enumsObject;
                        ArrayList<Object> enums = new ArrayList<Object>(enumsList.size());
                        for (int j2 = 0; j2 < enumsList.size(); ++j2) {
                            enums.add(j2, enumsList.get(j2));
                        }
                        p.enums = enums;
                        labelsObject = pyDict.get((PyObject)new PyString("labels"));
                        if (labelsObject != null && labelsObject instanceof PyList) {
                            labelsList = (PyList)labelsObject;
                            labels = new ArrayList<Object>(labelsList.size());
                            for (j = 0; j < labelsList.size(); ++j) {
                                labels.add(j, labelsList.get(j));
                            }
                            constraints.put("labels", labels);
                        }
                    } else {
                        logger.log(Level.WARNING, "should be a list: {0}", enumsObject);
                    }
                }
                if (examplesObject != null) {
                    if (examplesObject instanceof PyList) {
                        PyList examplesList = (PyList)examplesObject;
                        ArrayList<Object> list = new ArrayList<Object>(examplesList.size());
                        for (int j3 = 0; j3 < examplesList.size(); ++j3) {
                            list.add(j3, examplesList.get(j3));
                        }
                        p.examples = list;
                        labelsObject = pyDict.get((PyObject)new PyString("labels"));
                        if (labelsObject != null && labelsObject instanceof PyList) {
                            labelsList = (PyList)labelsObject;
                            labels = new ArrayList(labelsList.size());
                            for (j = 0; j < labelsList.size(); ++j) {
                                labels.add(j, labelsList.get(j).toString());
                            }
                            constraints.put("labels", labels);
                        }
                    } else {
                        logger.log(Level.WARNING, "should be a list: {0}", enumsObject);
                    }
                }
                if ((regex = (PyString)JythonUtil.getConstraintP(pyDict, (PyObject)new PyString("regex"), (PyObject)new PyString(""))).__len__() > 0) {
                    constraints.put("regex", regex);
                }
                if ((stringType = (PyString)JythonUtil.getConstraintP(pyDict, (PyObject)new PyString("stringType"), (PyObject)new PyString(""))).__len__() > 0) {
                    constraints.put("stringType", stringType);
                }
                p.constraints = constraints;
            }
            Object object = p.value = params == null ? null : params.get(p.name);
            if (p.name.equals("resourceUri")) {
                p.name = "resourceURI";
            }
            switch (p.name) {
                case "resourceURI": {
                    p.type = (char)82;
                    p.deft = p.deft.toString();
                    if (p.value == null) break;
                    p.value = p.value.toString();
                    break;
                }
                case "timerange": {
                    p.type = (char)84;
                    p.deft = p.deft.toString();
                    if (p.value == null) break;
                    p.value = p.value.toString();
                    break;
                }
                default: {
                    if (p.deft instanceof String) {
                        p.type = (char)65;
                        p.deft = p.deft.toString();
                        if (p.value == null) break;
                        p.value = p.value.toString();
                        break;
                    }
                    if (p.deft instanceof PyString) {
                        p.type = (char)65;
                        p.deft = p.deft.toString();
                        if (p.value == null) break;
                        p.value = p.value.toString();
                        break;
                    }
                    if (p.deft instanceof PyInteger) {
                        p.type = (char)70;
                        p.deft = ((PyInteger)p.deft).__tojava__(Integer.TYPE);
                        if (p.value == null) break;
                        if (p.value.equals("False")) {
                            p.value = 0;
                            break;
                        }
                        if (p.value.equals("True")) {
                            p.value = 1;
                            break;
                        }
                        p.value = Integer.parseInt(p.value.toString());
                        break;
                    }
                    if (p.deft instanceof PyFloat) {
                        p.type = (char)70;
                        p.deft = ((PyFloat)p.deft).__tojava__(Double.TYPE);
                        if (p.value == null) break;
                        p.value = Double.parseDouble(p.value.toString());
                        break;
                    }
                    if (!(p.deft instanceof PyJavaInstance)) break;
                    Object pp = ((PyJavaInstance)p.deft).__tojava__(URI.class);
                    if (pp == Py.NoConversion) {
                        pp = ((PyJavaInstance)p.deft).__tojava__(Datum.class);
                        if (pp == Py.NoConversion) {
                            pp = ((PyJavaInstance)p.deft).__tojava__(DatumRange.class);
                            if (pp == Py.NoConversion) {
                                pp = ((PyJavaInstance)p.deft).__tojava__(URL.class);
                                if (pp == Py.NoConversion) {
                                    pp = ((PyJavaInstance)p.deft).__tojava__(Color.class);
                                    if (pp == Py.NoConversion) {
                                        pp = ((PyJavaInstance)p.deft).__tojava__(File.class);
                                        p.type = (char)77;
                                        p.deft = pp;
                                        break;
                                    }
                                    p.type = (char)67;
                                    p.deft = pp;
                                    break;
                                }
                                p.type = (char)76;
                                p.deft = pp;
                                break;
                            }
                            p.type = (char)83;
                            p.deft = pp;
                            break;
                        }
                        p.type = (char)68;
                        p.deft = pp;
                        break;
                    }
                    p.type = (char)85;
                    p.deft = pp;
                }
            }
            result.add(p);
        }
        final String label = String.valueOf(interp.eval("autoplot._scriptLabel"));
        final String title = String.valueOf(interp.eval("autoplot._scriptTitle"));
        final String description = String.valueOf(interp.eval("autoplot._scriptDescription"));
        final String icon = String.valueOf(interp.eval("autoplot._scriptIcon"));
        ScriptDescriptor sd = new ScriptDescriptor(){

            @Override
            public String getLabel() {
                return label;
            }

            @Override
            public String getTitle() {
                return title;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public String getIconURL() {
                return icon;
            }

            @Override
            public List<Param> getParams() {
                return result;
            }
        };
        return sd;
    }

    public static String readScript(Reader reader) throws IOException {
        StringBuilder build = new StringBuilder();
        try (BufferedReader breader = new BufferedReader(reader);){
            String s = breader.readLine();
            while (s != null) {
                build.append(s).append("\n");
                s = breader.readLine();
            }
        }
        return build.toString();
    }

    public static List<Param> getGetParams(String script) throws PyException {
        return JythonUtil.getGetParams(null, script, new HashMap<String, String>());
    }

    public static List<Param> getGetParams(String script, Map<String, String> params) throws PyException {
        return JythonUtil.getGetParams(null, script, params);
    }

    public static List<Param> getGetParams(Map<String, Object> env, String script, Map<String, String> params) throws PyException {
        InteractiveInterpreter interp;
        String prog = JythonUtil.simplifyScriptToGetParams(script, true);
        logger.log(Level.FINER, "Simplified script: {0}", prog);
        try {
            interp = JythonUtil.createInterpreter(true);
        }
        catch (IOException ex) {
            return new ArrayList<Param>();
        }
        if (env != null) {
            for (Map.Entry<String, Object> ent : env.entrySet()) {
                if (ent.getKey() == null) {
                    logger.log(Level.WARNING, "parameter name was null");
                    continue;
                }
                if (ent.getValue() == null) {
                    if (ent.getKey().equals("dom")) {
                        logger.log(Level.FINE, "parameter \"dom\" value was set to null");
                        continue;
                    }
                    logger.log(Level.WARNING, "parameter value was null");
                    continue;
                }
                interp.set(ent.getKey(), ent.getValue());
            }
        }
        if (params != null) {
            JythonUtil.setParams((PythonInterpreter)interp, params);
        }
        try {
            prog = JythonRefactory.fixImports(prog, "<J>");
        }
        catch (IOException ex) {
            Logger.getLogger(JythonUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        interp.exec(prog);
        interp.exec("import autoplot2025 as autoplot\n");
        PyList sort = (PyList)interp.eval("autoplot._paramSort");
        boolean altWhy = false;
        if (sort.isEmpty()) {
            try {
                sort = (PyList)interp.eval("_paramSort");
                if (sort.size() > 0) {
                    logger.warning("things are suddenly in the wrong space.  This is because things are incorrectly imported.");
                    altWhy = true;
                }
            }
            catch (PyException pyException) {
                // empty catch block
            }
        }
        ArrayList<Param> result = new ArrayList<Param>();
        for (int i = 0; i < sort.__len__(); ++i) {
            String theParamName = (String)sort.get(i);
            PyList oo = (PyList)interp.eval("autoplot._paramMap['" + theParamName + "']");
            if (altWhy) {
                oo = (PyList)interp.eval("_paramMap['" + (String)sort.get(i) + "']");
            }
            Param p = new Param();
            p.label = (String)sort.get(i);
            if (p.label.startsWith("__")) continue;
            p.name = oo.__getitem__(0).toString();
            p.deft = oo.__getitem__(1);
            p.doc = oo.__getitem__(2).toString();
            p.constraints = new HashMap<String, Object>();
            if (oo.__getitem__(3) instanceof PyList) {
                PyList pyList = (PyList)oo.__getitem__(3);
                ArrayList<Object> enums = new ArrayList<Object>(pyList.size());
                for (int j = 0; j < pyList.size(); ++j) {
                    enums.add(j, pyList.get(j));
                }
                p.enums = enums;
            } else if (oo.__getitem__(3) instanceof PyDictionary) {
                PyString format;
                PyString regex;
                PyString stringType;
                PyObject pymax;
                PyObject pymin;
                PyDictionary pyDict = (PyDictionary)oo.__getitem__(3);
                Object enumsObject = pyDict.has_key((PyObject)new PyString("enum")) ? pyDict.pop((PyObject)new PyString("enum")) : (pyDict.has_key((PyObject)new PyString("values")) ? pyDict.pop((PyObject)new PyString("values")) : null);
                if (enumsObject != null && enumsObject instanceof PyList) {
                    PyList enumsList = (PyList)enumsObject;
                    ArrayList<Object> enums = new ArrayList<Object>(enumsList.size());
                    for (int j = 0; j < enumsList.size(); ++j) {
                        enums.add(j, enumsList.get(j));
                    }
                    p.enums = enums;
                    PyObject labelsObject = pyDict.pop((PyObject)new PyString("labels"), null);
                    if (labelsObject != null && labelsObject instanceof PyList) {
                        PyList labelsList = (PyList)labelsObject;
                        ArrayList<Object> labels = new ArrayList<Object>(labelsList.size());
                        for (int j = 0; j < labelsList.size(); ++j) {
                            labels.add(j, labelsList.get(j));
                        }
                        p.constraints.put("labels", labels);
                    }
                }
                if ((pymin = pyDict.get((PyObject)new PyString("min"), null)) != null) {
                    if (pymin instanceof PyInteger) {
                        p.constraints.put("min", ((PyInteger)pymin).__tojava__(Integer.class));
                    } else if (p.name.equals("timerange")) {
                        p.constraints.put("min", pymin.toString());
                    } else {
                        p.constraints.put("min", Double.parseDouble(pymin.__str__().toString()));
                    }
                }
                if ((pymax = pyDict.get((PyObject)new PyString("max"), null)) != null) {
                    if (pymax instanceof PyInteger) {
                        p.constraints.put("max", pymax.__tojava__(Integer.class));
                    } else if (p.name.equals("timerange")) {
                        p.constraints.put("max", pymax.toString());
                    } else {
                        p.constraints.put("max", Double.parseDouble(pymax.__str__().toString()));
                    }
                }
                if ((stringType = (PyString)pyDict.get((PyObject)new PyString("stringType"), null)) != null) {
                    p.constraints.put("stringType", stringType.toString());
                }
                if ((regex = (PyString)pyDict.get((PyObject)new PyString("regex"), null)) != null) {
                    p.constraints.put("regex", regex.toString());
                }
                if ((format = (PyString)pyDict.get((PyObject)new PyString("format"), null)) != null) {
                    p.constraints.put("format", format.toString());
                }
            }
            Object object = p.value = params == null ? null : params.get(p.name);
            if (p.name.equals("resourceUri")) {
                p.name = "resourceURI";
            }
            switch (p.name) {
                case "resourceURI": {
                    p.type = (char)82;
                    p.deft = p.deft.toString();
                    if (p.value == null) break;
                    p.value = p.value.toString();
                    break;
                }
                case "timerange": {
                    p.type = (char)84;
                    p.deft = p.deft.toString();
                    if (p.value == null) break;
                    p.value = p.value.toString();
                    break;
                }
                default: {
                    if (p.deft instanceof String) {
                        p.type = (char)65;
                        p.deft = p.deft.toString();
                        if (p.value == null) break;
                        p.value = p.value.toString();
                        break;
                    }
                    if (p.deft instanceof PyString) {
                        p.type = (char)65;
                        p.deft = p.deft.toString();
                        if (p.value == null) break;
                        p.value = p.value.toString();
                        break;
                    }
                    if (p.deft instanceof PyInteger) {
                        p.type = (char)70;
                        p.deft = ((PyInteger)p.deft).__tojava__(Integer.TYPE);
                        if (p.value == null) break;
                        if (p.value.equals("False")) {
                            p.value = 0;
                            break;
                        }
                        if (p.value.equals("True")) {
                            p.value = 1;
                            break;
                        }
                        p.value = Integer.parseInt(p.value.toString());
                        break;
                    }
                    if (p.deft instanceof PyFloat) {
                        p.type = (char)70;
                        p.deft = ((PyFloat)p.deft).__tojava__(Double.TYPE);
                        if (p.value == null) break;
                        p.value = Double.parseDouble(p.value.toString());
                        break;
                    }
                    if (!(p.deft instanceof PyJavaInstance)) break;
                    Object pp = ((PyJavaInstance)p.deft).__tojava__(URI.class);
                    if (pp == Py.NoConversion) {
                        pp = ((PyJavaInstance)p.deft).__tojava__(Datum.class);
                        if (pp == Py.NoConversion) {
                            pp = ((PyJavaInstance)p.deft).__tojava__(DatumRange.class);
                            if (pp == Py.NoConversion) {
                                pp = ((PyJavaInstance)p.deft).__tojava__(URL.class);
                                if (pp == Py.NoConversion) {
                                    pp = ((PyJavaInstance)p.deft).__tojava__(Color.class);
                                    if (pp == Py.NoConversion) {
                                        pp = ((PyJavaInstance)p.deft).__tojava__(File.class);
                                        p.type = (char)77;
                                        p.deft = pp;
                                        break;
                                    }
                                    p.type = (char)67;
                                    p.deft = pp;
                                    break;
                                }
                                p.type = (char)76;
                                p.deft = pp;
                                break;
                            }
                            p.type = (char)83;
                            p.deft = pp;
                            break;
                        }
                        p.type = (char)68;
                        p.deft = pp;
                        break;
                    }
                    p.type = (char)85;
                    p.deft = pp;
                }
            }
            result.add(p);
        }
        return result;
    }

    public static Map<String, String> getGetDataSet(Map<String, Object> env, String script, Map<String, String> params) throws PyException {
        InteractiveInterpreter interp;
        String[] ss = script.split("\n");
        for (int i = ss.length - 1; i >= 0 && !ss[i].contains("getDataSet"); --i) {
            ss[i] = "";
        }
        StringBuilder prog1 = new StringBuilder(ss[0]);
        prog1.append("\n");
        for (int i = 1; i < ss.length; ++i) {
            prog1.append(ss[i]).append("\n");
        }
        String prog = prog1.toString();
        logger.log(Level.FINER, "Simplified script: {0}", prog);
        try {
            interp = JythonUtil.createInterpreter(true);
        }
        catch (IOException ex) {
            return Collections.emptyMap();
        }
        if (env != null) {
            for (Map.Entry<String, Object> ent : env.entrySet()) {
                if (ent.getKey() == null) {
                    logger.log(Level.WARNING, "parameter name was null");
                    continue;
                }
                if (ent.getValue() == null) {
                    logger.log(Level.WARNING, "parameter value was null");
                    continue;
                }
                interp.set(ent.getKey(), ent.getValue());
            }
        }
        if (params != null) {
            JythonUtil.setParams((PythonInterpreter)interp, params);
        }
        interp.set("timerange", (Object)"timerange");
        String redefineGDS = "gds={}\nngds=0\ndef getDataSet( uri, timerange='', map=0 ):\n  global ngds\n  global gdsi\n  gds[ngds]=uri+' '+timerange\n  ngds=ngds+1\n";
        interp.exec(redefineGDS);
        try {
            interp.exec(prog);
        }
        catch (PyException ex) {
            logger.log(Level.WARNING, null, ex);
            throw ex;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        PyDictionary r = (PyDictionary)interp.get("gds");
        for (Object k : r.keys()) {
            result.put(k.toString(), r.get(Py.java2py(k)).toString());
        }
        return result;
    }

    public static Map pyDictionaryToMap(PyDictionary pd) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Object tt : pd.items()) {
            String k = ((PyTuple)tt).get(0).toString();
            Object o = ((PyTuple)tt).get(1);
            if (o instanceof PyString) {
                m.put(k, o.toString());
                continue;
            }
            if (o instanceof PyQDataSet) {
                m.put(k, ((PyQDataSet)((Object)o)).ds);
                continue;
            }
            if (o instanceof PyDatum) {
                m.put(k, ((PyDatum)((Object)o)).datum);
                continue;
            }
            if (o instanceof PyFloat) {
                m.put(k, Py.tojava((PyObject)((PyObject)o), (String)"java.lang.Double"));
                continue;
            }
            if (o instanceof PyDictionary) {
                m.put(k, JythonUtil.pyDictionaryToMap((PyDictionary)o));
                continue;
            }
            if (o instanceof String) {
                m.put(k, o);
                continue;
            }
            if (o instanceof Integer) {
                m.put(k, o);
                continue;
            }
            if (o instanceof Double) {
                m.put(k, o);
                continue;
            }
            if (o instanceof PyList) {
                m.put(k, o);
                continue;
            }
            logger.log(Level.INFO, "assuming Java type where conversion is not implemented: {0}", o);
            m.put(k, o);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLocals(BufferedReader reader) throws IOException {
        try {
            String s = reader.readLine();
            Pattern assignPattern = Pattern.compile("\\s*([_a-zA-Z][_a-zA-Z0-9]*)\\s*=.*(#(.*))?");
            Pattern defPattern = Pattern.compile("def .*");
            boolean inDef = false;
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            while (s != null) {
                Matcher m;
                Matcher defm;
                if (!inDef) {
                    defm = defPattern.matcher(s);
                    if (defm.matches()) {
                        inDef = true;
                    }
                } else if (s.length() > 0 && !Character.isWhitespace(s.charAt(0))) {
                    defm = defPattern.matcher(s);
                    inDef = defm.matches();
                }
                if (!inDef && (m = assignPattern.matcher(s)).matches()) {
                    if (m.group(3) != null) {
                        result.put(m.group(1), m.group(3));
                    } else {
                        result.put(m.group(1), s);
                    }
                }
                s = reader.readLine();
            }
            LinkedHashMap<String, String> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeSideEffects(String eval) {
        BufferedReader reader = new BufferedReader(new StringReader(eval));
        StringBuilder result = new StringBuilder();
        try {
            String s = reader.readLine();
            Pattern assignPattern = Pattern.compile("\\s*([_a-zA-Z][_a-zA-Z0-9]*)\\s*=.*(#(.*))?");
            Pattern defPattern = Pattern.compile("def .*");
            Pattern importPattern1 = Pattern.compile("from .*");
            Pattern importPattern2 = Pattern.compile("import .*");
            boolean inDef = false;
            while (s != null) {
                Matcher defm;
                int comment = s.indexOf("#");
                if (comment > -1) {
                    s = s.substring(0, comment);
                }
                boolean sideEffect = true;
                if (s.length() > 1 && Character.isWhitespace(s.charAt(0))) {
                    s = reader.readLine();
                    continue;
                }
                if (!inDef) {
                    defm = defPattern.matcher(s);
                    if (defm.matches()) {
                        inDef = true;
                        sideEffect = false;
                    }
                } else {
                    defm = defPattern.matcher(s);
                    if (defm.matches() && sideEffect) {
                        result.append("  pass\n");
                    }
                    if (s.length() > 0 && !Character.isWhitespace(s.charAt(0)) && (inDef = defm.matches())) {
                        sideEffect = false;
                    }
                    if (inDef && s.trim().equals("pass")) {
                        sideEffect = false;
                    }
                }
                if (!inDef) {
                    Matcher m = assignPattern.matcher(s);
                    if (m.matches()) {
                        sideEffect = false;
                    } else if (importPattern1.matcher(s).matches()) {
                        sideEffect = false;
                    } else if (importPattern2.matcher(s).matches()) {
                        sideEffect = false;
                    }
                }
                if (!sideEffect) {
                    result.append(s).append("\n");
                }
                s = reader.readLine();
            }
            if (inDef) {
                result.append("  pass\n");
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return result.toString();
    }

    public static String join(String[] list, String delim) {
        return JythonUtil.join(Arrays.asList(list), delim);
    }

    public static String join(List<String> list, String delim) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            result.append(delim).append(list.get(i));
        }
        return result.toString();
    }

    public static interface ScriptDescriptor {
        public String getLabel();

        public String getTitle();

        public String getDescription();

        public String getIconURL();

        public List<Param> getParams();
    }

    private static class MyVisitorBase<R>
    extends VisitorBase {
        boolean looksOkay = true;
        boolean visitNameFail = false;
        HashSet names = new HashSet();
        SimpleNode node;

        MyVisitorBase(HashSet names, SimpleNode node) {
            this.names = names;
            this.node = node;
            if (this.node.toString().contains("id=r_erg")) {
                System.err.println("HERE STOP 671");
            }
        }

        public Object visitName(Name node) throws Exception {
            if (!this.names.contains(node.id)) {
                this.visitNameFail = true;
            }
            return null;
        }

        protected Object unhandled_node(SimpleNode sn) throws Exception {
            return sn;
        }

        public void traverse(SimpleNode sn) throws Exception {
            if (sn instanceof Call) {
                boolean newLooksOkay = JythonUtil.trivialFunctionCall(sn);
                if (!newLooksOkay) {
                    logger.log(Level.FINE, "looksOkay=False, {0}", sn);
                } else {
                    Call c = (Call)sn;
                    for (exprType e : c.args) {
                        if (JythonUtil.simplifyScriptToGetParamsCanResolve((SimpleNode)e, this.names)) continue;
                        newLooksOkay = false;
                        this.visitNameFail = true;
                    }
                }
                this.looksOkay = newLooksOkay;
            } else if (sn instanceof Assign) {
                Assign a = (Assign)sn;
                exprType et = a.value;
                if (et instanceof Call) {
                    this.traverse((SimpleNode)et);
                }
            } else if (sn instanceof BinOp) {
                this.traverse((SimpleNode)((BinOp)sn).left);
                this.traverse((SimpleNode)((BinOp)sn).right);
            }
        }

        public boolean looksOkay() {
            return this.looksOkay;
        }

        public boolean visitNameFail() {
            return this.visitNameFail;
        }
    }
}

