/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.util.Collections;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.Element;
import org.autoplot.jythonsupport.StaticCodeAnalysis;
import org.autoplot.jythonsupport.ui.EditorAnnotationsSupport;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.python.parser.SimpleNode;

public class RefactorRenameVariable
extends JPanel {
    EditorTextPane editor;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField newNameTF;
    private JTextField oldNameTF;

    public RefactorRenameVariable(EditorTextPane editor) {
        this.initComponents();
        this.editor = editor;
        String var = editor.getSelectedText();
        if (var == null || var.length() == 0) {
            var = EditorAnnotationsSupport.getSymbolAt(editor, editor.getCaretPosition());
        }
        if (var == null || var.length() == 0) {
            this.oldNameTF.setText("");
        } else {
            this.oldNameTF.setText(var);
            this.oldNameTF.setEditable(false);
        }
    }

    public String refactorVarRename(String script, int i, String oldName, String newName) {
        int oldLen = oldName.length();
        List<SimpleNode> usages = StaticCodeAnalysis.showUsage(script, oldName);
        Collections.reverse(usages);
        for (SimpleNode n : usages) {
            Element root = this.editor.getDocument().getDefaultRootElement();
            int i0 = n.beginLine > 0 ? root.getElement(n.beginLine - 1).getStartOffset() : 0;
            System.err.println("replace at " + (i0 += n.beginColumn - 1));
            script = script.substring(0, i0) + newName + script.substring(i0 + oldLen);
        }
        return script;
    }

    public void refactorVarRename() {
        String script = this.editor.getText();
        String oldName = this.oldNameTF.getText();
        String newName = this.newNameTF.getText();
        String newScript = this.refactorVarRename(script, 0, oldName, newName);
        this.editor.setText(newScript);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.oldNameTF = new JTextField();
        this.newNameTF = new JTextField();
        this.jLabel1.setText("<html>Replace each instance where the name is used with the name.  Global/Local context is not supported.");
        this.jLabel2.setText("Old Symbol:");
        this.jLabel3.setText("New Symbol:");
        this.oldNameTF.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 302, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.oldNameTF, -1, 103, Short.MAX_VALUE).addComponent(this.newNameTF)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.newNameTF, this.oldNameTF);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 68, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.oldNameTF, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.newNameTF, -2, -1, -2)).addContainerGap(34, Short.MAX_VALUE)));
    }
}

