/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.jythonsupport.SimplifyScriptSupport;
import org.das2.jythoncompletion.DataSetUrlCompletionItem;
import org.das2.jythoncompletion.Utilities;
import org.das2.jythoncompletion.support.CompletionResultSet;
import org.das2.jythoncompletion.support.CompletionTask;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.parser;
import org.python.parser.ast.Module;

class DataSetUrlCompletionTask
implements CompletionTask {
    private static final Logger logger = Logger.getLogger("jython.editor");
    JTextComponent editor;

    public DataSetUrlCompletionTask(JTextComponent arg1) {
        this.editor = arg1;
    }

    @Override
    public void cancel() {
    }

    public static String popStringSyntax(JTextComponent editor, int[] pos) {
        try {
            String scri = SimplifyScriptSupport.alligatorParse(editor.getText());
            Module n = (Module)parser.parse((String)scri, (String)"exec");
            int i0 = Utilities.getRowStart(editor, editor.getCaretPosition());
            int iline = 1 + Utilities.getLineNumberForOffset(editor, i0);
            return SimplifyScriptSupport.tryResolveStringNode(n, iline, pos[0] - i0, new LinkedHashMap<String, Object>());
        }
        catch (BadLocationException ex) {
            Logger.getLogger(DataSetUrlCompletionTask.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static Map<String, Object> popString(JTextComponent editor, int[] pos) {
        try {
            String s = DataSetUrlCompletionTask.popStringSyntax(editor, pos);
            int i0 = Utilities.getRowStart(editor, editor.getCaretPosition());
            int i1 = Utilities.getRowEnd(editor, editor.getCaretPosition()) - 1;
            String line = editor.getText(i0, i1 - i0);
            int ipos = editor.getCaretPosition() - i0;
            i0 = line.lastIndexOf(39, ipos - 1);
            boolean doubleQuotes = false;
            if (i0 == -1) {
                i0 = line.lastIndexOf(34, ipos - 1);
                if (i0 == -1) {
                    throw new IllegalArgumentException("expected single quote");
                }
                doubleQuotes = true;
            }
            ++i0;
            i1 = doubleQuotes ? line.indexOf(34, ipos) : line.indexOf(39, ipos);
            if (i1 == -1) {
                i1 = line.length();
            }
            pos[0] = i0;
            pos[1] = i1;
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (s != null && s.endsWith(line.substring(i0, i1))) {
                result.put("string", s);
                result.put("offset", s.length() - (i1 - i0));
            } else {
                result.put("string", line.substring(i0, i1));
                result.put("offset", 0);
            }
            return result;
        }
        catch (BadLocationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return null;
    }

    @Override
    public void query(CompletionResultSet arg0) {
        try {
            int i0 = Utilities.getRowStart(this.editor, this.editor.getCaretPosition());
            int ipos = this.editor.getCaretPosition() - i0;
            int[] pos = new int[2];
            Map<String, Object> r = DataSetUrlCompletionTask.popString(this.editor, pos);
            String surl1 = (String)r.get("string");
            int carotPos = ipos - pos[0] + (Integer)r.get("offset");
            String pwd = (String)this.editor.getClientProperty("JYTHON_INTERPRETER_PWD");
            if (pwd != null && pwd.endsWith("/") && !surl1.startsWith(pwd) && (surl1 = URISplit.makeAbsolute((String)pwd, (String)surl1)).startsWith(pwd)) {
                carotPos += pwd.length();
            }
            List rs = DataSetURI.getCompletions((String)surl1, (int)carotPos, (ProgressMonitor)new NullProgressMonitor());
            for (DataSetURI.CompletionResult rs1 : rs) {
                arg0.addItem(new DataSetUrlCompletionItem(rs1));
            }
        }
        catch (BadLocationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public void refresh(CompletionResultSet arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

