/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion.nbadapt;

import java.lang.reflect.Method;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.das2.jythoncompletion.nbadapt.BaseDocument;
import org.das2.jythoncompletion.nbadapt.CharSequenceUtilities;

public class Utilities {
    public static boolean isMac() {
        String osName = System.getProperty("os.name");
        if (osName.equals("Mac OS X")) {
            return true;
        }
        return osName.startsWith("Darwin");
    }

    public static void openBrowser(String url) {
        String errMsg = "Error attempting to launch web browser";
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] getIdentifierBlock(JTextComponent c, int offset) throws BadLocationException {
        String id = null;
        int[] ret = null;
        Document doc = c.getDocument();
        int idStart = javax.swing.text.Utilities.getWordStart(c, offset);
        if (idStart < 0) return ret;
        int idEnd = javax.swing.text.Utilities.getWordEnd(c, idStart);
        if (idEnd < 0) return ret;
        id = doc.getText(idStart, idEnd - idStart);
        ret = new int[]{idStart, idEnd};
        CharSequence trim = CharSequenceUtilities.trim(id);
        if (trim.length() == 0 || trim.length() == 1 && !Character.isJavaIdentifierPart(trim.charAt(0))) {
            int prevWordStart = javax.swing.text.Utilities.getPreviousWord(c, offset);
            if (offset != javax.swing.text.Utilities.getWordEnd(c, prevWordStart)) return null;
            return new int[]{prevWordStart, offset};
        }
        if (id.length() == 0) return ret;
        if (CharSequenceUtilities.indexOf((CharSequence)id, 46) == -1) return ret;
        int index = offset - idStart;
        int begin = CharSequenceUtilities.lastIndexOf(id.subSequence(0, index), 46);
        begin = begin == -1 ? 0 : begin + 1;
        int end = CharSequenceUtilities.indexOf((CharSequence)id, 46, index);
        end = end == -1 ? id.length() : end;
        return new int[]{idStart + begin, idStart + end};
    }

    public static int[] getIdentifierBlock(BaseDocument doc, int pos) throws BadLocationException {
        int idEnd;
        int end;
        int iele;
        Object ret = null;
        Element root = doc.getDefaultRootElement();
        int start = root.getElement(iele = root.getElementIndex(pos)).getStartOffset();
        String s = doc.getText(start, (end = root.getElement(iele).getEndOffset()) - start);
        int idStart = s.lastIndexOf(" ", pos - start);
        if (idStart == -1) {
            idStart = 0;
        }
        if ((idEnd = s.indexOf(" ", pos - start)) == -1) {
            idEnd = end - start;
        }
        return new int[]{idStart + start, idEnd + start};
    }
}

