/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion.ui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.text.JTextComponent;
import org.das2.jythoncompletion.JythonCompletionProvider;

public final class CompletionSettings {
    public static final CompletionSettings INSTANCE = new CompletionSettings();

    private CompletionSettings() {
    }

    public boolean completionAutoPopup() {
        return true;
    }

    public int completionAutoPopupDelay() {
        return 300;
    }

    public boolean documentationAutoPopup() {
        return true;
    }

    public int documentationAutoPopupDelay() {
        return 600;
    }

    public Dimension completionPopupMaximumSize() {
        String s = JythonCompletionProvider.getInstance().settings().getDocumentationPaneSize();
        int i = s.indexOf("x");
        if (i == -1) {
            return new Dimension(640, 480);
        }
        try {
            return new Dimension(Integer.parseInt(s.substring(0, i)), Integer.parseInt(s.substring(i + 1)));
        }
        catch (NumberFormatException ex) {
            return new Dimension(640, 480);
        }
    }

    public Dimension documentationPopupPreferredSize() {
        return this.completionPopupMaximumSize();
    }

    public Color documentationBackgroundColor() {
        return Color.LIGHT_GRAY;
    }

    public boolean completionInstantSubstitution() {
        return true;
    }

    public void notifyEditorComponentChange(JTextComponent newEditorComponent) {
    }
}

