/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.ArrayAttribute;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public abstract class AArray {
    ArrayAttribute aa;
    Object o;
    int dim;
    boolean rowMajority = true;

    public AArray(Object o) throws Throwable {
        this(o, true);
    }

    public AArray(Object o, boolean rowMajority) throws Throwable {
        Class<?> cl = o.getClass();
        if (!cl.isArray()) {
            throw new Throwable("AArray: Object " + o + " is not an array");
        }
        this.o = o;
        this.aa = new ArrayAttribute(o);
        this.dim = this.aa.getDimensions().length;
        this.rowMajority = rowMajority;
    }

    public abstract Object array();

    public int[] getDimensions() {
        return this.aa.getDimensions();
    }

    ByteBuffer allocate(int elementSize) {
        int size = elementSize;
        int[] _dim = this.aa.getDimensions();
        for (int i = 0; i < _dim.length; ++i) {
            size *= _dim[i];
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(size);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf;
    }

    public ByteBuffer buffer(int size) throws Throwable {
        if (this.aa.getType() == String.class) {
            return this.buffer(String.class, size);
        }
        return this.buffer();
    }

    public ByteBuffer buffer() throws Throwable {
        if (this.aa.getType() == String.class) {
            throw new Throwable("Invalid call for String type");
        }
        return this.buffer(this.aa.getType(), 0);
    }

    public ByteBuffer buffer(Class<?> cl) throws Throwable {
        return this.buffer(cl, 0);
    }

    public abstract ByteBuffer buffer(Class<?> var1, int var2) throws Throwable;

    public boolean validateDimensions(int[] dimensions) {
        return Arrays.equals(dimensions, this.aa.getDimensions());
    }

    public static Object getPoint(Object o) throws Throwable {
        ArrayAttribute aa = new ArrayAttribute(o);
        int[] dim = aa.getDimensions();
        Object a = null;
        if (dim.length == 1) {
            a = Array.newInstance(aa.getType(), 1, dim[0]);
        }
        if (dim.length == 2) {
            a = Array.newInstance(aa.getType(), 1, dim[0], dim[1]);
        }
        if (dim.length == 3) {
            a = Array.newInstance(aa.getType(), 1, dim[0], dim[1], dim[2]);
        }
        if (dim.length == 4) {
            a = Array.newInstance(aa.getType(), 1, dim[0], dim[1], dim[2], dim[3]);
        }
        if (a == null) {
            return null;
        }
        Array.set(a, 0, o);
        return a;
    }
}

